/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.util.Glob;
import com.sap.jvm.profiling.viewer.tree.TreeModelForwardIterator;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

public final class SelectByContentCommand
implements ReportCommand {
    private final String pattern;

    public SelectByContentCommand(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        if (input instanceof TableResourceController) {
            TableResourceController controller = (TableResourceController)input;
            TypedTableModel model = (TypedTableModel)controller.getModel();
            int[] allItemIds = new int[model.getNrOfItems()];
            for (int i = 0; i < allItemIds.length; ++i) {
                allItemIds[i] = model.getItemId(i);
            }
            Glob glob = new Glob(this.pattern);
            TreeSet<Integer> selectedEntries = new TreeSet<Integer>();
            for (int column = 0; column < model.getNrOfColumns(); ++column) {
                for (int itemId : allItemIds) {
                    if (!glob.isMatch(model.getRendererForItem(itemId, column).asString())) continue;
                    selectedEntries.add(itemId);
                }
            }
            int[] itemIds = new int[selectedEntries.size()];
            int i = 0;
            Iterator iterator = selectedEntries.iterator();
            while (iterator.hasNext()) {
                int selection = (Integer)iterator.next();
                itemIds[i++] = selection;
            }
            model.setSelection(itemIds);
            if (context.isInteractive()) {
                System.out.println("Selected " + itemIds.length + " table entries matching the pattern '" + this.pattern + "'.");
            }
            return context;
        }
        if (input instanceof TreeResourceController) {
            TreeResourceController controller = (TreeResourceController)input;
            TypedTreeModel model = (TypedTreeModel)controller.getModel();
            TreeModelForwardIterator it = new TreeModelForwardIterator(model);
            ArrayList<TreeModelItem> allItems = new ArrayList<TreeModelItem>();
            while (it.hasNext()) {
                allItems.add(it.next());
            }
            Glob glob = new Glob(this.pattern);
            ArrayList<TreeModelItem> selection = new ArrayList<TreeModelItem>();
            for (TreeModelItem item : allItems) {
                if (!glob.isMatch(item.toString())) continue;
                selection.add(item);
            }
            model.setSelection(selection.toArray(new TreeModelItem[selection.size()]));
            if (context.isInteractive()) {
                System.out.println("Selected " + selection.size() + " visible tree entries matching the pattern '" + this.pattern + "'.");
            }
            return context;
        }
        throw new JvmProfReportException("Unsupported controller type for selection by content: " + input.getClass().getName());
    }
}

