/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.controller.ValueSetResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.TypedValueSetModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.viewer.tree.TreeModelForwardIterator;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import java.util.Arrays;
import java.util.HashSet;

public final class SelectByIndexCommand
implements ReportCommand {
    private final Integer[] indices;

    public SelectByIndexCommand(Integer[] indices) {
        this.indices = indices;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        if (input instanceof TableResourceController) {
            TableResourceController controller = (TableResourceController)input;
            TypedTableModel model = (TypedTableModel)controller.getModel();
            int[] itemIds = new int[this.indices.length];
            for (int i = 0; i < this.indices.length; ++i) {
                if (this.indices[i] < 0 || this.indices[i] >= model.getNrOfItems()) {
                    throw new JvmProfReportException("Selection index out of range [0.." + (model.getNrOfItems() - 1) + "]: " + this.indices[i]);
                }
                itemIds[i] = model.getItemId(this.indices[i]);
            }
            model.setSelection(itemIds);
            if (context.isInteractive()) {
                System.out.println("Selected " + itemIds.length + " table entries.");
            }
            return context;
        }
        if (input instanceof TreeResourceController) {
            TreeResourceController controller = (TreeResourceController)input;
            TypedTreeModel model = (TypedTreeModel)controller.getModel();
            TreeModelItem[] items = new TreeModelItem[this.indices.length];
            HashSet<Integer> selected = new HashSet<Integer>(Arrays.asList(this.indices));
            TreeModelForwardIterator it = new TreeModelForwardIterator(model);
            int index = 0;
            int pos = 0;
            while (it.hasNext()) {
                if (selected.contains(index)) {
                    items[pos] = it.next();
                    ++pos;
                } else {
                    it.next();
                }
                ++index;
            }
            for (int i = 0; i < items.length; ++i) {
                if (items[i] != null) continue;
                throw new JvmProfReportException("Selection index out of range: " + this.indices[i]);
            }
            model.setSelection(items);
            if (context.isInteractive()) {
                System.out.println("Selected " + items.length + " visible tree entries.");
            }
            return context;
        }
        if (input instanceof ValueSetResourceController) {
            ValueSetResourceController controller = (ValueSetResourceController)input;
            TypedValueSetModel model = (TypedValueSetModel)controller.getModel();
            int[] itemIds = new int[this.indices.length];
            for (int i = 0; i < this.indices.length; ++i) {
                if (this.indices[i] < 0 || this.indices[i] >= model.getNrOfRows()) {
                    throw new JvmProfReportException("Selection index out of range [0.." + (model.getNrOfRows() - 1) + "]: " + this.indices[i]);
                }
                itemIds[i] = this.indices[i];
            }
            model.setSelectedRows(itemIds);
            if (context.isInteractive()) {
                System.out.println("Selected " + itemIds.length + " rows.");
            }
            return context;
        }
        throw new JvmProfReportException("Unsupported controller type for selection by index: " + input.getClass().getName());
    }
}

