/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.controller.ValueSetResourceController;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.SelectAllCommand;
import com.sap.jvm.profiling.tools.report.command.SelectByContentCommand;
import com.sap.jvm.profiling.tools.report.command.SelectByIndexCommand;
import com.sap.jvm.profiling.tools.report.command.SelectTopCommand;
import java.util.ArrayList;
import java.util.List;

public final class SelectCommandFactory
implements ReportCommandFactory {
    private static final String SELECT_ALL_PREFIX = "select all";
    private static final String SELECT_BY_INDEX_PREFIX = "select by index ";
    private static final String SELECT_BY_CONTENT_PREFIX = "select by content ";
    private static final String SELECT_TOP_PREFIX = "select top ";

    @Override
    public ReportCommand create(String command) throws JvmProfReportException {
        String c = command.trim();
        if (c.equals(SELECT_ALL_PREFIX)) {
            return new SelectAllCommand();
        }
        if (c.startsWith(SELECT_BY_INDEX_PREFIX)) {
            String indicesPart = c.substring(SELECT_BY_INDEX_PREFIX.length());
            String[] indicesStrings = indicesPart.split(" ");
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (String s : indicesStrings) {
                if ("".equals(s)) continue;
                try {
                    indices.add(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    throw new JvmProfReportException("Invalid index specified: " + s);
                }
            }
            return new SelectByIndexCommand(indices.toArray(new Integer[indices.size()]));
        }
        if (c.startsWith(SELECT_BY_CONTENT_PREFIX)) {
            String content = c.substring(SELECT_BY_CONTENT_PREFIX.length());
            return new SelectByContentCommand(content);
        }
        if (c.startsWith(SELECT_TOP_PREFIX)) {
            String number = c.substring(SELECT_TOP_PREFIX.length());
            try {
                return new SelectTopCommand(Integer.parseInt(number));
            }
            catch (NumberFormatException e) {
                throw new JvmProfReportException("Invalid number specified: " + number);
            }
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < SELECT_ALL_PREFIX.length() && SELECT_ALL_PREFIX.startsWith(prefix) || prefix.length() >= SELECT_ALL_PREFIX.length() && prefix.startsWith(SELECT_ALL_PREFIX) || prefix.length() < SELECT_BY_INDEX_PREFIX.length() && SELECT_BY_INDEX_PREFIX.startsWith(prefix) || prefix.length() >= SELECT_BY_INDEX_PREFIX.length() && prefix.startsWith(SELECT_BY_INDEX_PREFIX) || prefix.length() < SELECT_BY_CONTENT_PREFIX.length() && SELECT_BY_CONTENT_PREFIX.startsWith(prefix) || prefix.length() >= SELECT_BY_CONTENT_PREFIX.length() && prefix.startsWith(SELECT_BY_CONTENT_PREFIX) || prefix.length() >= SELECT_TOP_PREFIX.length() && prefix.startsWith(SELECT_TOP_PREFIX))) {
            return false;
        }
        System.out.println("Select a set of entries");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  select all");
        System.out.println("  select by index <indices>");
        System.out.println("  select by content <content>");
        System.out.println("  select top <number-of-entries>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <indices>              An arbitrary list of indices to select separated by ' ' characters.");
        System.out.println("                         The first entry has the index 0.");
        System.out.println("  <content>              The partial content to use as pattern.");
        System.out.println("                         All entries that contain parts of the pattern are selected.");
        System.out.println("  <number-of-entries>    The number of entries to select starting from the top.");
        System.out.println("                         For example, 10 would select the top ten entries.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        Object context = executionContext.getController();
        if (!(context instanceof TableResourceController) && !(context instanceof TreeResourceController) || context instanceof ValueSetResourceController) {
            return;
        }
        if (SELECT_ALL_PREFIX.startsWith(commandPrefix)) {
            commands.add(SELECT_ALL_PREFIX);
        }
        if (SELECT_BY_CONTENT_PREFIX.startsWith(commandPrefix)) {
            commands.add(SELECT_BY_CONTENT_PREFIX);
        }
        if (SELECT_BY_INDEX_PREFIX.startsWith(commandPrefix)) {
            commands.add(SELECT_BY_INDEX_PREFIX);
        }
        if (SELECT_TOP_PREFIX.startsWith(commandPrefix)) {
            commands.add(SELECT_TOP_PREFIX);
        }
    }
}

