/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.SetCommandFactory;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import java.util.Arrays;

public class SetCommand
implements ReportCommand {
    private final String key;
    private final String value;

    public SetCommand(String key, String value) {
        this.key = key;
        this.value = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        int size;
        if (this.key.equals("decimal_point")) {
            if (this.value.equals("POINT")) {
                context.setDecimalPoint('.');
                return context;
            } else {
                if (!this.value.equals("COMMA")) throw new JvmProfReportException("Decimal point can only be set to 'POINT' or 'COMMA' and not '" + this.value + "'");
                context.setDecimalPoint(',');
            }
            return context;
        }
        if (this.key.equals("csv_separator")) {
            if (this.value.equals("SPACE")) {
                context.setComma(" ");
                return context;
            } else if (this.value.equals("TAB")) {
                context.setComma("\t");
                return context;
            } else if (this.value.equals("COMMA")) {
                context.setComma(",");
                return context;
            } else {
                if (!this.value.equals("SEMICOLON")) throw new JvmProfReportException("CSV separator can only be set to 'SPACE', 'TAB', 'COMMA' or 'SEMICOLON' and not '" + this.value + "'");
                context.setComma(";");
            }
            return context;
        }
        if (this.key.equals("overwrite")) {
            if (this.value.equals("true")) {
                context.setOverwrite(true);
                return context;
            } else {
                if (!this.value.equals("false")) throw new JvmProfReportException("overwrite can only be set to true or false");
                context.setOverwrite(false);
            }
            return context;
        }
        if (this.key.equals("column_titles")) {
            if (this.value.equals("true")) {
                context.setIncludeColumnTitles(true);
                return context;
            } else {
                if (!this.value.equals("false")) throw new JvmProfReportException("column_titles can only be set to true or false");
                context.setIncludeColumnTitles(false);
            }
            return context;
        }
        if (!this.key.equals("font")) throw new JvmProfReportException("Can not set '" + this.key + "'. Only allowed parameters: " + Arrays.toString(SetCommandFactory.KEYS));
        if (!this.value.contains(":")) {
            throw new JvmProfReportException("missing font size. Format is <name>:<size>.");
        }
        String name = this.value.substring(0, this.value.indexOf(58));
        String sizeStr = this.value.substring(this.value.lastIndexOf(58) + 1);
        try {
            size = Integer.parseInt(sizeStr);
        }
        catch (NumberFormatException e) {
            throw new JvmProfReportException("Could not parse font size: " + e.getMessage());
        }
        if (size <= 0) {
            throw new JvmProfReportException("Illegale font size " + size);
        }
        if (name.length() == 0) {
            context.setFont(null);
            return context;
        } else {
            context.setFont(new Font(name, size, Font.Style.NORMAL));
        }
        return context;
    }
}

