/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.SetCommand;
import java.util.HashMap;
import java.util.List;

public class SetCommandFactory
implements ReportCommandFactory {
    private static final String SET_PREFIX = "set ";
    public static final String[] KEYS = new String[]{"decimal_point", "csv_separator", "overwrite", "column_titles", "font"};
    private static final HashMap<String, String[]> values = new HashMap();

    @Override
    public ReportCommand create(String command) {
        String c = command.trim();
        if (!c.startsWith(SET_PREFIX)) {
            return null;
        }
        String name = c.substring(SET_PREFIX.length());
        int assignPos = name.indexOf(61);
        if (assignPos > 0) {
            String key = name.substring(0, assignPos);
            String value = name.substring(assignPos + 1);
            return new SetCommand(key, value);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < SET_PREFIX.length() && SET_PREFIX.startsWith(prefix) || prefix.length() >= SET_PREFIX.length() && prefix.startsWith(SET_PREFIX))) {
            return false;
        }
        System.out.println("Sets a global variable");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  set <key>=<value>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <key>                  One of the predefined keys.");
        System.out.println("  <value>                The value of the key.");
        System.out.println();
        System.out.println("The following keys are supported:");
        System.out.println("  decimal_point          The decimal point to use in CSV export. The values can");
        System.out.println("                         be POINT or COMMA.");
        System.out.println("  csv_separator          The separator to use in CSV export. The values can be");
        System.out.println("                         SPACE, TAB, COMMA or SEMICOLON.");
        System.out.println("  overwrite              If set to true exporting will overwrite existing files.");
        System.out.println("                         If set to false, no files will be overwritten.");
        System.out.println("  column_titles          If set to false column titles are not included in excel ");
        System.out.println("                         and CSV export.");
        System.out.println("  font                   The font to use. The format ist the name of the font ");
        System.out.println("                         followed by a colon and followed by the size.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        if (commandPrefix.startsWith(SET_PREFIX)) {
            String name = commandPrefix.substring(SET_PREFIX.length());
            int assignPos = name.indexOf(61);
            if (assignPos > 0) {
                String key = name.substring(0, assignPos);
                String value = name.substring(assignPos + 1);
                if (values.containsKey(key)) {
                    for (String v : values.get(key)) {
                        if (!v.startsWith(value)) continue;
                        commands.add(SET_PREFIX + key + "=" + v);
                    }
                }
            } else {
                for (String k : KEYS) {
                    if (!k.startsWith(name)) continue;
                    commands.add(SET_PREFIX + k + "=");
                }
            }
        } else if (SET_PREFIX.startsWith(commandPrefix)) {
            commands.add(SET_PREFIX);
        }
    }

    static {
        values.put("decimal_point", new String[]{"POINT", "COMMA"});
        values.put("csv_separator", new String[]{"SPACE", "TAB", "COMMA", "SEMICOLON"});
        values.put("overwrite", new String[]{"true", "false"});
        values.put("column_titles", new String[]{"true", "false"});
    }
}

