/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ReportResourceController;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TimeSeriesResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.controller.ValueSetResourceController;
import com.sap.jvm.profiling.controller.model.IncludeType;
import com.sap.jvm.profiling.presentation.typed.MethodFormat;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedReportModel;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.TypedValueSetModel;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.viewer.BatchTaskManager;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.SimpleModelViewer;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class ShowStatisticCommand
implements ReportCommand {
    private static final String[] prefixes = new String[]{"getSelected", "get", "getSelected", "get"};
    private static final String[] suffixes = new String[]{"Controller", "Controller", "", ""};
    private static final String[] groupingPrefixes = new String[]{"as"};
    private static final String[] groupingSuffixes = new String[]{""};
    private static final String THREAD_ANNOTATION_SUFFIX = "ThreadAnnotationStatistic";
    private static final Map<String, Object> statisticParameters;
    private static final Set<String> filteredGetter;
    private static final Map<String, String> statisticReplacements;
    private final String statistic;
    private final String command;
    private final Object argument;
    private final boolean isGrouping;

    public ShowStatisticCommand(String statistic, String command, boolean isGrouping) {
        String tmpStatistic = statistic;
        Object tmpArgument = null;
        for (Map.Entry<String, Object> entry : statisticParameters.entrySet()) {
            if (!statistic.endsWith(entry.getKey())) continue;
            tmpStatistic = statistic.substring(0, statistic.length() - entry.getKey().length()) + THREAD_ANNOTATION_SUFFIX;
            tmpArgument = entry.getValue();
            break;
        }
        for (Map.Entry<String, Object> entry : statisticReplacements.entrySet()) {
            tmpStatistic = tmpStatistic.replace((CharSequence)entry.getValue(), entry.getKey());
        }
        this.statistic = tmpStatistic;
        this.command = command;
        this.argument = tmpArgument;
        this.isGrouping = isGrouping;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        if (!(input instanceof ResourceController)) {
            throw new JvmProfReportException("Unknown input for show statistic/tree command.");
        }
        String[] pre = this.isGrouping ? groupingPrefixes : prefixes;
        String[] suf = this.isGrouping ? groupingSuffixes : suffixes;
        Class<?> clazz = input.getClass();
        Method getter = null;
        for (int i = 0; i < pre.length && (getter = this.findMethod(clazz, pre[i] + this.statistic + suf[i])) == null; ++i) {
        }
        if (getter == null) {
            System.err.println("Unknown statistic/tree: " + this.command);
            this.printPossibleStatistics(clazz);
            throw new JvmProfReportException("");
        }
        Object[] args = new Object[getter.getParameterTypes().length];
        if (args.length > 0) {
            args[args.length - 1] = IncludeType.TOTAL;
        }
        if (this.argument != null) {
            args[0] = this.argument;
        }
        if (args.length > 0 && MethodFilter[].class == getter.getParameterTypes()[0]) {
            try {
                MethodFilter[] filters = context.getComponents();
                if (filters == null || filters.length == 0) {
                    throw new JvmProfReportException("No components defined. Use 'define component' command to create component specifications prior to creating the statistic/tree.");
                }
                args[0] = filters;
            }
            catch (FilterParseException e) {
                throw new JvmProfReportException("Error during report: " + e.getMessage());
            }
        }
        try {
            Object result = getter.invoke(input, args);
            ShowStatisticCommand.ensureContentCreated(result);
            ShowStatisticCommand.makeInitial(result);
            if (context.isInteractive()) {
                if (result instanceof TableResourceController) {
                    TableResourceController controller = (TableResourceController)result;
                    System.out.println("Navigation to statistic yielded " + ((TypedTableModel)controller.getModel()).getNrOfItems() + " entries.");
                } else if (result instanceof TreeResourceController) {
                    TreeResourceController controller = (TreeResourceController)result;
                    System.out.println("Navigation to tree yielded " + ((TypedTreeModel)controller.getModel()).getRootItems().length + " root entries.");
                } else if (result instanceof ValueSetResourceController) {
                    ValueSetResourceController controller = (ValueSetResourceController)result;
                    System.out.println("Navigation yielded graph with " + ((TypedValueSetModel)controller.getModel()).getNrOfRows() + " rows.");
                } else if (result instanceof TimeSeriesResourceController) {
                    TimeSeriesResourceController controller = (TimeSeriesResourceController)result;
                    System.out.println("Navigation yielded graph with " + ((TypedTimeSeriesModel)controller.getModel()).getNrOfAreas() + " areas.");
                } else if (result instanceof ReportResourceController) {
                    ReportResourceController controller = (ReportResourceController)result;
                    System.out.println("Navigation to report with title " + ((TypedReportModel)controller.getModel()).getTitle() + ".");
                } else {
                    System.out.println("Navigation yielded unknown type");
                }
            }
            return context.changeContext(result);
        }
        catch (IllegalAccessException e) {
            throw new JvmProfReportException("Error during report: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new JvmProfReportException("Error during report: " + e.getCause().getMessage());
        }
    }

    public static String[] getPossibleStatistics(Class<?> clazz) {
        return ShowStatisticCommand.getPossibleStatisticsImpl(clazz, false);
    }

    public static String[] getPossibleGroupingStatistics(Class<?> clazz) {
        return ShowStatisticCommand.getPossibleStatisticsImpl(clazz, true);
    }

    private static String[] getPossibleStatisticsImpl(Class<?> clazz, boolean isGrouping) {
        TreeSet<String> set = new TreeSet<String>();
        for (Method method : clazz.getMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            String name = method.getName();
            boolean isAnnotation = name.contains(THREAD_ANNOTATION_SUFFIX);
            if (parameterTypes.length > 1 && !isAnnotation && parameterTypes[0] != MethodFilter[].class || parameterTypes.length == 1 && parameterTypes[0] != IncludeType.class && parameterTypes[0] != MethodFilter[].class && !isAnnotation) continue;
            ShowStatisticCommand.addNamesFromMethod(name, set, isGrouping);
        }
        return set.toArray(new String[set.size()]);
    }

    private static void addNamesFromMethod(String methodName, Set<String> commandSet, boolean isGrouping) {
        if (filteredGetter.contains(methodName)) {
            return;
        }
        String[] pre = isGrouping ? groupingPrefixes : prefixes;
        String[] suf = isGrouping ? groupingSuffixes : suffixes;
        int annotationIndex = methodName.indexOf(THREAD_ANNOTATION_SUFFIX);
        if (annotationIndex >= 0) {
            String prefix = methodName.substring(0, annotationIndex);
            String suffix = methodName.substring(annotationIndex + THREAD_ANNOTATION_SUFFIX.length());
            block0: for (String annotation : statisticParameters.keySet()) {
                String name = prefix + annotation + suffix;
                for (int i = 0; i < pre.length; ++i) {
                    if (!name.startsWith(pre[i]) || !name.endsWith(suf[i])) continue;
                    String stat = name.substring(pre[i].length(), name.length() - suf[i].length());
                    commandSet.add(ShowStatisticCommand.getStatisticName(stat));
                    continue block0;
                }
            }
        } else {
            String tmpMethodName = methodName;
            for (Map.Entry<String, String> entry : statisticReplacements.entrySet()) {
                tmpMethodName = tmpMethodName.replace(entry.getKey(), entry.getValue());
            }
            for (int i = 0; i < pre.length; ++i) {
                if (!tmpMethodName.startsWith(pre[i]) || !tmpMethodName.endsWith(suf[i])) continue;
                String stat = tmpMethodName.substring(pre[i].length(), tmpMethodName.length() - suf[i].length());
                commandSet.add(ShowStatisticCommand.getStatisticName(stat));
                break;
            }
        }
    }

    private void printPossibleStatistics(Class<?> clazz) {
        System.err.println("Available Statistics/Trees:");
        for (String s : ShowStatisticCommand.getPossibleStatisticsImpl(clazz, this.isGrouping)) {
            System.err.println("  " + s);
        }
    }

    private Method findMethod(Class<?> clazz, String name) {
        if (filteredGetter.contains(name)) {
            return null;
        }
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return clazz.getMethod(name, IncludeType.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    return clazz.getMethod(name, MethodFilter[].class);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    try {
                        return clazz.getMethod(name, MethodFilter[].class, IncludeType.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException4) {
                        if (name.contains(THREAD_ANNOTATION_SUFFIX)) {
                            try {
                                return clazz.getMethod(name, Integer.TYPE, IncludeType.class);
                            }
                            catch (NoSuchMethodException noSuchMethodException5) {
                                try {
                                    return clazz.getMethod(name, Integer.TYPE);
                                }
                                catch (NoSuchMethodException noSuchMethodException6) {
                                    // empty catch block
                                }
                            }
                        }
                        return null;
                    }
                }
            }
        }
    }

    public static void ensureContentCreated(Object controller) throws JvmProfReportException {
        BatchTaskManager manager;
        if (!(controller instanceof ResourceController)) {
            throw new JvmProfReportException("Unexpected controller type: " + controller.getClass().getName());
        }
        ResourceController rc = (ResourceController)controller;
        Object m = rc.getModel();
        if (m instanceof TypedTableModel) {
            TypedTableModel model = (TypedTableModel)m;
            if (model.getViewer() == null) {
                RendererThemeSpec spec = new RendererThemeSpec(new OSThemeSpec());
                spec.setMethodFormat(MethodFormat.FULL);
                model.setViewer(new SimpleModelViewer(new BatchTaskManager()), spec);
                model.createItems();
            }
            manager = (BatchTaskManager)model.getViewer().getTaskManager();
        } else if (m instanceof TypedTreeModel) {
            TypedTreeModel model = (TypedTreeModel)m;
            if (model.getViewer() == null) {
                RendererThemeSpec spec = new RendererThemeSpec(new OSThemeSpec());
                spec.setMethodFormat(MethodFormat.FULL);
                model.setViewer(new SimpleModelViewer(new BatchTaskManager()), spec);
                model.createRoots();
            }
            manager = (BatchTaskManager)model.getViewer().getTaskManager();
        } else if (m instanceof TypedValueSetModel) {
            TypedValueSetModel model = (TypedValueSetModel)m;
            if (model.getViewer() == null) {
                RendererThemeSpec spec = new RendererThemeSpec(new OSThemeSpec());
                spec.setMethodFormat(MethodFormat.FULL);
                model.setViewer(new SimpleModelViewer(new BatchTaskManager()), spec);
                model.createData();
            }
            manager = (BatchTaskManager)model.getViewer().getTaskManager();
        } else if (m instanceof TypedTimeSeriesModel) {
            TypedTimeSeriesModel model = (TypedTimeSeriesModel)m;
            if (model.getViewer() == null) {
                RendererThemeSpec spec = new RendererThemeSpec(new OSThemeSpec());
                spec.setMethodFormat(MethodFormat.FULL);
                model.setViewer(new SimpleModelViewer(new BatchTaskManager()), spec);
                model.createData();
            }
            manager = (BatchTaskManager)model.getViewer().getTaskManager();
        } else if (m instanceof TypedReportModel) {
            TypedReportModel model = (TypedReportModel)m;
            if (model.getViewer() == null) {
                RendererThemeSpec spec = new RendererThemeSpec(new OSThemeSpec());
                spec.setMethodFormat(MethodFormat.FULL);
                model.setViewer(new SimpleModelViewer(new BatchTaskManager()), spec);
                model.createData();
            }
            manager = (BatchTaskManager)model.getViewer().getTaskManager();
        } else {
            throw new JvmProfReportException("Unknown model type: " + m.getClass().getName());
        }
        manager.waitForTasks();
    }

    public static void makeInitial(Object controller) throws JvmProfReportException {
        if (!(controller instanceof ResourceController)) {
            throw new JvmProfReportException("Unexpected controller type: " + controller.getClass().getName());
        }
        ResourceController rc = (ResourceController)controller;
        Object m = rc.getModel();
        if (m instanceof TypedTableModel) {
            TypedTableModel model = (TypedTableModel)m;
            TypedColumnSpec spec = model.getSpec();
            for (int i = 0; i < spec.getNrOfDefaultSorts(); ++i) {
                model.setSorting(spec.getDefaultSortColumn(i), spec.getDefaultSortDirection(spec.getDefaultSortColumn(i)));
            }
            model.setColumnVisibility(spec.getDefaultVisibleSets());
            model.setSelection(new int[0]);
        } else if (m instanceof TypedTreeModel) {
            TypedTreeModel model = (TypedTreeModel)m;
            TypedColumnSpec spec = model.getSpec();
            for (int i = 0; i < spec.getNrOfDefaultSorts(); ++i) {
                model.setSorting(spec.getDefaultSortColumn(i), spec.getDefaultSortDirection(spec.getDefaultSortColumn(i)));
            }
            model.setColumnVisibility(spec.getDefaultVisibleSets());
            model.setSelection(new TreeModelItem[0]);
            model.collapseAll();
        } else if (m instanceof TypedValueSetModel) {
            TypedValueSetModel model = (TypedValueSetModel)m;
            TypedColumnSpec spec = model.getSpec();
            for (int i = 0; i < spec.getNrOfDefaultSorts(); ++i) {
                model.setSorting(spec.getDefaultSortColumn(i), spec.getDefaultSortDirection(spec.getDefaultSortColumn(i)));
            }
            model.setColumnVisibility(spec.getDefaultVisibleSets());
            model.setSelectedRows(new int[0]);
        } else if (!(m instanceof TypedTimeSeriesModel) && !(m instanceof TypedReportModel)) {
            throw new JvmProfReportException("Unknown model type: " + m.getClass().getName());
        }
    }

    public static String getStatisticName(String statistic) {
        StringBuilder buffer = new StringBuilder();
        for (int j = 0; j < statistic.length(); ++j) {
            char c = statistic.charAt(j);
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
                if (buffer.length() > 0) {
                    buffer.append(' ');
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    static {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("UserStatistic", 0);
        map.put("SessionStatistic", 1);
        map.put("RequestStatistic", 2);
        map.put("ApplicationStatistic", 3);
        map.put("TenantStatistic", 3);
        statisticParameters = Collections.unmodifiableMap(map);
        HashSet<String> set = new HashSet<String>();
        set.add("getModel");
        set.add("getDependents");
        set.add("getParent");
        set.add("getParentName");
        set.add("getChildren");
        set.add("getBaseName");
        set.add("getId");
        set.add("getResourceName");
        set.add("getClass");
        set.add("getSnapshot");
        set.add("getAlertsController");
        set.add("getController");
        set.add("getSourceControllerALabel");
        set.add("getSourceControllerBLabel");
        set.add("getMatController");
        set.add("getCalledTimeSeriesController");
        set.add("getSelectedOtherMethodParameterStatistic");
        set.add("getSelectedBlockedCalledTimeSeries");
        set.add("getSelectedBlockedTimeSeries");
        set.add("getSelectedBlockingCalledTimeSeries");
        set.add("getSelectedBlockingTimeSeries");
        set.add("getWaitingThreadIdStatisticController");
        set.add("getWaitingThreadNameStatisticController");
        set.add("getSnapshotController");
        set.add("getConcGcIds");
        set.add("getFirstGcId");
        set.add("getFullGcIds");
        set.add("getGcType");
        set.add("getLastGcId");
        set.add("getSelectedGcIds");
        set.add("getSelectedGcsInformation");
        set.add("getThreadDumpTreeControllerNames");
        filteredGetter = Collections.unmodifiableSet(set);
        HashMap<String, String> statisticRenaming = new HashMap<String, String>();
        statisticRenaming.put("FilterStatistic", "ComponentStatistic");
        statisticRenaming.put("FilterTree", "ComponentTree");
        statisticReplacements = Collections.unmodifiableMap(statisticRenaming);
    }
}

