/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ShowStatisticCommand;
import java.util.List;

public final class ShowStatisticCommandFactory
implements ReportCommandFactory {
    private static final String SHOW_PREFIX = "goto ";
    private static final String GROUP_PREFIX = "group as ";

    @Override
    public ReportCommand create(String command) {
        boolean isGroup;
        String c = command.trim();
        boolean isShow = c.startsWith(SHOW_PREFIX);
        boolean bl = isGroup = !isShow && c.startsWith(GROUP_PREFIX);
        if (!isShow && !isGroup) {
            return null;
        }
        String prefix = isShow ? SHOW_PREFIX : GROUP_PREFIX;
        String name = c.substring(prefix.length());
        StringBuilder buffer = new StringBuilder();
        boolean capitalLetter = true;
        for (int i = 0; i < name.length(); ++i) {
            char character = name.charAt(i);
            if (character == ' ') {
                capitalLetter = true;
                continue;
            }
            if (capitalLetter) {
                character = Character.toUpperCase(character);
                capitalLetter = false;
            }
            buffer.append(character);
        }
        return new ShowStatisticCommand(buffer.toString(), name, isGroup);
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        return this.printUsageShow(commandPrefix) | this.printUsageGroup(commandPrefix);
    }

    private boolean printUsageShow(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < SHOW_PREFIX.length() && SHOW_PREFIX.startsWith(prefix) || prefix.length() >= SHOW_PREFIX.length() && prefix.startsWith(SHOW_PREFIX))) {
            return false;
        }
        System.out.println("Go to a statistic or tree, i.e. open the corresponding profiling data");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  goto <name>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <name>                 The name of the statistic or tree to navigate to.");
        System.out.println("                         Examples are \"called method statistic\" or \"thread id statistic\".");
        System.out.println("                         (All possible statistics/trees are shown in case the name is unknown.)");
        System.out.println();
        return true;
    }

    private boolean printUsageGroup(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < GROUP_PREFIX.length() && GROUP_PREFIX.startsWith(prefix) || prefix.length() >= GROUP_PREFIX.length() && prefix.startsWith(GROUP_PREFIX))) {
            return false;
        }
        System.out.println("Group the profiling data as a different statistic");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  group as <name>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <name>                 The name of the statistic used to group the profiling data.");
        System.out.println("                         Examples are \"called method statistic by class\".");
        System.out.println("                         (All possible statistics are shown in case the name is unknown.)");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        String statisticPrefix;
        Object context = executionContext.getController();
        if (!(context instanceof ResourceController)) {
            return;
        }
        if (SHOW_PREFIX.startsWith(commandPrefix) && SHOW_PREFIX.length() > commandPrefix.length()) {
            commands.add(SHOW_PREFIX);
        }
        if (commandPrefix.startsWith(SHOW_PREFIX)) {
            statisticPrefix = commandPrefix.substring(SHOW_PREFIX.length()).trim();
            for (String statistic : ShowStatisticCommand.getPossibleStatistics(context.getClass())) {
                if (!statistic.startsWith(statisticPrefix)) continue;
                commands.add(SHOW_PREFIX + statistic);
            }
        }
        if (GROUP_PREFIX.startsWith(commandPrefix) && GROUP_PREFIX.length() > commandPrefix.length()) {
            commands.add(GROUP_PREFIX);
        }
        if (commandPrefix.startsWith(GROUP_PREFIX)) {
            statisticPrefix = commandPrefix.substring(GROUP_PREFIX.length()).trim();
            for (String statistic : ShowStatisticCommand.getPossibleGroupingStatistics(context.getClass())) {
                if (!statistic.startsWith(statisticPrefix)) continue;
                commands.add(GROUP_PREFIX + statistic);
            }
        }
    }
}

