/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;

public final class SortCommand
implements ReportCommand {
    private static final int ASCENDING = 1;
    private static final int DESCENDING = -1;
    private final String column;
    private final boolean ascending;

    public SortCommand(String column, boolean ascending) {
        this.column = column;
        this.ascending = ascending;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        int order;
        Object input = context.getController();
        int n = order = this.ascending ? 1 : -1;
        if (input instanceof TableResourceController) {
            TableResourceController controller = (TableResourceController)input;
            TypedTableModel model = (TypedTableModel)controller.getModel();
            model.setSorting(this.getColumnIndex(model.getSpec()), order);
            if (context.isInteractive()) {
                System.out.println("Sorted by " + this.column + " in " + (this.ascending ? "ascending" : "descending") + " order.");
            }
            return context;
        }
        if (input instanceof TreeResourceController) {
            TreeResourceController controller = (TreeResourceController)input;
            TypedTreeModel model = (TypedTreeModel)controller.getModel();
            model.setSorting(this.getColumnIndex(model.getSpec()), order);
            if (context.isInteractive()) {
                System.out.println("Sorted by " + this.column + " in " + (this.ascending ? "ascending" : "descending") + " order.");
            }
            return context;
        }
        throw new JvmProfReportException("Unsupported controller type for sort command: " + input.getClass().getName());
    }

    private int getColumnIndex(TypedColumnSpec spec) throws JvmProfReportException {
        for (int i = 0; i < spec.getNrOfColumns(); ++i) {
            if (!this.column.equals(spec.getColumnText(i).toLowerCase())) continue;
            return i;
        }
        System.err.println("Unknown column: " + this.column);
        this.printPossibleColumns(spec);
        throw new JvmProfReportException("");
    }

    private void printPossibleColumns(TypedColumnSpec spec) {
        System.err.println("Available Columns:");
        for (int i = 0; i < spec.getNrOfColumns(); ++i) {
            String name = spec.getColumnText(i);
            if (name == null || "".equals(name.trim())) continue;
            System.err.println("  " + spec.getColumnText(i).toLowerCase());
        }
    }
}

