/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ColumnResourceController;
import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.SortCommand;
import java.util.List;

public final class SortCommandFactory
implements ReportCommandFactory {
    private static final String SORT_PREFIX = "sort by ";
    public static final String ASCENDING_SUFFIX = " ascending";
    public static final String DESCENDING_SUFFIX = " descending";

    @Override
    public ReportCommand create(String command) {
        String c = command.trim();
        if (!c.startsWith(SORT_PREFIX) || !c.endsWith(ASCENDING_SUFFIX) && !c.endsWith(DESCENDING_SUFFIX) || c.length() < SORT_PREFIX.length() + DESCENDING_SUFFIX.length() + 1) {
            return null;
        }
        boolean ascending = c.endsWith(ASCENDING_SUFFIX);
        String column = c.substring(SORT_PREFIX.length(), c.length() - (ascending ? ASCENDING_SUFFIX.length() : DESCENDING_SUFFIX.length())).toLowerCase();
        return new SortCommand(column, ascending);
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < SORT_PREFIX.length() && SORT_PREFIX.startsWith(prefix) || prefix.length() >= SORT_PREFIX.length() && prefix.startsWith(SORT_PREFIX))) {
            return false;
        }
        System.out.println("Sort the profiling data by a given column");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  sort by <column> ascending");
        System.out.println("  sort by <column> descending");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <column>               The name of the column to sort by.");
        System.out.println("                         The range of valid names is specific for each statistic or tree.");
        System.out.println("                         (All possible column names are shown in case the name is unknown.)");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        Object context = executionContext.getController();
        if (!(context instanceof TableResourceController) && !(context instanceof TreeResourceController)) {
            return;
        }
        if (SORT_PREFIX.startsWith(commandPrefix) && SORT_PREFIX.length() > commandPrefix.length()) {
            commands.add(SORT_PREFIX);
        }
        if (commandPrefix.startsWith(SORT_PREFIX)) {
            ColumnResourceController<TypedTableModel> controller;
            TypedColumnSpec spec = null;
            if (context instanceof TableResourceController) {
                controller = (TableResourceController)context;
                spec = ((TypedTableModel)controller.getModel()).getSpec();
            } else if (context instanceof TreeResourceController) {
                controller = (TreeResourceController)context;
                spec = ((TypedTreeModel)controller.getModel()).getSpec();
            } else assert (false);
            String columnPrefix = commandPrefix.substring(SORT_PREFIX.length()).trim();
            for (int i = 0; i < spec.getNrOfColumns(); ++i) {
                String column = spec.getColumnText(i).toLowerCase();
                if (column.length() > 0 && column.startsWith(columnPrefix)) {
                    commands.add(SORT_PREFIX + column + ASCENDING_SUFFIX);
                    commands.add(SORT_PREFIX + column + DESCENDING_SUFFIX);
                }
                if (!columnPrefix.startsWith(column) || columnPrefix.length() <= column.length()) continue;
                String sortPrefix = columnPrefix.substring(column.length()).trim();
                if (ASCENDING_SUFFIX.startsWith(sortPrefix, 1)) {
                    commands.add(SORT_PREFIX + column + ASCENDING_SUFFIX);
                }
                if (!DESCENDING_SUFFIX.startsWith(sortPrefix, 1)) continue;
                commands.add(SORT_PREFIX + column + DESCENDING_SUFFIX);
            }
        }
    }
}

