/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.presentation.graph.TimeSeriesUtils;
import com.sap.jvm.profiling.presentation.graph.ValueSetUtils;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.XmlModelExporter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ExportCommandFactory;
import com.sap.jvm.profiling.viewer.graph.ValueSetModel;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModel;
import java.io.File;
import java.io.IOException;

public final class XmlExportCommand
implements ReportCommand {
    private final String file;
    private final boolean selectionOnly;

    public XmlExportCommand(String file, boolean selectionOnly) {
        this.file = file;
        this.selectionOnly = selectionOnly;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        XmlModelExporter exporter;
        Object input = context.getController();
        if (!(input instanceof ResourceController)) {
            throw new JvmProfReportException("Unknown input for export command.");
        }
        ExportCommandFactory.checkOverwrite(context, this.file);
        ResourceController rc = (ResourceController)input;
        Object model = rc.getModel();
        if (model instanceof TypedTableModel) {
            exporter = ((TypedTableModel)model).getXmlExporter(this.selectionOnly);
        } else if (model instanceof TypedTreeModel) {
            exporter = ((TypedTreeModel)model).getXmlExporter(this.selectionOnly);
        } else if (model instanceof ValueSetModel) {
            exporter = ValueSetUtils.getXmlExporter((ValueSetModel)model);
        } else if (model instanceof TimeSeriesModel) {
            exporter = TimeSeriesUtils.getXmlExporter((TimeSeriesModel)model);
        } else {
            throw new JvmProfReportException("Unknown model type: " + model.getClass().getName());
        }
        try {
            if (context.isInteractive()) {
                System.out.print("Exporting profiling data to file '" + this.file + "'... ");
            }
            ProgressReporter reporter = new ProgressReporter();
            exporter.writeXml(new File(this.file), reporter);
            reporter.finish();
            if (context.isInteractive()) {
                System.out.println("finished.");
            }
            return context;
        }
        catch (IOException e) {
            if (context.isInteractive()) {
                System.out.println("failed.");
            }
            throw new JvmProfReportException("Error while exporting data: " + e.getMessage());
        }
    }
}

