/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.GraphContainerChart;
import com.sap.jvm.profiling.ui.graph.axes.AxisLabelDimensionProvider;
import com.sap.jvm.profiling.ui.graph.axes.GraphAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxis;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.DataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.legend.LegendPositionAnchor;
import com.sap.jvm.profiling.ui.graph.renderer.ChartsContainerActionListener;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.List;

public class AxisChart
extends GraphContainerChart<DataSet> {
    public static final int VERTICAL_ORIENTATION = 0;
    public static final int HOROZONTAL_ORIENTATION = 1;
    public static final int LABEL_LEFT = 0;
    public static final int LABEL_ONTOP = 0;
    public static final int LABEL_RIGHT = 1;
    public static final int LABEL_BELOW = 1;
    private GraphChartContainer chartsContainer;
    private LineGraphAxis axis;
    private GraphAxisModel axisModel;
    private Rectangle mainArea = new Rectangle();
    Rectangle[] allChartAreas = new Rectangle[]{this.mainArea, this.graphArea};
    private int paddingStart = 0;
    private int paddinEnd = 0;
    private final LegendPositionAnchor[] ANCHORS;
    private ChartsContainerActionListener actionListener = new ChartsContainerActionListener(){

        @Override
        public void dispose() {
        }

        @Override
        public void initializedDrawingArea(Renderer source, GraphChartContainer.DisplayCell cell) {
            Rectangle newGraphArea = cell.getGraphArea();
            AxisChart.this.graphArea.update(newGraphArea.x, newGraphArea.y, newGraphArea.width, newGraphArea.height);
        }

        @Override
        public void resizedDrawingArea(Renderer renderer, GraphChartContainer.DisplayCell cell) {
            Rectangle newGraphArea = cell.getEntireArea();
            if (AxisChart.this.axis.getOrientation() == 1) {
                int height = AxisChart.this.axis.getMinDimension(AxisChart.this.getRenderer());
                AxisChart.this.mainArea.update(newGraphArea.x, newGraphArea.y, newGraphArea.width, height);
                AxisChart.this.graphArea.update(newGraphArea.x + AxisChart.this.paddingStart, newGraphArea.y, Math.max(newGraphArea.width - AxisChart.this.paddingStart - AxisChart.this.paddinEnd, 0), height);
                AxisChart.this.axisModel.recalculateRaster(AxisChart.this.graphArea.width, -1);
            } else {
                int width = Math.min(AxisChart.this.axis.getMinDimension(AxisChart.this.getRenderer()), newGraphArea.width);
                AxisChart.this.mainArea.update(newGraphArea.x, newGraphArea.y, width, newGraphArea.height);
                AxisChart.this.graphArea.update(newGraphArea.x, newGraphArea.y - AxisChart.this.paddingStart, width, newGraphArea.height - AxisChart.this.paddingStart - AxisChart.this.paddinEnd);
                AxisChart.this.axisModel.recalculateRaster(AxisChart.this.graphArea.height, -1);
            }
            AxisChart.this.notifyLayoutListener(AxisChart.this.mainArea, AxisChart.this.allChartAreas);
        }

        @Override
        public boolean hasModelDataChanged() {
            return true;
        }

        @Override
        public void repaintDrawingArea(Renderer renderer) {
            renderer.setPaintArea(AxisChart.this.mainArea);
            renderer.clearDrawingArea();
            AxisChart.this.axis.repaintAxis(true, false, null, AxisChart.this.graphArea, AxisChart.this.mainArea, renderer);
        }

        @Override
        public void postRestoredScreen(Renderer renderer) {
        }

        @Override
        public void mouseDownLeft(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseDownRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseHovered(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMoved(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMovedByLeftPressed(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMovedByRightPressed(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseUpLeft(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseUpRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseDoubleClicked(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }
    };

    public AxisChart(GraphChartContainer chartsContainer) {
        this(chartsContainer, 1, 1);
    }

    public AxisChart(GraphChartContainer chartsContainer, int orientation, int labelPosition) {
        this.chartsContainer = chartsContainer;
        this.axisModel = new GraphAxisModel(true);
        this.axis = new LineGraphAxis(this.axisModel, orientation, labelPosition, this.getRenderer());
        this.axis.enableLableBlending(false);
        this.ANCHORS = orientation == 1 ? new LegendPositionAnchor[]{new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.RIGHT_TOP, this.graphArea, 0), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_TOP, this.graphArea, 1)} : new LegendPositionAnchor[]{new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_TOP, this.graphArea, 0), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_BOTTOM, this.graphArea, 1)};
    }

    public int getPaddingStart() {
        return this.paddingStart;
    }

    public void setPaddingStart(int paddingStart) {
        this.paddingStart = paddingStart;
    }

    public int getPaddinEnd() {
        return this.paddinEnd;
    }

    public void setPaddingEnd(int paddinEnd) {
        this.paddinEnd = paddinEnd;
    }

    public void adjustAxisToReadableValues() {
        this.axisModel.adjustAxisToReadableValues();
    }

    public void adjustAxis(double minValue, double maxValue) {
        this.axisModel.adjustAxis(minValue, maxValue, this.graphArea.width);
    }

    public double getMin() {
        return this.axisModel.getMin();
    }

    public double getMax() {
        return this.axisModel.getMax();
    }

    public void setRasterAdapter(RasterCalculationAdapter rasterAdapter) {
        this.axisModel.setRasterAdapter(rasterAdapter);
    }

    public void setAxisCaptionProvider(LineGraphAxisCaptionProvider caption_provider) {
        this.axis.setAxisCaptionProvider(caption_provider);
    }

    public void setLabelDimensionProvider(AxisLabelDimensionProvider labelDimensionProvider) {
        this.axisModel.setLabelDimensionProvider(labelDimensionProvider);
    }

    public double getAxisRasterSize() {
        return this.axisModel.getAxisRasterSize();
    }

    public int getAxisRasterPixelSize(int pixelLength) {
        return this.axisModel.getAxisRasterPixelSize(pixelLength);
    }

    public double getAxisRasterStart() {
        return this.axisModel.getAxisRasterStart();
    }

    public boolean isHorizontal() {
        return this.axisModel.isHorizontal();
    }

    @Override
    public Renderer getRenderer() {
        return this.chartsContainer.getRenderer();
    }

    @Override
    public LegendPositionAnchor getDefaultLegedPosition() {
        return this.ANCHORS[0];
    }

    @Override
    public LegendPositionAnchor[] getLegendAnchors() {
        return this.ANCHORS;
    }

    @Override
    public void addGraph(DataSet data) {
    }

    @Override
    public void addGraph(DataSet graph, boolean secondary) {
    }

    @Override
    public List<DataSet> getAllGraphs() {
        return new ArrayList<DataSet>(0);
    }

    @Override
    public void removeAllGraphs() {
    }

    @Override
    public void refresh() {
        this.actionListener.repaintDrawingArea(this.chartsContainer.getRenderer());
        this.actionListener.postRestoredScreen(this.chartsContainer.getRenderer());
        this.chartsContainer.updateFullScreen();
    }

    @Override
    public ChartsContainerActionListener provideContainerListener() {
        return this.actionListener;
    }

    @Override
    public Rectangle getMinBounds() {
        return new Rectangle(0, 0, 100, this.axis.getMinDimension(this.getRenderer()));
    }

    @Override
    public void keyNext() {
    }

    @Override
    public void keyPrevious() {
    }

    @Override
    public String getAccessibleControlName() {
        return "";
    }

    @Override
    public String getAccessibleStateText() {
        return "";
    }
}

