/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.ui.graph.BarGraphContainer;
import com.sap.jvm.profiling.ui.graph.BarGraphMoveController;
import com.sap.jvm.profiling.ui.graph.BarGraphRenderer;
import com.sap.jvm.profiling.ui.graph.BarGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.BarGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.GraphContainerChart;
import com.sap.jvm.profiling.ui.graph.XYGraphContainerListener;
import com.sap.jvm.profiling.ui.graph.axes.BarGraphAxis;
import com.sap.jvm.profiling.ui.graph.axes.BarGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxis;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisAdapter;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxisModelListener;
import com.sap.jvm.profiling.ui.graph.dataset.AccBarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.BarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.XYGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.legend.LegendPositionAnchor;
import com.sap.jvm.profiling.ui.graph.mouse.BarGraphMouseActionController;
import com.sap.jvm.profiling.ui.graph.renderer.ChartsContainerActionListener;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import com.sap.jvm.tracing.Trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BarGraphChart
extends GraphContainerChart<BarGraphDataSet> {
    private boolean xAxisShow;
    private boolean yAxisShow;
    private boolean enableVericalBarTitles;
    private Rectangle mainArea = new Rectangle();
    private Rectangle axisYArea = new Rectangle();
    private Rectangle axisYClippArea = new Rectangle();
    private Rectangle axisXArea = new Rectangle();
    private Rectangle axisXClippArea = new Rectangle();
    private Rectangle[] allChartAreas = new Rectangle[]{this.mainArea, this.axisXArea, this.axisYArea, this.graphArea};
    private BarGraphToolTipProvider toolTipProvider;
    private BarGraphContainer container;
    private BarGraphMouseActionController mouseController;
    private BarGraphMoveController moveController;
    private XYGraphAxesModel axesModel = new XYGraphAxesModel();
    private LineGraphAxis value_axis;
    private BarGraphAxis barsAxis;
    private List<BarGraphDataSet> dataSets = new ArrayList<BarGraphDataSet>();
    private List<String> toolTips = new ArrayList<String>();
    private List<Rectangle> toolTipAreas = new ArrayList<Rectangle>();
    private GraphChartContainer chartsContainer;
    List<BarGraphRenderer.DisplayedBar> displayedBars = new ArrayList<BarGraphRenderer.DisplayedBar>();
    private List<BarGraphSelectionListener> listeners = new ArrayList<BarGraphSelectionListener>();
    private Map<BarGraphDataSet, Set<Value2D>> selectedGraphs = new HashMap<BarGraphDataSet, Set<Value2D>>();
    private final LegendPositionAnchor[] ANCHORS = new LegendPositionAnchor[]{new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.RIGHT_TOP, this.graphArea, 0), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.RIGHT_BOTTOM, this.graphArea, 1), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_BOTTOM, this.graphArea, 2), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_TOP, this.graphArea, 3)};
    private GraphChartContainer.DisplayCell containerDisplayCell;
    private ChartsContainerActionListener actionListener = new ChartsContainerActionListener(){

        @Override
        public void dispose() {
        }

        @Override
        public void initializedDrawingArea(Renderer source, GraphChartContainer.DisplayCell cell) {
            BarGraphChart.this.axesModel.setListenersEnabled(false);
            BarGraphChart.this.axesModel.setAxesToDefault(source.getWidth(), source.getHeight());
            BarGraphChart.this.axesModel.adjustXAxis(BarGraphChart.this.graphArea.width, BarGraphChart.this.axesModel.getMinX(), BarGraphChart.this.axesModel.getMaxX() + 1.0 - BarGraphChart.this.axesModel.getMaxX() % 1.0);
            this.resizedDrawingArea(source, cell);
            BarGraphChart.this.axesModel.setListenersEnabled(true);
        }

        @Override
        public void resizedDrawingArea(Renderer renderer, GraphChartContainer.DisplayCell cell) {
            if (!renderer.isVisibleInitialized()) {
                return;
            }
            BarGraphChart.this.mainArea = cell.getGraphArea();
            ((BarGraphChart)BarGraphChart.this).allChartAreas[0] = BarGraphChart.this.mainArea;
            BarGraphChart.this.containerDisplayCell = cell;
            BarGraphChart.this.updateAreaSizes(renderer);
        }

        @Override
        public boolean hasModelDataChanged() {
            return true;
        }

        @Override
        public void repaintDrawingArea(Renderer renderer) {
            if (renderer.getScreenHeight() > 10 && renderer.getScreenWidth() > 10) {
                BarGraphChart.this.paint(renderer, true);
            } else {
                renderer.restoreScreen(BarGraphChart.this);
            }
        }

        @Override
        public void postRestoredScreen(Renderer source) {
        }

        @Override
        public void mouseDownLeft(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            BarGraphChart.this.mouseController.mouseDownLeft(x, y);
            if (BarGraphChart.this.mouseController.setHoveredBar(BarGraphChart.this.getBarAt(x, y))) {
                BarGraphChart.this.mouseController.setLeftAction(15);
            } else {
                BarGraphChart.this.mouseController.setLeftAction(0);
            }
        }

        @Override
        public void mouseDownRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            BarGraphChart.this.mouseController.mouseDownRight(x, y);
            BarGraphChart.this.mouseController.setRightAction(0);
            if (BarGraphChart.this.moveController.isEnabled() && BarGraphChart.this.graphArea.isIn(x, y)) {
                BarGraphChart.this.moveController.setStartPosition(BarGraphChart.this.graphArea.getXinRec(x), BarGraphChart.this.axesModel);
                BarGraphChart.this.mouseController.setRightAction(8);
            }
        }

        @Override
        public void mouseHovered(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (BarGraphChart.this.axisXArea.isIn(x, y)) {
                String tip = BarGraphChart.this.getToolTipAt(BarGraphChart.this.axisXArea.getXinRec(x), BarGraphChart.this.axisXArea.getYinRec(y));
                if (tip != null) {
                    renderer.provideToolTip(x, y, tip);
                }
                return;
            }
            if (BarGraphChart.this.toolTipProvider != null && BarGraphChart.this.graphArea.isIn(x, y)) {
                BarGraphRenderer.DisplayedBar bar = BarGraphChart.this.getBarAt(x, y);
                if (bar != null) {
                    renderer.provideToolTip(x, y, BarGraphChart.this.toolTipProvider.provideToolTip(bar.getDataSet(), bar.getIndex()));
                }
                return;
            }
        }

        @Override
        public void mouseMovedByRightPressed(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (BarGraphChart.this.mouseController.getRightAction() == 8 && BarGraphChart.this.moveController.move(x, BarGraphChart.this.axesModel, BarGraphChart.this.graphArea)) {
                BarGraphChart.this.refresh();
            }
        }

        @Override
        public void mouseUpLeft(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (BarGraphChart.this.mouseController.getLeftAction() == 15) {
                if (BarGraphChart.this.mouseController.getHoveredBar() == BarGraphChart.this.getBarAt(x, y)) {
                    BarGraphRenderer.DisplayedBar bar = BarGraphChart.this.mouseController.getHoveredBar();
                    Value2D val = bar.getDataSet().getValueAt(bar.getIndex());
                    if (BarGraphChart.this.isSelected(bar.getDataSet(), val)) {
                        BarGraphChart.this.resetSingleSelection(bar.getDataSet(), bar.getIndex());
                    } else {
                        BarGraphChart.this.setSingleSelection(bar.getDataSet(), bar.getIndex());
                    }
                    BarGraphChart.this.refreshWithContainerFullScreenUpdate();
                }
                return;
            }
            if (BarGraphChart.this.isAnySelected()) {
                BarGraphChart.this.resetSelection(false);
                BarGraphChart.this.refreshWithContainerFullScreenUpdate();
            } else {
                BarGraphChart.this.refresh();
            }
        }

        @Override
        public void mouseUpRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMoved(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseDoubleClicked(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMovedByLeftPressed(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }
    };

    public BarGraphChart(GraphChartContainer chartsContainer, boolean x_axis_show, boolean y_axis_show) {
        this.chartsContainer = chartsContainer;
        this.xAxisShow = x_axis_show;
        this.yAxisShow = y_axis_show;
        this.container = new BarGraphContainer(chartsContainer.getRenderer());
        this.mouseController = new BarGraphMouseActionController();
        this.value_axis = new LineGraphAxis(this.axesModel.getYAxis(), 0, 0, chartsContainer.getRenderer());
        this.axesModel.setFixedXRaster(1.0);
        this.barsAxis = new BarGraphAxis(this.axesModel, this);
        this.moveController = new BarGraphMoveController();
        this.axesModel.addAxisListener(new XYGraphAxisModelListener(){

            @Override
            public void adjustedYAxis(XYGraphAxesModel source) {
                if (BarGraphChart.this.yAxisShow) {
                    BarGraphChart.this.notifyACC();
                }
            }

            @Override
            public void adjustedXAxis(XYGraphAxesModel source) {
                if (BarGraphChart.this.xAxisShow) {
                    BarGraphChart.this.notifyACC();
                }
            }

            @Override
            public void adjustedBothAxis(XYGraphAxesModel source) {
                if (BarGraphChart.this.xAxisShow || BarGraphChart.this.yAxisShow) {
                    BarGraphChart.this.notifyACC();
                }
            }

            @Override
            public void undoStackChanged(XYGraphAxesModel source) {
            }
        });
        this.listeners.add(new BarGraphSelectionListener(){

            @Override
            public void selectionChanged(BarSelectedValues selection, boolean selected) {
                BarGraphChart.this.notifyACC();
            }
        });
    }

    @Override
    public Renderer getRenderer() {
        return this.chartsContainer.getRenderer();
    }

    @Override
    public LegendPositionAnchor getDefaultLegedPosition() {
        return this.ANCHORS[0];
    }

    @Override
    public LegendPositionAnchor[] getLegendAnchors() {
        return this.ANCHORS;
    }

    @Override
    public void refresh() {
        this.actionListener.repaintDrawingArea(this.chartsContainer.getRenderer());
        this.chartsContainer.updateScreen(this.containerDisplayCell);
    }

    private void refreshWithContainerFullScreenUpdate() {
        this.actionListener.repaintDrawingArea(this.chartsContainer.getRenderer());
        this.chartsContainer.updateFullScreen();
    }

    @Override
    public void addGraph(BarGraphDataSet graph) {
        this.addGraph(graph, false);
    }

    @Override
    public void addGraph(BarGraphDataSet graph, boolean secondary) {
        this.container.appendGraph(graph, secondary);
        this.dataSets.add(graph);
    }

    @Override
    public void addGraph(final AccBarGraphDataSet data, boolean secondary) {
        BarGraphDataSet dataWrapper = new BarGraphDataSet(""){

            @Override
            public XYGraphDataSet.GraphType getType() {
                return XYGraphDataSet.GraphType.COMBINED;
            }

            @Override
            public Iterator<Value2D> iterator() {
                return data.iterator();
            }

            @Override
            public long getSize() {
                return data.getSize();
            }

            @Override
            public String getName() {
                return data.getName();
            }

            @Override
            public boolean isEmpty() {
                return data.isEmpty();
            }

            @Override
            public double getYValueAt(double x) {
                double value = 0.0;
                for (BarGraphDataSet set : data.getDataSets()) {
                    value += set.getYValueAt(x);
                }
                return value;
            }

            @Override
            public XYGraphDataSet[] getCombinedItems() {
                return data.getDataSets();
            }
        };
        dataWrapper.setData(null, data);
        this.container.appendGraph(dataWrapper, secondary);
        this.dataSets.add(dataWrapper);
    }

    @Override
    public List<BarGraphDataSet> getAllGraphs() {
        return this.container.getAllGraphs();
    }

    @Override
    public void removeAllGraphs() {
        this.container.removeAllGraphs(null);
        this.dataSets.clear();
        this.selectedGraphs.clear();
    }

    public void setToolTipProvider(BarGraphToolTipProvider provider) {
        this.toolTipProvider = provider;
    }

    public void initAxes() {
        this.container.initAxes(this.axesModel, null);
    }

    public void addGraphContainerListener(XYGraphContainerListener<BarGraphDataSet> listener) {
        this.container.addGraphContainerListener(listener);
    }

    public void removeGraphContainerListener(XYGraphContainerListener<BarGraphDataSet> listener) {
        this.container.removeGraphContainerListener(listener);
    }

    public void setRasterColor(Color color) {
        this.value_axis.setRasterColor(color);
    }

    public void setRasterAdaptor(RasterCalculationAdapter adapter) {
        this.axesModel.setYRasterAdapter(adapter);
    }

    public void setRangeAxisAdaptor(RangeLineAxisAdapter xAdapter, RangeLineAxisAdapter yAdapter) {
        this.axesModel.setRangeAxisAdaptor(xAdapter, yAdapter);
    }

    public void setAxesCaptionProvider(BarGraphAxisCaptionProvider provider) {
        if (this.value_axis != null) {
            this.value_axis.setAxisCaptionProvider(provider);
        }
        this.barsAxis.setAxisCaptionProvider(provider);
    }

    public List<BarGraphRenderer.DisplayedBar> getAllVisibleBars() {
        return this.displayedBars;
    }

    public void addSelectionListener(BarGraphSelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionListener(BarGraphSelectionListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void adjustXAxis(long min, long max) {
        this.axesModel.adjustXAxis(this.graphArea.width, min, max);
    }

    public void adjustYAxis(double min, double max) {
        this.axesModel.adjustYAxis(this.graphArea.height, min, max);
    }

    public void enableContentScrolling(boolean enable) {
        if (enable) {
            this.moveController.enable(false);
        }
        this.moveController.enable(enable);
    }

    public void enableContentScrolling(int min, int max) {
        this.moveController.enable(true);
        this.moveController.setMoveRange(min, max);
    }

    public void enableVerticalBarTitels(boolean enable) {
        this.enableVericalBarTitles = enable;
    }

    public boolean isVerticalBarTitelsEnabled() {
        return this.enableVericalBarTitles;
    }

    @Override
    public ChartsContainerActionListener provideContainerListener() {
        return this.actionListener;
    }

    private void updateAreaSizes(Renderer renderer) {
        int fontHeight = renderer.getFontHeight();
        int availableHeight = this.mainArea.height;
        int xAxisHeight = 0;
        if (this.xAxisShow) {
            if (this.enableVericalBarTitles) {
                xAxisHeight = this.barsAxis.getVerticalTitleDimension(renderer);
            } else {
                int minSize = this.barsAxis.getMinDimension(renderer);
                int prefSize = this.axesModel.getXAxis().getPreferredDisplaySize();
                if (prefSize <= minSize) {
                    xAxisHeight = prefSize;
                } else {
                    double factor = Math.min(1.0, (double)this.mainArea.height * 0.003);
                    xAxisHeight = minSize + (int)Math.round((double)(prefSize - minSize) * factor);
                }
                if (xAxisHeight > availableHeight / 2) {
                    xAxisHeight = availableHeight / 2;
                }
            }
        }
        int graphAreaHeight = this.xAxisShow ? availableHeight + 1 : (availableHeight -= xAxisHeight);
        int yAxisWidth = 0;
        if (this.yAxisShow) {
            int prefSize = this.axesModel.getYAxis().getPreferredDisplaySize() + (this.value_axis.hasAxisTitle() ? fontHeight : 0);
            yAxisWidth = Math.max(this.value_axis.getMinDimension(renderer), prefSize);
            this.axisYArea.update(this.mainArea.x, this.mainArea.y, yAxisWidth, graphAreaHeight);
            this.axisYClippArea.update(this.axisYArea.x, this.axisYArea.y + fontHeight / 2, this.axisYArea.width, this.axisYArea.height + fontHeight);
        }
        if (this.xAxisShow) {
            this.axisXArea.update(this.mainArea.x + (this.yAxisShow ? this.axisYArea.width - 1 : 0), this.mainArea.y_end + xAxisHeight, this.mainArea.width - yAxisWidth, xAxisHeight);
            this.axisXClippArea.update(this.mainArea.x, this.axisXArea.y, this.mainArea.width, this.axisXArea.height);
        }
        this.graphArea.update(this.yAxisShow ? this.mainArea.x + yAxisWidth - 1 : this.mainArea.x, this.mainArea.y, this.yAxisShow ? this.mainArea.width - yAxisWidth : this.mainArea.width, graphAreaHeight);
        this.axesModel.recalculateAxesRaster(this.graphArea.width, this.graphArea.height);
        this.notifyLayoutListener(this.graphArea, this.allChartAreas);
    }

    private void paint(Renderer renderer, boolean allowRecursion) {
        renderer.setPaintArea(this.mainArea);
        renderer.clearDrawingArea();
        boolean axesNeedResize = false;
        if (this.yAxisShow) {
            this.value_axis.repaintAxis(this.graphArea, this.axisYArea, this.axisYClippArea, renderer);
            if (this.value_axis.getMinDimension(renderer) > this.axisYArea.width) {
                axesNeedResize = true;
            }
        }
        if (axesNeedResize && allowRecursion) {
            this.updateAreaSizes(renderer);
            this.paint(renderer, false);
            return;
        }
        if (!this.dataSets.isEmpty()) {
            renderer.setPaintArea(this.graphArea);
            this.container.getGraphRenderer().prepareGraphArea(this.barsAxis.calculateRaster(this.graphArea.width, this.graphArea.height), this.dataSets, this.axesModel, this);
            renderer.setPaintArea(this.graphArea);
            this.container.repaintGraphs(this.axesModel, this.dataSets);
        }
        if (this.xAxisShow) {
            renderer.setPaintArea(this.axisXArea);
            this.barsAxis.repaint(this.graphArea, this.axisXArea, this.axisXClippArea, renderer);
        }
        renderer.saveScreen(this.mainArea, this);
    }

    BarGraphRenderer.DisplayedBar getBarAt(int x, int y) {
        for (BarGraphRenderer.DisplayedBar sel : this.displayedBars) {
            if (!sel.isIn(x, y)) continue;
            return sel;
        }
        return null;
    }

    BarGraphRenderer.DisplayedBar getBarAt(int x) {
        for (BarGraphRenderer.DisplayedBar sel : this.displayedBars) {
            if (!sel.isInXRange(x)) continue;
            return sel;
        }
        return null;
    }

    public void addAxisCaptionToolTip(Rectangle captionRec, String tooltip) {
        this.toolTips.add(tooltip);
        this.toolTipAreas.add(captionRec);
    }

    public void removeAllToolTips() {
        this.toolTipAreas.clear();
        this.toolTips.clear();
    }

    public String getToolTipAt(int x, int y) {
        for (int i = 0; i < this.toolTipAreas.size(); ++i) {
            if (!this.toolTipAreas.get(i).isIn(x, y)) continue;
            return this.toolTips.get(i);
        }
        return null;
    }

    protected void setSelectionChange(BarGraphDataSet data) {
        Set<Value2D> selected;
        if (!this.selectedGraphs.containsKey(data)) {
            this.selectedGraphs.put(data, new HashSet());
        }
        if ((long)(selected = this.selectedGraphs.get(data)).size() == data.getSize()) {
            this.selectedGraphs.remove(data);
            this.notifySelectionListeners(new BarSelectedValuesImpl(data), false);
        } else {
            ArrayList<Value2D> newSelection = new ArrayList<Value2D>();
            for (Value2D val : data) {
                if (selected.contains(val)) continue;
                selected.add(val);
                newSelection.add(val);
            }
            this.notifySelectionListeners(new BarSelectedValuesImpl(data, newSelection), true);
        }
    }

    public void setSelection(BarGraphDataSet data, boolean selected, boolean withListeners) {
        if (selected) {
            Set<Value2D> dataSel;
            if (!this.selectedGraphs.containsKey(data)) {
                this.selectedGraphs.put(data, new HashSet());
            }
            if ((long)(dataSel = this.selectedGraphs.get(data)).size() != data.getSize()) {
                ArrayList<Value2D> newSelection = new ArrayList<Value2D>();
                for (Value2D val : data) {
                    if (dataSel.contains(val)) continue;
                    dataSel.add(val);
                    newSelection.add(val);
                }
                if (withListeners) {
                    this.notifySelectionListeners(new BarSelectedValuesImpl(data, newSelection), true);
                }
            }
        } else {
            Set<Value2D> removedList = this.selectedGraphs.remove(data);
            if (removedList != null && withListeners) {
                this.notifySelectionListeners(new BarSelectedValuesImpl(data, removedList), false);
            }
        }
    }

    public void resetSelection(BarGraphDataSet data, boolean silent) {
        if (this.selectedGraphs.containsKey(data)) {
            Set<Value2D> removedList = this.selectedGraphs.remove(data);
            if (!silent) {
                this.notifySelectionListeners(new BarSelectedValuesImpl(data, removedList), false);
            }
        }
    }

    public void resetSelection(boolean silent) {
        if (!this.selectedGraphs.isEmpty()) {
            BarSelectedValues[] selections = new BarSelectedValues[this.selectedGraphs.size()];
            int i = 0;
            for (Map.Entry<BarGraphDataSet, Set<Value2D>> e : this.selectedGraphs.entrySet()) {
                selections[i++] = new BarSelectedValuesImpl(e);
            }
            this.selectedGraphs.clear();
            if (!silent) {
                for (BarSelectedValues sel : selections) {
                    this.notifySelectionListeners(sel, false);
                }
            }
        }
    }

    public void setSingleSelection(BarGraphDataSet data, Value2D value, boolean selection, boolean withListeners) {
        if (selection) {
            this.setSingleSelection(data, value, withListeners);
        } else {
            Set<Value2D> selected = this.selectedGraphs.get(data);
            if (selected != null) {
                if (selected.contains(value)) {
                    selected.remove(value);
                    if (withListeners) {
                        this.notifySelectionListeners(new BarSelectedValuesImpl(data, value), false);
                    }
                }
                if (selected.isEmpty()) {
                    this.selectedGraphs.remove(data);
                }
            }
        }
    }

    protected void setSingleSelection(BarGraphDataSet data, int idx) {
        if (!this.selectedGraphs.containsKey(data)) {
            this.selectedGraphs.put(data, new HashSet());
        }
        Value2D val = data.getValueAt(idx);
        Set<Value2D> selected = this.selectedGraphs.get(data);
        if (!selected.contains(val)) {
            selected.add(val);
            this.notifySelectionListeners(new BarSelectedValuesImpl(data, val), true);
        }
    }

    protected void setSingleSelection(BarGraphDataSet data, Value2D value, boolean withListeners) {
        Set<Value2D> selected;
        if (!this.selectedGraphs.containsKey(data)) {
            this.selectedGraphs.put(data, new HashSet());
        }
        if (!(selected = this.selectedGraphs.get(data)).contains(value)) {
            selected.add(value);
            if (withListeners) {
                this.notifySelectionListeners(new BarSelectedValuesImpl(data, value), true);
            }
        }
    }

    protected void resetSingleSelection(BarGraphDataSet data, int idx) {
        Value2D val = data.getValueAt(idx);
        Set<Value2D> selected = this.selectedGraphs.get(data);
        if (selected.contains(val)) {
            selected.remove(val);
            this.notifySelectionListeners(new BarSelectedValuesImpl(data, val), false);
        }
        if (selected.isEmpty()) {
            this.selectedGraphs.remove(data);
        }
    }

    protected boolean isAnySelected() {
        return this.selectedGraphs.size() > 0;
    }

    public boolean isSelected(BarGraphDataSet data, Value2D val) {
        Set<Value2D> values = this.selectedGraphs.get(data);
        return values != null && values.contains(val);
    }

    public boolean isSelected(BarGraphDataSet data) {
        Set<Value2D> values = this.selectedGraphs.get(data);
        return values != null && (long)values.size() == data.getSize();
    }

    public boolean contains(BarGraphDataSet data) {
        for (BarGraphDataSet d : this.dataSets) {
            if (d.getType() == XYGraphDataSet.GraphType.COMBINED) {
                for (XYGraphDataSet acc : d.getCombinedItems()) {
                    if (acc != data) continue;
                    return true;
                }
                continue;
            }
            if (d != data) continue;
            return true;
        }
        return false;
    }

    protected BarSelectedValues[] getSelection() {
        BarSelectedValues[] selection = new BarSelectedValues[this.selectedGraphs.size()];
        int i = 0;
        for (Map.Entry<BarGraphDataSet, Set<Value2D>> e : this.selectedGraphs.entrySet()) {
            selection[i++] = new BarSelectedValuesImpl(e);
        }
        return selection;
    }

    private void notifySelectionListeners(BarSelectedValues selection, boolean selected) {
        try {
            if (!this.listeners.isEmpty()) {
                for (BarGraphSelectionListener l : this.listeners) {
                    l.selectionChanged(selection, selected);
                }
            }
        }
        catch (Throwable th) {
            Trace.error((Throwable)th);
        }
    }

    public void moveHorizontal(int pixels) {
        double val = this.axesModel.getXLength(this.graphArea.width, pixels);
        double min = this.axesModel.getMinX() + val;
        double max = this.axesModel.getMaxX() + val;
        this.axesModel.adjustXAxis(this.graphArea.width, min, max);
        this.refresh();
    }

    @Override
    public void keyNext() {
        this.moveHorizontal(-10);
    }

    @Override
    public void keyPrevious() {
        this.moveHorizontal(10);
    }

    @Override
    public String getAccessibleControlName() {
        return I18n._s((String)"Bar Chart");
    }

    @Override
    public String getAccessibleStateText() {
        StringBuilder text = new StringBuilder();
        if (this.value_axis != null) {
            text.append(this.value_axis.getAccessibleText());
            text.append(", ");
        }
        text.append(this.barsAxis.getAccessibleText());
        text.append(", ");
        if (this.moveController.isEnabled()) {
            text.append(I18n._s((String)"Use the arrow keys to move the graph."));
            text.append(" ");
        }
        StringBuilder selectionText = new StringBuilder();
        for (BarGraphDataSet set : this.selectedGraphs.keySet()) {
            if (!this.selectedGraphs.containsKey(set) || this.selectedGraphs.get(set).isEmpty()) continue;
            selectionText.append(set.getName());
            selectionText.append(", ");
            for (Value2D val : this.selectedGraphs.get(set)) {
                int idx = (int)val.x;
                selectionText.append(I18n._s((String)"selected bar at: {0}, value {1}", (Object[])new Object[]{this.barsAxis.getAccessibeValueText(idx), this.value_axis != null ? this.value_axis.getAccessibeValueText(val.y) : Double.valueOf(val.y)}));
                if (this.toolTipProvider != null) {
                    selectionText.append(", tooltip, ");
                    selectionText.append(this.toolTipProvider.provideToolTip(set, idx));
                }
                selectionText.append(", ");
            }
        }
        if (selectionText.length() > 0) {
            text.append((CharSequence)selectionText);
        } else {
            text.append(I18n._s((String)"Nothing selected."));
            text.append(' ');
        }
        return text.toString();
    }

    public static interface BarSelectedValues {
        public BarGraphDataSet getDataSet();

        public int[] getSelectedValues();
    }

    private static class BarSelectedValuesImpl
    implements BarSelectedValues {
        private BarGraphDataSet set;
        private int[] values;

        public BarSelectedValuesImpl(Map.Entry<BarGraphDataSet, Set<Value2D>> e) {
            this.set = e.getKey();
            this.values = new int[e.getValue().size()];
            int i = 0;
            for (Value2D val : e.getValue()) {
                this.values[i++] = (int)val.x;
            }
        }

        public BarSelectedValuesImpl(BarGraphDataSet set) {
            this.set = set;
            this.values = new int[(int)set.getSize()];
            int i = 0;
            for (Value2D val : set) {
                this.values[i++] = (int)val.x;
            }
        }

        public BarSelectedValuesImpl(BarGraphDataSet set, Collection<Value2D> selection) {
            this.set = set;
            this.values = new int[selection.size()];
            int i = 0;
            for (Value2D val : selection) {
                this.values[i++] = (int)val.x;
            }
        }

        public BarSelectedValuesImpl(BarGraphDataSet set, Value2D selection) {
            this.set = set;
            this.values = new int[1];
            int i = 0;
            this.values[i++] = (int)selection.x;
        }

        @Override
        public BarGraphDataSet getDataSet() {
            return this.set;
        }

        @Override
        public int[] getSelectedValues() {
            return this.values;
        }
    }
}

