/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;

public final class BarGraphMoveController {
    private boolean enabled;
    private int startX;
    private double minX;
    private double maxX;
    private int minBorder;
    private int maxBorder;

    public BarGraphMoveController() {
        this.enable(false);
    }

    public void enable(boolean enable) {
        this.enabled = enable;
        if (!enable) {
            this.maxBorder = 0;
            this.minBorder = 0;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setStartPosition(int x, XYGraphAxesModel axesModel) {
        this.startX = x;
        this.minX = axesModel.getMinX();
        this.maxX = axesModel.getMaxX();
        this.checkBorders(axesModel);
    }

    public boolean move(int xDisplay, XYGraphAxesModel axesModel, Rectangle graphArea) {
        int x;
        double delta;
        boolean hasMoved = false;
        if (this.enabled && (delta = axesModel.getXValue(graphArea.width, x = graphArea.getXinRec(xDisplay)) - axesModel.getXValue(graphArea.width, this.startX)) != 0.0) {
            double minPos = this.minX - delta;
            double maxPos = this.maxX - delta;
            if (this.minBorder != this.maxBorder) {
                if (minPos < (double)this.minBorder) {
                    maxPos = (double)this.minBorder + (maxPos - minPos);
                    minPos = this.minBorder;
                }
                if (maxPos > (double)this.maxBorder) {
                    minPos = (double)this.maxBorder - (maxPos - minPos);
                    maxPos = this.maxBorder;
                }
                hasMoved = axesModel.getMinX() != (double)this.minBorder && axesModel.getMaxX() != (double)this.maxBorder;
            } else {
                hasMoved = true;
            }
            axesModel.adjustXAxis(graphArea.width, minPos, maxPos);
        }
        return hasMoved;
    }

    public void setMoveRange(int min, int max) {
        if (min > max) {
            throw new IllegalStateException("Invalid scrolling range definition!!!");
        }
        this.minBorder = min;
        this.maxBorder = max;
    }

    private void checkBorders(XYGraphAxesModel axesModel) {
        if (this.minBorder != this.maxBorder) {
            this.minBorder = (int)axesModel.getMinX() < this.minBorder ? (int)axesModel.getMinX() : this.minBorder;
            this.maxBorder = (int)axesModel.getMaxX() > this.maxBorder ? (int)axesModel.getMaxX() : this.maxBorder;
        }
    }
}

