/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.BarGraphChart;
import com.sap.jvm.profiling.ui.graph.XYGraphRenderer;
import com.sap.jvm.profiling.ui.graph.axes.GraphAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.dataset.AccBarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.BarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.ColoredBarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.XYGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BarGraphRenderer
implements XYGraphRenderer<BarGraphDataSet> {
    private Map<BarGraphDataSet, List<IndexedPaintArea>> preparedBarFields = new HashMap<BarGraphDataSet, List<IndexedPaintArea>>();
    private BarGraphChart preparedChart;

    void prepareGraphArea(List<Rectangle> barAreas, List<BarGraphDataSet> dataList, XYGraphAxesModel axes_model, BarGraphChart chart) {
        this.preparedChart = chart;
        chart.displayedBars.clear();
        this.preparedBarFields.clear();
        double idx = axes_model.getMinX() - axes_model.getMinX() % axes_model.getXAxisRasterSize();
        if (axes_model.getMinX() < 0.0) {
            idx -= axes_model.getXAxisRasterSize();
        }
        if (barAreas.isEmpty()) {
            return;
        }
        int delta = (int)((double)barAreas.get((int)0).width * 0.8 / (double)dataList.size());
        for (int i = 0; i < barAreas.size(); ++i) {
            for (int j = 0; j < dataList.size(); ++j) {
                if (!this.preparedBarFields.containsKey(dataList.get(j))) {
                    this.preparedBarFields.put(dataList.get(j), new ArrayList());
                }
                List<IndexedPaintArea> paintAreas = this.preparedBarFields.get(dataList.get(j));
                paintAreas.add(new IndexedPaintArea(idx, new Rectangle(barAreas.get((int)i).x + 4 + delta * j, barAreas.get((int)i).y, delta - 1, barAreas.get((int)i).height)));
            }
            idx += axes_model.getXAxisRasterSize();
        }
    }

    @Override
    public void drawGraph(BarGraphDataSet data, Renderer renderer, XYGraphAxesModel axes_model) {
        List<IndexedPaintArea> paintAreas = this.preparedBarFields.get(data);
        GraphAxisModel yAxis = axes_model.getYAxis();
        if (paintAreas != null) {
            int yRref = yAxis.getPosition(renderer.getHeight(), 0.0);
            for (IndexedPaintArea i : paintAreas) {
                int yPos;
                int height;
                if (!(i.idx >= 0.0) || !(i.idx < (double)data.getSize())) continue;
                double yValue = data.getYValueAt(i.idx);
                int yValPos = yAxis.getPosition(renderer.getHeight(), yValue);
                if (yValPos > yRref) {
                    height = yValPos - yRref;
                    yPos = yValPos;
                } else {
                    height = yRref - yValPos;
                    yPos = yRref;
                }
                if (yValue != 0.0) {
                    renderer.setFillColor(Color.LIGHT_GRAY);
                    renderer.fillRectangle(i.paintArea.x + 2, yPos - 2, i.paintArea.width + 1, height + 1);
                }
                if (data.getType() == XYGraphDataSet.GraphType.COMBINED) {
                    AccBarGraphDataSet accData = (AccBarGraphDataSet)data.getData(null);
                    int low = height = yRref;
                    for (BarGraphDataSet set : accData.getDataSets()) {
                        double val = set.getYValueAt(i.idx);
                        if (val == 0.0) continue;
                        this.paintBar(renderer, set, (int)i.idx, i.paintArea.x, height += yAxis.getPosition(renderer.getHeight(), val) - yRref, i.paintArea.width, height - low - 1);
                        low = height;
                    }
                    continue;
                }
                this.paintBar(renderer, data, (int)i.idx, i.paintArea.x, yPos, i.paintArea.width, height);
            }
        }
    }

    private void paintBar(Renderer renderer, BarGraphDataSet data, int idx, int x, int y, int width, int height) {
        Color borderColor;
        Color fillColor;
        if (data.getType() == XYGraphDataSet.GraphType.COLORED) {
            ColoredBarGraphDataSet colorData = (ColoredBarGraphDataSet)data;
            fillColor = colorData.getColor(colorData.getValueAt(idx));
            borderColor = Color.darker(fillColor);
        } else {
            fillColor = data.getGraphColor();
            borderColor = Color.darker(fillColor);
        }
        Value2D value = data.getValueAt(idx);
        if (this.preparedChart.isAnySelected() && !this.preparedChart.isSelected(data, value)) {
            fillColor = Color.alpha(fillColor, Color.WHITE, 0.4);
            borderColor = Color.alpha(borderColor, Color.WHITE, 0.4);
        }
        renderer.setFillColor(fillColor);
        renderer.setForeground(borderColor);
        Rectangle graphArea = renderer.getPainArea();
        Rectangle barArea = new Rectangle(graphArea.getXonDisplay(x), graphArea.getYonDisplay(y), width, height);
        this.preparedChart.displayedBars.add(new DisplayedBar(barArea, data, idx));
        renderer.setAlpha(130);
        renderer.fillRectangle(x, y, width, height);
        renderer.setAlpha(255);
        renderer.drawRectangle(x, y, width, height);
        if (this.preparedChart.isSelected(data, value) && width > 1 && height > 1) {
            renderer.drawRectangle(x + 1, y - 1, width - 2, height - 2);
            if (width > 3 && height > 3) {
                renderer.drawRectangle(x + 2, y - 2, width - 4, height - 4);
                if (width > 5 && height > 5) {
                    renderer.drawRectangle(x + 3, y - 3, width - 6, height - 6);
                }
            }
        }
    }

    public static class DisplayedBar {
        private Rectangle viewRec;
        private BarGraphDataSet set;
        private int idx;

        public DisplayedBar(Rectangle viewRec, BarGraphDataSet set, int idx) {
            this.viewRec = viewRec;
            this.set = set;
            this.idx = idx;
        }

        public BarGraphDataSet getDataSet() {
            return this.set;
        }

        public int getIndex() {
            return this.idx;
        }

        public Rectangle getViewRect() {
            return this.viewRec;
        }

        public boolean isIn(int x, int y) {
            return this.viewRec.isIn(x, y);
        }

        public boolean isInXRange(int x) {
            return this.viewRec.isInXRange(x);
        }
    }

    static class IndexedPaintArea {
        double idx;
        Rectangle paintArea;

        public IndexedPaintArea(double idx, Rectangle paintArea) {
            this.idx = idx;
            this.paintArea = paintArea;
        }
    }
}

