/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.ui.graph.GraphContainerChart;
import com.sap.jvm.profiling.ui.graph.LineGraphChart;
import com.sap.jvm.profiling.ui.graph.TitleAlignment;
import com.sap.jvm.profiling.ui.graph.accessibility.AccessibilityStateListener;
import com.sap.jvm.profiling.ui.graph.accessibility.AccessibleControl;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.legend.GraphLegend;
import com.sap.jvm.profiling.ui.graph.legend.LegendAnchorController;
import com.sap.jvm.profiling.ui.graph.legend.LegendItem;
import com.sap.jvm.profiling.ui.graph.legend.LegendPositionAnchor;
import com.sap.jvm.profiling.ui.graph.legend.LegendSelectionHandler;
import com.sap.jvm.profiling.ui.graph.legend.LegendSelectionListener;
import com.sap.jvm.profiling.ui.graph.mouse.AbstractMouseActionController;
import com.sap.jvm.profiling.ui.graph.renderer.ChartsContainerActionListener;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import com.sap.jvm.profiling.ui.graph.renderer.RendererActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GraphChartContainer
implements AccessibleControl {
    private static final boolean DEBUG = false;
    private int BORDER_LEFT = 1;
    private int BORDER_RIGHT = 1;
    private int BORDER_TOP = 1;
    private int BORDER_BOTTOM = 1;
    private final Renderer renderer;
    private Rectangle screenArea = new Rectangle();
    private Rectangle mainArea = new Rectangle();
    private GraphLegend legend;
    private LegendAnchorController legendAnchorController = new LegendAnchorController();
    private int columns = 1;
    private List<DisplayCell> displayCells = new ArrayList<DisplayCell>();
    private AbstractMouseActionController mouseController = new AbstractMouseActionController();
    private DisplayCell mouseDrggedCell = null;
    private Runnable initializer;
    private volatile boolean needsResize = true;
    private boolean withMarginBottom = true;
    private boolean withHorizontalMargin = true;
    private int[] layoutOrder = new int[0];
    private final RendererActionListener rendererActionListener = new RendererActionListener(){
        private boolean legendMoveScreenSave;
        private Object legendScreenBufferKey = new Object();

        @Override
        public void dispose() {
            for (DisplayCell cell : GraphChartContainer.this.displayCells) {
                GraphChartContainer.this.renderer.invalidateSavedScreen(cell.chart);
                cell.dispose();
            }
        }

        @Override
        public void initializedDrawingArea(Renderer source) {
            GraphChartContainer.this.updateAreaSizes(source);
            for (DisplayCell cell : GraphChartContainer.this.displayCells) {
                cell.actionListener.initializedDrawingArea(source, cell);
            }
            if (GraphChartContainer.this.initializer != null) {
                GraphChartContainer.this.initializer.run();
                GraphChartContainer.this.initializer = null;
            }
        }

        @Override
        public void resizedDrawingArea(Renderer source) {
            GraphChartContainer.this.updateAreaSizes(source);
        }

        @Override
        public void repaintDrawingArea(Renderer source) {
            if (GraphChartContainer.this.needsResize || ((GraphChartContainer)GraphChartContainer.this).screenArea.width != source.getScreenWidth() || ((GraphChartContainer)GraphChartContainer.this).screenArea.height != source.getScreenHeight()) {
                GraphChartContainer.this.updateAreaSizes(source);
            }
            GraphChartContainer.this.updateFullScreen();
        }

        @Override
        public void mouseDoubleClicked(Renderer source, int x, int y) {
            for (DisplayCell cell : GraphChartContainer.this.displayCells) {
                if (!cell.canDo(x, y)) continue;
                cell.actionListener.mouseDoubleClicked(source, x, y, cell);
                return;
            }
        }

        @Override
        public void mouseDownLeft(Renderer source, int x, int y) {
            GraphChartContainer.this.mouseController.mouseDownLeft(x, y);
            GraphChartContainer.this.mouseDrggedCell = null;
            if (GraphChartContainer.this.legend.isHovered(x, y)) {
                GraphChartContainer.this.mouseController.setLeftAction(10);
                GraphChartContainer.this.mouseController.setMouseDownLegendItem(GraphChartContainer.this.legend.getFocusedItem());
                if (GraphChartContainer.this.mouseController.getMouseDownLegendItem() == null) {
                    GraphChartContainer.this.legendAnchorController.setLegendMove();
                    GraphChartContainer.this.paintAllCells();
                    GraphChartContainer.this.renderer.saveScreen(GraphChartContainer.this.screenArea, this.legendScreenBufferKey);
                    GraphChartContainer.this.renderer.setPaintArea(null);
                    GraphChartContainer.this.renderer.setFillColor(Color.LIGHT_GRAY);
                    GraphChartContainer.this.renderer.setAlpha(210);
                    GraphChartContainer.this.renderer.fillRectangle(((GraphChartContainer)GraphChartContainer.this).mainArea.x, ((GraphChartContainer)GraphChartContainer.this).mainArea.y, ((GraphChartContainer)GraphChartContainer.this).mainArea.width, ((GraphChartContainer)GraphChartContainer.this).mainArea.height);
                    GraphChartContainer.this.renderer.setAlpha(255);
                    GraphChartContainer.this.legendAnchorController.paintAnchors(GraphChartContainer.this.renderer, GraphChartContainer.this.displayCells, GraphChartContainer.this.legend);
                    GraphChartContainer.this.legend.paintLegend();
                    GraphChartContainer.this.renderer.showScreenBuffer();
                }
            } else {
                for (DisplayCell cell : GraphChartContainer.this.displayCells) {
                    if (!cell.canDo(x, y)) continue;
                    GraphChartContainer.this.mouseDrggedCell = cell;
                    cell.actionListener.mouseDownLeft(source, x, y, cell);
                    return;
                }
            }
        }

        @Override
        public void mouseDownRight(Renderer source, int x, int y) {
            GraphChartContainer.this.mouseController.mouseDownRight(x, y);
            GraphChartContainer.this.mouseController.setRightAction(0);
            GraphChartContainer.this.mouseDrggedCell = null;
            for (DisplayCell cell : GraphChartContainer.this.displayCells) {
                if (!cell.canDo(x, y)) continue;
                GraphChartContainer.this.mouseDrggedCell = cell;
                cell.actionListener.mouseDownRight(source, x, y, cell);
                return;
            }
        }

        @Override
        public void mouseHovered(Renderer source, int x, int y) {
            if (GraphChartContainer.this.legend.isHovered(x, y)) {
                return;
            }
            for (DisplayCell cell : GraphChartContainer.this.displayCells) {
                if (!cell.canDo(x, y)) continue;
                cell.actionListener.mouseHovered(source, x, y, cell);
                return;
            }
        }

        @Override
        public void mouseMoved(Renderer source, int x, int y) {
            if (this.updateLegendCursorState(x, y)) {
                for (DisplayCell cell : GraphChartContainer.this.displayCells) {
                    if (!cell.canDo(x, y)) continue;
                    cell.actionListener.mouseMoved(source, x, y, cell);
                    return;
                }
            }
        }

        @Override
        public void mouseMovedByLeftPressed(Renderer source, int x, int y) {
            switch (GraphChartContainer.this.mouseController.getLeftAction()) {
                case 10: {
                    if (GraphChartContainer.this.legend.getFocusedItem() != null) break;
                    if (this.legendMoveScreenSave) {
                        GraphChartContainer.this.renderer.restoreScreen(this.legendScreenBufferKey);
                    } else {
                        GraphChartContainer.this.paintAllCells();
                        GraphChartContainer.this.renderer.saveScreen(GraphChartContainer.this.screenArea, this.legendScreenBufferKey);
                        this.legendMoveScreenSave = true;
                    }
                    if (GraphChartContainer.this.legendAnchorController.isLegendMove()) {
                        GraphChartContainer.this.renderer.setPaintArea(null);
                        GraphChartContainer.this.renderer.setFillColor(Color.LIGHT_GRAY);
                        GraphChartContainer.this.renderer.setAlpha(210);
                        GraphChartContainer.this.renderer.fillRectangle(((GraphChartContainer)GraphChartContainer.this).mainArea.x, ((GraphChartContainer)GraphChartContainer.this).mainArea.y, ((GraphChartContainer)GraphChartContainer.this).mainArea.width, ((GraphChartContainer)GraphChartContainer.this).mainArea.height);
                        GraphChartContainer.this.renderer.setAlpha(255);
                        GraphChartContainer.this.legendAnchorController.paintAnchors(GraphChartContainer.this.renderer, GraphChartContainer.this.displayCells, GraphChartContainer.this.legend);
                    }
                    GraphChartContainer.this.legend.restoreDefaultPosition();
                    GraphChartContainer.this.legend.moveLegend(x - GraphChartContainer.this.mouseController.getDownLeftX(), y - GraphChartContainer.this.mouseController.getDownLeftY(), GraphChartContainer.this.mainArea);
                    GraphChartContainer.this.legend.paintLegend();
                    GraphChartContainer.this.renderer.showScreenBuffer();
                    break;
                }
                default: {
                    if (GraphChartContainer.this.mouseDrggedCell == null) break;
                    ((GraphChartContainer)GraphChartContainer.this).mouseDrggedCell.actionListener.mouseMovedByLeftPressed(source, x, y, GraphChartContainer.this.mouseDrggedCell);
                }
            }
        }

        @Override
        public void mouseMovedByRightPressed(Renderer source, int x, int y) {
            if (GraphChartContainer.this.mouseDrggedCell != null) {
                ((GraphChartContainer)GraphChartContainer.this).mouseDrggedCell.actionListener.mouseMovedByRightPressed(source, x, y, GraphChartContainer.this.mouseDrggedCell);
            }
        }

        @Override
        public void mouseUpLeft(Renderer source, int x, int y) {
            GraphChartContainer.this.mouseController.mosuseUpLeft();
            this.legendMoveScreenSave = false;
            this.updateLegendCursorState(x, y);
            switch (GraphChartContainer.this.mouseController.getLeftAction()) {
                case 10: {
                    if (GraphChartContainer.this.legendAnchorController.isLegendMove()) {
                        GraphChartContainer.this.legendAnchorController.resetLegendMove();
                        LegendPositionAnchor anchor = GraphChartContainer.this.legendAnchorController.getHoveredAnchor();
                        if (anchor != null) {
                            GraphChartContainer.this.legend.setPositionAnchor(anchor);
                        } else {
                            GraphChartContainer.this.legend.saveAsDefaultPosition();
                        }
                        GraphChartContainer.this.renderer.restoreScreen(this.legendScreenBufferKey);
                        GraphChartContainer.this.legend.paintLegend();
                        GraphChartContainer.this.renderer.showScreenBuffer();
                    } else {
                        LegendItemImpl hoveredItem = (LegendItemImpl)GraphChartContainer.this.legend.getFocusedItem();
                        if (hoveredItem != null && hoveredItem == GraphChartContainer.this.mouseController.getMouseDownLegendItem()) {
                            hoveredItem.preform();
                        }
                        GraphChartContainer.this.mouseController.setMouseDownLegendItem(null);
                    }
                    return;
                }
            }
            if (GraphChartContainer.this.mouseDrggedCell != null) {
                ((GraphChartContainer)GraphChartContainer.this).mouseDrggedCell.actionListener.mouseUpLeft(source, x, y, GraphChartContainer.this.mouseDrggedCell);
            }
        }

        @Override
        public void mouseUpRight(Renderer source, int x, int y) {
            GraphChartContainer.this.mouseController.mosuseUpRight();
            this.updateLegendCursorState(x, y);
            if (GraphChartContainer.this.mouseDrggedCell != null) {
                ((GraphChartContainer)GraphChartContainer.this).mouseDrggedCell.actionListener.mouseUpRight(source, x, y, GraphChartContainer.this.mouseDrggedCell);
            }
        }

        private boolean updateLegendCursorState(int x, int y) {
            if (GraphChartContainer.this.legend.isHovered(x, y)) {
                LegendItem item = GraphChartContainer.this.legend.getHoveredItem();
                if (item == null) {
                    GraphChartContainer.this.renderer.setCursor(Renderer.CursorType.CURSOR_MOVE);
                    if (GraphChartContainer.this.legend.getFocusedItem() != null) {
                        GraphChartContainer.this.legend.setFocusedItem(null);
                        GraphChartContainer.this.updateFullScreen();
                    }
                } else {
                    GraphChartContainer.this.legend.setFocusedItem(item);
                    GraphChartContainer.this.renderer.setCursor(Renderer.CursorType.CURSOR_SELECT);
                    GraphChartContainer.this.updateFullScreen();
                }
                return false;
            }
            if (GraphChartContainer.this.legend.getFocusedItem() != null) {
                GraphChartContainer.this.legend.setFocusedItem(null);
                GraphChartContainer.this.updateFullScreen();
            }
            GraphChartContainer.this.renderer.setCursor(null);
            return true;
        }
    };
    private DisplayCell focusedCell;
    private boolean allCellsDisabled;
    private boolean tabDirectionNext = true;
    private AccessibilityStateListener ACC;
    private String accText = "";
    private static final int ACC_NONE = 0;
    private static final int ACC_LEGEND = 2;
    private static final int ACC_TAB = 3;

    public GraphChartContainer(Renderer renderer, int columns) {
        this(renderer);
        this.setColumnsCount(columns);
    }

    public GraphChartContainer(Renderer renderer) {
        this.renderer = renderer;
        this.legend = new GraphLegend(renderer);
        renderer.addRendererActionListener(this.rendererActionListener);
    }

    public void setColumnsCount(int columnsCount) {
        this.columns = columnsCount < 1 ? 1 : columnsCount;
        this.needsResize = true;
    }

    public int getColumnsCount() {
        return this.columns;
    }

    public DisplayCell getCell(GraphContainerChart<?> chart) {
        for (DisplayCell cell : this.displayCells) {
            if (cell.chart != chart) continue;
            return cell;
        }
        return null;
    }

    public int getChartsCount() {
        return this.displayCells.size();
    }

    public Rectangle getMinChartBounds(int idx) {
        return this.displayCells.get((int)idx).chart.getMinBounds();
    }

    public void setInitializer(Runnable initializer) {
        this.initializer = initializer;
    }

    public void setChartTitle(String title) {
        this.setChartTitle(title, 0);
    }

    public void setChartTitle(String title, int idx) {
        this.setChartTitle(title, TitleAlignment.CENTER, idx);
    }

    public void setChartTitle(String title, TitleAlignment alignment, int idx) {
        this.displayCells.get(idx).title = title;
        this.displayCells.get(idx).alignment = alignment;
        this.needsResize = true;
    }

    public String getChartTitle(int idx) {
        if (idx < this.displayCells.size()) {
            return this.displayCells.get(idx).title;
        }
        return null;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public boolean isRefreshNotBlocked() {
        return !this.mouseController.isRefreshBlocked();
    }

    public void refresh(boolean force) {
        if (this.renderer.isVisibleInitialized() && (this.isRefreshNotBlocked() || force)) {
            this.rendererActionListener.resizedDrawingArea(this.renderer);
            this.rendererActionListener.repaintDrawingArea(this.renderer);
        } else {
            this.needsResize = true;
        }
    }

    public void refresh() {
        this.refresh(false);
    }

    public void setBackground(Color color) {
        this.renderer.setDefaultBackground(color);
    }

    public void enableCellMarginBottom(boolean enable) {
        this.withMarginBottom = enable;
    }

    public void enableCellHorizontalMargin(boolean enable) {
        this.withHorizontalMargin = enable;
    }

    private void updLayoutOrder() {
        int[] newOrder = new int[this.layoutOrder.length + 1];
        System.arraycopy(this.layoutOrder, 0, newOrder, 0, this.layoutOrder.length);
        newOrder[this.layoutOrder.length] = this.displayCells.size();
        this.layoutOrder = newOrder;
    }

    private void putFirst(int[] list, int idx) {
        if (list.length < 2 || idx == 0) {
            return;
        }
        int topIdx = list[idx];
        int prev = list[0];
        for (int i = 1; i <= idx; ++i) {
            int tmp = list[i];
            list[i] = prev;
            prev = tmp;
        }
        list[0] = topIdx;
    }

    public void putChartOnTopLayoutOrder(GraphContainerChart<?> chart) {
        if (this.layoutOrder.length < 2) {
            return;
        }
        for (int idx = 1; idx < this.layoutOrder.length; ++idx) {
            if (this.displayCells.get((int)this.layoutOrder[idx]).chart != chart) continue;
            this.putFirst(this.layoutOrder, idx);
            return;
        }
    }

    public void addChart(GraphContainerChart<?> chart) {
        this.addChart(chart, 1, 1);
        if (this.legend.getPositionAnchor() == null && chart.getDefaultLegedPosition() != null) {
            this.legend.setPositionAnchor(chart.getDefaultLegedPosition());
        }
    }

    public void addChart(GraphContainerChart<?> chart, int cols, int rows) {
        DisplayCell cell = new DisplayCell(cols, rows);
        this.updLayoutOrder();
        this.displayCells.add(cell);
        cell.setChart(chart);
        this.needsResize = true;
    }

    public void removeAllCharts() {
        this.mouseDrggedCell = null;
        this.focusedCell = null;
        Iterator<DisplayCell> cells = this.displayCells.iterator();
        while (cells.hasNext()) {
            DisplayCell cell = cells.next();
            cells.remove();
            this.renderer.invalidateSavedScreen(cell.chart);
            cell.dispose();
        }
        this.layoutOrder = new int[0];
        this.needsResize = true;
    }

    void updateFullScreen() {
        if (this.renderer.isVisibleInitialized()) {
            this.paintAllCells();
            this.legend.paintLegend();
            this.renderer.showScreenBuffer();
        }
    }

    void updateScreen(DisplayCell cell) {
        if (cell != null && this.renderer.isVisibleInitialized()) {
            cell.repaintHeader(this.renderer);
            if (this.allCellsDisabled || this.focusedCell != null && this.focusedCell != cell) {
                this.renderer.setPaintArea(cell.entireArea);
                this.renderer.setAlpha(120);
                this.renderer.setFillColor(Color.LIGHT_GRAY);
                this.renderer.fillRectangle(0, ((DisplayCell)cell).entireArea.height, ((DisplayCell)cell).entireArea.width, ((DisplayCell)cell).entireArea.height + 1);
                this.renderer.setAlpha(255);
            }
            if (this.legendAnchorController.isLegendMove()) {
                this.renderer.setPaintArea(null);
                this.renderer.setFillColor(Color.LIGHT_GRAY);
                this.renderer.setAlpha(210);
                this.renderer.fillRectangle(((DisplayCell)cell).entireArea.x, ((DisplayCell)cell).entireArea.y, ((DisplayCell)cell).entireArea.width, ((DisplayCell)cell).entireArea.height);
                this.renderer.setAlpha(255);
                this.legendAnchorController.paintAnchor(this.renderer, cell, this.legend);
            }
            this.legend.paintLegend(cell.entireArea);
            this.renderer.showScreenBuffer();
        }
    }

    public void removeAllLegendItems() {
        this.legend.removeAllItems();
    }

    public LegendItem addLegendItem(String text, Color color, LegendSelectionListener listener) {
        return this.legend.appendItem(new LegendItemImpl(text, color, listener));
    }

    public LegendItem addLegendItem(String text, Color color, LegendSelectionHandler handler) {
        return this.legend.appendItem(new LegendItemImpl(text, color, handler));
    }

    public LegendItem addLegendItem(String text, Color color) {
        return this.legend.appendItem(new LegendItemImpl(text, color));
    }

    public void addLegendItem(LegendItem item) {
        this.legend.appendItem(item);
    }

    public void addLegendSeparator(String text) {
        this.legend.appendItem(new LegendItemImpl(text));
    }

    public void removeLegendItem(LegendItem item) {
        this.legend.removeItem(item);
    }

    public void enableLegend(boolean enable) {
        this.legend.setEnabled(enable);
    }

    public void enableLegendItemSelection(boolean enable) {
        this.legend.setItemSelectionEnabled(enable);
    }

    public void setPositionAnchor(LegendPositionAnchor anchor) {
        this.legend.setPositionAnchor(anchor);
    }

    public void adjustLegendPosition(double xRel, double yRel) {
        this.legend.setRelPosition(xRel, yRel);
    }

    public double getLegendRelXPosition() {
        return this.legend.getRelXPosition();
    }

    public double getLegendRelYPosition() {
        return this.legend.getRelYPosition();
    }

    public boolean isLegendPinnedOnAnchor() {
        return this.legend.isPinnedOnAnchor();
    }

    public int getPinnedLegendChartIndex() {
        if (this.legend.isPinnedOnAnchor()) {
            for (int i = 0; i < this.displayCells.size(); ++i) {
                if (this.displayCells.get((int)i).chart.getLegendAnchors() == null) continue;
                for (LegendPositionAnchor a : this.displayCells.get((int)i).chart.getLegendAnchors()) {
                    if (a != this.legend.getPositionAnchor()) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public int getPinnedLegendAnchorIndex() {
        if (this.legend.isPinnedOnAnchor()) {
            return this.legend.getPositionAnchor().getId();
        }
        return -1;
    }

    public boolean pinLegendOnAnchor(int chartIdx, int anchorIdx) {
        if (chartIdx < 0 || chartIdx >= this.displayCells.size() || anchorIdx < 0) {
            return false;
        }
        LegendPositionAnchor[] anchors = this.displayCells.get((int)chartIdx).chart.getLegendAnchors();
        if (anchors != null && anchorIdx < anchors.length) {
            this.legend.setPositionAnchor(anchors[anchorIdx]);
            return true;
        }
        return false;
    }

    public boolean isLegendEnabled() {
        return this.legend.isEnabled();
    }

    private void paintAllCells() {
        this.renderer.setPaintArea(null);
        this.renderer.clearDrawingArea();
        if (this.renderer.getScreenWidth() > 10 && this.renderer.getScreenHeight() > 10) {
            for (DisplayCell cell : this.displayCells) {
                if (!cell.actionListener.hasModelDataChanged() && this.renderer.restoreScreen(cell.chart)) continue;
                cell.repaint();
            }
            for (DisplayCell cell : this.displayCells) {
                cell.repaintHeader(this.renderer);
                cell.postRepaint();
                if (!this.allCellsDisabled && (this.focusedCell == null || this.focusedCell == cell)) continue;
                this.renderer.setPaintArea(cell.entireArea);
                this.renderer.setAlpha(120);
                this.renderer.setFillColor(Color.LIGHT_GRAY);
                this.renderer.fillRectangle(0, ((DisplayCell)cell).entireArea.height, ((DisplayCell)cell).entireArea.width, ((DisplayCell)cell).entireArea.height + 1);
                this.renderer.setAlpha(255);
            }
        }
    }

    private void updateAreaSizes(Renderer source) {
        this.screenArea.update(0, source.getScreenHeight(), source.getScreenWidth(), source.getScreenHeight());
        this.mainArea.update(this.BORDER_LEFT, this.renderer.getScreenHeight() - this.BORDER_TOP, this.renderer.getScreenWidth() - this.BORDER_LEFT - this.BORDER_RIGHT, this.renderer.getScreenHeight() - this.BORDER_TOP - this.BORDER_BOTTOM);
        if (!this.displayCells.isEmpty()) {
            DisplayCell cell;
            int[] cellColStart = new int[this.columns + 1];
            for (int col = 0; col <= this.columns; ++col) {
                cellColStart[col] = (int)Math.round((double)(this.mainArea.width * col) / (double)this.columns);
            }
            boolean[][] cellMatrix = new boolean[50][this.columns];
            int rows = 1;
            Iterator<DisplayCell> i = this.displayCells.iterator();
            for (int row = 0; row < cellMatrix.length && i.hasNext(); ++row) {
                for (int col = 0; col < cellMatrix[row].length && i.hasNext(); ++col) {
                    if (cellMatrix[row][col]) continue;
                    cell = i.next();
                    try {
                        for (int deltaRow = 0; deltaRow < cell.rows; ++deltaRow) {
                            for (int deltaCol = 0; deltaCol < cell.colls; ++deltaCol) {
                                cellMatrix[row + deltaRow][col + deltaCol] = true;
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException exp) {
                        throw new IllegalStateException("Invalid chart layout definition! Check the graph layout settings (columns and chart width)");
                    }
                    cell.rowPos = row;
                    cell.colPos = col;
                    rows = row + cell.rows > rows ? row + cell.rows : rows;
                }
            }
            int[] cellRowStart = new int[rows + 1];
            for (int row = 0; row <= rows; ++row) {
                cellRowStart[row] = (int)Math.round((double)(this.mainArea.height * row) / (double)rows);
            }
            for (int idx = 0; idx < this.layoutOrder.length; ++idx) {
                cell = this.displayCells.get(this.layoutOrder[idx]);
                int x = this.mainArea.x + cellColStart[cell.colPos];
                int y = this.mainArea.y - cellRowStart[cell.rowPos];
                int availableWidth = cellColStart[cell.colPos + cell.colls] - cellColStart[cell.colPos];
                int availableHeight = cellRowStart[cell.rowPos + cell.rows] - cellRowStart[cell.rowPos];
                cell.entireArea.update(x, y, availableWidth, availableHeight);
                int headerHeight = 0;
                if (cell.title != null) {
                    headerHeight = Math.max(cell.getHeaderHeight(this.renderer), (int)Math.round((double)availableHeight * 0.1));
                }
                cell.headerArea.update(((DisplayCell)cell).entireArea.x, ((DisplayCell)cell).entireArea.y, ((DisplayCell)cell).entireArea.width, headerHeight);
                int margin = this.withHorizontalMargin ? (int)Math.round((double)Math.max(availableWidth - 400, 0) * 0.02) : 0;
                int marginBottom = this.withMarginBottom ? (int)Math.round((double)availableHeight * 0.9) : (availableHeight -= headerHeight);
                cell.graphArea.update(((DisplayCell)cell).entireArea.x + margin, ((DisplayCell)cell).entireArea.y - ((DisplayCell)cell).headerArea.height, ((DisplayCell)cell).entireArea.width - 2 * margin, marginBottom);
                if (!cell.canDo()) continue;
                cell.actionListener.resizedDrawingArea(source, cell);
            }
        }
        this.legend.updateLegendArea(this.mainArea);
        this.needsResize = false;
    }

    public boolean isLegendFocused() {
        return this.allCellsDisabled;
    }

    public void moveLegend(int pixels, boolean horizontal) {
        if (this.isLegendEnabled()) {
            if (horizontal) {
                this.legend.moveLegend(pixels, 0, this.mainArea);
            } else {
                this.legend.moveLegend(0, pixels, this.mainArea);
            }
            this.legend.saveAsDefaultPosition();
            this.updateFullScreen();
        }
    }

    public void resetFocused() {
        this.focusedCell = null;
        this.allCellsDisabled = false;
        this.legend.setFocusedItem(null);
        for (LegendItem i : this.legend.getItems()) {
            if (!(i instanceof LegendItemImpl)) continue;
            ((LegendItemImpl)i).resetSelection();
        }
        for (DisplayCell cell : this.displayCells) {
            GraphContainerChart<?> chart = cell.chart;
            if (!(chart instanceof LineGraphChart)) continue;
            ((LineGraphChart)chart).closeValueBar();
        }
        this.notifyACC(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean focusNextChart() {
        try {
            if (this.displayCells.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (this.allCellsDisabled && this.tabDirectionNext) {
                boolean bl = false;
                return bl;
            }
            if (this.focusedCell == null) {
                if (this.displayCells.size() == 1) {
                    if (!this.isLegendEnabled()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.allCellsDisabled = true;
                    this.tabDirectionNext = true;
                    this.focusedCell = null;
                } else {
                    this.allCellsDisabled = false;
                    this.focusedCell = this.displayCells.get(0);
                }
                boolean bl = true;
                return bl;
            }
            if (this.displayCells.indexOf(this.focusedCell) == this.displayCells.size() - 1) {
                this.focusedCell = null;
                this.tabDirectionNext = true;
                if (this.isLegendEnabled()) {
                    this.allCellsDisabled = true;
                    boolean bl = true;
                    return bl;
                }
                this.allCellsDisabled = false;
                boolean bl = false;
                return bl;
            }
            this.allCellsDisabled = false;
            this.focusedCell = this.displayCells.get(this.displayCells.indexOf(this.focusedCell) + 1);
            boolean bl = true;
            return bl;
        }
        finally {
            this.notifyACC(3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean focusPreviousChart() {
        try {
            if (this.displayCells.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (this.allCellsDisabled && !this.tabDirectionNext) {
                boolean bl = false;
                return bl;
            }
            if (this.focusedCell == null) {
                if (this.displayCells.size() == 1) {
                    if (!this.isLegendEnabled()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.allCellsDisabled = true;
                    this.tabDirectionNext = false;
                    this.focusedCell = null;
                } else {
                    this.allCellsDisabled = false;
                    this.focusedCell = this.displayCells.get(this.displayCells.size() - 1);
                }
                boolean bl = true;
                return bl;
            }
            if (this.displayCells.indexOf(this.focusedCell) == 0) {
                this.focusedCell = null;
                this.tabDirectionNext = false;
                if (this.isLegendEnabled()) {
                    this.allCellsDisabled = true;
                    boolean bl = true;
                    return bl;
                }
                this.allCellsDisabled = false;
                boolean bl = false;
                return bl;
            }
            this.allCellsDisabled = false;
            this.focusedCell = this.displayCells.get(this.displayCells.indexOf(this.focusedCell) - 1);
            boolean bl = true;
            return bl;
        }
        finally {
            this.notifyACC(3);
        }
    }

    public void focusNextLegendItem() {
        if (this.isLegendEnabled()) {
            this.legend.focusNextItem();
            this.updateFullScreen();
            this.notifyACC(2);
        }
    }

    public void focusPrevLegendItem() {
        if (this.isLegendEnabled()) {
            this.legend.focusPrevItem();
            this.updateFullScreen();
            this.notifyACC(2);
        }
    }

    public void toggleFocusItemSelection() {
        LegendItemImpl hoveredItem;
        if (this.isLegendEnabled() && (hoveredItem = (LegendItemImpl)this.legend.getFocusedItem()) != null) {
            hoveredItem.preform();
        }
    }

    public void keyNext() {
        if (this.focusedCell != null) {
            this.focusedCell.chart.keyNext();
        }
    }

    public void keyPrevious() {
        if (this.focusedCell != null) {
            this.focusedCell.chart.keyPrevious();
        }
    }

    public void setAccessibilityStateListener(AccessibilityStateListener listener) {
        this.ACC = listener;
        for (DisplayCell cell : this.displayCells) {
            cell.chart.setAccessibilityStateListener(new ACCDelegate(cell));
        }
    }

    public void removeAccessibilityStateListener() {
        this.ACC = null;
        for (DisplayCell cell : this.displayCells) {
            cell.chart.removeAccessibilityStateListener();
        }
    }

    private void notifyACC(DisplayCell cell) {
        if (this.ACC != null) {
            this.accText = cell.chart.getAccessibleStateText();
            this.ACC.stateChanged(this);
        }
    }

    private void notifyACC(int accID) {
        if (this.ACC != null) {
            StringBuilder text = new StringBuilder();
            switch (accID) {
                case 0: {
                    break;
                }
                case 2: {
                    text.append(I18n._s((String)"Legend item {0} focused, press return to toggle the selection.", (Object[])new Object[]{this.legend.getFocusedItem().getItemText()}));
                    break;
                }
                case 3: {
                    if (this.focusedCell != null) {
                        String title = this.focusedCell.title != null && this.focusedCell.title.trim().length() > 0 ? this.focusedCell.title : "";
                        text.append(I18n._s((String)"Focused chart {0}", (Object[])new Object[]{title}));
                        text.append(", ");
                        text.append(this.focusedCell.chart.getAccessibleControlName());
                        String state = this.focusedCell.chart.getAccessibleStateText();
                        if (state != null) {
                            text.append(", ").append(state);
                        }
                        text.append(".");
                        break;
                    }
                    if (!this.allCellsDisabled) break;
                    text.append(I18n._s((String)"Legend focused, use the arrow buttons to move."));
                }
            }
            this.accText = text.toString();
            this.ACC.stateChanged(this);
        }
    }

    @Override
    public String getAccessibleControlName() {
        StringBuilder text = new StringBuilder();
        text.append(I18n._ssn((String)"Graph charts area containing {0} chart.", (String)"Graph charts area containing {0} charts.", (int)this.displayCells.size(), (Object[])new Object[]{this.displayCells.size()}));
        text.append(' ');
        for (int i = 0; i < this.displayCells.size(); ++i) {
            DisplayCell cell = this.displayCells.get(i);
            text.append(cell.title).append(", ");
            text.append(cell.chart.getAccessibleControlName());
            if (i < this.displayCells.size() - 1) {
                text.append(", ");
                continue;
            }
            text.append(". ");
        }
        if (this.isLegendEnabled()) {
            text.append(I18n._ssn((String)"Legend containing {0} item.", (String)"Legend containing {0} items.", (int)this.legend.getItems().length, (Object[])new Object[]{this.legend.getItems().length}));
            text.append(' ');
            LegendItem[] items = this.legend.getItems();
            for (int i = 0; i < items.length; ++i) {
                text.append(items[i].getItemText());
                if (i < items.length - 1) {
                    text.append(", ");
                    continue;
                }
                text.append(". ");
            }
        }
        return text.toString();
    }

    @Override
    public String getAccessibleStateText() {
        return this.accText;
    }

    private class ACCDelegate
    implements AccessibilityStateListener {
        private DisplayCell cell;

        public ACCDelegate(DisplayCell cell) {
            this.cell = cell;
        }

        @Override
        public void stateChanged(AccessibleControl control) {
            GraphChartContainer.this.notifyACC(this.cell);
        }
    }

    public class DisplayCell {
        int colls;
        int rows;
        int colPos;
        int rowPos;
        private String title = null;
        private TitleAlignment alignment = TitleAlignment.CENTER;
        private Rectangle headerArea = new Rectangle();
        private Rectangle graphArea = new Rectangle();
        private Rectangle entireArea = new Rectangle();
        private boolean disposed;
        GraphContainerChart<?> chart;
        ChartsContainerActionListener actionListener;
        private Font titleFont;

        public DisplayCell(int colls, int rows) {
            this.colls = colls < 1 ? 1 : colls;
            this.rows = rows < 1 ? 1 : rows;
        }

        private void setChart(GraphContainerChart<?> chart) {
            this.chart = chart;
            this.actionListener = chart.provideContainerListener();
        }

        private boolean canDo() {
            return this.actionListener != null;
        }

        private boolean canDo(int x, int y) {
            if (this.actionListener == null || GraphChartContainer.this.allCellsDisabled) {
                return false;
            }
            return (GraphChartContainer.this.focusedCell == null || GraphChartContainer.this.focusedCell == this) && this.entireArea.isIn(x, y);
        }

        public LegendPositionAnchor[] getLegendAnchors() {
            return this.chart.getLegendAnchors();
        }

        public Rectangle getHeaderArea() {
            return this.headerArea;
        }

        public Rectangle getGraphArea() {
            return this.graphArea;
        }

        public Rectangle getEntireArea() {
            return this.entireArea;
        }

        private void repaint() {
            GraphChartContainer.this.renderer.setPaintArea(null);
            if (this.actionListener != null) {
                this.actionListener.repaintDrawingArea(GraphChartContainer.this.renderer);
            }
        }

        private void postRepaint() {
            GraphChartContainer.this.renderer.setPaintArea(null);
            if (this.actionListener != null) {
                this.actionListener.postRestoredScreen(GraphChartContainer.this.renderer);
            }
        }

        private int getHeaderHeight(Renderer r) {
            Font defFont = r.getFont();
            if (this.titleFont == null) {
                this.titleFont = new Font(defFont.getName(), defFont.getSize() + 1, Font.Style.BOLD);
            }
            r.setFont(this.titleFont);
            int result = r.getFontHeight();
            r.setFont(defFont);
            return result;
        }

        private void repaintHeader(Renderer r) {
            if (this.title == null || this.disposed) {
                return;
            }
            r.setPaintArea(this.headerArea, GraphChartContainer.this.mainArea);
            r.setDefaultColors();
            Font defFont = r.getFont();
            boolean oldAntialias = r.isAntialiased();
            r.setAntialiased(true);
            r.setForeground(Color.DARK_GRAY);
            r.setFont(this.titleFont);
            int height = r.getFontHeight();
            int width = r.getStringWidth(this.title);
            int y = this.headerArea.height / 2 + height / 2;
            int x = 0;
            switch (this.alignment) {
                case CENTER: {
                    x = this.headerArea.width / 2 - width / 2;
                    break;
                }
                case LEFT: {
                    x = 0;
                    break;
                }
                case RIGHT: {
                    x = this.headerArea.width - width;
                    break;
                }
                case LEFT_MAX: {
                    x = -(width / 2);
                    break;
                }
                case RIGHT_MAX: {
                    x = this.headerArea.width - width / 2;
                }
            }
            r.fillRectangle(x, y, width, height);
            r.drawString(this.title, x, y);
            r.setFont(defFont);
            r.setAntialiased(oldAntialias);
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public void dispose() {
            this.disposed = true;
            if (this.actionListener != null) {
                this.actionListener.dispose();
            }
            this.actionListener = null;
            this.chart = null;
        }

        public String getTitle() {
            return this.title;
        }

        public String toString() {
            return "DisplayCell title=\"" + this.title + (this.disposed ? "\" (disposed) :" : "\" : " + this.entireArea);
        }
    }

    private class LegendItemImpl
    implements LegendItem {
        String text;
        Color color;
        LegendSelectionListener listener;
        LegendSelectionHandler handler;
        boolean selection;
        private boolean isSeparatorItem;

        public LegendItemImpl(String text) {
            this.text = text;
            this.color = null;
            this.isSeparatorItem = true;
        }

        public LegendItemImpl(String text, Color color) {
            this.text = text;
            this.color = color;
            this.isSeparatorItem = false;
        }

        public LegendItemImpl(String text, Color color, LegendSelectionListener listener) {
            this(text, color);
            this.listener = listener;
        }

        public LegendItemImpl(String text, Color color, LegendSelectionHandler handler) {
            this(text, color);
            this.handler = handler;
        }

        public void preform() {
            if (this.handler != null) {
                this.handler.toggleSelection(this);
            } else {
                boolean bl = this.selection = !this.selection;
                if (this.listener != null) {
                    this.listener.selectionChanged(this);
                }
            }
            GraphChartContainer.this.refresh();
        }

        @Override
        public String getItemText() {
            return this.text;
        }

        @Override
        public Color getItemColor() {
            return this.color;
        }

        @Override
        public boolean isSelected() {
            if (this.handler != null) {
                return this.handler.getSelection(this);
            }
            return this.selection;
        }

        public void resetSelection() {
            if (this.handler != null) {
                this.handler.resetSelection(this);
            } else {
                this.selection = false;
                if (this.listener != null) {
                    this.listener.selectionChanged(this);
                }
            }
        }

        @Override
        public boolean isSeparatorItem() {
            return this.isSeparatorItem;
        }
    }
}

