/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.accessibility.AccessibilityStateListener;
import com.sap.jvm.profiling.ui.graph.accessibility.AccessibleControl;
import com.sap.jvm.profiling.ui.graph.dataset.DataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.layouting.GraphContainerChartLayoutListener;
import com.sap.jvm.profiling.ui.graph.legend.LegendPositionAnchor;
import com.sap.jvm.profiling.ui.graph.renderer.ChartsContainerActionListener;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.List;

public abstract class GraphContainerChart<T extends DataSet>
implements AccessibleControl {
    private List<GraphContainerChartLayoutListener> layoutListeners = new ArrayList<GraphContainerChartLayoutListener>();
    private AccessibilityStateListener ACC;
    protected Rectangle graphArea = new Rectangle();

    public abstract ChartsContainerActionListener provideContainerListener();

    public abstract Renderer getRenderer();

    public abstract void addGraph(T var1);

    public abstract void addGraph(T var1, boolean var2);

    public abstract List<T> getAllGraphs();

    public abstract void removeAllGraphs();

    public abstract void refresh();

    public abstract LegendPositionAnchor getDefaultLegedPosition();

    public abstract LegendPositionAnchor[] getLegendAnchors();

    public Rectangle getGraphArea() {
        return this.graphArea;
    }

    public final void addLayoutListener(GraphContainerChartLayoutListener listener) {
        this.layoutListeners.add(listener);
    }

    public final boolean removeLayoutListener(GraphContainerChartLayoutListener listener) {
        return this.layoutListeners.remove(listener);
    }

    public final void setAccessibilityStateListener(AccessibilityStateListener listener) {
        this.ACC = listener;
    }

    public final void removeAccessibilityStateListener() {
        this.ACC = null;
    }

    public abstract void keyNext();

    public abstract void keyPrevious();

    public Rectangle getMinBounds() {
        return null;
    }

    protected void notifyLayoutListener(Rectangle mainArea, Rectangle[] allChartAreas) {
        for (GraphContainerChartLayoutListener listener : this.layoutListeners) {
            listener.layoutChanged(mainArea, allChartAreas);
        }
    }

    protected void notifyACC() {
        if (this.ACC != null) {
            this.ACC.stateChanged(this);
        }
    }
}

