/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.LineGraphAnnotationTooltipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphAnnotationsImageFactory;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotation;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotationSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.ui.graph.renderer.Image;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import com.sap.jvm.profiling.ui.icons.ImageIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class LineGraphAnnotationsController {
    private Font dscrFont;
    private List<LineGraphAnnotationSet> sets = new ArrayList<LineGraphAnnotationSet>();
    private Map<Rectangle, Object> annotationAreas = new HashMap<Rectangle, Object>();
    private LineGraphAnnotationsImageFactory imgFactory;
    private LineGraphAnnotationTooltipProvider tooltipProvider;
    private static Image ERROR_IMG;
    private static Image WARNING_IMG;
    private static Image INFO_IMG;

    public void setTooltipProvider(LineGraphAnnotationTooltipProvider tooltipProvider) {
        this.tooltipProvider = tooltipProvider;
    }

    public void setImgFactory(LineGraphAnnotationsImageFactory imgFactory) {
        this.imgFactory = imgFactory;
    }

    public boolean anyAnnotationsDefined() {
        return !this.sets.isEmpty();
    }

    public void addAnnotationSet(LineGraphAnnotationSet set) {
        if (!this.sets.contains(set)) {
            this.sets.add(set);
        }
    }

    public void removeAnnotationSet(LineGraphAnnotationSet set) {
        this.sets.remove(set);
    }

    public void removeAll() {
        this.sets.clear();
    }

    public List<LineGraphAnnotation> getAnnotations(double min, double max) {
        ArrayList<LineGraphAnnotation> selection = new ArrayList<LineGraphAnnotation>();
        for (LineGraphAnnotationSet set : this.sets) {
            selection.addAll(set.getAnnotations(min, max));
        }
        return selection.isEmpty() ? null : selection;
    }

    private void paintStamp(Renderer renderer, Rectangle graphArea, int pos, int y, AnnotationPane pane) {
        LineGraphAnnotation a = pane.getAnnotation();
        Image img = this.getImage(a, renderer);
        if (img != null) {
            Rectangle size = img.getBounds();
            int imgX = pos - img.getBounds().width / 2;
            int imgY = y + (img.getBounds().height + 3);
            renderer.drawImage(img, imgX, imgY);
            this.annotationAreas.put(new Rectangle(graphArea.getXonDisplay(imgX), graphArea.getYonDisplay(imgY), size.width, size.height), pane.isMerged() ? pane : pane.getAnnotation());
        }
        renderer.setLineWidth(2);
        renderer.setForeground(a.getBorderColor());
        renderer.drawLine(pos - 3, y, pos + 3, y);
        renderer.drawLine(pos, y, pos, y - 5);
        renderer.drawLine(pos - 3, 2, pos + 3, 2);
        renderer.drawLine(pos, 2, pos, 7);
        renderer.setLineWidth(1);
        renderer.setLineStyle(Renderer.LineType.LINE_DOT);
        renderer.drawLine(pos, y - 7, pos, 9);
        renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
    }

    private void paintPane(Renderer renderer, Rectangle graphArea, AnnotationPane pane) {
        boolean isFullSized;
        if (!pane.getAnnotation().isRange()) {
            this.paintStamp(renderer, graphArea, ((AnnotationPane)pane).area.x, ((AnnotationPane)pane).area.y, pane);
            return;
        }
        Color paneColor = pane.getAnnotation().getColor();
        Color borderColor = pane.getAnnotation().getBorderColor();
        if (pane.isMerged() && !pane.isSingleType()) {
            paneColor = borderColor = Color.GRAY_MIDDLE;
        }
        renderer.setFillColor(paneColor);
        renderer.setForeground(borderColor);
        if (pane.isMerged()) {
            renderer.setAlpha(60);
            renderer.fillRectangle(((AnnotationPane)pane).area.x, ((AnnotationPane)pane).area.y, ((AnnotationPane)pane).area.width, ((AnnotationPane)pane).area.height);
            for (int x = ((AnnotationPane)pane).area.x; x < ((AnnotationPane)pane).area.x_end; x += 2) {
                renderer.drawLine(x, ((AnnotationPane)pane).area.y + 1, x, ((AnnotationPane)pane).area.y - 15);
            }
        } else {
            renderer.setAlpha(60);
            renderer.fillRectangle(((AnnotationPane)pane).area.x, ((AnnotationPane)pane).area.y, ((AnnotationPane)pane).area.width, ((AnnotationPane)pane).area.height);
        }
        renderer.setAlpha(255);
        renderer.setLineWidth(2);
        boolean bl = isFullSized = ((AnnotationPane)pane).area.width > 15;
        if (isFullSized) {
            renderer.drawLine(((AnnotationPane)pane).area.x, ((AnnotationPane)pane).area.y, ((AnnotationPane)pane).area.x + 15, ((AnnotationPane)pane).area.y);
            renderer.drawLine(((AnnotationPane)pane).area.x, ((AnnotationPane)pane).area.y + 1, ((AnnotationPane)pane).area.x, ((AnnotationPane)pane).area.y - 15);
            renderer.drawLine(((AnnotationPane)pane).area.x_end, ((AnnotationPane)pane).area.y, ((AnnotationPane)pane).area.x_end - 15, ((AnnotationPane)pane).area.y);
            renderer.drawLine(((AnnotationPane)pane).area.x_end, ((AnnotationPane)pane).area.y + 1, ((AnnotationPane)pane).area.x_end, ((AnnotationPane)pane).area.y - 15);
            if (!pane.isMerged()) {
                renderer.setAlpha(128);
                renderer.drawLine(((AnnotationPane)pane).area.x, 3, ((AnnotationPane)pane).area.x + 15, 3);
                renderer.drawLine(((AnnotationPane)pane).area.x, 2, ((AnnotationPane)pane).area.x, 19);
                renderer.drawLine(((AnnotationPane)pane).area.x_end, 3, ((AnnotationPane)pane).area.x_end - 15, 3);
                renderer.drawLine(((AnnotationPane)pane).area.x_end, 2, ((AnnotationPane)pane).area.x_end, 19);
            }
        } else {
            renderer.drawLine(((AnnotationPane)pane).area.x, ((AnnotationPane)pane).area.y, ((AnnotationPane)pane).area.x_end, ((AnnotationPane)pane).area.y);
            renderer.drawLine(((AnnotationPane)pane).area.x, ((AnnotationPane)pane).area.y + 1, ((AnnotationPane)pane).area.x, ((AnnotationPane)pane).area.y - 15);
            renderer.drawLine(((AnnotationPane)pane).area.x_end, ((AnnotationPane)pane).area.y + 1, ((AnnotationPane)pane).area.x_end, ((AnnotationPane)pane).area.y - 15);
            if (!pane.isMerged()) {
                renderer.setAlpha(128);
                renderer.drawLine(((AnnotationPane)pane).area.x, 3, ((AnnotationPane)pane).area.x_end, 3);
                renderer.drawLine(((AnnotationPane)pane).area.x, 2, ((AnnotationPane)pane).area.x, 19);
                renderer.drawLine(((AnnotationPane)pane).area.x_end, 2, ((AnnotationPane)pane).area.x_end, 19);
            }
        }
        renderer.setLineWidth(1);
        renderer.setAlpha(255);
        renderer.setLineStyle(Renderer.LineType.LINE_DOT);
        if (isFullSized) {
            renderer.drawLine(((AnnotationPane)pane).area.x + 17, ((AnnotationPane)pane).area.y, ((AnnotationPane)pane).area.x_end - 18, ((AnnotationPane)pane).area.y);
            if (!pane.isMerged()) {
                renderer.drawLine(((AnnotationPane)pane).area.x + 17, 4, ((AnnotationPane)pane).area.x_end - 18, 4);
            }
        }
        int lineEnd = pane.isMerged() ? 2 : 22;
        renderer.drawLine(((AnnotationPane)pane).area.x, ((AnnotationPane)pane).area.y - 17, ((AnnotationPane)pane).area.x, lineEnd);
        renderer.drawLine(((AnnotationPane)pane).area.x_end, ((AnnotationPane)pane).area.y - 17, ((AnnotationPane)pane).area.x_end, lineEnd);
        renderer.setDefaultColors();
        renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
        if (!pane.isMerged()) {
            Image img = this.getImage(pane.getAnnotation(), renderer);
            if (img != null) {
                int imgX = ((AnnotationPane)pane).area.x - img.getBounds().width / 2;
                int imgY = ((AnnotationPane)pane).area.y + (img.getBounds().height + 3);
                Rectangle size = img.getBounds();
                renderer.drawImage(img, imgX, imgY);
                this.annotationAreas.put(new Rectangle(graphArea.getXonDisplay(imgX), graphArea.getYonDisplay(imgY), size.width, size.height), pane.getAnnotation());
            }
        } else if (pane.isSingleType()) {
            Image img = this.getImage(pane.getAnnotation(), renderer);
            if (img != null) {
                int imgX = ((AnnotationPane)pane).area.x - img.getBounds().width / 2;
                int imgY = ((AnnotationPane)pane).area.y + (img.getBounds().height + 3);
                Rectangle size = img.getBounds();
                renderer.drawImage(img, imgX + 3, imgY + 3);
                renderer.drawImage(img, imgX, imgY);
                this.annotationAreas.put(new Rectangle(graphArea.getXonDisplay(imgX), graphArea.getYonDisplay(imgY), size.width, size.height), pane);
            }
        } else {
            int imgX = -1;
            int imgY = -1;
            int offsetX = -1;
            int height = -1;
            int width = -1;
            int lastIconwidth = -1;
            for (Map.Entry e : pane.types.entrySet()) {
                Rectangle size = ((Image)e.getValue()).getBounds();
                if (imgX == -1) {
                    imgX = ((AnnotationPane)pane).area.x - size.width / 2;
                    imgY = ((AnnotationPane)pane).area.y + (size.height + 3);
                    offsetX = imgX;
                    height = size.height;
                    width = size.width;
                } else {
                    int delta = size.width - lastIconwidth + 6;
                    if (delta > 0) {
                        width += delta;
                    }
                }
                lastIconwidth = size.width;
                renderer.drawImage((Image)e.getValue(), offsetX, imgY);
                offsetX += 6;
            }
            this.annotationAreas.put(new Rectangle(graphArea.getXonDisplay(imgX), graphArea.getYonDisplay(imgY), width, height), pane);
        }
    }

    public synchronized void repaint(Renderer renderer, XYGraphAxesModel model, Rectangle graphArea, Rectangle valueArea) {
        this.annotationAreas.clear();
        if (this.dscrFont == null) {
            this.dscrFont = new Font(renderer.getFont().getName(), renderer.getFont().getSize() - 1, renderer.getFont().getStyle());
        }
        if (valueArea.height > 0) {
            Rectangle clip = new Rectangle(graphArea.x, valueArea.y, graphArea.width, valueArea.height + graphArea.height);
            renderer.setPaintArea(graphArea, clip);
        }
        renderer.setForeground(Color.GRAY);
        for (LineGraphAnnotationSet set : this.sets) {
            Stack<AnnotationPane> paintStack = new Stack<AnnotationPane>();
            ArrayList<AnnotationPane> commited = new ArrayList<AnnotationPane>();
            List<LineGraphAnnotation> ranges = set.getAllAnnotations();
            int count = ranges.size();
            for (int i = 0; i < count; ++i) {
                renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
                LineGraphAnnotation a = ranges.get(i);
                int pos = this.getPosition(a, model, graphArea);
                int y = graphArea.height - 2;
                int endPos = pos;
                if (a.isRange()) {
                    endPos = this.getEndPosition(a, model, graphArea);
                }
                if (endPos < 0) continue;
                if (pos >= graphArea.width) break;
                if (paintStack.isEmpty()) {
                    paintStack.push(new AnnotationPane(pos, y, endPos - pos, graphArea.height - 6, a, renderer));
                    continue;
                }
                AnnotationPane lastPane = (AnnotationPane)paintStack.peek();
                if (pos - ((AnnotationPane)lastPane).area.x < lastPane.getMinDistance()) {
                    lastPane.merge(pos, endPos, a);
                    continue;
                }
                boolean commitStack = true;
                for (AnnotationPane p : paintStack) {
                    if (((AnnotationPane)p).area.x_end <= pos) continue;
                    commitStack = false;
                    break;
                }
                if (commitStack) {
                    commited.addAll(paintStack);
                    paintStack.clear();
                }
                paintStack.push(new AnnotationPane(pos, y, endPos - pos, graphArea.height - 6, a, renderer));
            }
            if (!paintStack.isEmpty()) {
                commited.addAll(paintStack);
            }
            for (AnnotationPane pane : commited) {
                this.paintPane(renderer, graphArea, pane);
            }
        }
        renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
    }

    private Image getImage(LineGraphAnnotation a, Renderer renderer) {
        if (this.imgFactory != null) {
            return this.imgFactory.provideImage(a, renderer);
        }
        switch (a.getSeverity()) {
            case ERROR: {
                if (ERROR_IMG == null) {
                    ERROR_IMG = ImageIcons.ERROR.getImage(renderer);
                }
                return ERROR_IMG;
            }
            case WARNING: {
                if (WARNING_IMG == null) {
                    WARNING_IMG = ImageIcons.WARNING.getImage(renderer);
                }
                return WARNING_IMG;
            }
            case INFO: {
                if (INFO_IMG == null) {
                    INFO_IMG = ImageIcons.INFO.getImage(renderer);
                }
                return INFO_IMG;
            }
        }
        return null;
    }

    private String getImageKey(LineGraphAnnotation a, Renderer renderer) {
        if (this.imgFactory != null) {
            return this.imgFactory.provideImageKey(a, renderer);
        }
        return a.getSeverity().name();
    }

    public Object isHovering(int x, int y, Renderer renderer) {
        for (Map.Entry<Rectangle, Object> e : this.annotationAreas.entrySet()) {
            if (!e.getKey().isIn(x, y)) continue;
            return e.getValue();
        }
        return null;
    }

    public boolean hovered(int x, int y, Renderer renderer) {
        if (this.tooltipProvider != null) {
            ArrayList<LineGraphAnnotation> annotations = new ArrayList<LineGraphAnnotation>();
            for (Map.Entry<Rectangle, Object> e : this.annotationAreas.entrySet()) {
                if (!e.getKey().isIn(x, y)) continue;
                if (e.getValue() instanceof AnnotationPane) {
                    AnnotationPane pane = (AnnotationPane)e.getValue();
                    annotations.addAll(pane.getAllAnnotations());
                } else {
                    annotations.add((LineGraphAnnotation)e.getValue());
                }
                renderer.provideToolTip(x, y, this.tooltipProvider.provideTooltip(annotations));
                return true;
            }
        } else {
            for (Map.Entry<Rectangle, Object> e : this.annotationAreas.entrySet()) {
                if (!e.getKey().isIn(x, y)) continue;
                StringBuilder tooltip = new StringBuilder();
                if (e.getValue() instanceof AnnotationPane) {
                    AnnotationPane pane = (AnnotationPane)e.getValue();
                    int count = pane.getAllAnnotations().size();
                    for (LineGraphAnnotation a : pane.annotations) {
                        tooltip.append(a.getMessage());
                        if (--count <= 0) continue;
                        tooltip.append('\n');
                    }
                } else {
                    tooltip.append(((LineGraphAnnotation)e.getValue()).getMessage());
                }
                renderer.provideToolTip(x, y, tooltip.toString());
                return true;
            }
        }
        return false;
    }

    private int getPosition(LineGraphAnnotation annotation, XYGraphAxesModel model, Rectangle graphArea) {
        return model.getXPosition(graphArea.width, annotation.getValue());
    }

    private int getEndPosition(LineGraphAnnotation annotation, XYGraphAxesModel model, Rectangle graphArea) {
        return model.getXPosition(graphArea.width, annotation.getEndValue());
    }

    class AnnotationPane {
        private Rectangle area;
        private List<LineGraphAnnotation> annotations = new ArrayList<LineGraphAnnotation>();
        private Map<String, Image> types = new LinkedHashMap<String, Image>();
        private int minNextDistance = 18;
        private Renderer renderer;

        public AnnotationPane(int x, int y, int width, int height, LineGraphAnnotation a, Renderer renderer) {
            this.renderer = renderer;
            this.area = new Rectangle(x, y, width, height);
            this.annotations.add(a);
            this.types.put(LineGraphAnnotationsController.this.getImageKey(a, renderer), LineGraphAnnotationsController.this.getImage(a, renderer));
        }

        List<LineGraphAnnotation> getAllAnnotations() {
            return this.annotations;
        }

        public boolean isSingleType() {
            return this.types.size() == 1;
        }

        public void merge(int pos, int endPos, LineGraphAnnotation a) {
            this.area.updateWidth(Math.max(this.area.width, endPos - this.area.x));
            this.annotations.add(a);
            String type = LineGraphAnnotationsController.this.getImageKey(a, this.renderer);
            if (!this.types.containsKey(type)) {
                this.types.put(type, LineGraphAnnotationsController.this.getImage(a, this.renderer));
                this.minNextDistance += 9;
            }
        }

        public LineGraphAnnotation getAnnotation() {
            return this.annotations.get(0);
        }

        public boolean isMerged() {
            return this.annotations.size() > 1;
        }

        public int getMinDistance() {
            return this.minNextDistance;
        }
    }
}

