/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.GraphContainerChart;
import com.sap.jvm.profiling.ui.graph.LineGraphAnnotationSelectionListener;
import com.sap.jvm.profiling.ui.graph.LineGraphAnnotationTooltipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphAnnotationsController;
import com.sap.jvm.profiling.ui.graph.LineGraphAnnotationsImageFactory;
import com.sap.jvm.profiling.ui.graph.LineGraphContainer;
import com.sap.jvm.profiling.ui.graph.LineGraphHorizontalSelector;
import com.sap.jvm.profiling.ui.graph.LineGraphMoveAdapter;
import com.sap.jvm.profiling.ui.graph.LineGraphMoveController;
import com.sap.jvm.profiling.ui.graph.LineGraphQuickView;
import com.sap.jvm.profiling.ui.graph.LineGraphRectangleSelector;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionToolTipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphValueBar;
import com.sap.jvm.profiling.ui.graph.LineGraphValueBarListener;
import com.sap.jvm.profiling.ui.graph.LineGraphValueBarToolTipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphValueSelector;
import com.sap.jvm.profiling.ui.graph.axes.InvalidSelectionRange;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxis;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisAdapter;
import com.sap.jvm.profiling.ui.graph.axes.RasterAnchorsList;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxisModelListener;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotation;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotationSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphPresentationAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphVirtualDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.legend.LegendPositionAnchor;
import com.sap.jvm.profiling.ui.graph.mouse.LineGraphMouseActionController;
import com.sap.jvm.profiling.ui.graph.progress.RenderingAsyncProgress;
import com.sap.jvm.profiling.ui.graph.renderer.ChartsContainerActionListener;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LineGraphChart
extends GraphContainerChart<LineGraphDataSet> {
    private static long instanceCounter = 0L;
    private final long instanceId;
    private final boolean allowAsynchRendering;
    private boolean adjust_db;
    private boolean auto_adjust;
    private XYGraphAxesModel axes_model = new XYGraphAxesModel();
    private Rectangle mainArea = new Rectangle();
    private Rectangle axisXArea = new Rectangle();
    private Rectangle axisXClippArea = new Rectangle();
    private Rectangle axisYArea = new Rectangle();
    private Rectangle axisYClippArea = new Rectangle();
    private Rectangle axisSecYArea = new Rectangle();
    private Rectangle axisSecYClippArea = new Rectangle();
    private Rectangle graphClippArea = new Rectangle();
    private Rectangle valueArea = new Rectangle();
    private Rectangle graphValueArea = new Rectangle();
    private Rectangle quickArea = new Rectangle();
    private Rectangle[] allChartAreas = new Rectangle[]{this.mainArea, this.axisXArea, this.axisYArea, this.axisSecYArea, this.graphArea, this.valueArea, this.graphValueArea, this.quickArea};
    private boolean x_axis_show;
    private boolean y_axis_show;
    private boolean y_axisSec_show;
    private boolean x_raster_show;
    private boolean y_raster_show;
    private LineGraphAxis x_axis;
    private LineGraphAxis y_axis;
    private LineGraphAxis y_axisSec;
    private LineGraphContainer container;
    private LineGraphValueBar value_bar;
    private LineGraphHorizontalSelector horizontalSelector;
    private LineGraphRectangleSelector rectangleSelector;
    private LineGraphValueSelector valueSelector;
    private LineGraphMoveController moveController;
    private LineGraphQuickView quickView;
    private LineGraphMouseActionController mouseController;
    private LineGraphAnnotationsController annotatiosController;
    private AutoQuickViewController autoQVController = new AutoQuickViewController();
    private Runnable initializer;
    private GraphChartContainer chartsContainer;
    private RenderingAsyncProgress.ProgressOp uiOp = new RenderingAsyncProgress.ProgressOp(){

        @Override
        public void run(final RenderingAsyncProgress.Progress progress) {
            final Renderer renderer = LineGraphChart.this.getRenderer();
            renderer.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (progress.isWorking()) {
                        LineGraphChart.this.actionListener.repaintDrawingArea(renderer);
                    }
                }
            });
        }
    };
    private RenderingAsyncProgress asyncRenderingProgress = new RenderingAsyncProgress(this.uiOp);
    private final LegendPositionAnchor[] ANCHORS = new LegendPositionAnchor[]{new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.RIGHT_TOP, this.graphArea, 0), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.RIGHT_BOTTOM, this.graphArea, 1), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_BOTTOM, this.graphArea, 2), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_TOP, this.graphArea, 3)};
    private List<LineGraphAnnotationSelectionListener> annotationListeners = new ArrayList<LineGraphAnnotationSelectionListener>();
    private volatile boolean forceFullRepaint = true;
    private GraphChartContainer.DisplayCell containerDisplayCell;
    private ChartsContainerActionListener actionListener = new ChartsContainerActionListener(){

        @Override
        public void dispose() {
            LineGraphChart.this.asyncRenderingProgress.shutDown();
            LineGraphChart.this.containerDisplayCell = null;
        }

        @Override
        public void initializedDrawingArea(Renderer renderer, GraphChartContainer.DisplayCell cell) {
            LineGraphChart.this.mainArea = cell.getGraphArea();
            ((LineGraphChart)LineGraphChart.this).allChartAreas[0] = LineGraphChart.this.mainArea;
            LineGraphChart.this.axes_model.setListenersEnabled(false);
            LineGraphChart.this.axes_model.setAxesToDefault(renderer.getWidth(), renderer.getHeight());
            this.resizedDrawingArea(renderer, cell);
            LineGraphChart.this.value_bar.setPosition(LineGraphChart.this.graphArea.width / 2);
            if (LineGraphChart.this.initializer != null) {
                LineGraphChart.this.initializer.run();
                LineGraphChart.this.initializer = null;
            }
            LineGraphChart.this.axes_model.setListenersEnabled(true);
            if (((LineGraphChart)LineGraphChart.this).autoQVController.enabled) {
                LineGraphChart.this.autoQVController.adjustedBothAxis(LineGraphChart.this.axes_model);
            }
            LineGraphChart.this.axes_model.addAxisListener(new XYGraphAxisModelListener(){

                @Override
                public void adjustedBothAxis(XYGraphAxesModel r1) {
                    LineGraphChart.this.forceFullRepaint = true;
                }

                @Override
                public void adjustedXAxis(XYGraphAxesModel r1) {
                    LineGraphChart.this.forceFullRepaint = true;
                }

                @Override
                public void adjustedYAxis(XYGraphAxesModel r1) {
                    LineGraphChart.this.forceFullRepaint = true;
                }

                @Override
                public void undoStackChanged(XYGraphAxesModel source) {
                }
            });
        }

        @Override
        public void resizedDrawingArea(Renderer renderer, GraphChartContainer.DisplayCell cell) {
            if (!renderer.isVisibleInitialized()) {
                return;
            }
            LineGraphChart.this.mainArea = cell.getGraphArea();
            ((LineGraphChart)LineGraphChart.this).allChartAreas[0] = LineGraphChart.this.mainArea;
            LineGraphChart.this.containerDisplayCell = cell;
            LineGraphChart.this.updateAreaSizes(renderer);
        }

        @Override
        public boolean hasModelDataChanged() {
            return LineGraphChart.this.forceFullRepaint;
        }

        @Override
        public void repaintDrawingArea(Renderer renderer) {
            if (!renderer.isVisibleInitialized()) {
                return;
            }
            if (LineGraphChart.this.allowAsynchRendering) {
                this.paintAsynchAllowed(renderer);
            } else {
                this.paintOnePass(renderer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintOnePass(Renderer renderer) {
            RenderingAsyncProgress renderingAsyncProgress = LineGraphChart.this.asyncRenderingProgress;
            synchronized (renderingAsyncProgress) {
                LineGraphChart.this.asyncRenderingProgress.stopRendering();
                LineGraphChart.this.paint(renderer, true, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintAsynchAllowed(final Renderer renderer) {
            boolean didRestore = renderer.restoreScreen(LineGraphChart.this, LineGraphChart.this.mainArea);
            if (((LineGraphChart)LineGraphChart.this).mainArea.height <= 10 || ((LineGraphChart)LineGraphChart.this).mainArea.width <= 10) {
                return;
            }
            RenderingAsyncProgress renderingAsyncProgress = LineGraphChart.this.asyncRenderingProgress;
            synchronized (renderingAsyncProgress) {
                if (LineGraphChart.this.forceFullRepaint || !didRestore) {
                    LineGraphChart.this.asyncRenderingProgress.stopRendering();
                    if (!didRestore) {
                        LineGraphChart.this.paint(renderer, true, true);
                        return;
                    }
                    LineGraphChart.this.forceFullRepaint = false;
                    LineGraphChart.this.asyncRenderingProgress.requestRenderingJob(new RenderingAsyncProgress.RenderingJob(){

                        @Override
                        public boolean processAsync(RenderingAsyncProgress.Progress progress) {
                            return LineGraphChart.this.container.prepareGraphsForDrawing(LineGraphChart.this.axes_model, LineGraphChart.this.graphArea, progress);
                        }

                        @Override
                        public void paint(Renderer source) {
                            if (!renderer.isVisibleInitialized()) {
                                return;
                            }
                            LineGraphChart.this.paint(renderer, true, false);
                        }
                    }, renderer);
                } else {
                    if (LineGraphChart.this.asyncRenderingProgress.isRendering()) {
                        LineGraphChart.this.asyncRenderingProgress.paintRenderingState(renderer, LineGraphChart.this.graphArea);
                        LineGraphChart.this.quickView.drawView(false);
                    } else {
                        this.postRestoredScreen(renderer);
                    }
                    LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
                }
            }
        }

        @Override
        public void postRestoredScreen(Renderer renderer) {
            LineGraphChart.this.paintSelectionAndValueBar(renderer);
            LineGraphChart.this.quickView.drawView(false);
        }

        @Override
        public void mouseDownLeft(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (LineGraphChart.this.asyncRenderingProgress.isRendering()) {
                return;
            }
            LineGraphChart.this.mouseController.mouseDownLeft(x, y);
            int x_trans = LineGraphChart.this.graphArea.getXinRec(x);
            int y_trans = LineGraphChart.this.graphArea.getYinRec(y);
            if (((LineGraphChart)LineGraphChart.this).valueArea.height > 0 && LineGraphChart.this.value_bar.isCloseButtonHovered(x_trans, y_trans)) {
                LineGraphChart.this.mouseController.setLeftAction(12);
                return;
            }
            LineGraphChart.this.mouseController.setHoveredAnnotation(LineGraphChart.this.annotatiosController.isHovering(x, y, renderer));
            if (LineGraphChart.this.mouseController.getHoveredAnnotation() != null) {
                LineGraphChart.this.mouseController.setLeftAction(16);
                return;
            }
            if (!LineGraphChart.this.graphArea.isIn(x, y) && !LineGraphChart.this.quickArea.isIn(x, y)) {
                return;
            }
            if (LineGraphChart.this.quickView.isHovered(x, y)) {
                LineGraphChart.this.mouseController.setLeftAction(9);
                return;
            }
            if (LineGraphChart.this.horizontalSelector.isMinBorderHovered(x_trans)) {
                LineGraphChart.this.horizontalSelector.setMaxAsStart();
                LineGraphChart.this.mouseController.setLeftAction(5);
                return;
            }
            if (LineGraphChart.this.horizontalSelector.isMaxBorderHovered(x_trans)) {
                LineGraphChart.this.horizontalSelector.setMinAsStart();
                LineGraphChart.this.mouseController.setLeftAction(6);
                return;
            }
            if (!LineGraphChart.this.horizontalSelector.isSelected() && !LineGraphChart.this.rectangleSelector.isSelected() && LineGraphChart.this.value_bar.isHovered(x_trans)) {
                LineGraphChart.this.mouseController.setLeftAction(11);
                return;
            }
            if (LineGraphChart.this.graphArea.isIn(x, y) && (LineGraphChart.this.horizontalSelector.isHovered(x_trans) || LineGraphChart.this.rectangleSelector.isHovered(x_trans, y_trans))) {
                LineGraphChart.this.mouseController.setLeftAction(7);
                return;
            }
            if (!LineGraphChart.this.horizontalSelector.isSelected() && LineGraphChart.this.value_bar.isEnabled() && ((LineGraphChart)LineGraphChart.this).valueArea.height > 0) {
                renderer.restoreScreen(LineGraphChart.this, LineGraphChart.this.mainArea);
                LineGraphChart.this.value_bar.setPosition(x_trans);
                LineGraphChart.this.value_bar.checkPositionAndAdjust(LineGraphChart.this.graphArea.width);
                LineGraphChart.this.value_bar.drawValueBar(LineGraphChart.this.graphArea, LineGraphChart.this.mainArea, false);
                LineGraphChart.this.quickView.drawView();
                LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
            }
            if (LineGraphChart.this.horizontalSelector.isEnabled()) {
                LineGraphChart.this.horizontalSelector.startSelection(x_trans);
                LineGraphChart.this.mouseController.setLeftAction(3);
            } else if (LineGraphChart.this.rectangleSelector.isEnabled()) {
                LineGraphChart.this.rectangleSelector.startSelection(x_trans, y_trans);
                LineGraphChart.this.mouseController.setLeftAction(1);
            }
        }

        @Override
        public void mouseMovedByLeftPressed(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (LineGraphChart.this.asyncRenderingProgress.isRendering()) {
                return;
            }
            switch (LineGraphChart.this.mouseController.getLeftAction()) {
                case 11: {
                    renderer.restoreScreen(LineGraphChart.this, LineGraphChart.this.mainArea);
                    LineGraphChart.this.value_bar.setPosition(LineGraphChart.this.graphArea.getXinRec(x));
                    LineGraphChart.this.value_bar.checkPositionAndAdjust(LineGraphChart.this.graphArea.width);
                    LineGraphChart.this.paintSelectionAndValueBar(renderer);
                    LineGraphChart.this.quickView.drawView();
                    LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
                    break;
                }
                case 5: 
                case 6: {
                    renderer.setCursor(Renderer.CursorType.CURSOR_RESIZE);
                }
                case 3: 
                case 4: {
                    if (!LineGraphChart.this.horizontalSelector.select(LineGraphChart.this.graphArea.getXinRec(x))) break;
                    LineGraphChart.this.mouseController.setLeftAction(4);
                    renderer.restoreScreen(LineGraphChart.this, LineGraphChart.this.mainArea);
                    renderer.setPaintArea(LineGraphChart.this.graphArea, LineGraphChart.this.graphValueArea);
                    LineGraphChart.this.horizontalSelector.drawSelection(renderer, LineGraphChart.this.isValueAreaAvailable());
                    LineGraphChart.this.quickView.drawView();
                    LineGraphChart.this.container.notifyHorizontalRangeSelectionChanged(LineGraphChart.this.horizontalSelector.getMin(), LineGraphChart.this.horizontalSelector.getMax(), LineGraphChart.this.horizontalSelector.getLastDrawnInvalidRanges());
                    LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
                    break;
                }
                case 1: 
                case 2: {
                    if (!LineGraphChart.this.rectangleSelector.select(LineGraphChart.this.graphArea.getXinRec(x), LineGraphChart.this.graphArea.getYinRec(y))) break;
                    LineGraphChart.this.mouseController.setLeftAction(2);
                    renderer.restoreScreen(LineGraphChart.this, LineGraphChart.this.mainArea);
                    renderer.setPaintArea(LineGraphChart.this.graphArea);
                    LineGraphChart.this.rectangleSelector.drawSelection();
                    LineGraphChart.this.quickView.drawView();
                    LineGraphChart.this.container.notifyRectangleRangeSelectionChanged(LineGraphChart.this.rectangleSelector.getStartX(), LineGraphChart.this.rectangleSelector.getEndX(), LineGraphChart.this.rectangleSelector.getStartY(), LineGraphChart.this.rectangleSelector.getEndY());
                    LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
                    break;
                }
                case 9: {
                    LineGraphChart.this.quickView.mouseOn(x, y, false);
                    LineGraphChart.this.repaintIfNoAsync(renderer);
                    break;
                }
                case 12: {
                    if (LineGraphChart.this.value_bar.isCloseButtonHovered(LineGraphChart.this.graphArea.getXinRec(x), LineGraphChart.this.graphArea.getYinRec(y))) {
                        renderer.setCursor(Renderer.CursorType.CURSOR_SELECT);
                        break;
                    }
                    renderer.setCursor(null);
                }
            }
        }

        @Override
        public void mouseUpLeft(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (LineGraphChart.this.asyncRenderingProgress.isRendering()) {
                return;
            }
            switch (LineGraphChart.this.mouseController.getLeftAction()) {
                case 7: {
                    LineGraphChart.this.notifiySelectionTouched();
                    break;
                }
                case 5: 
                case 6: {
                    renderer.setCursor(Renderer.CursorType.CURSOR_RESIZE);
                }
                case 4: {
                    if (LineGraphChart.this.horizontalSelector.adaptSelectionToRaster()) {
                        renderer.restoreScreen(LineGraphChart.this, LineGraphChart.this.mainArea);
                        renderer.setPaintArea(LineGraphChart.this.graphArea, LineGraphChart.this.graphValueArea);
                        if (LineGraphChart.this.horizontalSelector.isSelected()) {
                            LineGraphChart.this.horizontalSelector.drawSelection(renderer, LineGraphChart.this.isValueAreaAvailable());
                        } else {
                            LineGraphChart.this.container.notifySelectionReset();
                            if (((LineGraphChart)LineGraphChart.this).valueArea.height > 0) {
                                LineGraphChart.this.value_bar.drawValueBar(LineGraphChart.this.graphArea, LineGraphChart.this.mainArea, false);
                            }
                        }
                        LineGraphChart.this.quickView.drawView();
                        LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
                    }
                    if (!LineGraphChart.this.horizontalSelector.isSelected()) break;
                    LineGraphChart.this.container.notifyHorizontalRangeSelected(LineGraphChart.this.horizontalSelector.getMin(), LineGraphChart.this.horizontalSelector.getMax(), LineGraphChart.this.horizontalSelector.getSelectedInvalidRanges());
                    break;
                }
                case 3: {
                    if (!LineGraphChart.this.horizontalSelector.isSelected()) break;
                    LineGraphChart.this.horizontalSelector.resetSelection();
                    LineGraphChart.this.container.notifySelectionReset();
                    renderer.restoreScreen(LineGraphChart.this, LineGraphChart.this.mainArea);
                    if (((LineGraphChart)LineGraphChart.this).valueArea.height > 0) {
                        LineGraphChart.this.value_bar.drawValueBar(LineGraphChart.this.graphArea, LineGraphChart.this.mainArea, false);
                    }
                    LineGraphChart.this.quickView.drawView();
                    LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
                    break;
                }
                case 2: {
                    if (LineGraphChart.this.rectangleSelector.adaptSelectionToRaster()) {
                        renderer.restoreScreen(LineGraphChart.this, LineGraphChart.this.mainArea);
                        renderer.setPaintArea(LineGraphChart.this.graphArea);
                        LineGraphChart.this.rectangleSelector.drawSelection();
                        LineGraphChart.this.quickView.drawView();
                        LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
                    }
                    if (!LineGraphChart.this.rectangleSelector.isSelected()) break;
                    LineGraphChart.this.container.notifyRectangleRangeSelected(LineGraphChart.this.rectangleSelector.getStartX(), LineGraphChart.this.rectangleSelector.getEndX(), LineGraphChart.this.rectangleSelector.getStartY(), LineGraphChart.this.rectangleSelector.getEndY());
                    break;
                }
                case 1: {
                    if (!LineGraphChart.this.rectangleSelector.isSelected()) break;
                    LineGraphChart.this.rectangleSelector.resetSelection();
                    LineGraphChart.this.container.notifySelectionReset();
                    renderer.restoreScreen(LineGraphChart.this, LineGraphChart.this.mainArea);
                    if (((LineGraphChart)LineGraphChart.this).valueArea.height > 0) {
                        LineGraphChart.this.value_bar.drawValueBar(LineGraphChart.this.graphArea, LineGraphChart.this.mainArea, false);
                    }
                    LineGraphChart.this.quickView.drawView();
                    LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
                    break;
                }
                case 16: {
                    if (LineGraphChart.this.annotatiosController.isHovering(x, y, renderer) != LineGraphChart.this.mouseController.getHoveredAnnotation()) break;
                    LineGraphChart.this.notifyAnnotationListeners(LineGraphChart.this.mouseController.getHoveredAnnotation());
                    break;
                }
                case 9: {
                    LineGraphChart.this.quickView.mouseOn(x, y, LineGraphChart.this.auto_adjust);
                    LineGraphChart.this.repaintIfNoAsync(renderer);
                    break;
                }
                case 12: {
                    if (!LineGraphChart.this.value_bar.isCloseButtonHovered(LineGraphChart.this.graphArea.getXinRec(x), LineGraphChart.this.graphArea.getYinRec(y))) break;
                    LineGraphChart.this.value_bar.closeValueBar();
                    LineGraphChart.this.container.notifyValueBarClosed();
                    LineGraphChart.this.repaintIfNoAsync(renderer);
                }
            }
        }

        @Override
        public void mouseMoved(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (LineGraphChart.this.asyncRenderingProgress.isRendering()) {
                return;
            }
            renderer.setCursor(null);
            int x_pos = LineGraphChart.this.graphArea.getXinRec(x);
            int y_pos = LineGraphChart.this.graphArea.getYinRec(y);
            if (((LineGraphChart)LineGraphChart.this).valueArea.height > 0 && LineGraphChart.this.value_bar.isCloseButtonHovered(x_pos, y_pos)) {
                renderer.setCursor(Renderer.CursorType.CURSOR_SELECT);
                return;
            }
            if (!LineGraphChart.this.graphArea.isIn(x, y)) {
                if (LineGraphChart.this.annotatiosController.isHovering(x, y, renderer) != null) {
                    renderer.setCursor(Renderer.CursorType.CURSOR_SELECT);
                }
                return;
            }
            renderer.setPaintArea(LineGraphChart.this.graphArea);
            if (!LineGraphChart.this.horizontalSelector.isSelected() && !LineGraphChart.this.rectangleSelector.isSelected() && LineGraphChart.this.value_bar.isHovered(x_pos) || LineGraphChart.this.horizontalSelector.isBorderHovered(x_pos)) {
                renderer.setCursor(Renderer.CursorType.CURSOR_RESIZE);
            } else {
                renderer.setCursor(null);
            }
        }

        @Override
        public void mouseHovered(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (LineGraphChart.this.asyncRenderingProgress.isRendering()) {
                return;
            }
            if (LineGraphChart.this.annotatiosController.hovered(x, y, source)) {
                return;
            }
            if (LineGraphChart.this.valueSelector.isValueHovered(LineGraphChart.this.graphArea.getXinRec(x), LineGraphChart.this.graphArea.getYinRec(y))) {
                LineGraphChart.this.valueSelector.showToolTip(LineGraphChart.this.axes_model, LineGraphChart.this.graphArea.width, x, y);
            }
        }

        @Override
        public void mouseDownRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (LineGraphChart.this.asyncRenderingProgress.isRendering()) {
                return;
            }
            LineGraphChart.this.mouseController.mouseDownRight(x, y);
            if (!LineGraphChart.this.graphArea.isIn(x, y)) {
                return;
            }
            if (LineGraphChart.this.quickView.isHovered(x, y)) {
                LineGraphChart.this.mouseController.setRightAction(10);
                return;
            }
            if (LineGraphChart.this.moveController.isEnabled()) {
                LineGraphChart.this.moveController.setStartPosition(LineGraphChart.this.graphArea.getXinRec(x), LineGraphChart.this.graphArea.getYinRec(y));
                LineGraphChart.this.mouseController.setRightAction(8);
            }
        }

        @Override
        public void mouseMovedByRightPressed(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (LineGraphChart.this.asyncRenderingProgress.isRendering()) {
                return;
            }
            switch (LineGraphChart.this.mouseController.getRightAction()) {
                case 8: {
                    if (!LineGraphChart.this.moveController.move(LineGraphChart.this.graphArea.getXinRec(x), LineGraphChart.this.graphArea.getYinRec(y))) break;
                    LineGraphChart.this.repaintIfNoAsync(source);
                }
            }
        }

        @Override
        public void mouseUpRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (LineGraphChart.this.asyncRenderingProgress.isRendering()) {
                return;
            }
            switch (LineGraphChart.this.mouseController.getRightAction()) {
                case 8: {
                    if (!LineGraphChart.this.moveController.move(LineGraphChart.this.graphArea.getXinRec(x), LineGraphChart.this.graphArea.getYinRec(y)) || !LineGraphChart.this.auto_adjust) break;
                    LineGraphChart.this.axes_model.adjustAxisToReadableValues();
                }
            }
        }

        @Override
        public void mouseDoubleClicked(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (LineGraphChart.this.asyncRenderingProgress.isRendering()) {
                return;
            }
            if (LineGraphChart.this.adjust_db) {
                LineGraphChart.this.initAxes();
            }
        }
    };

    private void performAsync(final RenderingAsyncProgress.ProgressOp action) {
        Thread job = new Thread(new Runnable(){

            @Override
            public void run() {
                LineGraphChart.this.container.getGraphRenderer().visualSetChaged();
                RenderingAsyncProgress.Progress progress = new RenderingAsyncProgress.Progress(new RenderingAsyncProgress.ProgressOp(){

                    @Override
                    public void run(final RenderingAsyncProgress.Progress p) {
                        final Renderer renderer = LineGraphChart.this.getRenderer();
                        renderer.asyncExec(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (p.isWorking()) {
                                    RenderingAsyncProgress renderingAsyncProgress = LineGraphChart.this.asyncRenderingProgress;
                                    synchronized (renderingAsyncProgress) {
                                        renderer.restoreScreen(LineGraphChart.this, LineGraphChart.this.mainArea);
                                        RenderingAsyncProgress.paintRenderingState(p, renderer, LineGraphChart.this.graphArea);
                                        LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
                                    }
                                }
                            }
                        });
                    }
                });
                try {
                    action.run(progress);
                }
                catch (Throwable th) {
                    Trace.error((Throwable)th);
                }
                finally {
                    progress.endTask();
                    LineGraphChart.this.actionListener.repaintDrawingArea(LineGraphChart.this.chartsContainer.getRenderer());
                }
            }
        });
        job.start();
    }

    public static LineGraphDataSet createDataSet(String name) {
        return new LineGraphDataSet(name){};
    }

    public static LineGraphVirtualDataSet createVirtualDataSet(String name, String fileName) throws IOException {
        return new LineGraphVirtualDataSet(name, fileName){};
    }

    public static LineGraphVirtualDataSet createVirtualDataSet(String name, String fileName, LineGraphPresentationAdapter adapter) throws IOException {
        LineGraphVirtualDataSet set = new LineGraphVirtualDataSet(name, fileName){};
        set.setPresentationAdapter(adapter);
        return set;
    }

    public LineGraphChart(GraphChartContainer chartsContainer, boolean x_axis_show, boolean y_axis_show) {
        this(chartsContainer, x_axis_show, y_axis_show, true);
    }

    public LineGraphChart(GraphChartContainer chartsContainer, boolean x_axis_show, boolean y_axis_show, boolean allowAsynchRendering) {
        this.instanceId = instanceCounter++;
        this.chartsContainer = chartsContainer;
        this.x_axis_show = x_axis_show;
        this.x_raster_show = x_axis_show;
        this.y_axis_show = y_axis_show;
        this.y_raster_show = y_axis_show;
        this.y_axisSec_show = false;
        this.allowAsynchRendering = allowAsynchRendering;
        Renderer renderer = chartsContainer.getRenderer();
        this.x_axis = new LineGraphAxis(this.axes_model.getXAxis(), 1, 1, renderer);
        this.y_axis = new LineGraphAxis(this.axes_model.getYAxis(), 0, 0, renderer);
        this.y_axisSec = new LineGraphAxis(this.axes_model.getYAxisSecondary(), 0, 1, renderer);
        this.y_axisSec.enableRasterLines(false);
        this.container = new LineGraphContainer(renderer, this.axes_model);
        this.value_bar = new LineGraphValueBar(renderer, this.axes_model, this.container);
        this.horizontalSelector = new LineGraphHorizontalSelector(this.graphArea, this.axes_model, this.container);
        this.rectangleSelector = new LineGraphRectangleSelector(renderer, this.axes_model);
        this.valueSelector = new LineGraphValueSelector(renderer, this.container);
        this.moveController = new LineGraphMoveController(this.graphArea, this.axes_model);
        this.mouseController = new LineGraphMouseActionController();
        this.annotatiosController = new LineGraphAnnotationsController();
        this.quickView = new LineGraphQuickView(renderer, this.container, this.axes_model, this.quickArea, this.graphArea);
        this.addValueBarListener(new LineGraphValueBarListener(){

            @Override
            public void positionChanged(double xPos, boolean positionSet) {
                LineGraphChart.this.notifyACC();
            }

            @Override
            public void valueBarClosed() {
            }
        });
        this.addLineGraphSelectionListener(new LineGraphSelectionListener(){

            @Override
            public void valueSelected(LineGraphDataSet graph, List<Value2D> values) {
                LineGraphChart.this.notifyACC();
            }

            @Override
            public void selectionReset() {
                LineGraphChart.this.notifyACC();
            }

            @Override
            public void selectionClickedOn() {
                LineGraphChart.this.notifyACC();
            }

            @Override
            public void rectangleRangeSelectionChanged(double minX, double maxX, double minY, double maxY) {
                LineGraphChart.this.notifyACC();
            }

            @Override
            public void rectangleRangeSelected(double minX, double maxX, double minY, double maxY) {
                LineGraphChart.this.notifyACC();
            }

            @Override
            public void horizontalRangeSelectionChanged(double min, double max, List<InvalidSelectionRange> ranges) {
                LineGraphChart.this.notifyACC();
            }

            @Override
            public void horizontalRangeSelected(double min, double max, List<InvalidSelectionRange> ranges) {
                LineGraphChart.this.notifyACC();
            }

            @Override
            public void graphSelected(LineGraphDataSet graph) {
                LineGraphChart.this.notifyACC();
            }
        });
        this.addAxisListener(new XYGraphAxisModelListener(){

            @Override
            public void adjustedYAxis(XYGraphAxesModel source) {
                if (LineGraphChart.this.y_axis_show) {
                    LineGraphChart.this.notifyACC();
                }
            }

            @Override
            public void adjustedXAxis(XYGraphAxesModel source) {
                if (LineGraphChart.this.x_axis_show) {
                    LineGraphChart.this.notifyACC();
                }
            }

            @Override
            public void adjustedBothAxis(XYGraphAxesModel source) {
                if (LineGraphChart.this.x_axis_show || LineGraphChart.this.y_axis_show) {
                    LineGraphChart.this.notifyACC();
                }
            }

            @Override
            public void undoStackChanged(XYGraphAxesModel source) {
            }
        });
    }

    @Override
    public Renderer getRenderer() {
        return this.chartsContainer.getRenderer();
    }

    public void setInitializer(Runnable initializer) {
        this.initializer = initializer;
    }

    @Override
    public void refresh() {
        this.forceFullRepaint = true;
        if (this.chartsContainer.isRefreshNotBlocked()) {
            this.actionListener.repaintDrawingArea(this.chartsContainer.getRenderer());
        }
    }

    @Override
    public void addGraph(LineGraphDataSet graph, boolean secondary) {
        this.container.appendGraph(graph, secondary);
        this.refreshWithQuickView();
        this.notifyACC();
    }

    @Override
    public void addGraph(LineGraphDataSet graph) {
        this.addGraph(graph, false);
    }

    @Override
    public List<LineGraphDataSet> getAllGraphs() {
        return this.container.getAllGraphs();
    }

    public List<LineGraphDataSet> getAllPrimaryAxisGraphs() {
        return this.container.getAllPrimaryAxisGraphs();
    }

    public List<LineGraphDataSet> getAllSecondaryAxisGraphs() {
        return this.container.getAllSecondaryAxisGraphs();
    }

    public XYGraphAxesModel getAxesModel() {
        return this.axes_model;
    }

    @Override
    public void removeAllGraphs() {
        this.container.removeAllGraphs(this.axes_model);
        this.refreshWithQuickView();
        this.notifyACC();
    }

    public void removeGraph(LineGraphDataSet graph) {
        if (this.container.removeGraph(graph)) {
            this.refreshWithQuickView();
            this.notifyACC();
        }
    }

    public void enableAutoAxesAdjust(boolean enable) {
        this.auto_adjust = enable;
    }

    public void enableSecondaryYAxis(boolean enable) {
        this.y_axisSec_show = enable;
    }

    public void setRasterVisible(boolean xRaster, boolean yRaster) {
        this.x_raster_show = xRaster;
        this.y_raster_show = yRaster;
    }

    public void setAutoQuickViewEnabling(boolean enable) {
        this.autoQVController.init(enable);
        this.axes_model.removeAxisListener(this.autoQVController);
        if (enable) {
            this.axes_model.addAxisListener(this.autoQVController);
        }
    }

    public void enableQuickView(boolean enable) {
        boolean relayout = !this.forceFullRepaint && enable != this.quickView.isEnabled();
        this.quickView.enable(enable);
        if (relayout) {
            this.chartsContainer.refresh(true);
        }
    }

    public boolean isQuickViewEnabled() {
        return this.quickView.isEnabled();
    }

    public void setHorizontalQuickViewSelection(boolean enable) {
        this.quickView.setHorizontalSelectionOnly(enable);
    }

    public void refreshWithQuickView() {
        this.quickView.updateView(new Runnable(){

            @Override
            public void run() {
                LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
            }
        });
        this.refresh();
    }

    public void enableValueSelection(boolean enable) {
        this.valueSelector.enable(enable);
    }

    public boolean isValueSelectionEnabled() {
        return this.valueSelector.isEnabled();
    }

    public void setAdjustOnDoubleClick(boolean adjust) {
        this.adjust_db = adjust;
    }

    @Override
    public LegendPositionAnchor getDefaultLegedPosition() {
        return this.ANCHORS[0];
    }

    @Override
    public LegendPositionAnchor[] getLegendAnchors() {
        return this.ANCHORS;
    }

    public void enableMouseMove(boolean enable) {
        this.moveController.enable(enable);
    }

    public void enableHorizontalMouseMove(boolean enable) {
        this.moveController.enableHorizontal(enable);
    }

    public void enableVerticalMouseMove(boolean enable) {
        this.moveController.enableVertical(enable);
    }

    public boolean isMouseMoveEnabled() {
        return this.moveController.isEnabled();
    }

    public void enableRectangleSelection(boolean enable) {
        this.rectangleSelector.enable(enable);
        if (enable) {
            this.horizontalSelector.enable(false);
        }
    }

    public boolean isRectangleSelectionEnabled() {
        return this.rectangleSelector.isEnabled();
    }

    public void enableHorizontalSelection(boolean enable) {
        this.horizontalSelector.enable(enable);
        if (enable) {
            this.rectangleSelector.enable(false);
        }
    }

    public boolean isHorizontalSelectionEnabled() {
        return this.horizontalSelector.isEnabled();
    }

    public void selectHorizontal(double min, double max) {
        if (this.chartsContainer.isRefreshNotBlocked() && this.horizontalSelector.select(min, max)) {
            Renderer renderer = this.chartsContainer.getRenderer();
            renderer.restoreScreen(this, this.mainArea);
            renderer.setPaintArea(this.graphArea, this.graphValueArea);
            this.horizontalSelector.drawSelection(renderer, this.isValueAreaAvailable());
            this.quickView.drawView();
            this.chartsContainer.updateScreen(this.containerDisplayCell);
        }
    }

    public void resetSelction(boolean silent) {
        if (this.chartsContainer.isRefreshNotBlocked() && (this.horizontalSelector.resetSelection() || this.rectangleSelector.resetSelection())) {
            Renderer renderer = this.chartsContainer.getRenderer();
            renderer.restoreScreen(this, this.mainArea);
            if (this.valueArea.height > 0) {
                this.value_bar.drawValueBar(this.graphArea, this.mainArea, false);
            }
            this.quickView.drawView();
            this.chartsContainer.updateScreen(this.containerDisplayCell);
            if (!silent) {
                this.container.notifySelectionReset();
            }
        }
    }

    public void zoomSelection() {
        if (!this.chartsContainer.isRefreshNotBlocked() || this.horizontalSelector.zoom() || this.rectangleSelector.zoom()) {
            // empty if block
        }
    }

    public void notifiySelectionTouched() {
        if (this.horizontalSelector.isSelected() || this.rectangleSelector.isSelected()) {
            this.container.notifySelectionClickedOn();
            this.horizontalSelector.resetSelection();
            this.rectangleSelector.resetSelection();
            this.container.notifySelectionReset();
            this.refresh();
        }
    }

    public void moveXOnly(int pixels, boolean undo) {
        double delta = this.axes_model.getXRange() / (double)this.graphArea.width * (double)pixels;
        this.adjustXAxis(this.axes_model.getMinX() + delta, this.axes_model.getMaxX() + delta, undo);
        this.repaintIfNoAsync(this.chartsContainer.getRenderer());
    }

    public void moveXOnly(double newXmin, boolean undo, boolean silent) {
        double delta = newXmin - this.axes_model.getMinX();
        this.adjustXAxis(this.axes_model.getMinX() + delta, this.axes_model.getMaxX() + delta, undo, silent);
        this.repaintIfNoAsync(this.chartsContainer.getRenderer());
    }

    public void disableRasterSelection() {
        this.horizontalSelector.disableRasterSelection();
        this.rectangleSelector.disableRasterSelection();
    }

    public void enableRasterSelection(double rasterPeriod) {
        this.horizontalSelector.enableRasterSelection(rasterPeriod);
        this.rectangleSelector.enableRasterSelection(rasterPeriod);
    }

    public void enableHorizontalRasterSelection(RasterAnchorsList anchors) {
        this.horizontalSelector.enableRasterSelection(anchors);
    }

    public void enableHorizontalRasterSelection(final double[] anchors) {
        RasterAnchorsList list = new RasterAnchorsList(){

            @Override
            public long getLength() {
                return anchors.length;
            }

            @Override
            public double getValueAt(long idx) {
                return anchors[(int)idx];
            }
        };
        this.horizontalSelector.enableRasterSelection(list);
    }

    public void addInvalidSelectionRange(InvalidSelectionRange range) {
        this.horizontalSelector.addInvalidSelectionRange(range);
    }

    public void removeInvalidSelectionRange(InvalidSelectionRange range) {
        this.horizontalSelector.removeInvalidSelectionRange(range);
    }

    public void removeAllInvalidRanges() {
        this.horizontalSelector.removeAllInvalidRanges();
    }

    public void initAxes() {
        if (this.chartsContainer.isRefreshNotBlocked()) {
            this.performAsync(new RenderingAsyncProgress.ProgressOp(){

                @Override
                public void run(RenderingAsyncProgress.Progress progress) {
                    LineGraphChart.this.container.initAxes(LineGraphChart.this.axes_model, progress);
                    LineGraphChart.this.notifyACC();
                }
            });
        }
    }

    public void setRasterColor(Color color) {
        this.x_axis.setRasterColor(color);
        this.y_axis.setRasterColor(color);
        this.y_axisSec.setRasterColor(color);
    }

    public void setXRasterAdapter(RasterCalculationAdapter adapterX) {
        this.axes_model.setXRasterAdapter(adapterX);
    }

    public void setYRasterAdapter(RasterCalculationAdapter adapterY) {
        this.axes_model.setYRasterAdapter(adapterY);
    }

    public void setSecYRasterAdapter(RasterCalculationAdapter adapterY) {
        this.axes_model.getYAxisSecondary().setRasterAdapter(adapterY);
    }

    public void setRangeAxisAdaptor(RangeLineAxisAdapter xAdapter, RangeLineAxisAdapter yAdapter) {
        this.axes_model.setRangeAxisAdaptor(xAdapter, yAdapter);
    }

    public void setSecYRangeAxisAdaptor(RangeLineAxisAdapter yAdapter) {
        this.axes_model.getYAxisSecondary().setRangeAxisAdaptor(yAdapter);
    }

    public void addLineGraphSelectionListener(LineGraphSelectionListener listener) {
        this.container.addLineGraphSelectionListener(listener);
    }

    public void removeLineGraphSelectionListener(LineGraphSelectionListener listener) {
        this.container.removeLineGraphSelectionListener(listener);
    }

    public void addLineGraphSelectionToolTipProvider(LineGraphSelectionToolTipProvider provider) {
        this.container.addLineGraphSelectionToolTipProvider(provider);
    }

    public void addValueBarListener(LineGraphValueBarListener listener) {
        this.container.addValueBarListener(listener);
    }

    public void removeValueBarListener(LineGraphValueBarListener listener) {
        this.container.removeBarListener(listener);
    }

    public void setAnnotationsImageFactory(LineGraphAnnotationsImageFactory imgFactory) {
        this.annotatiosController.setImgFactory(imgFactory);
    }

    public void setAnnotationTooltipProvider(LineGraphAnnotationTooltipProvider tooltipProvider) {
        this.annotatiosController.setTooltipProvider(tooltipProvider);
    }

    public void addAnnotationSet(LineGraphAnnotationSet set) {
        this.annotatiosController.addAnnotationSet(set);
    }

    public void removeAnnotationSet(LineGraphAnnotationSet set) {
        this.annotatiosController.removeAnnotationSet(set);
    }

    public void removeAllAnnotations() {
        this.annotatiosController.removeAll();
    }

    public void addAnnotationSelectionLister(LineGraphAnnotationSelectionListener listener) {
        if (this.annotationListeners.indexOf(listener) == -1) {
            this.annotationListeners.add(listener);
        }
    }

    public void removeAnnotationSelectionLister(LineGraphAnnotationSelectionListener listener) {
        this.annotationListeners.remove(listener);
    }

    private void notifyAnnotationListeners(Object annotations) {
        ArrayList<LineGraphAnnotation> list = new ArrayList<LineGraphAnnotation>();
        if (annotations instanceof LineGraphAnnotation) {
            list.add((LineGraphAnnotation)annotations);
        } else {
            LineGraphAnnotationsController.AnnotationPane pane = (LineGraphAnnotationsController.AnnotationPane)annotations;
            list.addAll(pane.getAllAnnotations());
        }
        for (LineGraphAnnotationSelectionListener l : this.annotationListeners) {
            l.annotationSelected(list);
        }
    }

    public void addAxisListener(XYGraphAxisModelListener listener) {
        this.axes_model.addAxisListener(listener);
    }

    public void removeAxisListener(XYGraphAxisModelListener listener) {
        this.axes_model.removeAxisListener(listener);
    }

    public void adjustXAxis(double min, double max, boolean undo) {
        this.adjustXAxis(min, max, undo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustXAxis(double min, double max, boolean undo, boolean silent) {
        if (this.chartsContainer.isRefreshNotBlocked()) {
            if (undo) {
                this.axes_model.markUndo();
            }
            if (silent) {
                try {
                    this.axes_model.setListenersEnabled(false);
                    this.axes_model.adjustXAxis(this.graphArea.width, min, max);
                }
                finally {
                    this.axes_model.setListenersEnabled(true);
                    if (this.autoQVController.enabled) {
                        this.autoQVController.adjustedXAxis(this.axes_model);
                    }
                }
            } else {
                this.axes_model.adjustXAxis(this.graphArea.width, min, max);
            }
        }
    }

    public void adjustYAxis(double min, double max, boolean undo) {
        if (this.chartsContainer.isRefreshNotBlocked()) {
            if (undo) {
                this.axes_model.markUndo();
            }
            this.axes_model.adjustYAxis(this.graphArea.height, min, max);
        }
    }

    public void adjustSecondaryYAxis(double min, double max, boolean undo) {
        if (this.chartsContainer.isRefreshNotBlocked()) {
            if (undo) {
                this.axes_model.markUndo();
            }
            this.axes_model.adjustSecondaryYAxis(this.graphArea.height, min, max);
        }
    }

    public double getMaxXAxisValue() {
        return this.axes_model.getMaxX();
    }

    public double getMaxYAxisValue() {
        return this.axes_model.getMaxY();
    }

    public double getMaxSecondaryYAxisValue() {
        return this.axes_model.getYAxisSecondary().getMax();
    }

    public double getMinXAxisValue() {
        return this.axes_model.getMinX();
    }

    public double getMinYAxisValue() {
        return this.axes_model.getMinY();
    }

    public double getMinSecondaryYAxisValue() {
        return this.axes_model.getYAxisSecondary().getMin();
    }

    public double getXAxisRasterSize() {
        return this.axes_model.getXAxisRasterSize();
    }

    public double getYAxisRasterSize() {
        return this.axes_model.getYAxisRasterSize();
    }

    public double getSecondaryYAxisRasterSize() {
        return this.axes_model.getYAxisSecondary().getAxisRasterSize();
    }

    public boolean canUndo() {
        return this.axes_model.canUndo();
    }

    public boolean unDo() {
        return this.chartsContainer.isRefreshNotBlocked() && this.axes_model.unDo(this.graphArea.width, this.graphArea.height);
    }

    public byte[] exportUndoStack() {
        return this.axes_model.exportUndoStack();
    }

    public void importUndoStack(byte[] data) throws IOException {
        this.axes_model.importUndoStack(data);
    }

    public void setXAxisCaptionProvider(LineGraphAxisCaptionProvider provider) {
        if (this.x_axis != null) {
            this.x_axis.setAxisCaptionProvider(provider);
        }
    }

    public void setYAxisCaptionProvider(LineGraphAxisCaptionProvider provider) {
        if (this.y_axis != null) {
            this.y_axis.setAxisCaptionProvider(provider);
        }
    }

    public void setSecondaryYAxisCaptionProvider(LineGraphAxisCaptionProvider provider) {
        if (this.y_axisSec != null) {
            this.y_axisSec.setAxisCaptionProvider(provider);
        }
    }

    public void setMoveAdapter(LineGraphMoveAdapter adapter) {
        this.moveController.setMoveAdapter(adapter);
        this.quickView.setMoveAdapter(adapter);
    }

    public void setValueBarToolTipProvider(LineGraphValueBarToolTipProvider provider) {
        this.value_bar.setProvider(provider);
    }

    public void setValueBarPosition(double value) {
        int pos = this.getAxesModel().getXAxis().getPosition(this.graphArea.width, value);
        this.value_bar.setPosition(pos);
        this.updateValueBarDisplay();
    }

    public void closeValueBar() {
        if (this.value_bar.isVisible()) {
            this.value_bar.closeValueBar();
            this.container.notifyValueBarClosed();
            this.container.renderer.setCursor(null);
            this.updateValueBarDisplay();
        }
    }

    private void updateValueBarDisplay() {
        if (this.asyncRenderingProgress.isRendering()) {
            return;
        }
        if (!this.horizontalSelector.isSelected() && this.value_bar.isEnabled() && this.valueArea.height > 0) {
            Renderer renderer = this.chartsContainer.getRenderer();
            renderer.restoreScreen(this, this.mainArea);
            this.value_bar.checkPositionAndAdjust(this.graphArea.width);
            this.value_bar.drawValueBar(this.graphArea, this.mainArea, true);
            this.quickView.drawView();
            this.chartsContainer.updateScreen(this.containerDisplayCell);
        }
    }

    public List<LineGraphAnnotation> getSelectedAnnotations() {
        if (this.horizontalSelector.isSelected()) {
            return this.annotatiosController.getAnnotations(this.horizontalSelector.getMin(), this.horizontalSelector.getMax());
        }
        return null;
    }

    private void paintSelectionAndValueBar(Renderer renderer) {
        renderer.setPaintArea(this.graphArea, this.graphValueArea);
        if (!this.horizontalSelector.drawSelection(renderer, this.isValueAreaAvailable()) && !this.rectangleSelector.drawSelection() && this.valueArea.height > 0) {
            this.value_bar.drawValueBar(this.graphArea, this.mainArea, false);
        }
    }

    private boolean isValueAreaAvailable() {
        return this.valueArea.height > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintIfNoAsync(Renderer renderer) {
        RenderingAsyncProgress renderingAsyncProgress = this.asyncRenderingProgress;
        synchronized (renderingAsyncProgress) {
            if (this.asyncRenderingProgress.isRendering()) {
                return;
            }
            this.paint(renderer, true, true);
        }
    }

    private void paint(Renderer renderer, boolean allowRecursion, boolean prepareGraphs) {
        renderer.setPaintArea(this.mainArea);
        renderer.clearDrawingArea();
        boolean axesNeedResize = false;
        if (this.y_axis_show || this.y_raster_show) {
            this.y_axis.repaintAxis(this.y_axis_show, this.y_raster_show, this.graphArea, this.axisYArea, this.axisYClippArea, renderer);
            if (this.y_axis.getMinDimension(renderer) > this.axisYArea.width) {
                axesNeedResize = true;
            }
        }
        if (this.y_axisSec_show) {
            this.y_axisSec.repaintAxis(this.y_axisSec_show, false, this.graphArea, this.axisSecYArea, this.axisSecYClippArea, renderer);
            if (this.y_axisSec.getMinDimension(renderer) > this.axisSecYArea.width) {
                axesNeedResize = true;
            }
        }
        if (axesNeedResize && allowRecursion) {
            this.updateAreaSizes(renderer);
            this.paint(renderer, false, prepareGraphs);
            return;
        }
        if (prepareGraphs) {
            this.container.prepareGraphsForDrawing(this.axes_model, this.graphArea, new RenderingAsyncProgress.Progress());
        }
        if (this.x_axis_show || this.x_raster_show) {
            this.x_axis.repaintAxis(this.x_axis_show, this.x_raster_show, this.graphArea, this.axisXArea, this.axisXClippArea, renderer);
        }
        renderer.setPaintArea(this.graphArea, this.graphClippArea);
        this.container.repaintGraphs(this.axes_model);
        this.annotatiosController.repaint(renderer, this.axes_model, this.graphArea, this.valueArea);
        renderer.saveScreen(this.mainArea, this);
        this.quickView.drawView();
        this.paintSelectionAndValueBar(renderer);
        this.chartsContainer.updateScreen(this.containerDisplayCell);
        this.forceFullRepaint = false;
    }

    private void updateAreaSizes(Renderer renderer) {
        int prefSize;
        int fontHeight = renderer.getFontHeight();
        int availableHeight = this.mainArea.height;
        int xAxisHeight = 0;
        if (this.x_axis_show) {
            int minSize = this.x_axis.getMinDimension(renderer);
            int prefSize2 = this.axes_model.getXAxis().getPreferredDisplaySize() + (this.x_axis.hasAxisTitle() ? fontHeight : 0);
            if (prefSize2 <= minSize) {
                xAxisHeight = prefSize2;
            } else {
                double factor = Math.min(1.0, (double)this.mainArea.height * 0.003);
                xAxisHeight = minSize + (int)Math.round((double)(prefSize2 - minSize) * factor);
            }
            if (xAxisHeight > availableHeight / 2) {
                xAxisHeight = availableHeight / 2;
            }
        }
        this.quickArea.update(this.mainArea.x, this.mainArea.y_end + this.quickView.getViewHeight(availableHeight -= xAxisHeight) + 1, this.mainArea.width, this.quickView.getViewHeight(availableHeight));
        int optionalAreaHeight = 0;
        if ((availableHeight -= this.quickArea.height) > 50) {
            int valueBarHeight = this.value_bar.isEnabled() ? this.value_bar.getTipHeight() : 0;
            int annotationsHeight = this.annotatiosController.anyAnnotationsDefined() ? (int)Math.round((double)renderer.getFontHeight() * 1.5) : 0;
            int selectorHeight = this.horizontalSelector.isEnabled() ? this.horizontalSelector.getCaptionHeight(renderer) : 0;
            optionalAreaHeight = Math.max(valueBarHeight, Math.max(annotationsHeight, selectorHeight));
        }
        this.valueArea.update(this.mainArea.x, this.mainArea.y, this.mainArea.width, optionalAreaHeight);
        int graphAreaHeight = this.x_axis_show ? availableHeight + 1 : (availableHeight -= optionalAreaHeight);
        int y_axis_width = 0;
        int y_sec_axis_width = 0;
        if (this.y_axis_show) {
            prefSize = this.axes_model.getYAxis().getPreferredDisplaySize() + (this.y_axis.hasAxisTitle() ? fontHeight : 0);
            y_axis_width = Math.max(this.y_axis.getMinDimension(renderer), prefSize);
            this.axisYArea.update(this.mainArea.x, this.mainArea.y - this.valueArea.height, y_axis_width, graphAreaHeight);
            this.axisYClippArea.update(this.axisYArea.x, this.axisYArea.y + fontHeight / 2, this.axisYArea.width, this.axisYArea.height + fontHeight);
        }
        if (this.y_axisSec_show) {
            prefSize = this.axes_model.getYAxisSecondary().getPreferredDisplaySize() + (this.y_axisSec.hasAxisTitle() ? fontHeight : 0);
            y_sec_axis_width = Math.max(this.y_axisSec.getMinDimension(renderer), prefSize);
            this.axisSecYArea.update(this.mainArea.x + this.mainArea.width - y_sec_axis_width, this.mainArea.y - this.valueArea.height, y_sec_axis_width, graphAreaHeight);
            this.axisSecYClippArea.update(this.axisSecYArea.x, this.axisSecYArea.y + fontHeight / 2, this.axisSecYArea.width, this.axisSecYArea.height + fontHeight);
        }
        if (this.x_axis_show) {
            this.axisXArea.update(this.mainArea.x + (this.y_axis_show ? this.axisYArea.width - 1 : 0), this.quickArea.y + xAxisHeight - 1, this.mainArea.width - (this.y_axis_show ? this.axisYArea.width : 0) - (this.y_axisSec_show ? this.axisSecYArea.width : 0), xAxisHeight);
            this.axisXClippArea.update(this.mainArea.x, this.axisXArea.y, this.mainArea.width, this.axisXArea.height);
        }
        this.graphArea.update(this.y_axis_show ? this.mainArea.x + y_axis_width - 1 : this.mainArea.x, this.mainArea.y - this.valueArea.height, this.mainArea.width - (this.y_axis_show ? y_axis_width : 0) - (this.y_axisSec_show ? y_sec_axis_width : 0), graphAreaHeight);
        this.graphClippArea.copy(this.graphArea);
        if (this.x_axis_show) {
            this.graphClippArea.updateHeight(graphAreaHeight - 1);
        }
        this.graphValueArea.update(this.graphArea.x, this.valueArea.y, this.graphArea.width, this.graphArea.height + this.valueArea.height);
        this.quickArea.update(this.graphArea.x, this.quickArea.y, this.graphArea.width, this.quickArea.height);
        this.axes_model.recalculateAxesRaster(this.graphArea.width, this.graphArea.height);
        this.value_bar.checkPositionAndAdjust(this.graphArea.width);
        this.quickView.updateView(new Runnable(){

            @Override
            public void run() {
                LineGraphChart.this.chartsContainer.updateScreen(LineGraphChart.this.containerDisplayCell);
            }
        });
        this.forceFullRepaint = true;
        this.notifyLayoutListener(this.graphArea, this.allChartAreas);
    }

    @Override
    public ChartsContainerActionListener provideContainerListener() {
        if (this.asyncRenderingProgress.isShutDown()) {
            this.asyncRenderingProgress.restart();
        }
        return this.actionListener;
    }

    @Override
    public String getAccessibleControlName() {
        return I18n._s((String)"Line Chart");
    }

    @Override
    public String getAccessibleStateText() {
        StringBuilder result = new StringBuilder();
        if (this.x_axis_show) {
            result.append(this.x_axis.getAccessibleText());
            result.append(", ");
        }
        if (this.y_axis_show) {
            if (this.y_axisSec_show) {
                result.append(I18n._ss((String)"graph y-axis", (String)"primary")).append(", ");
            }
            result.append(this.y_axis.getAccessibleText());
            result.append(", ");
        }
        if (this.y_axisSec_show) {
            result.append(I18n._ss((String)"graph y-axis", (String)"secondary")).append(", ");
            result.append(this.y_axisSec.getAccessibleText());
            result.append(", ");
        }
        if (this.horizontalSelector.isEnabled() && this.horizontalSelector.isSelected()) {
            result.append(this.horizontalSelector.getAccessibleValueState(this.x_axis));
        } else if (!(this.rectangleSelector.isEnabled() && this.rectangleSelector.isSelected() || !this.value_bar.isEnabled())) {
            result.append(this.value_bar.getAccessibleValueState());
        }
        return result.toString();
    }

    @Override
    public void keyNext() {
        this.moveXOnly(-10, false);
    }

    @Override
    public void keyPrevious() {
        this.moveXOnly(10, false);
    }

    public String toString() {
        String title = this.containerDisplayCell == null ? null : this.containerDisplayCell.getTitle();
        return "LineGraphChart_" + this.instanceId + "(" + (title != null ? title : "<no title>") + ")";
    }

    private class AutoQuickViewController
    implements XYGraphAxisModelListener {
        double lastMin = Double.MIN_VALUE;
        double lastMax = Double.MAX_VALUE;
        boolean enabled = false;

        private AutoQuickViewController() {
        }

        @Override
        public void undoStackChanged(XYGraphAxesModel source) {
        }

        @Override
        public void adjustedYAxis(XYGraphAxesModel source) {
        }

        @Override
        public void adjustedXAxis(XYGraphAxesModel source) {
            this.updateQuickViewState(source);
        }

        @Override
        public void adjustedBothAxis(XYGraphAxesModel source) {
            this.updateQuickViewState(source);
        }

        public void init(boolean enable) {
            this.lastMin = Double.MIN_VALUE;
            this.lastMax = Double.MAX_VALUE;
            this.enabled = enable;
        }

        void updateQuickViewState(XYGraphAxesModel source) {
            if (LineGraphChart.this.container.isEmpty() || !this.enabled) {
                if (LineGraphChart.this.quickView.isEnabled()) {
                    LineGraphChart.this.enableQuickView(false);
                }
                return;
            }
            double sourceMin = source.getMinX();
            double sourceMax = source.getMaxX();
            if (sourceMin != this.lastMin || sourceMax != this.lastMax) {
                this.lastMin = sourceMin;
                this.lastMax = sourceMax;
                double min = Double.MAX_VALUE;
                double max = Double.MIN_VALUE;
                for (LineGraphDataSet set : LineGraphChart.this.container.getAllGraphs()) {
                    min = min > set.getMinX() ? set.getMinX() : min;
                    max = max < set.getMaxX() ? set.getMaxX() : max;
                }
                LineGraphChart.this.enableQuickView(min < sourceMin || max > sourceMax);
            }
        }
    }
}

