/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.LineGraphRenderer;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionToolTipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphValueBarListener;
import com.sap.jvm.profiling.ui.graph.XYGraphContainer;
import com.sap.jvm.profiling.ui.graph.axes.InvalidSelectionRange;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.progress.RenderingAsyncProgress;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import com.sap.jvm.tracing.Trace;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LineGraphContainer
extends XYGraphContainer<LineGraphDataSet> {
    private LineGraphRenderer graphRenderer;
    private XYGraphAxesModel axes_model;
    private HashSet<LineGraphSelectionListener> selection_listeners = new HashSet();
    private HashSet<LineGraphValueBarListener> valuebar_listeners = new HashSet();
    private LineGraphSelectionToolTipProvider provider;

    protected LineGraphContainer(Renderer renderer, XYGraphAxesModel axes_model) {
        super(renderer);
        this.axes_model = axes_model;
        this.graphRenderer = new LineGraphRenderer();
        this.addGraphContainerListener(this.graphRenderer);
    }

    protected LineGraphRenderer getGraphRenderer() {
        return this.graphRenderer;
    }

    protected boolean unDoZoomSelection() {
        return this.axes_model.unDo(this.renderer.getWidth(), this.renderer.getHeight());
    }

    protected boolean prepareGraphsForDrawing(XYGraphAxesModel model, Rectangle graphArea, RenderingAsyncProgress.Progress progress) {
        if (this.isEmpty()) {
            return false;
        }
        return this.graphRenderer.prepareGraphsForDrawing(model, this.getAllGraphs(), this.getSecondaryAxisFlags(), graphArea, progress);
    }

    protected Map<LineGraphDataSet, List<Point2D>> prepareGraphsForQuickView(XYGraphAxesModel model, RenderingAsyncProgress.Progress progress, int width, int height) {
        if (this.isEmpty()) {
            return null;
        }
        return this.graphRenderer.prepareGraphsForQuickView(model, this.getAllGraphs(), this.getSecondaryAxisFlags(), progress, width, height);
    }

    protected void addLineGraphSelectionListener(LineGraphSelectionListener listener) {
        this.selection_listeners.add(listener);
    }

    protected void removeLineGraphSelectionListener(LineGraphSelectionListener listener) {
        this.selection_listeners.remove(listener);
    }

    protected void notifyGraphSelected(LineGraphDataSet graph) {
        try {
            for (LineGraphSelectionListener l : this.selection_listeners) {
                l.graphSelected(graph);
            }
        }
        catch (Throwable th) {
            Trace.error((Throwable)th);
        }
    }

    protected void notifyValueSelected(LineGraphDataSet graph, List<Value2D> value) {
        try {
            for (LineGraphSelectionListener l : this.selection_listeners) {
                l.valueSelected(graph, value);
            }
        }
        catch (Throwable th) {
            Trace.error((Throwable)th);
        }
    }

    protected void notifyHorizontalRangeSelected(double min, double max, List<InvalidSelectionRange> ranges) {
        try {
            for (LineGraphSelectionListener l : this.selection_listeners) {
                l.horizontalRangeSelected(min, max, ranges);
            }
        }
        catch (Throwable th) {
            Trace.error((Throwable)th);
        }
    }

    protected void notifyHorizontalRangeSelectionChanged(double min, double max, List<InvalidSelectionRange> ranges) {
        try {
            for (LineGraphSelectionListener l : this.selection_listeners) {
                l.horizontalRangeSelectionChanged(min, max, ranges);
            }
        }
        catch (Throwable th) {
            Trace.error((Throwable)th);
        }
    }

    protected void notifySelectionReset() {
        try {
            for (LineGraphSelectionListener l : this.selection_listeners) {
                l.selectionReset();
            }
        }
        catch (Throwable th) {
            Trace.error((Throwable)th);
        }
    }

    protected void notifySelectionClickedOn() {
        try {
            for (LineGraphSelectionListener l : this.selection_listeners) {
                l.selectionClickedOn();
            }
        }
        catch (Throwable th) {
            Trace.error((Throwable)th);
        }
    }

    protected void notifyRectangleRangeSelected(double minX, double maxX, double minY, double maxY) {
        try {
            for (LineGraphSelectionListener l : this.selection_listeners) {
                l.rectangleRangeSelected(minX, maxX, minY, maxY);
            }
        }
        catch (Throwable th) {
            Trace.error((Throwable)th);
        }
    }

    protected void notifyRectangleRangeSelectionChanged(double minX, double maxX, double minY, double maxY) {
        try {
            for (LineGraphSelectionListener l : this.selection_listeners) {
                l.rectangleRangeSelectionChanged(minX, maxX, minX, maxY);
            }
        }
        catch (Throwable th) {
            Trace.error((Throwable)th);
        }
    }

    public void addValueBarListener(LineGraphValueBarListener listener) {
        this.valuebar_listeners.add(listener);
    }

    public void removeBarListener(LineGraphValueBarListener listener) {
        this.valuebar_listeners.remove(listener);
    }

    protected void notifyValueBarListeners(int width, int pos, boolean positionSet) {
        if (!this.valuebar_listeners.isEmpty()) {
            for (LineGraphValueBarListener l : this.valuebar_listeners) {
                l.positionChanged(this.axes_model.getXValue(width, pos), positionSet);
            }
        }
    }

    protected void notifyValueBarClosed() {
        if (!this.valuebar_listeners.isEmpty()) {
            for (LineGraphValueBarListener l : this.valuebar_listeners) {
                l.valueBarClosed();
            }
        }
    }

    protected void addLineGraphSelectionToolTipProvider(LineGraphSelectionToolTipProvider newProvider) {
        this.provider = newProvider;
    }

    protected String provideSelectionToolTip(LineGraphDataSet graph, List<Value2D> values) {
        String caption;
        if (this.provider != null && !values.isEmpty() && (caption = this.provider.provideSelectedValueToolTip(graph, values)) != null) {
            return caption;
        }
        StringBuffer text = new StringBuffer();
        for (Value2D val : values) {
            text.append("[" + val.x + "/" + val.y + "]\n");
        }
        return text.toString();
    }

    protected String provideHorizontalSelectionText(double min, double max) {
        if (this.provider != null) {
            return this.provider.provideHorizontalSelectionText(min, max);
        }
        return String.valueOf(min) + '/' + max;
    }
}

