/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.LineGraphContainer;
import com.sap.jvm.profiling.ui.graph.axes.InvalidSelectionRange;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxis;
import com.sap.jvm.profiling.ui.graph.axes.RasterAnchorsList;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class LineGraphHorizontalSelector {
    private boolean enabled;
    private Rectangle graphArea;
    private XYGraphAxesModel axesModel;
    private LineGraphContainer container;
    private int startPos;
    private double min;
    private double max;
    private double raster = -1.0;
    private RasterAnchorsList selectionAnchors = null;
    private List<InvalidSelectionRange> invalidRanges = new ArrayList<InvalidSelectionRange>();
    private List<InvalidSelectionRange> lastDrawnRanges;

    public LineGraphHorizontalSelector(Rectangle graphArea, XYGraphAxesModel axesModel, LineGraphContainer container) {
        this.graphArea = graphArea;
        this.axesModel = axesModel;
        this.container = container;
    }

    public void enable(boolean enable) {
        this.enabled = enable;
    }

    public void enableRasterSelection(double rasterPeriod) {
        if (rasterPeriod <= 0.0) {
            throw new IllegalArgumentException("The selection raster could not be a negative value.");
        }
        this.selectionAnchors = null;
        this.raster = rasterPeriod;
    }

    public void enableRasterSelection(RasterAnchorsList anchors) {
        this.disableRasterSelection();
        if (anchors != null) {
            this.selectionAnchors = anchors;
        }
    }

    public void disableRasterSelection() {
        this.raster = -1.0;
        this.selectionAnchors = null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSelected() {
        return this.enabled && this.min != this.max;
    }

    public boolean resetSelection() {
        if (this.isSelected()) {
            this.max = 0.0;
            this.min = 0.0;
            return true;
        }
        return false;
    }

    public boolean isHovered(int pos) {
        if (this.isSelected()) {
            int posMin = this.axesModel.getXPosition(this.graphArea.width, this.min);
            int posMax = this.axesModel.getXPosition(this.graphArea.width, this.max);
            return pos > posMin && pos < posMax;
        }
        return false;
    }

    public boolean isBorderHovered(int pos) {
        if (this.isSelected()) {
            int posMin = this.axesModel.getXPosition(this.graphArea.width, this.min);
            int posMax = this.axesModel.getXPosition(this.graphArea.width, this.max);
            return Math.abs(pos - posMin) < 3 || Math.abs(pos - posMax) < 3;
        }
        return false;
    }

    public boolean isMinBorderHovered(int pos) {
        if (this.isSelected()) {
            int posMin = this.axesModel.getXPosition(this.graphArea.width, this.min);
            return Math.abs(pos - posMin) < 3;
        }
        return false;
    }

    public boolean isMaxBorderHovered(int pos) {
        if (this.isSelected()) {
            int posMax = this.axesModel.getXPosition(this.graphArea.width, this.max);
            return Math.abs(pos - posMax) < 3;
        }
        return false;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public List<InvalidSelectionRange> getSelectedInvalidRanges() {
        return this.findInvalidRanges(this.min, this.max);
    }

    public boolean zoom() {
        if (this.isSelected()) {
            this.axesModel.markUndo();
            this.axesModel.adjustXAxis(this.graphArea.width, this.min, this.max);
            this.resetSelection();
            return true;
        }
        return false;
    }

    public boolean select(double minValue, double maxValue) {
        if (this.enabled) {
            this.min = minValue;
            this.max = maxValue;
            return true;
        }
        return false;
    }

    public void startSelection(int pos) {
        this.startPos = pos;
        if (this.isSelected()) {
            this.min = this.axesModel.getXValue(this.graphArea.width, this.startPos);
        } else {
            this.max = this.min = this.axesModel.getXValue(this.graphArea.width, this.startPos);
        }
    }

    public void setMinAsStart() {
        this.startPos = this.axesModel.getXPosition(this.graphArea.width, this.min);
    }

    public void setMaxAsStart() {
        this.startPos = this.axesModel.getXPosition(this.graphArea.width, this.max);
    }

    public boolean select(int selectedPos) {
        if (this.enabled && Math.abs(selectedPos - this.startPos) > 2) {
            int posMax = selectedPos;
            if (posMax < 2) {
                posMax = 2;
            } else if (posMax > this.graphArea.width) {
                posMax = this.graphArea.width - 1;
            }
            if (posMax < this.startPos) {
                int posMin = posMax;
                posMax = this.startPos;
                this.min = this.axesModel.getXValue(this.graphArea.width, posMin);
                this.max = this.axesModel.getXValue(this.graphArea.width, posMax);
            } else {
                int posMin = this.startPos;
                this.max = this.axesModel.getXValue(this.graphArea.width, posMax);
            }
            return true;
        }
        return false;
    }

    public boolean adaptSelectionToRaster() {
        if (this.raster > 0.0) {
            this.min = this.min % this.raster == 0.0 ? this.min : this.min - this.min % this.raster;
            this.max = this.max % this.raster == 0.0 ? this.max : this.max + this.raster - this.max % this.raster;
            return true;
        }
        if (this.selectionAnchors != null) {
            this.min = this.selectionAnchors.getValueAt(this.find(this.selectionAnchors, this.min, true));
            this.max = this.selectionAnchors.getValueAt(this.find(this.selectionAnchors, this.max, false));
            return true;
        }
        return false;
    }

    private long find(RasterAnchorsList list, double val, boolean nextLow) {
        long result;
        long low = 0L;
        long high = list.getLength() - 1L;
        while (low <= high) {
            long mid = low + high >> 1;
            double midVal = list.getValueAt(mid);
            double cmp = midVal - val;
            if (cmp < 0.0) {
                low = mid + 1L;
                continue;
            }
            if (cmp > 0.0) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        long l = result = nextLow ? high : low;
        if (result < 0L) {
            return 0L;
        }
        if (result > list.getLength() - 1L) {
            return list.getLength() - 1L;
        }
        return result;
    }

    public boolean drawSelection(Renderer renderer, boolean valueBarAvailable) {
        if (this.isSelected()) {
            int posMin = this.axesModel.getXPosition(renderer.getWidth(), this.min);
            int posMax = this.axesModel.getXPosition(renderer.getWidth(), this.max);
            int width = posMax - posMin;
            if (valueBarAvailable) {
                int yCaption = renderer.getHeight() + this.getCaptionHeight(renderer);
                renderer.setDefaultColors();
                renderer.setAlpha(200);
                renderer.fillRectangle(posMin, yCaption, width, this.getCaptionHeight(renderer));
                renderer.setAlpha(255);
                renderer.drawLine(posMin, yCaption - 4, posMin, yCaption - this.getCaptionHeight(renderer) + 4);
                renderer.drawLine(posMax, yCaption - 4, posMax, yCaption - this.getCaptionHeight(renderer) + 4);
                renderer.drawLine(posMin, yCaption - this.getCaptionHeight(renderer) / 2, posMax, yCaption - this.getCaptionHeight(renderer) / 2);
                String caption = this.container.provideHorizontalSelectionText(this.min, this.max);
                int str_height = renderer.getFontHeight() + 4;
                int str_width = renderer.getStringWidth(caption) + 10;
                if (width > str_width) {
                    int pMin = posMin;
                    int pMax = posMax;
                    if (pMin < 0) {
                        pMin = 0;
                    }
                    if (pMax > renderer.getWidth()) {
                        pMax = renderer.getWidth();
                    }
                    int w = pMax - pMin;
                    int offset = pMin + 2;
                    if (w > str_width) {
                        offset = pMin + w / 2 - str_width / 2;
                    } else if (pMax < renderer.getWidth()) {
                        offset = pMax - str_width - 2;
                    }
                    renderer.fillRectangle(offset, yCaption, str_width, str_height);
                    renderer.drawString(caption, offset + 5, yCaption - 2);
                }
            }
            renderer.setAlpha(100);
            renderer.setFillColor(Color.LIGHT_GRAY);
            renderer.fillRectangle(posMin, renderer.getHeight(), width, renderer.getHeight() - 1);
            renderer.setAlpha(255);
            this.lastDrawnRanges = this.drawInvalidRanges(renderer);
            renderer.setForeground(Color.GRAY);
            renderer.setLineWidth(1);
            renderer.setLineStyle(Renderer.LineType.LINE_DOT);
            renderer.drawLine(posMin, renderer.getHeight(), posMin, 1);
            renderer.drawLine(posMax, renderer.getHeight(), posMax, 1);
            renderer.setDefaultColors();
            if (valueBarAvailable) {
                renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
                renderer.drawLine(posMin, renderer.getHeight(), posMin, renderer.getHeight() - 10);
                renderer.drawLine(posMax, renderer.getHeight(), posMax, renderer.getHeight() - 10);
            } else {
                renderer.drawLine(posMin, renderer.getHeight(), posMax, renderer.getHeight());
                renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
                int w = posMax - posMin;
                w = w > 10 ? 10 : w;
                renderer.drawLine(posMin, renderer.getHeight(), posMin + w, renderer.getHeight());
                renderer.drawLine(posMin, renderer.getHeight(), posMin, renderer.getHeight() - 10);
                renderer.drawLine(posMax, renderer.getHeight(), posMax - w, renderer.getHeight());
                renderer.drawLine(posMax, renderer.getHeight(), posMax, renderer.getHeight() - 10);
            }
            renderer.drawLine(posMin, 0, posMin, 10);
            renderer.drawLine(posMax, 0, posMax, 10);
            return true;
        }
        this.lastDrawnRanges = null;
        return false;
    }

    public List<InvalidSelectionRange> getLastDrawnInvalidRanges() {
        return this.lastDrawnRanges;
    }

    private List<InvalidSelectionRange> drawInvalidRanges(Renderer renderer) {
        List<InvalidSelectionRange> ranges = this.findInvalidRanges(this.min, this.max);
        if (ranges != null) {
            renderer.setForeground(Color.RED);
            renderer.setFillColor(Color.LIGHT_RED);
            Rectangle paint = renderer.getPainArea();
            Rectangle range = paint.clone();
            for (InvalidSelectionRange r : ranges) {
                int rangeMinPos = this.axesModel.getXPosition(paint.width, r.min);
                rangeMinPos = rangeMinPos < 0 ? 0 : rangeMinPos;
                int rangeWidth = this.axesModel.getXPosition(paint.width, r.max) - rangeMinPos;
                if (rangeWidth == 0) {
                    if (rangeMinPos == 0) continue;
                    rangeWidth = 1;
                }
                range.update(paint.x + rangeMinPos, paint.height + paint.y - paint.height, rangeWidth, paint.height);
                renderer.setPaintArea(range);
                if (rangeWidth > 2) {
                    int lineWidth;
                    renderer.setAlpha(100);
                    renderer.setForeground(Color.RED);
                    renderer.setFillColor(Color.LIGHT_RED);
                    renderer.fillRectangle(0, renderer.getHeight(), renderer.getWidth(), renderer.getHeight());
                    renderer.drawRectangle(0, renderer.getHeight() - 1, renderer.getWidth() - 1, renderer.getHeight() - 2);
                    int count = (range.height > range.width ? range.height : range.width) / 5;
                    for (int i = 0; i < count; ++i) {
                        renderer.drawLine(i * 10, 0, 0, i * 10);
                    }
                    if (r.getDescription() == null) continue;
                    renderer.setFillColor(Color.RED);
                    ArrayList<String> lines = new ArrayList<String>();
                    String text = r.getDescription();
                    int offset = 0;
                    int txtWidth = 0;
                    int txtHight = 0;
                    while ((offset = text.indexOf(10)) > 0) {
                        String line = text.substring(0, offset).trim();
                        lineWidth = renderer.getStringWidth(line);
                        txtWidth = lineWidth > txtWidth ? lineWidth : txtWidth;
                        txtHight += renderer.getFontHeight();
                        lines.add(line);
                        text = text.substring(offset).trim();
                    }
                    lines.add(text);
                    lineWidth = renderer.getStringWidth(text);
                    txtWidth = lineWidth > txtWidth ? lineWidth : txtWidth;
                    txtHight += renderer.getFontHeight();
                    if (txtWidth >= renderer.getWidth()) continue;
                    int x = renderer.getWidth() / 2 - txtWidth / 2;
                    int y = renderer.getHeight() / 2 + txtHight / 2;
                    renderer.setAlpha(120);
                    renderer.setForeground(Color.RED);
                    renderer.fillRectangle(x - 2, y - 1, txtWidth + 4, txtHight);
                    renderer.setAlpha(255);
                    renderer.drawRectangle(x - 2, y - 1, txtWidth + 4, txtHight);
                    renderer.setForeground(Color.WHITE);
                    for (String l : lines) {
                        renderer.drawString(l, x, y);
                        y -= renderer.getFontHeight();
                    }
                    continue;
                }
                if (renderer.getWidth() == 1) {
                    renderer.drawLine(0, 0, 0, renderer.getHeight());
                    continue;
                }
                renderer.drawRectangle(0, renderer.getHeight() - 1, renderer.getWidth() - 1, renderer.getHeight() - 2);
            }
            renderer.setPaintArea(paint);
            renderer.setAlpha(255);
        }
        return ranges;
    }

    private List<InvalidSelectionRange> findInvalidRanges(double selMin, double selMax) {
        if (this.invalidRanges.isEmpty()) {
            return null;
        }
        ArrayList<InvalidSelectionRange> ranges = new ArrayList<InvalidSelectionRange>();
        for (InvalidSelectionRange range : this.invalidRanges) {
            if (range.max < selMin) continue;
            if (range.min < selMin) {
                if (range.max >= selMax) {
                    ranges.add(new InvalidSelectionRange(selMin, selMax, range.getDescription()));
                    return ranges;
                }
                if (!(range.max > selMin)) continue;
                ranges.add(new InvalidSelectionRange(selMin, range.max, range.getDescription()));
                continue;
            }
            if (!(range.min < selMax)) break;
            if (range.max <= selMax) {
                ranges.add(range);
                continue;
            }
            ranges.add(new InvalidSelectionRange(range.min, selMax, range.getDescription()));
        }
        return ranges.isEmpty() ? null : ranges;
    }

    public int getCaptionHeight(Renderer renderer) {
        return this.enabled ? renderer.getFontHeight() + 4 : 0;
    }

    public void addInvalidSelectionRange(InvalidSelectionRange range) {
        if (this.invalidRanges.indexOf(range) > -1) {
            return;
        }
        for (InvalidSelectionRange r : this.invalidRanges) {
            if (range.max <= r.min || range.min >= r.max) continue;
            throw new IllegalArgumentException("Range overlapping!!!");
        }
        this.invalidRanges.add(range);
        Collections.sort(this.invalidRanges, new Comparator<InvalidSelectionRange>(){

            @Override
            public int compare(InvalidSelectionRange o1, InvalidSelectionRange o2) {
                double diff = o1.min - o2.min;
                if (diff == 0.0) {
                    return 0;
                }
                return diff > 0.0 ? 1 : -1;
            }
        });
    }

    public void removeInvalidSelectionRange(InvalidSelectionRange range) {
        this.invalidRanges.remove(range);
    }

    public void removeAllInvalidRanges() {
        this.invalidRanges.clear();
    }

    public String getAccessibleValueState(LineGraphAxis xAxis) {
        StringBuilder result = new StringBuilder("horizontal selection ");
        if (xAxis != null) {
            result.append(", from ");
            result.append(xAxis.getAccessibeValueText(this.min));
            result.append(", to, ");
            result.append(xAxis.getAccessibeValueText(this.max));
        } else {
            result.append(", from ");
            result.append(this.min);
            result.append(", to, ");
            result.append(this.max);
        }
        return result.toString();
    }
}

