/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.LineGraphMoveAdapter;
import com.sap.jvm.profiling.ui.graph.axes.GraphAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;

public final class LineGraphMoveController {
    private boolean enabledX;
    private boolean enabledY;
    private Rectangle graphArea;
    private XYGraphAxesModel axesModel;
    private int startX;
    private int startY;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private LineGraphMoveAdapter adapter;

    public LineGraphMoveController(Rectangle graphArea, XYGraphAxesModel axesModel) {
        this.graphArea = graphArea;
        this.axesModel = axesModel;
    }

    public void setMoveAdapter(LineGraphMoveAdapter adapter) {
        this.adapter = adapter;
    }

    public void enable(boolean enable) {
        this.enabledX = this.enabledY = enable;
    }

    public boolean isEnabled() {
        return this.enabledX || this.enabledY;
    }

    public void enableHorizontal(boolean enable) {
        this.enabledX = enable;
    }

    public void enableVertical(boolean enable) {
        this.enabledY = enable;
    }

    public boolean isHorizontalEnabled() {
        return this.enabledX;
    }

    public boolean isVerticalEnabled() {
        return this.enabledY;
    }

    public void setStartPosition(int x, int y) {
        this.startX = x;
        this.startY = y;
        this.minX = this.axesModel.getMinX();
        this.maxX = this.axesModel.getMaxX();
        this.minY = this.axesModel.getMinY();
        this.maxY = this.axesModel.getMaxY();
    }

    public boolean move(int x, int y) {
        double delta;
        boolean hasMoved = false;
        if (this.enabledX) {
            delta = this.axesModel.getXValue(this.graphArea.width, x) - this.axesModel.getXValue(this.graphArea.width, this.startX);
            if (this.adapter != null) {
                delta = -1.0 * this.adapter.moveHorizontal(this.minX, this.maxX, delta * -1.0);
            }
            if (delta != 0.0) {
                this.axesModel.adjustXAxis(this.graphArea.width, this.minX - delta, this.maxX - delta);
                hasMoved = true;
            }
        }
        if (this.enabledY) {
            delta = this.axesModel.getYValue(this.graphArea.width, y) - this.axesModel.getYValue(this.graphArea.width, this.startY);
            if (this.adapter != null) {
                delta = -1.0 * this.adapter.moveVertical(this.minY, this.maxY, -1.0 * delta);
            }
            if (delta != 0.0) {
                this.axesModel.adjustYAxis(this.graphArea.height, this.minY - delta, this.maxY - delta);
                GraphAxisModel axis = this.axesModel.getYAxisSecondary();
                delta = delta / this.axesModel.getYRange() * axis.getRange();
                axis.adjustAxis(axis.getMin() - delta, axis.getMax() - delta, this.graphArea.height);
                hasMoved = true;
            }
        }
        return hasMoved;
    }
}

