/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.LineGraphContainer;
import com.sap.jvm.profiling.ui.graph.LineGraphMoveAdapter;
import com.sap.jvm.profiling.ui.graph.LineGraphRenderer;
import com.sap.jvm.profiling.ui.graph.axes.GraphAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.progress.RenderingAsyncProgress;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class LineGraphQuickView {
    private static final Color QUICK_VIEW_WINDOW = new Color(110, 130, 170);
    private Renderer renderer;
    private XYGraphAxesModel axes_model;
    private XYGraphAxesModel quick_axes_model = new XYGraphAxesModel();
    private LineGraphContainer container;
    private boolean hSelection = false;
    private boolean enabled = false;
    private Rectangle quickArea;
    private Rectangle graphArea;
    private Rectangle viewWindow = new Rectangle();
    private LineGraphMoveAdapter adapter;
    private int barWidth;
    private int barHeight;
    private Timer updateTimer = new Timer("QuickView Timer", true);
    private UpdateTask updateTask;
    private Object quickContentLock = new Object();
    private Map<LineGraphDataSet, List<Point2D>> quickContent;
    private Map<LineGraphDataSet, List<Point2D>> emptyContent = new HashMap<LineGraphDataSet, List<Point2D>>();
    private boolean performRepaint;
    private boolean updateRequested;

    public LineGraphQuickView(Renderer renderer, LineGraphContainer container, XYGraphAxesModel axes_model, Rectangle quickArea, Rectangle graphArea) {
        this.renderer = renderer;
        this.container = container;
        this.axes_model = axes_model;
        this.quickArea = quickArea;
        this.graphArea = graphArea;
    }

    protected void enable(boolean enable) {
        this.enabled = enable;
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected void setMoveAdapter(LineGraphMoveAdapter adapter) {
        this.adapter = adapter;
    }

    protected void setHorizontalSelectionOnly(boolean enable) {
        this.hSelection = enable;
    }

    protected void updateView(Runnable updAction) {
        if (this.enabled) {
            boolean paintAreaChanged = this.barWidth != this.quickArea.width || this.barHeight != this.quickArea.height;
            boolean axisRangeChanged = this.adjustAxisXRange();
            if (paintAreaChanged || axisRangeChanged) {
                if (this.updateTask != null) {
                    this.updateTask.cancel();
                    this.updateTask = null;
                }
                this.updateTask = new UpdateTask(updAction);
                this.updateTimer.schedule((TimerTask)this.updateTask, 0L);
                this.barHeight = this.quickArea.height;
                this.barWidth = this.quickArea.width;
            }
        }
    }

    protected int getViewHeight(int availableHeight) {
        if (!this.enabled) {
            return 0;
        }
        int prefHeight = Math.min((int)Math.round((double)availableHeight * 0.15), 50);
        if (prefHeight < 6) {
            return 0;
        }
        return Math.max(prefHeight, 8);
    }

    protected boolean isHovered(int x, int y) {
        if (this.enabled) {
            return this.quickArea.isIn(x, y);
        }
        return false;
    }

    protected void mouseOn(int x, int y, boolean adjust) {
        if (this.enabled) {
            int transX = this.quickArea.getXinRec(x);
            int cappedX = Math.max(0, Math.min(transX, this.quickArea.width));
            double deltaX = this.quick_axes_model.getXValue(this.quickArea.width, cappedX) - this.quick_axes_model.getXValue(this.quickArea.width, this.viewWindow.center.x);
            if (this.adapter != null) {
                deltaX = this.adapter.moveHorizontal(this.axes_model.getMinX(), this.axes_model.getMaxX(), deltaX);
            }
            this.axes_model.adjustXAxis(this.quickArea.width, this.axes_model.getMinX() + deltaX, this.axes_model.getMaxX() + deltaX);
            if (!this.hSelection) {
                int transY = this.quickArea.getYinRec(y);
                int cappedY = Math.max(0, Math.min(transY, this.quickArea.height));
                double deltaY = this.quick_axes_model.getYValue(this.quickArea.height, cappedY) - this.quick_axes_model.getYValue(this.quickArea.height, this.viewWindow.center.y);
                if (this.adapter != null) {
                    deltaY = this.adapter.moveVertical(this.axes_model.getMinY(), this.axes_model.getMaxY(), deltaY);
                }
                this.axes_model.adjustYAxis(this.graphArea.height, this.axes_model.getMinY() + deltaY, this.axes_model.getMaxY() + deltaY);
                GraphAxisModel axis = this.axes_model.getYAxisSecondary();
                deltaY = deltaY / this.axes_model.getYRange() * axis.getRange();
                axis.adjustAxis(axis.getMin() + deltaY, axis.getMax() + deltaY, this.graphArea.height);
            }
            if (adjust) {
                this.axes_model.adjustAxisToReadableValues();
            }
        }
    }

    protected void drawView() {
        this.drawView(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawView(boolean waitForContent) {
        if (this.enabled && this.quickArea.height > 0) {
            this.updateViewWindow();
            this.renderer.setPaintArea(null);
            this.quickArea.drawShadow(this.renderer);
            this.quickArea.fill(this.renderer, Color.LIGHT_GRAY);
            this.renderer.setPaintArea(this.quickArea);
            if (!this.container.isEmpty()) {
                this.viewWindow.fill(this.renderer, this.renderer.getDefaultBackground());
            }
            Object object = this.quickContentLock;
            synchronized (object) {
                if (this.updateRequested) {
                    this.performRepaint = true;
                }
            }
            this.drawContent();
            if (!this.container.isEmpty()) {
                this.viewWindow.drawWithCenter(this.renderer, QUICK_VIEW_WINDOW);
            }
            this.renderer.setPaintArea(null);
            this.quickArea.draw(this.renderer, Color.GRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawContent() {
        Map<LineGraphDataSet, List<Point2D>> content = null;
        Iterator iterator = this.quickContentLock;
        synchronized (iterator) {
            if (this.quickContent != null) {
                content = this.quickContent;
            }
        }
        if (content != null) {
            this.renderer.setPaintArea(this.quickArea);
            for (LineGraphDataSet set : this.container.getAllGraphs()) {
                LineGraphRenderer.drawGraph(this.renderer, content.get(set), set.getGraphColor(), set.getDrawingStyle(), 2);
            }
            if (!this.hSelection) {
                GraphAxisModel yAxis = this.quick_axes_model.getYAxis();
                int posY = yAxis.getPosition(this.quickArea.height, yAxis.getMax());
                this.viewWindow.updatePosition(this.viewWindow.x, posY);
                this.viewWindow.update(this.viewWindow.width, posY - yAxis.getPosition(this.quickArea.height, yAxis.getMin()));
            }
        }
    }

    private void updateViewWindow() {
        int margin = this.quickArea.height < 20 ? 1 : 2;
        int posX1 = this.quick_axes_model.getXPosition(this.quickArea.width, this.axes_model.getMinX());
        int posX2 = this.quick_axes_model.getXPosition(this.quickArea.width, this.axes_model.getMaxX());
        int posY = this.quickArea.height - margin;
        int width = posX2 - posX1;
        int height = this.quickArea.height - 2 * margin;
        if (width < 10) {
            int border = (10 - width) / 2;
            width = (posX2 += border) - (posX1 -= border);
        }
        this.viewWindow.updatePosition(posX1, posY);
        this.viewWindow.update(width, height);
    }

    private boolean adjustAxisXRange() {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        boolean hasData = false;
        for (LineGraphDataSet data : this.container.getAllGraphs()) {
            if (data.isEmpty()) continue;
            hasData = true;
            min = min > data.getFirstValue().x ? data.getFirstValue().x : min;
            max = max < data.getLastValue().x ? data.getLastValue().x : max;
        }
        if (!hasData) {
            min = 0.0;
            max = 1.0;
        }
        if (this.quick_axes_model.getMinX() != min || this.quick_axes_model.getMaxX() != max) {
            this.quick_axes_model.adjustXAxis(this.quickArea.width, min, max);
            return true;
        }
        return false;
    }

    private class UpdateTask
    extends TimerTask {
        Runnable updAct;
        private RenderingAsyncProgress.Progress quickProgress;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UpdateTask(Runnable updAct) {
            this.updAct = updAct;
            Object object = LineGraphQuickView.this.quickContentLock;
            synchronized (object) {
                LineGraphQuickView.this.quickContent = null;
                LineGraphQuickView.this.updateRequested = true;
            }
        }

        @Override
        public boolean cancel() {
            if (this.quickProgress != null) {
                this.quickProgress.cancel();
            }
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.quickProgress = new RenderingAsyncProgress.Progress();
            if (this.quickProgress.isCanceled()) {
                return;
            }
            boolean dataAvailable = false;
            double minX = Double.MAX_VALUE;
            double maxX = 0.0;
            for (LineGraphDataSet graph : LineGraphQuickView.this.container.getAllGraphs()) {
                if (!graph.isEmpty()) {
                    dataAvailable = true;
                    Value2D firstValue = graph.getFirstValue();
                    Value2D lastValue = graph.getLastValue();
                    if (firstValue != null && minX > firstValue.x) {
                        minX = firstValue.x;
                    }
                    if (lastValue != null && maxX < lastValue.x) {
                        maxX = lastValue.x;
                    }
                }
                if (!this.quickProgress.isCanceled()) continue;
                return;
            }
            if (dataAvailable) {
                double space = LineGraphQuickView.this.quick_axes_model.getXRange() / 100.0;
                LineGraphQuickView.this.quick_axes_model.adjustXAxis(((LineGraphQuickView)LineGraphQuickView.this).quickArea.width, minX - space, maxX + space);
                space = LineGraphQuickView.this.quick_axes_model.getYRange() / 10.0;
                LineGraphQuickView.this.quick_axes_model.adjustYAxis(((LineGraphQuickView)LineGraphQuickView.this).quickArea.height, LineGraphQuickView.this.axes_model.getMinY() - space, LineGraphQuickView.this.axes_model.getMaxY() + space);
                space = LineGraphQuickView.this.quick_axes_model.getSecondaryYRange() / 10.0;
                LineGraphQuickView.this.quick_axes_model.adjustSecondaryYAxis(((LineGraphQuickView)LineGraphQuickView.this).quickArea.height, LineGraphQuickView.this.axes_model.getSecondaryMinY() - space, LineGraphQuickView.this.axes_model.getSecondaryMaxY() + space);
            }
            if (this.quickProgress.isCanceled()) {
                return;
            }
            Map content = LineGraphQuickView.this.container.prepareGraphsForQuickView(LineGraphQuickView.this.quick_axes_model, this.quickProgress, ((LineGraphQuickView)LineGraphQuickView.this).quickArea.width, ((LineGraphQuickView)LineGraphQuickView.this).quickArea.height);
            Object object = LineGraphQuickView.this.quickContentLock;
            synchronized (object) {
                if (this.quickProgress.isCanceled()) {
                    return;
                }
                LineGraphQuickView.this.quickContent = content == null ? LineGraphQuickView.this.emptyContent : content;
                LineGraphQuickView.this.updateRequested = false;
                if (LineGraphQuickView.this.performRepaint) {
                    LineGraphQuickView.this.renderer.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            LineGraphQuickView.this.drawContent();
                            UpdateTask.this.updAct.run();
                        }
                    });
                    LineGraphQuickView.this.performRepaint = false;
                }
            }
            if (this.quickProgress.isCanceled()) {
                return;
            }
            this.quickProgress.endTask();
        }
    }
}

