/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;

public final class LineGraphRectangleSelector {
    private boolean enabled;
    private Renderer renderer;
    private XYGraphAxesModel axesModel;
    private double startXValue;
    private double startYValue;
    private double startYValueSec;
    private double endXValue;
    private double endYValue;
    private double endYValueSec;
    private double raster = -1.0;

    public LineGraphRectangleSelector(Renderer renderer, XYGraphAxesModel axesModel) {
        this.renderer = renderer;
        this.axesModel = axesModel;
    }

    public double getStartX() {
        return this.startXValue;
    }

    public double getStartY() {
        return this.startYValue;
    }

    public double getStartYsecondary() {
        return this.startYValueSec;
    }

    public double getEndX() {
        return this.endXValue;
    }

    public double getEndY() {
        return this.endYValue;
    }

    public double getEndYsecondary() {
        return this.endYValueSec;
    }

    public void enable(boolean enable) {
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enableRasterSelection(double rasterPeriod) {
        if (rasterPeriod <= 0.0) {
            throw new IllegalArgumentException("The selection raster could not be a negative value.");
        }
        this.raster = rasterPeriod;
    }

    public void disableRasterSelection() {
        this.raster = -1.0;
    }

    public boolean isSelected() {
        return this.enabled && (this.startXValue != this.endXValue || this.startYValue != this.endYValue);
    }

    public boolean resetSelection() {
        if (this.isSelected()) {
            this.endXValue = 0.0;
            this.startXValue = 0.0;
            this.endYValue = 0.0;
            this.startYValue = 0.0;
            this.endYValueSec = 0.0;
            this.startYValueSec = 0.0;
            return true;
        }
        return false;
    }

    public void startSelection(int x, int y) {
        this.startXValue = this.axesModel.getXValue(this.renderer.getWidth(), x);
        this.startYValue = this.axesModel.getYAxis().getValue(this.renderer.getHeight(), y);
        this.startYValueSec = this.axesModel.getYAxisSecondary().getValue(this.renderer.getHeight(), y);
    }

    public boolean select(int x, int y) {
        int startXPos = this.axesModel.getXAxis().getPosition(this.renderer.getWidth(), this.startXValue);
        int startYPos = this.axesModel.getYAxis().getPosition(this.renderer.getHeight(), this.startYValue);
        if (Math.abs(x - startXPos) > 3 && Math.abs(y - startYPos) > 3) {
            this.endXValue = this.axesModel.getXAxis().getValue(this.renderer.getWidth(), x);
            this.endYValue = this.axesModel.getYAxis().getValue(this.renderer.getHeight(), y);
            this.endYValueSec = this.axesModel.getYAxisSecondary().getValue(this.renderer.getHeight(), y);
            return true;
        }
        return false;
    }

    public boolean adaptSelectionToRaster() {
        if (this.raster > 0.0) {
            this.startXValue = this.startXValue % this.raster == 0.0 ? this.startXValue : this.startXValue - this.startXValue % this.raster;
            this.endXValue = this.endXValue % this.raster == 0.0 ? this.endXValue : this.endXValue + this.raster - this.endXValue % this.raster;
            this.startYValue = this.startYValue % this.raster == 0.0 ? this.startYValue : this.startYValue - this.startYValue % this.raster + this.raster;
            this.endYValue = this.endYValue % this.raster == 0.0 ? this.endYValue : this.endYValue - this.endYValue % this.raster;
            this.startYValueSec = this.startYValueSec % this.raster == 0.0 ? this.startYValueSec : this.startYValueSec - this.startYValueSec % this.raster + this.raster;
            this.endYValueSec = this.endYValueSec % this.raster == 0.0 ? this.endYValueSec : this.endYValueSec - this.endYValueSec % this.raster;
            return true;
        }
        return false;
    }

    public boolean isHovered(int posX, int posY) {
        if (this.isSelected()) {
            int posX1 = this.axesModel.getXPosition(this.renderer.getWidth(), this.startXValue);
            int posX2 = this.axesModel.getXPosition(this.renderer.getWidth(), this.endXValue);
            int posY1 = this.axesModel.getYPosition(this.renderer.getHeight(), this.startYValue, false);
            int posY2 = this.axesModel.getYPosition(this.renderer.getHeight(), this.endYValue, false);
            if (posX1 < posX2 ? posX < posX1 || posX > posX2 : posX < posX2 || posX > posX1) {
                return false;
            }
            return !(posY1 < posY2 ? posY < posY1 || posY > posY2 : posY < posY2 || posY > posY1);
        }
        return false;
    }

    public boolean drawSelection() {
        if (this.isSelected()) {
            int height;
            int posY;
            int width;
            int posX;
            if (this.startXValue < this.endXValue) {
                posX = this.axesModel.getXPosition(this.renderer.getWidth(), this.startXValue);
                width = this.axesModel.getXPosition(this.renderer.getWidth(), this.endXValue) - posX;
            } else {
                posX = this.axesModel.getXPosition(this.renderer.getWidth(), this.endXValue);
                width = this.axesModel.getXPosition(this.renderer.getWidth(), this.startXValue) - posX;
            }
            if (this.startYValue < this.endYValue) {
                posY = this.axesModel.getYPosition(this.renderer.getHeight(), this.endYValue, false);
                height = posY - this.axesModel.getYPosition(this.renderer.getHeight(), this.startYValue, false);
            } else {
                posY = this.axesModel.getYPosition(this.renderer.getHeight(), this.startYValue, false);
                height = posY - this.axesModel.getYPosition(this.renderer.getHeight(), this.endYValue, false);
            }
            this.renderer.setFillColor(Color.LIGHT_GRAY);
            this.renderer.setAlpha(150);
            this.renderer.fillRectangle(posX, posY, width, height);
            this.renderer.setForeground(Color.GRAY);
            this.renderer.setAlpha(255);
            this.renderer.setLineStyle(Renderer.LineType.LINE_DOT);
            this.renderer.drawRectangle(posX, posY, width, height);
            this.renderer.setDefaultColors();
            this.renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
            return true;
        }
        return false;
    }

    protected boolean zoom() {
        if (this.isSelected()) {
            this.axesModel.markUndo();
            this.axesModel.adjustXAxis(this.renderer.getWidth(), this.startXValue < this.endXValue ? this.startXValue : this.endXValue, this.startXValue > this.endXValue ? this.startXValue : this.endXValue);
            this.axesModel.getYAxisSecondary().adjustAxis(this.startYValueSec < this.endYValueSec ? this.startYValueSec : this.endYValueSec, this.startYValueSec > this.endYValueSec ? this.startYValueSec : this.endYValueSec, this.renderer.getHeight());
            this.axesModel.adjustYAxis(this.renderer.getHeight(), this.startYValue < this.endYValue ? this.startYValue : this.endYValue, this.startYValue > this.endYValue ? this.startYValue : this.endYValue);
            this.resetSelection();
            return true;
        }
        return false;
    }
}

