/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.XYGraphContainerListener;
import com.sap.jvm.profiling.ui.graph.XYGraphRenderer;
import com.sap.jvm.profiling.ui.graph.axes.GraphAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphVirtualDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.XYGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.geometry.Value2DExtended;
import com.sap.jvm.profiling.ui.graph.progress.RenderingAsyncProgress;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LineGraphRenderer
implements XYGraphRenderer<LineGraphDataSet>,
XYGraphContainerListener<LineGraphDataSet> {
    private final Map<LineGraphDataSet, RenderingContext> renContexts = new HashMap<LineGraphDataSet, RenderingContext>();
    private boolean notFinishedRescale;

    public List<Point2D> getPaintedGraphPolygon(LineGraphDataSet graph) {
        return this.renContexts.get(graph).drawnPolygon;
    }

    Point2D getVisibleEmphasizedValueAtLocation(LineGraphDataSet data, int x, int y) {
        if (this.renContexts.containsKey(data)) {
            for (Point2D point : this.renContexts.get(data).emphasizedPoints) {
                int f = 4;
                if (point.x - f > x) {
                    return null;
                }
                if (point.x + f < x || x < point.x - f || x > point.x + f || y < point.y - f || y > point.y + f) continue;
                return point;
            }
        }
        return null;
    }

    Set<Point2D> getEmphasizedPoints(LineGraphDataSet data, XYGraphAxesModel model, int width) {
        return this.renContexts.get(data).emphasizedPoints;
    }

    public void visualSetChaged() {
        for (Map.Entry<LineGraphDataSet, RenderingContext> e : this.renContexts.entrySet()) {
            if (e.getValue().drawnPolygon != null) {
                e.getValue().drawnPolygon.clear();
            }
            if (e.getValue().emphasizedPoints == null) continue;
            e.getValue().emphasizedPoints.clear();
        }
    }

    public boolean prepareGraphsForDrawing(XYGraphAxesModel model, List<LineGraphDataSet> graphs, List<Boolean> secondaryAxis, Rectangle graphArea, RenderingAsyncProgress.Progress progress) {
        if (progress.isCanceled()) {
            return false;
        }
        for (int i = 0; i < graphs.size(); ++i) {
            LineGraphDataSet data = graphs.get(i);
            boolean secondary = secondaryAxis.get(i);
            GraphAxisModel yAxis = secondary ? model.getYAxisSecondary() : model.getYAxis();
            GraphAxisModel xAxis = model.getXAxis();
            if (progress.isCanceled()) {
                return false;
            }
            boolean emphasized = data.getType() == XYGraphDataSet.GraphType.EMPHASIZED;
            RenderingContext renCtx = this.renContexts.get(data);
            if (renCtx == null) continue;
            if (emphasized) {
                renCtx.emphasizedPoints = new LinkedHashSet();
            }
            List<Point2D> values = null;
            values = data instanceof LineGraphVirtualDataSet ? this.calculateGraphPolygon((LineGraphVirtualDataSet)data, xAxis, yAxis, graphArea, progress, emphasized) : this.calculateGraphPolygonAVG(data, xAxis, yAxis, graphArea.width, graphArea.height, emphasized);
            if (progress.isCanceled()) {
                renCtx.stateRollBack();
                return false;
            }
            renCtx.drawnPolygon = values;
        }
        return true;
    }

    @Override
    public void drawGraph(LineGraphDataSet data, Renderer renderer, XYGraphAxesModel axes_model) {
        if (!data.isEmpty() && this.renContexts.containsKey(data)) {
            boolean emphasized = data.getType() == XYGraphDataSet.GraphType.EMPHASIZED;
            LineGraphDataSet.GraphStyle style = data.getDrawingStyle();
            List values = this.renContexts.get(data).drawnPolygon;
            int dataPointSize = 3;
            LineGraphRenderer.drawGraph(renderer, values, data.getGraphColor(), style, dataPointSize);
            if (emphasized) {
                if (style == LineGraphDataSet.GraphStyle.CONNECTED_POINTS || style == LineGraphDataSet.GraphStyle.CONNECTED_POINTS_DOTTED || style == LineGraphDataSet.GraphStyle.DATA_POINTS) {
                    ++dataPointSize;
                }
                LineGraphRenderer.drawValues(this.renContexts.get(data).emphasizedPoints, renderer, data.getValueColor(), dataPointSize);
            }
        }
    }

    private List<Point2D> calculateGraphPolygonAVG(LineGraphDataSet data, GraphAxisModel xAxis, GraphAxisModel yAxis, int width, int height, boolean emphasized) {
        RenderingContext rCtx = this.renContexts.get(data);
        ArrayList<Point2D> values = new ArrayList<Point2D>();
        if (data.isEmpty() || rCtx == null) {
            return values;
        }
        long idx = data.getIndexOfXValue(xAxis.getMin());
        if (idx == data.getSize() - 1L) {
            return values;
        }
        if (idx > 0L) {
            --idx;
        }
        Set emphPoints = rCtx.emphasizedPoints;
        Value2D first = data.getValueAt(idx);
        Point2D point = new Point2D(xAxis.getPosition(width, first.x), yAxis.getPosition(height, first.y));
        values.add(point);
        int count = 1;
        int acc = yAxis.getPosition(height, data.getValueAt((long)idx++).y);
        long toIdx = data.getIndexOfXValue(xAxis.getMax()) + 1L;
        for (Value2D val : data.getValues(idx, Math.min(data.getSize(), toIdx + 1L))) {
            int x = xAxis.getPosition(width, val.x);
            int y = yAxis.getPosition(height, val.y);
            if (x > point.x) {
                point = new Point2D(x, y);
                values.add(point);
                acc = y;
                count = 1;
            } else {
                point.y = Math.round((float)(acc += y) / (float)(++count));
            }
            if (!emphasized || !val.emphasized || !yAxis.isInRange(val.y)) continue;
            emphPoints.add(point);
        }
        return values;
    }

    private List<Point2D> calculateGraphPolygonMinMax(LineGraphDataSet data, GraphAxisModel xAxis, GraphAxisModel yAxis, int width, int height, boolean emphasized) {
        ArrayList<Point2D> values = new ArrayList<Point2D>();
        if (data.isEmpty() || !this.renContexts.containsKey(data)) {
            return values;
        }
        long idx = data.getIndexOfXValue(xAxis.getMin());
        if (idx == data.getSize() - 1L) {
            return values;
        }
        if (idx > 0L) {
            --idx;
        }
        Set emphPoints = this.renContexts.get(data).emphasizedPoints;
        Value2D first = data.getValueAt(idx);
        Point2D pointEntry = new Point2D(xAxis.getPosition(width, first.x), yAxis.getPosition(height, first.y));
        Point2D pointExit = null;
        Point2D pointMin = null;
        Point2D pointMax = null;
        values.add(pointEntry);
        int counter = 0;
        long toIdx = data.getIndexOfXValue(xAxis.getMax()) + 1L;
        for (Value2D val : data.getValues(idx, Math.min(data.getSize(), toIdx + 1L))) {
            int x = xAxis.getPosition(width, val.x);
            int y = yAxis.getPosition(height, val.y);
            if (emphasized && val.emphasized && yAxis.isInRange(val.y)) {
                Point2D pointEmph = new Point2D(x, y);
                emphPoints.add(pointEmph);
            }
            if (x > pointEntry.x) {
                pointEntry = new Point2D(x, y);
                values.add(pointEntry);
                counter = 0;
                continue;
            }
            if (counter == 0) {
                pointExit = new Point2D(x, y);
                values.add(pointExit);
            } else if (counter == 1) {
                pointMax = pointExit;
                pointExit = new Point2D(x, y);
                values.add(pointExit);
            } else if (counter == 2) {
                pointMin = pointExit;
                pointExit = new Point2D(x, y);
                values.add(pointExit);
                if (pointMax.y < pointMin.y) {
                    int tmpY = pointMax.y;
                    pointMax.y = pointMin.y;
                    pointMin.y = tmpY;
                }
            } else {
                int oldExitY = pointExit.y;
                pointExit.y = y;
                if (oldExitY < pointMin.y) {
                    pointMin.y = oldExitY;
                } else if (pointMax.y < oldExitY) {
                    pointMax.y = oldExitY;
                }
            }
            ++counter;
        }
        return values;
    }

    private List<Point2D> calculateGraphPolygon(LineGraphVirtualDataSet data, GraphAxisModel xAxis, GraphAxisModel yAxis, Rectangle graphArea, RenderingAsyncProgress.Progress progress, boolean emphasized) {
        RenderingContext rCtx = this.renContexts.get(data);
        int state = data.determineStateChange(xAxis, graphArea, rCtx);
        switch (state) {
            case 0: {
                return this.calculateGraphPolygonMinMax(data, xAxis, yAxis, graphArea.width, graphArea.height, emphasized);
            }
            case 1: 
            case 2: {
                data.rescaleVisibleSet(progress, xAxis, graphArea.width, rCtx);
                this.notFinishedRescale = progress.isCanceled();
                break;
            }
            case 3: 
            case 4: {
                data.moveVisibleSet(xAxis, graphArea.width, state == 3, rCtx);
                break;
            }
            case 5: {
                data.moveVisibleSet(xAxis, graphArea.width, false, rCtx);
                break;
            }
            default: {
                if (!this.notFinishedRescale) break;
                data.rescaleVisibleSet(progress, xAxis, graphArea.width, rCtx);
                this.notFinishedRescale = progress.isCanceled();
            }
        }
        if (progress.isCanceled()) {
            rCtx.stateRollBack();
            return null;
        }
        return this.calculateGraphPolygonALL(data, rCtx.getVisibleSet(), xAxis, yAxis, graphArea.width, graphArea.height, progress, emphasized);
    }

    private List<Point2D> calculateGraphPolygonALL(LineGraphVirtualDataSet data, List<Value2DExtended> values, GraphAxisModel xAxis, GraphAxisModel yAxis, int width, int height, RenderingAsyncProgress.Progress progress, boolean emphasized) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        if (!this.renContexts.containsKey(data)) {
            return points;
        }
        Set emphPoints = this.renContexts.get(data).emphasizedPoints;
        for (Value2DExtended val : values) {
            int x;
            if (progress != null && progress.isCanceled()) {
                return null;
            }
            if (val.entry == val.exit) {
                x = xAxis.getPosition(width, val.x);
                int y = yAxis.getPosition(height, val.y);
                if (emphasized && val.emphasized) {
                    Point2D p = new Point2D(x, y);
                    emphPoints.add(p);
                }
                points.add(new Point2D(x, y));
                continue;
            }
            x = xAxis.getPosition(width, val.x);
            int yEntry = yAxis.getPosition(height, val.entry);
            int yExit = yAxis.getPosition(height, val.exit);
            int yMin = yAxis.getPosition(height, val.min);
            int yMax = yAxis.getPosition(height, val.max);
            if (emphasized && val.emphasized) {
                Point2D p = new Point2D(x, yMax);
                emphPoints.add(p);
            }
            points.add(new Point2D(x, yEntry));
            points.add(new Point2D(x, yMax));
            points.add(new Point2D(x, yMin));
            points.add(new Point2D(x, yExit));
        }
        return points;
    }

    static void drawGraph(Renderer renderer, List<Point2D> values, Color color, LineGraphDataSet.GraphStyle graphStyle, int valuePointSize) {
        if (values != null) {
            boolean oldAntialias = renderer.isAntialiased();
            renderer.setAntialiased(true);
            renderer.setForeground(color);
            if (graphStyle == LineGraphDataSet.GraphStyle.LINES_FILLED) {
                renderer.setFillColor(color);
                renderer.setAlpha(50);
                int[] points = new int[8];
                for (int i = 0; i < values.size() - 1; ++i) {
                    Point2D p1 = values.get(i);
                    Point2D p2 = values.get(i + 1);
                    points[0] = p1.x;
                    points[1] = p1.y;
                    points[2] = p2.x;
                    points[3] = p2.y;
                    points[4] = p2.x;
                    points[5] = 0;
                    points[6] = p1.x;
                    points[7] = 0;
                    renderer.fillPolygon(points);
                }
                renderer.setAlpha(255);
            }
            if (graphStyle == LineGraphDataSet.GraphStyle.CONNECTED_POINTS || graphStyle == LineGraphDataSet.GraphStyle.CONNECTED_POINTS_DOTTED || graphStyle == LineGraphDataSet.GraphStyle.DATA_POINTS) {
                LineGraphRenderer.drawValues(new HashSet<Point2D>(values), renderer, color, valuePointSize);
            }
            if (graphStyle != LineGraphDataSet.GraphStyle.DATA_POINTS) {
                if (graphStyle == LineGraphDataSet.GraphStyle.LINES_DOTTED || graphStyle == LineGraphDataSet.GraphStyle.CONNECTED_POINTS_DOTTED) {
                    renderer.setLineStyle(Renderer.LineType.LINE_DOT);
                    renderer.drawPolyline(values);
                    renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
                } else {
                    renderer.drawPolyline(values);
                }
            }
            renderer.setAntialiased(oldAntialias);
        }
    }

    private static void drawValues(Set<Point2D> values, Renderer renderer, Color color, int size) {
        if (values != null && values.size() > 0) {
            Color fillColor = renderer.getFillColor();
            boolean antialias = renderer.isAntialiased();
            renderer.setFillColor(color);
            renderer.setAntialiased(true);
            for (Point2D val : values) {
                renderer.fillPolygon(new int[]{val.x - size, val.y, val.x, val.y + size, val.x + size, val.y, val.x, val.y - size});
            }
            renderer.setAntialiased(antialias);
            renderer.setFillColor(fillColor);
        }
    }

    @Override
    public void appendedGraph(LineGraphDataSet graph) {
        if (!this.renContexts.containsKey(graph)) {
            this.renContexts.put(graph, new RenderingContext());
        }
    }

    @Override
    public void removedAllGraphs(ArrayList<LineGraphDataSet> graphs) {
        for (LineGraphDataSet graph : graphs) {
            this.renContexts.remove(graph);
        }
    }

    @Override
    public void removedGraph(LineGraphDataSet graph) {
        this.renContexts.remove(graph);
    }

    public Map<LineGraphDataSet, List<Point2D>> prepareGraphsForQuickView(XYGraphAxesModel axes_model, List<LineGraphDataSet> allGraphs, List<Boolean> secondaryAxis, RenderingAsyncProgress.Progress progress, int width, int height) {
        HashMap<LineGraphDataSet, List<Point2D>> graphs = new HashMap<LineGraphDataSet, List<Point2D>>();
        for (int i = 0; i < allGraphs.size(); ++i) {
            List<Point2D> graph;
            GraphAxisModel yAxis;
            LineGraphDataSet set = allGraphs.get(i);
            boolean secondary = secondaryAxis.get(i);
            GraphAxisModel xAxis = axes_model.getXAxis();
            GraphAxisModel graphAxisModel = yAxis = secondary ? axes_model.getYAxisSecondary() : axes_model.getYAxis();
            if (progress != null && progress.isCanceled()) {
                return null;
            }
            if (set instanceof LineGraphVirtualDataSet) {
                LineGraphVirtualDataSet data = (LineGraphVirtualDataSet)set;
                List<Value2DExtended> visibleSet = data.getEntireVisibleSet(progress, 100000, xAxis, width);
                graph = this.calculateGraphPolygonALL(data, visibleSet, xAxis, yAxis, width, height, progress, false);
            } else {
                graph = this.calculateGraphPolygonAVG(set, xAxis, yAxis, width, height, false);
            }
            if (progress != null && progress.isCanceled()) {
                return null;
            }
            graphs.put(set, graph);
        }
        return graphs;
    }

    public static class RenderingContext {
        private List<Value2DExtended> visibleSet = new ArrayList<Value2DExtended>();
        private Set<Point2D> emphasizedPoints = new LinkedHashSet<Point2D>();
        private List<Point2D> drawnPolygon;
        private int state = 0;
        private int width = 0;
        private double min;
        private double range;
        private long dataSize;
        private boolean rollBack;
        private double[] stateRollback = new double[5];

        public int saveScreenState(long size, GraphAxisModel xAxisModel, Rectangle graphArea, int newState) {
            this.stateRollback[0] = this.state;
            this.stateRollback[1] = this.width;
            this.stateRollback[2] = this.min;
            this.stateRollback[3] = this.range;
            this.stateRollback[4] = this.dataSize;
            this.rollBack = true;
            this.width = graphArea.width;
            this.min = xAxisModel.getMin();
            this.range = xAxisModel.getRange();
            this.dataSize = size;
            this.state = newState;
            return this.state;
        }

        public void stateRollBack() {
            if (this.rollBack) {
                this.state = (int)this.stateRollback[0];
                this.width = (int)this.stateRollback[1];
                this.min = this.stateRollback[2];
                this.range = this.stateRollback[3];
                this.dataSize = (long)this.stateRollback[4];
                this.rollBack = false;
            }
        }

        public List<Value2DExtended> getVisibleSet() {
            return this.visibleSet;
        }

        public void resetVisibleSet() {
            this.visibleSet = new ArrayList<Value2DExtended>();
        }

        public int getScreenState() {
            return this.state;
        }

        public int getScreenWidth() {
            return this.width;
        }

        public double getMinXValue() {
            return this.min;
        }

        public double getXAxisRange() {
            return this.range;
        }

        public long getDataSize() {
            return this.dataSize;
        }
    }
}

