/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.GraphContainerChart;
import com.sap.jvm.profiling.ui.graph.LineGraphContainer;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionToolTipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphValueSelector;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxis;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisAdapter;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxisModelListener;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphVirtualDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.legend.LegendPositionAnchor;
import com.sap.jvm.profiling.ui.graph.progress.RenderingAsyncProgress;
import com.sap.jvm.profiling.ui.graph.renderer.ChartsContainerActionListener;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LineGraphSimpleChart
extends GraphContainerChart<LineGraphDataSet> {
    private XYGraphAxesModel axes_model = new XYGraphAxesModel();
    private Rectangle mainArea = new Rectangle();
    private Rectangle axisYArea = new Rectangle();
    private Rectangle axisYClippArea = new Rectangle();
    private Rectangle axisXArea = new Rectangle();
    private Rectangle axisXClippArea = new Rectangle();
    private Rectangle[] allChartAreas = new Rectangle[]{this.mainArea, this.axisXArea, this.axisYArea, this.graphArea};
    private boolean x_axis_show;
    private boolean y_axis_show;
    private LineGraphAxis x_axis;
    private LineGraphAxis y_axis;
    private LineGraphContainer container;
    private GraphChartContainer chartsContainer;
    private final LegendPositionAnchor[] ANCHORS = new LegendPositionAnchor[]{new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.RIGHT_TOP, this.graphArea, 0), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.RIGHT_BOTTOM, this.graphArea, 1), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_BOTTOM, this.graphArea, 2), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_TOP, this.graphArea, 3)};
    private GraphChartContainer.DisplayCell containerDisplayCell;
    private ChartsContainerActionListener actionListener = new ChartsContainerActionListener(){

        @Override
        public void dispose() {
        }

        @Override
        public void initializedDrawingArea(Renderer renderer, GraphChartContainer.DisplayCell cell) {
            LineGraphSimpleChart.this.axes_model.setListenersEnabled(false);
            this.resizedDrawingArea(renderer, cell);
            LineGraphSimpleChart.this.axes_model.setAxesToDefault(renderer.getWidth(), renderer.getHeight());
            LineGraphSimpleChart.this.axes_model.setListenersEnabled(true);
        }

        @Override
        public void resizedDrawingArea(Renderer renderer, GraphChartContainer.DisplayCell cell) {
            if (!renderer.isVisibleInitialized()) {
                return;
            }
            LineGraphSimpleChart.this.mainArea = cell.getGraphArea();
            LineGraphSimpleChart.this.containerDisplayCell = cell;
            LineGraphSimpleChart.this.updateAreaSizes(renderer);
        }

        @Override
        public boolean hasModelDataChanged() {
            return true;
        }

        @Override
        public void repaintDrawingArea(Renderer renderer) {
            if (!renderer.isVisibleInitialized()) {
                return;
            }
            if (((LineGraphSimpleChart)LineGraphSimpleChart.this).mainArea.height > 10 && ((LineGraphSimpleChart)LineGraphSimpleChart.this).mainArea.width > 10) {
                LineGraphSimpleChart.this.container.prepareGraphsForDrawing(LineGraphSimpleChart.this.axes_model, LineGraphSimpleChart.this.graphArea, new RenderingAsyncProgress.Progress());
                LineGraphSimpleChart.this.paint(renderer, true);
            } else {
                renderer.restoreScreen(LineGraphSimpleChart.this);
                LineGraphSimpleChart.this.chartsContainer.updateScreen(LineGraphSimpleChart.this.containerDisplayCell);
            }
        }

        @Override
        public void postRestoredScreen(Renderer renderer) {
        }

        @Override
        public void mouseDownLeft(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMovedByLeftPressed(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseUpLeft(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMoved(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseHovered(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseDownRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMovedByRightPressed(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseUpRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseDoubleClicked(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }
    };

    public static LineGraphDataSet createDataSet(String name) {
        return new LineGraphDataSet(name){};
    }

    public static LineGraphVirtualDataSet createVirtualDataSet(String name, String fileName) throws IOException {
        return new LineGraphVirtualDataSet(name, fileName){};
    }

    public LineGraphSimpleChart(GraphChartContainer chartsContainer, boolean x_axis_show, boolean y_axis_show) {
        this.chartsContainer = chartsContainer;
        this.x_axis_show = x_axis_show;
        this.y_axis_show = y_axis_show;
        Renderer renderer = chartsContainer.getRenderer();
        this.x_axis = new LineGraphAxis(this.axes_model.getXAxis(), 1, 1, renderer);
        this.y_axis = new LineGraphAxis(this.axes_model.getYAxis(), 0, 0, renderer);
        this.container = new LineGraphContainer(renderer, this.axes_model);
    }

    @Override
    public Renderer getRenderer() {
        return this.chartsContainer.getRenderer();
    }

    @Override
    public LegendPositionAnchor getDefaultLegedPosition() {
        return this.ANCHORS[0];
    }

    @Override
    public LegendPositionAnchor[] getLegendAnchors() {
        return this.ANCHORS;
    }

    @Override
    public void refresh() {
        this.actionListener.repaintDrawingArea(this.chartsContainer.getRenderer());
        this.chartsContainer.updateScreen(this.containerDisplayCell);
    }

    @Override
    public void addGraph(LineGraphDataSet graph) {
        this.addGraph(graph, false);
    }

    @Override
    public void addGraph(LineGraphDataSet graph, boolean secondary) {
        if (secondary) {
            throw new UnsupportedOperationException("Secondary y-axis is not supported by LineGraphSimpleChart");
        }
        this.container.appendGraph(graph, secondary);
        this.notifyACC();
    }

    @Override
    public List<LineGraphDataSet> getAllGraphs() {
        return this.container.getAllGraphs();
    }

    @Override
    public void removeAllGraphs() {
        this.container.removeAllGraphs(this.axes_model);
        this.notifyACC();
    }

    public void addLineGraphSelectionToolTipProvider(LineGraphSelectionToolTipProvider provider) {
        this.container.addLineGraphSelectionToolTipProvider(provider);
    }

    public void initAxes() {
        this.container.initAxes(this.axes_model, new RenderingAsyncProgress.Progress());
    }

    public void setRasterColor(Color color) {
        this.x_axis.setRasterColor(color);
        this.y_axis.setRasterColor(color);
    }

    public void setXRasterAdapter(RasterCalculationAdapter adapterX) {
        this.axes_model.setXRasterAdapter(adapterX);
    }

    public void setYRasterAdapter(RasterCalculationAdapter adapterY) {
        this.axes_model.setYRasterAdapter(adapterY);
    }

    public void setRangeAxisAdaptor(RangeLineAxisAdapter xAdapter, RangeLineAxisAdapter yAdapter) {
        this.axes_model.setRangeAxisAdaptor(xAdapter, yAdapter);
    }

    public void addAxisListener(XYGraphAxisModelListener listener) {
        this.axes_model.addAxisListener(listener);
    }

    public void removeAxisListener(XYGraphAxisModelListener listener) {
        this.axes_model.removeAxisListener(listener);
    }

    public void adjustXAxis(double min, double max, boolean undo) {
        if (undo) {
            this.axes_model.markUndo();
        }
        this.axes_model.adjustXAxis(this.graphArea.width, min, max);
    }

    public void adjustYAxis(double min, double max, boolean undo) {
        if (undo) {
            this.axes_model.markUndo();
        }
        this.axes_model.adjustYAxis(this.graphArea.height, min, max);
    }

    public double getMaxXAxisValue() {
        return this.axes_model.getMaxX();
    }

    public double getMaxYAxisValue() {
        return this.axes_model.getMaxY();
    }

    public double getMinXAxisValue() {
        return this.axes_model.getMinX();
    }

    public double getMinYAxisValue() {
        return this.axes_model.getMinY();
    }

    public double getXAxisRasterSize() {
        return this.axes_model.getXAxisRasterSize();
    }

    public double getYAxisRasterSize() {
        return this.axes_model.getYAxisRasterSize();
    }

    public boolean canUndo() {
        return this.axes_model.canUndo();
    }

    public boolean unDo() {
        return this.axes_model.unDo(this.graphArea.width, this.graphArea.height);
    }

    public void setXAxisCaptionProvider(LineGraphAxisCaptionProvider provider) {
        if (this.x_axis != null) {
            this.x_axis.setAxisCaptionProvider(provider);
        }
    }

    public void setYAxisCaptionProvider(LineGraphAxisCaptionProvider provider) {
        if (this.y_axis != null) {
            this.y_axis.setAxisCaptionProvider(provider);
        }
    }

    @Override
    public ChartsContainerActionListener provideContainerListener() {
        return this.actionListener;
    }

    @Override
    public String getAccessibleControlName() {
        return I18n._s((String)"Line Chart");
    }

    @Override
    public String getAccessibleStateText() {
        StringBuilder result = new StringBuilder();
        if (this.x_axis_show) {
            result.append(this.x_axis.getAccessibleText());
            result.append(", ");
        }
        if (this.y_axis_show) {
            result.append(this.y_axis.getAccessibleText());
            result.append(", ");
        }
        return result.toString();
    }

    @Override
    public void keyNext() {
    }

    @Override
    public void keyPrevious() {
    }

    public Map<Point2D, String> getEmphasizedPointsTooltips() {
        int ox = this.graphArea.x;
        int oy = this.getRenderer().getScreenHeight() - this.graphArea.y_end;
        HashMap<Point2D, String> result = new HashMap<Point2D, String>();
        for (LineGraphDataSet graph : this.getAllGraphs()) {
            Set<Point2D> points = this.container.getGraphRenderer().getEmphasizedPoints(graph, this.axes_model, this.graphArea.width);
            for (Point2D p : points) {
                List<Value2D> values = LineGraphValueSelector.getRealEmphasisedValues(graph, p, this.axes_model, this.graphArea.width);
                Point2D pTransformed = new Point2D(p.x + ox, oy - p.y);
                String tooltip = this.container.provideSelectionToolTip(graph, values);
                result.put(pTransformed, tooltip);
            }
        }
        return result;
    }

    private void updateAreaSizes(Renderer renderer) {
        int fontHeight = renderer.getFontHeight();
        int availableHeight = this.mainArea.height;
        int xAxisHeight = 0;
        if (this.x_axis_show) {
            int minSize = this.x_axis.getMinDimension(renderer);
            int prefSize = this.axes_model.getXAxis().getPreferredDisplaySize() + (this.x_axis.hasAxisTitle() ? fontHeight : 0);
            if (prefSize <= minSize) {
                xAxisHeight = prefSize;
            } else {
                double factor = Math.min(1.0, (double)this.mainArea.height * 0.003);
                xAxisHeight = minSize + (int)Math.round((double)(prefSize - minSize) * factor);
            }
            if (xAxisHeight > availableHeight / 2) {
                xAxisHeight = availableHeight / 2;
            }
        }
        int graphAreaHeight = this.x_axis_show ? availableHeight + 1 : (availableHeight -= xAxisHeight);
        int y_axis_width = 0;
        if (this.y_axis_show) {
            int prefSize = this.axes_model.getYAxis().getPreferredDisplaySize() + (this.y_axis.hasAxisTitle() ? fontHeight : 0);
            y_axis_width = Math.max(this.y_axis.getMinDimension(renderer), prefSize);
            this.axisYArea.update(this.mainArea.x, this.mainArea.y, y_axis_width, graphAreaHeight);
            this.axisYClippArea.update(this.axisYArea.x, this.axisYArea.y + fontHeight / 2, this.axisYArea.width, this.axisYArea.height + fontHeight);
        }
        if (this.x_axis_show) {
            this.axisXArea.update(this.mainArea.x + (this.y_axis_show ? this.axisYArea.width - 1 : 0), this.mainArea.y_end + xAxisHeight - 1, this.mainArea.width - (this.y_axis_show ? this.axisYArea.width : 0), xAxisHeight);
            this.axisXClippArea.update(this.mainArea.x, this.axisXArea.y, this.mainArea.width, this.axisXArea.height);
        }
        this.graphArea.update(this.y_axis_show ? this.mainArea.x + y_axis_width - 1 : this.mainArea.x, this.mainArea.y, this.mainArea.width - (this.y_axis_show ? y_axis_width : 0), graphAreaHeight);
        this.axes_model.recalculateAxesRaster(this.graphArea.width, this.graphArea.height);
        this.notifyLayoutListener(this.graphArea, this.allChartAreas);
    }

    private void paint(Renderer renderer, boolean allowRecursion) {
        renderer.setPaintArea(this.mainArea);
        renderer.clearDrawingArea();
        if (this.y_axis_show) {
            this.y_axis.repaintAxis(this.y_axis_show, this.y_axis_show, this.graphArea, this.axisYArea, this.axisYClippArea, renderer);
            if (this.y_axis.getMinDimension(renderer) > this.axisYArea.width) {
                this.updateAreaSizes(renderer);
                this.paint(renderer, false);
                return;
            }
        }
        if (this.x_axis_show) {
            this.x_axis.repaintAxis(this.x_axis_show, this.x_axis_show, this.graphArea, this.axisXArea, this.axisXClippArea, renderer);
        }
        renderer.setPaintArea(this.graphArea, this.mainArea);
        this.container.repaintGraphs(this.axes_model);
        renderer.saveScreen(this.mainArea, this);
        this.chartsContainer.updateScreen(this.containerDisplayCell);
    }
}

