/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.LineGraphContainer;
import com.sap.jvm.profiling.ui.graph.LineGraphValueBarToolTipProvider;
import com.sap.jvm.profiling.ui.graph.axes.GraphAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class LineGraphValueBar {
    private static final int TEXT_LEFT_MARGIN = 10;
    private static final int TEXT_RIGHT_MARGIN = 10;
    private static final int TEXT_TOP_MARGIN = 2;
    private static final int TEXT_BOTTOM_MARGIN = 2;
    private static final int TEXT_WIDTH_MARGIN = 20;
    private static final int TEXT_HIGHT_MARGIN = 4;
    private static final int CLOSE_BUTTON_SIZE = 6;
    private static final int SHADOW_BORDER = 3;
    private boolean enabled;
    private boolean visible;
    private Renderer renderer;
    private XYGraphAxesModel axesModel;
    private LineGraphContainer container;
    private LineGraphValueBarToolTipProvider provider;
    private int pixelPos;
    private double lastXValue;
    private boolean positionSet = false;
    private boolean showCloseBtn = true;
    private int closeBtnX = -1;
    private int closeBtnY = -1;
    private List<String> valueStates = new ArrayList<String>();

    public LineGraphValueBar(Renderer renderer, XYGraphAxesModel axesModel, LineGraphContainer container) {
        this.renderer = renderer;
        this.axesModel = axesModel;
        this.container = container;
    }

    public void setProvider(LineGraphValueBarToolTipProvider provider) {
        this.provider = provider;
        this.enabled = this.provider != null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isIn(int min, int max) {
        return this.enabled && this.pixelPos > min && this.pixelPos < max;
    }

    public boolean isHovered(int pos) {
        return this.enabled && this.visible && Math.abs(pos - this.pixelPos) < 3;
    }

    public boolean isCloseButtonHovered(int x, int y) {
        return this.enabled && this.visible && this.showCloseBtn && Math.abs(x - this.closeBtnX) < 6 && Math.abs(y - this.closeBtnY) < 6;
    }

    public void closeValueBar() {
        this.visible = false;
        this.pixelPos = -1;
        this.closeBtnX = -1;
        this.closeBtnY = -1;
    }

    public boolean isVisible() {
        return this.enabled && this.visible;
    }

    public void setPosition(int pos) {
        this.pixelPos = pos;
        this.positionSet = true;
        this.visible = true;
    }

    public int getPosition() {
        return this.pixelPos;
    }

    public void checkPositionAndAdjust(int width) {
        if (this.enabled) {
            if (this.pixelPos > width) {
                this.pixelPos = width - 1;
            } else if (this.pixelPos < 2) {
                this.pixelPos = 2;
            }
        }
    }

    public int getTipHeight() {
        return this.enabled && this.provider.isBarValueTooltipAvailable() ? this.renderer.getFontHeight() + 4 + 3 : this.renderer.getFontHeight();
    }

    public String getAccessibleValueState() {
        StringBuilder result = new StringBuilder("Value Bar ");
        if (!this.valueStates.isEmpty()) {
            result.append("x axis value, ");
            result.append(this.valueStates.get(0));
            if (this.valueStates.size() > 2) {
                result.append(", y values, ");
            } else {
                result.append(", y value, ");
            }
            for (int i = 1; i < this.valueStates.size(); ++i) {
                result.append(this.valueStates.get(i));
                result.append(", ");
            }
        }
        return result.toString();
    }

    public void drawValueBar(Rectangle paintRec, Rectangle clipRec, boolean silent) {
        if (this.enabled && this.visible && !this.container.isEmpty()) {
            this.renderer.setPaintArea(paintRec, clipRec);
            int height = this.renderer.getHeight() - 4;
            this.renderer.setForeground(Color.GRAY);
            this.renderer.drawLine(this.pixelPos - 1, height, this.pixelPos + 1, height);
            this.renderer.drawLine(this.pixelPos - 1, 2, this.pixelPos + 1, 2);
            this.renderer.drawLine(this.pixelPos, height, this.pixelPos, 2);
            this.renderer.setDefaultColors();
            double xVal = this.axesModel.getXValue(this.renderer.getWidth(), this.pixelPos);
            this.valueStates.clear();
            this.valueStates.add(this.provider.getXAxisValueText(xVal));
            if (this.provider.isBarValueTooltipAvailable()) {
                this.drawBarValue(this.pixelPos, height, this.valueStates.get(0));
            }
            ArrayList<Rectangle> tips = new ArrayList<Rectangle>();
            List allGraphs = this.container.getAllGraphs();
            List<Boolean> secondaryFlags = this.container.getSecondaryAxisFlags();
            for (int graphIdx = 0; graphIdx < allGraphs.size(); ++graphIdx) {
                List<Point2D> list;
                GraphAxisModel yAxis;
                LineGraphDataSet graph = (LineGraphDataSet)allGraphs.get(graphIdx);
                GraphAxisModel graphAxisModel = yAxis = secondaryFlags.get(graphIdx) != false ? this.axesModel.getYAxisSecondary() : this.axesModel.getYAxis();
                if (!this.provider.isGraphValueToltipAvailable(graph) || !graph.isXIn(xVal) || (list = this.container.getGraphRenderer().getPaintedGraphPolygon(graph)) == null || list.isEmpty()) continue;
                int idx = this.findPoint(list, this.pixelPos);
                Point2D low = list.get(idx);
                int y = low.y;
                if (low.x == this.pixelPos) {
                    int max = low.y;
                    int i = 1;
                    while (idx - i >= 0) {
                        low = list.get(idx - i);
                        if (low.x != this.pixelPos) break;
                        ++i;
                        max = Math.max(max, low.y);
                    }
                    i = 1;
                    while (idx + i < list.size()) {
                        low = list.get(idx + i);
                        if (low.x != this.pixelPos) break;
                        ++i;
                        max = Math.max(max, low.y);
                    }
                    y = max;
                } else if (idx + 1 < list.size()) {
                    Point2D next = list.get(idx + 1);
                    double dy = (double)(next.y - low.y) / (double)(next.x - low.x);
                    y = (int)((double)low.y + dy * (double)(this.pixelPos - low.x));
                }
                double yValue = yAxis.getValue(this.renderer.getHeight(), y);
                if (!(yValue >= yAxis.getMin()) || !(yValue <= yAxis.getMax())) continue;
                String text = this.provider.getYAxisValueText(graph, yValue);
                if (text != null) {
                    tips.add(this.getValueTipArea(this.pixelPos, y, new TipEntry(text, this.provider.getTipColor(graph))));
                }
                this.valueStates.add(graph.getName() + ' ' + text);
            }
            if (!tips.isEmpty()) {
                int i;
                Collections.sort(tips, new Comparator<Rectangle>(){

                    @Override
                    public int compare(Rectangle rec1, Rectangle rec2) {
                        return rec1.y - rec2.y;
                    }
                });
                Rectangle recLast = (Rectangle)tips.get(0);
                for (i = 1; i < tips.size(); ++i) {
                    Rectangle rec = (Rectangle)tips.get(i);
                    if (rec.isInXRange(recLast) && rec.y_end < recLast.y + 3) {
                        int newY = recLast.y + rec.height + 3;
                        rec.update(rec.x, newY, rec.width, rec.height);
                    }
                    recLast = rec;
                }
                if (tips.size() > 1) {
                    int lowest = ((Rectangle)tips.get((int)0)).y_end;
                    int highest = ((Rectangle)tips.get((int)(tips.size() - 1))).y;
                    int moveUpDelta = Math.max(0, -lowest);
                    int moveDownDelta = Math.max(0, highest - this.renderer.getHeight());
                    int delta = moveDownDelta - moveUpDelta;
                    if (delta != 0) {
                        for (int i2 = 0; i2 < tips.size(); ++i2) {
                            Rectangle tip = (Rectangle)tips.get(i2);
                            tip.update(tip.x, tip.y - delta, tip.width, tip.height);
                        }
                    }
                }
                for (i = 0; i < tips.size(); ++i) {
                    this.drawTip((Rectangle)tips.get(i));
                }
            }
            this.renderer.setDefaultColors();
            if (xVal != this.lastXValue) {
                if (!silent) {
                    this.container.notifyValueBarListeners(this.renderer.getWidth(), this.getPosition(), this.positionSet);
                }
                this.lastXValue = xVal;
                this.positionSet = false;
            }
        }
    }

    private int findPoint(List<Point2D> list, int x) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Point2D midVal = list.get(mid);
            double cmp = midVal.x - x;
            if (cmp < 0.0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0.0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low == 0 ? 0 : low - 1;
    }

    private void drawTip(Rectangle rec) {
        TipEntry tip = (TipEntry)rec.getData();
        this.renderer.setAlpha(80);
        this.renderer.setFillColor(Color.GRAY);
        this.renderer.fillRectangle(rec.x + 3, rec.y - 3, rec.width, rec.height);
        this.renderer.setAlpha(150);
        this.renderer.setFillColor(tip.color);
        this.renderer.fillRectangle(rec.x, rec.y, rec.width, rec.height);
        this.renderer.setDefaultColors();
        this.renderer.setAlpha(255);
        this.renderer.drawRectangle(rec.x, rec.y, rec.width, rec.height);
        int y = rec.y - 2;
        for (String text : tip.textLines) {
            this.renderer.drawString(text, rec.x + 10, y);
            y -= this.renderer.getFontHeight();
        }
    }

    private void drawBarValue(int posX, int posY, String text) {
        if (text == null) {
            return;
        }
        int h = this.renderer.getFontHeight() + 4;
        int w = this.renderer.getStringWidth(text) + 20;
        int x = posX - w / 2;
        int y = posY + h + 3;
        if (this.showCloseBtn) {
            this.closeBtnX = x + w + 3;
            this.closeBtnY = y - 2 - this.renderer.getFontHeight() / 2 + 1;
            w = w + 6 + 5;
        }
        this.renderer.setAlpha(80);
        this.renderer.setFillColor(Color.GRAY);
        this.renderer.fillRectangle(x + 3, y - 3, w, h);
        this.renderer.setAlpha(180);
        this.renderer.setFillColor(Color.TOOLTIP_ORANGE);
        this.renderer.fillRectangle(x, y, w, h);
        this.renderer.drawRectangle(x, y, w, h);
        this.renderer.setAlpha(255);
        this.renderer.drawString(text, x + 10, y - 2);
        if (this.showCloseBtn) {
            int x1 = this.closeBtnX - 3;
            int y1 = this.closeBtnY - 3;
            int x2 = x1 + 6;
            int y2 = y1 + 6;
            this.renderer.setForeground(Color.DARK_GRAY);
            this.renderer.setAlpha(128);
            this.renderer.drawLine(x1 + 1, y1, x2, y2 - 1);
            this.renderer.drawLine(x1, y1 + 1, x2 - 1, y2);
            this.renderer.drawLine(x1 + 1, y2, x2, y1 + 1);
            this.renderer.drawLine(x1, y2 - 1, x2 - 1, y1);
            this.renderer.setAlpha(255);
            this.renderer.drawLine(x1, y1, x2, y2);
            this.renderer.drawLine(x1, y2, x2, y1);
        }
    }

    private Rectangle getValueTipArea(int posX, int posY, TipEntry tip) {
        if (tip.textLines == null) {
            return null;
        }
        int lines = tip.textLines.length;
        int h = lines * this.renderer.getFontHeight() + 4;
        int w = 0;
        for (String line : tip.textLines) {
            w = Math.max(w, this.renderer.getStringWidth(line));
        }
        int y = posY;
        int x = posX;
        if (this.renderer.getWidth() - x - 10 <= (w += 20)) {
            this.renderer.drawPoint(x - 2, y);
            this.renderer.drawLine(x - 3, y - 1, x - 3, y + 1);
            this.renderer.drawLine(x - 4, y - 2, x - 4, y + 2);
            x -= w + 9;
        } else {
            this.renderer.drawPoint(x + 2, y);
            this.renderer.drawLine(x + 3, y - 1, x + 3, y + 1);
            this.renderer.drawLine(x + 4, y - 2, x + 4, y + 2);
            x += 7;
        }
        return new Rectangle(x, y += h - 3, w, h, tip);
    }

    private class TipEntry {
        String[] textLines;
        Color color;

        public TipEntry(String text, Color color) {
            this.textLines = text.split("\n");
            this.color = color == null ? Color.TOOLTIP_YELLOW : color;
        }
    }
}

