/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.LineGraphContainer;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineGraphValueSelector {
    private boolean enabled;
    private Renderer renderer;
    private LineGraphContainer container;
    private Point2D lastHoveredValue;
    private LineGraphDataSet lastHoveredGraph;

    public LineGraphValueSelector(Renderer renderer, LineGraphContainer container) {
        this.renderer = renderer;
        this.container = container;
    }

    public void enable(boolean enable) {
        this.enabled = enable;
        if (enable) {
            this.lastHoveredValue = null;
            this.lastHoveredGraph = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isValueHovered(int x, int y) {
        if (this.enabled) {
            this.lastHoveredValue = null;
            this.lastHoveredGraph = null;
            for (LineGraphDataSet graph : this.container.getAllGraphs()) {
                Point2D val_p = this.container.getGraphRenderer().getVisibleEmphasizedValueAtLocation(graph, x, y);
                if (val_p == null) continue;
                this.lastHoveredValue = val_p;
                this.lastHoveredGraph = graph;
                return true;
            }
        }
        return false;
    }

    public void drawLastHoveredValue(XYGraphAxesModel model, int width) {
        List<Value2D> values = this.getRealEmphasisedValues(this.lastHoveredValue, model, width);
        this.container.notifyGraphSelected(this.lastHoveredGraph);
        this.container.notifyValueSelected(this.lastHoveredGraph, values);
    }

    private List<Value2D> getRealEmphasisedValues(Point2D point, XYGraphAxesModel model, int width) {
        return LineGraphValueSelector.getRealEmphasisedValues(this.lastHoveredGraph, point, model, width);
    }

    public static List<Value2D> getRealEmphasisedValues(LineGraphDataSet graph, Point2D point, XYGraphAxesModel model, int width) {
        Value2D v;
        long foundIdx;
        ArrayList<Value2D> result = new ArrayList<Value2D>();
        double xValue = model.getXAxis().getValue(width, point.x);
        long idx = foundIdx = graph.getIndexOfXValue(xValue);
        while (idx > -1L) {
            v = graph.getValueAt(idx--);
            if (point.x != model.getXAxis().getPosition(width, v.x)) break;
            if (!v.emphasized || result.contains(v)) continue;
            result.add(v);
        }
        idx = foundIdx;
        while (idx + 1L < graph.getSize()) {
            v = graph.getValueAt(++idx);
            if (point.x != model.getXAxis().getPosition(width, v.x)) break;
            if (!v.emphasized || result.contains(v)) continue;
            result.add(v);
        }
        Collections.sort(result);
        return result;
    }

    public void showToolTip(XYGraphAxesModel model, int width, int x, int y) {
        List<Value2D> values = this.getRealEmphasisedValues(this.lastHoveredValue, model, width);
        this.renderer.provideToolTip(x, y, this.container.provideSelectionToolTip(this.lastHoveredGraph, values));
    }
}

