/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.PieGraph;
import com.sap.jvm.profiling.ui.graph.PieGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.List;

public class Pie2DGraph
extends PieGraph {
    private static final int SELECTION_DISTANCE = 20;
    private static final int SHADOW_SHIFT = 4;
    private Color SHADOW_COLOR = Color.brighter(Color.DARK_GRAY);
    private Color SHADOW_COLOR2 = new Color(235, 235, 235);
    private List<CaptionRequest> captions = new ArrayList<CaptionRequest>();

    Pie2DGraph(Renderer renderer, PieGraphDataSet data) {
        super(renderer, data);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rec = super.getEllipseRec();
        for (PieGraphDataSet.PiePiece piece : this.data.getPieces()) {
            if (!piece.isSelected()) continue;
            return new Rectangle(rec.x - 20, rec.y + 20, rec.width + 40 + 8, rec.height + 40 + 8);
        }
        return new Rectangle(rec.x, rec.y, rec.width + 8, rec.height + 8);
    }

    @Override
    protected int calculateDrawingAreaHeight(int width, int height) {
        return this.calculateDrawingAreaWidth(width, height);
    }

    @Override
    protected int calculateDrawingAreaWidth(int width, int height) {
        int result = (int)Math.round((double)(width > height ? height : width) * this.getFillRatio());
        return result;
    }

    @Override
    protected void paintGraph(Rectangle graphArea, PieGraphToolTipProvider provider) {
        this.captions.clear();
        this.renderer.setPaintArea(graphArea, null);
        boolean oldAntialias = this.renderer.isAntialiased();
        this.renderer.setAntialiased(true);
        if (!this.data.isEmpty()) {
            this.drawPie(provider);
        }
        this.renderer.setAntialiased(oldAntialias);
        this.renderer.setDefaultColors();
    }

    @Override
    protected void paintGraphTools(Rectangle graphArea, PieGraphToolTipProvider tipProvider) {
        this.renderer.setPaintArea(graphArea, null);
        for (CaptionRequest req : this.captions.toArray(new CaptionRequest[this.captions.size()])) {
            req.paint();
        }
    }

    private void drawPie(PieGraphToolTipProvider provider) {
        ArrayList<PieGraphDataSet.PiePiece> selectedPeaces = new ArrayList<PieGraphDataSet.PiePiece>();
        ArrayList<PieGraphDataSet.PiePiece> restPeaces = new ArrayList<PieGraphDataSet.PiePiece>();
        for (PieGraphDataSet.PiePiece p : this.data.getPieces()) {
            if (p.isSelected()) {
                selectedPeaces.add(p);
                continue;
            }
            restPeaces.add(p);
        }
        if (!selectedPeaces.isEmpty()) {
            this.drawPieWithSelecton(selectedPeaces, restPeaces, provider);
            return;
        }
        this.renderer.setFillColor(Color.GRAY_70);
        this.renderer.fillOval(this.pieSize.x + 4, this.pieSize.y - 4, this.pieSize.width, this.pieSize.width);
        this.renderer.blur(8);
        ArrayList<PieGraphDataSet.PiePiece> pieces = this.data.getPieces();
        ArrayList<PieGraphDataSet.PiePiece> filteredPieces = new ArrayList<PieGraphDataSet.PiePiece>();
        for (PieGraphDataSet.PiePiece p : pieces) {
            if (p.getAngle() == 0) continue;
            filteredPieces.add(p);
        }
        if (filteredPieces.isEmpty()) {
            this.renderer.setFillColor(Color.LIGHT_GRAY);
            this.renderer.fillOval(this.pieSize.x, this.pieSize.y, this.pieSize.width, this.pieSize.width);
            String msg = "Empty Pie Content!";
            int w = this.renderer.getStringWidth(msg) + 6;
            int h = this.renderer.getFontHeight() + 4;
            int x = this.pieSize.x + this.pieSize.h_width - w / 2;
            int y = this.pieSize.y - this.pieSize.h_height + h / 2;
            this.renderer.setFillColor(Color.GRAY);
            this.renderer.fillRectangle(x + 4, y - 4, w, h);
            this.renderer.setFillColor(Color.TOOLTIP_YELLOW);
            this.renderer.fillRectangle(x, y, w, h);
            this.renderer.drawRectangle(x, y, w, h);
            this.renderer.drawString(msg, x + 3, y - 1);
        } else if (filteredPieces.size() == 1) {
            this.renderer.setFillColor(((PieGraphDataSet.PiePiece)filteredPieces.get(0)).getColor());
            this.renderer.fillOval(this.pieSize.x, this.pieSize.y, this.pieSize.width, this.pieSize.width);
            if (this.data.hasFixedTooltips()) {
                this.captions.add(new CaptionRequest(this.pieSize.center.x, this.pieSize.center.y, ((PieGraphDataSet.PiePiece)filteredPieces.get(0)).getPieCenterAngle(), 1, 1, this.pieSize.h_width, provider.provideToolTip(this.data, (PieGraphDataSet.PiePiece)filteredPieces.get(0))));
            }
        } else {
            for (PieGraphDataSet.PiePiece p : filteredPieces) {
                this.renderer.setFillColor(p.getColor());
                this.renderer.fillArc(this.pieSize.x, this.pieSize.y, this.pieSize.width, this.pieSize.width, p.getPiePositionAngle(), p.getAngle());
            }
            for (PieGraphDataSet.PiePiece p : filteredPieces) {
                this.renderer.setForeground(Color.DARK_GRAY);
                this.renderer.setAlpha(150);
                this.drawAngleLine(this.pieSize.center.x, this.pieSize.center.y, p.getPiePositionAngle(), 1.0, 1.0, this.pieSize.h_width);
                this.renderer.setAlpha(255);
                if (!this.data.hasFixedTooltips()) continue;
                this.captions.add(new CaptionRequest(this.pieSize.center.x, this.pieSize.center.y, p.getPieCenterAngle(), 1, 1, this.pieSize.h_width, provider.provideToolTip(this.data, p)));
            }
        }
        this.renderer.setForeground(Color.DARK_GRAY);
        this.renderer.setLineWidth(2);
        this.renderer.setAlpha(90);
        this.renderer.drawOval(this.pieSize.x, this.pieSize.y, this.pieSize.width, this.pieSize.width);
        this.renderer.setLineWidth(1);
        this.renderer.setAlpha(255);
    }

    private void drawPieWithSelecton(List<PieGraphDataSet.PiePiece> selected, List<PieGraphDataSet.PiePiece> rest, PieGraphToolTipProvider provider) {
        int[] p1;
        for (PieGraphDataSet.PiePiece p : rest) {
            if (p.isSelected() || p.getAngle() == 0) continue;
            this.renderer.setFillColor(this.SHADOW_COLOR2);
            this.renderer.setForeground(this.SHADOW_COLOR2);
            this.renderer.fillArc(this.pieSize.x + 4, this.pieSize.y - 4, this.pieSize.width, this.pieSize.width, p.getPiePositionAngle(), p.getAngle());
            this.renderer.fillArc(this.pieSize.x, this.pieSize.y, this.pieSize.width, this.pieSize.width, p.getPiePositionAngle(), p.getAngle());
        }
        for (PieGraphDataSet.PiePiece p : selected) {
            if (p.getAngle() == 0) continue;
            p1 = this.getPoint(this.pieSize.x, this.pieSize.y, p.getPieCenterAngle(), 1.0, 1.0, this.getDistance(p));
            this.drawPiePieceShadow(p1[0], p1[1], this.pieSize.width, p);
        }
        this.renderer.blur(8);
        for (PieGraphDataSet.PiePiece p : rest) {
            this.renderer.setAlpha(100);
            if (p.isSelected() || p.getAngle() == 0) continue;
            this.renderer.setFillColor(p.getColor());
            this.renderer.fillArc(this.pieSize.x, this.pieSize.y, this.pieSize.width, this.pieSize.width, p.getPiePositionAngle(), p.getAngle());
            this.renderer.setForeground(Color.GRAY);
            this.renderer.drawArc(this.pieSize.x, this.pieSize.y, this.pieSize.width, this.pieSize.width, p.getPiePositionAngle(), p.getAngle());
            this.drawAngleLine(this.pieSize.center.x, this.pieSize.center.y, p.getPiePositionAngle(), 1.0, 1.0, this.pieSize.h_width);
            this.drawAngleLine(this.pieSize.center.x, this.pieSize.center.y, p.getPiePositionAngle() + p.getAngle(), 1.0, 1.0, this.pieSize.h_width);
            this.renderer.setAlpha(255);
            if (!this.data.hasFixedTooltips()) continue;
            this.captions.add(new CaptionRequest(this.pieSize.center.x, this.pieSize.center.y, p.getPieCenterAngle(), 1, 1, this.pieSize.h_width, provider.provideToolTip(this.data, p)));
        }
        this.renderer.setAlpha(255);
        for (PieGraphDataSet.PiePiece p : selected) {
            if (p.getAngle() == 0) continue;
            p1 = this.getPoint(this.pieSize.x, this.pieSize.y, p.getPieCenterAngle(), 1.0, 1.0, this.getDistance(p));
            this.drawPiePiece(p1[0], p1[1], this.pieSize.width, p, provider.provideToolTip(this.data, p));
        }
    }

    private void drawPiePiece(int x, int y, int length, PieGraphDataSet.PiePiece piece, String caption) {
        double hw = (double)length / 2.0;
        double c_x = (double)x + hw;
        double c_y = (double)y - hw;
        this.renderer.setForeground(Color.darker(piece.getColor()));
        this.renderer.setLineWidth(3);
        this.renderer.setFillColor(piece.getColor());
        int start_angle = piece.getPiePositionAngle();
        this.renderer.fillArc(x, y, length, length, start_angle, piece.getAngle());
        this.renderer.drawArc(x, y, length + 1, length + 1, start_angle, piece.getAngle());
        this.drawAngleLine(c_x, c_y, start_angle, length, length, hw);
        this.drawAngleLine(c_x, c_y, piece.getAngle() + start_angle, length, length, hw);
        this.renderer.setLineWidth(1);
        if (this.data.hasFixedTooltips()) {
            this.captions.add(new CaptionRequest((int)c_x, (int)c_y, piece.getPieCenterAngle(), 1, 1, hw, caption));
        }
    }

    private void drawPiePieceShadow(int x, int y, int length, PieGraphDataSet.PiePiece val) {
        this.renderer.setFillColor(this.SHADOW_COLOR);
        this.renderer.fillArc(x + 4, y - 4, length, length, val.getPiePositionAngle(), val.getAngle());
    }

    @Override
    protected int getDistance(PieGraphDataSet.PiePiece piece) {
        if (piece.isSelected()) {
            return 20;
        }
        return 0;
    }

    protected class CaptionRequest {
        int x;
        int y;
        int angle;
        int width;
        int height;
        double length;
        String caption;

        public CaptionRequest(int x, int y, int angle, int width, int height, double length, String caption) {
            this.x = x;
            this.y = y;
            this.angle = angle;
            this.width = width;
            this.height = height;
            this.length = length;
            this.caption = caption;
        }

        public void paint() {
            Pie2DGraph.this.drawCaption(this.x, this.y, this.angle, this.width, this.height, this.length, this.caption);
        }
    }
}

