/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.PieGraph;
import com.sap.jvm.profiling.ui.graph.PieGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;

public class Pie3DGraph
extends PieGraph {
    private static final double BODY = 0.15;

    Pie3DGraph(Renderer renderer, PieGraphDataSet data) {
        super(renderer, data);
    }

    @Override
    protected int calculateDrawingAreaHeight(int width, int height) {
        int result = (int)((double)width * this.getFillRatio() * 0.3);
        if (result >= height - 30) {
            result = height - 30;
        }
        return result;
    }

    @Override
    protected int calculateDrawingAreaWidth(int width, int height) {
        return (int)((double)width * 0.5);
    }

    @Override
    protected void paintGraph(Rectangle graphArea, PieGraphToolTipProvider tipProvider) {
        this.renderer.setPaintArea(graphArea, graphArea);
        this.paintPie(this.data, this.pieSize, tipProvider);
        this.renderer.setDefaultColors();
    }

    @Override
    protected void paintGraphTools(Rectangle graphArea, PieGraphToolTipProvider tipProvider) {
        if (this.data.hasFixedTooltips()) {
            int body = (int)((double)this.pieSize.height * 0.15);
            int height = this.pieSize.height - body;
            int c_x = this.pieSize.x + this.pieSize.h_width;
            int c_y = this.pieSize.y - height / 2;
            this.renderer.setForeground(Color.GRAY);
            this.renderer.setPaintArea(graphArea, null);
            for (PieGraphDataSet.PiePiece piece : this.data.getPieces()) {
                if (!piece.isSelected()) {
                    if (piece.getAngle() == 0) continue;
                    this.drawCaption(c_x, c_y, piece.getPieCenterAngle(), this.pieSize.width, height, this.pieSize.h_width, tipProvider.provideToolTip(this.data, piece));
                    continue;
                }
                int[] p = this.getPoint(c_x, c_y, piece.getPieCenterAngle(), this.pieSize.width, height, this.getDistance(piece));
                this.drawCaption(p[0], p[1], piece.getPieCenterAngle(), this.pieSize.width, height, this.pieSize.h_width, tipProvider.provideToolTip(this.data, piece));
            }
        }
    }

    @Override
    protected Rectangle getEllipseRec() {
        int body = (int)((double)this.pieSize.viewRec.height * 0.15);
        return new Rectangle(this.pieSize.viewRec.x, this.pieSize.viewRec.y, this.pieSize.viewRec.width, this.pieSize.viewRec.height - body);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rec = this.getEllipseRec();
        int extend = (int)((double)this.pieSize.height * 0.15);
        rec.update(rec.x, rec.y + extend, rec.width, rec.height + extend);
        return rec;
    }

    private void paintPie(PieGraphDataSet graph, PieGraph.PieSize area, PieGraphToolTipProvider tipProvider) {
        ArrayList<PieGraphDataSet.PiePiece> selectedPieces = new ArrayList<PieGraphDataSet.PiePiece>();
        ArrayList<PieGraphDataSet.PiePiece> restPieces = new ArrayList<PieGraphDataSet.PiePiece>();
        for (PieGraphDataSet.PiePiece p : graph.getPieces()) {
            if (p.isSelected()) {
                selectedPieces.add(p);
                continue;
            }
            restPieces.add(p);
        }
        int body = (int)((double)area.height * 0.15);
        int height = area.height - body;
        boolean oldAntialias = this.renderer.isAntialiased();
        this.paintPieShadow(selectedPieces, restPieces, area.x + 1, -3 + area.y - body--, area.width, height, selectedPieces.isEmpty());
        this.renderer.blur(8);
        this.renderer.setAntialiased(true);
        boolean valid = this.paintFlatPie(selectedPieces, restPieces, area.x, area.y - body--, area.width, height, true, selectedPieces.isEmpty());
        this.renderer.setAntialiased(false);
        for (int i = body; i > 0; --i) {
            this.paintFlatPie(selectedPieces, restPieces, area.x, area.y - i, area.width, height, true, selectedPieces.isEmpty());
        }
        this.renderer.setAntialiased(true);
        this.paintFlatPie(selectedPieces, restPieces, area.x, area.y, area.width, height, false, selectedPieces.isEmpty());
        this.renderer.setAntialiased(false);
        if (!valid) {
            String msg = "Empty Pie Content!";
            int w = this.renderer.getStringWidth(msg) + 6;
            int h = this.renderer.getFontHeight() + 4;
            int x = area.x + area.h_width - w / 2;
            int y = area.y - area.h_height + h;
            this.renderer.setFillColor(Color.GRAY);
            this.renderer.fillRectangle(x + 4, y - 4, w, h);
            this.renderer.setFillColor(Color.TOOLTIP_YELLOW);
            this.renderer.fillRectangle(x, y, w, h);
            this.renderer.drawRectangle(x, y, w, h);
            this.renderer.drawString(msg, x + 3, y - 1);
        }
        this.renderer.setAntialiased(oldAntialias);
        this.renderer.setDefaultColors();
    }

    private boolean paintFlatPie(ArrayList<PieGraphDataSet.PiePiece> selectedPieces, ArrayList<PieGraphDataSet.PiePiece> restPieces, int x, int y, int width, int height, boolean dim, boolean noSelection) {
        Color background;
        boolean empty = true;
        for (PieGraphDataSet.PiePiece piece : restPieces) {
            if (piece.getAngle() == 0) continue;
            empty = false;
            Color color = background = dim ? piece.getDimColor() : piece.getColor();
            if (!noSelection) {
                background = Color.alpha(background, Color.WHITE, 0.35);
            }
            this.renderer.setFillColor(background);
            if (piece.getAngle() == 360) {
                this.renderer.fillOval(x, y, width, height);
                return true;
            }
            this.renderer.fillArc(x, y, width, height, piece.getPiePositionAngle(), piece.getAngle());
        }
        for (PieGraphDataSet.PiePiece p : selectedPieces) {
            if (p.getAngle() == 0) continue;
            empty = false;
            int cAngle = p.getPieCenterAngle();
            int[] pos = this.getPoint(x, y, cAngle, width, height, this.getDistance(p));
            background = dim ? p.getDimColor() : p.getColor();
            this.renderer.setFillColor(background);
            this.renderer.fillArc(pos[0], pos[1], width, height, p.getPiePositionAngle(), p.getAngle());
            this.renderer.setForeground(background);
            pos = this.getPoint((double)x + (double)width / 2.0, (double)y - (double)height / 2.0, cAngle, width, height, (double)this.getDistance(p) + 3.0);
            int[] pos2 = this.getPoint(pos[0], pos[1], cAngle, width, height, width / 3);
            this.renderer.drawLine(pos[0], pos[1], pos2[0], pos2[1]);
        }
        if (empty) {
            this.renderer.setFillColor(dim ? Color.GRAY : Color.LIGHT_GRAY);
            this.renderer.fillOval(x, y, width, height);
            return false;
        }
        return true;
    }

    private boolean paintPieShadow(ArrayList<PieGraphDataSet.PiePiece> selectedPieces, ArrayList<PieGraphDataSet.PiePiece> restPieces, int x, int y, int width, int height, boolean noSelection) {
        boolean empty = true;
        this.renderer.setFillColor(Color.GRAY);
        for (PieGraphDataSet.PiePiece piece : restPieces) {
            if (piece.getAngle() == 0) continue;
            empty = false;
            if (piece.getAngle() == 360) {
                this.renderer.fillOval(x, y, width, height);
                return true;
            }
            this.renderer.fillArc(x, y, width, height, piece.getPiePositionAngle(), piece.getAngle());
        }
        for (PieGraphDataSet.PiePiece p : selectedPieces) {
            if (p.getAngle() == 0) continue;
            empty = false;
            int cAngle = p.getPieCenterAngle();
            int[] pos = this.getPoint(x, y, cAngle, width, height, this.getDistance(p));
            this.renderer.fillArc(pos[0], pos[1], width, height, p.getPiePositionAngle(), p.getAngle());
        }
        if (empty) {
            this.renderer.fillOval(x, y, width, height);
            return false;
        }
        return true;
    }

    @Override
    protected int getDistance(PieGraphDataSet.PiePiece piece) {
        if (piece.isSelected()) {
            return 25;
        }
        return 0;
    }
}

