/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.PieGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Arc;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;

public abstract class PieGraph {
    protected Renderer renderer;
    protected Rectangle paintCell;
    protected PieSize pieSize;
    protected PieGraphDataSet data;
    private boolean isFixedTooltipTransparent = true;
    private double fillRatio;

    PieGraph(Renderer renderer, PieGraphDataSet data) {
        this.renderer = renderer;
        this.data = data;
        this.paintCell = new Rectangle();
        this.pieSize = new PieSize();
        this.fillRatio = 0.65;
    }

    protected abstract int calculateDrawingAreaWidth(int var1, int var2);

    protected abstract int calculateDrawingAreaHeight(int var1, int var2);

    protected abstract void paintGraph(Rectangle var1, PieGraphToolTipProvider var2);

    protected abstract void paintGraphTools(Rectangle var1, PieGraphToolTipProvider var2);

    protected abstract int getDistance(PieGraphDataSet.PiePiece var1);

    protected void graphAreaResized() {
        this.pieSize = new PieSize();
    }

    protected void drawCaption(int x, int y, int angle, int width, int height, double length, String caption) {
        if (caption != null) {
            int ang = angle % 360;
            int cap_width = this.renderer.getStringWidth(caption) + 8;
            int cap_heigh = this.renderer.getFontHeight() + 4;
            int[] p1 = this.getPoint(x, y, ang, width, height, (int)(length * 0.75));
            int[] p2 = this.getPoint(x, y, ang, width, height, (int)(length * 1.25));
            int[] p3 = new int[]{0, p2[1]};
            int[] p = new int[]{0, 0};
            if (ang > 90 && ang < 270) {
                p3[0] = p2[0] - 5;
                p = new int[]{p3[0] - cap_width - 6, p3[1] + cap_heigh / 2};
            } else {
                p3[0] = p2[0] + 5;
                p = new int[]{p3[0] + 3, p3[1] + cap_heigh / 2};
            }
            this.renderer.setForeground(Color.GRAY);
            this.renderer.drawLine(p1[0], p1[1], p2[0], p2[1]);
            this.renderer.drawLine(p2[0], p2[1], p3[0], p3[1]);
            if (this.isFixedTooltipTransparent) {
                this.renderer.setAlpha(100);
                this.renderer.setFillColor(Color.GRAY);
                this.renderer.fillRectangle(p[0] + 3, p[1] - cap_heigh, cap_width, 3);
                this.renderer.fillRectangle(p[0] + cap_width, p[1] - 3, 3, cap_heigh - 3);
                this.renderer.setFillColor(Color.TOOLTIP_YELLOW);
                this.renderer.fillRectangle(p[0], p[1], cap_width, cap_heigh);
                this.renderer.setAlpha(255);
            } else {
                this.renderer.setFillColor(Color.TOOLTIP_LIGHT_YELLOW);
                this.renderer.fillRectangle(p[0], p[1], cap_width, cap_heigh);
            }
            this.renderer.setForeground(Color.BLACK);
            boolean oldAntialias = this.renderer.isAntialiased();
            this.renderer.setAntialiased(true);
            this.renderer.drawRectangle(p[0], p[1], cap_width, cap_heigh);
            this.renderer.drawString(caption, p[0] + 4, p[1] - 2);
            this.renderer.setAntialiased(oldAntialias);
        }
    }

    protected void enableTransparentFixedToolTips(boolean enable) {
        this.isFixedTooltipTransparent = enable;
    }

    protected int[] getPoint(double x, double y, double angle, double width, double height, double distance) {
        double rad = Math.toRadians(angle);
        double dx = Math.cos(rad) * distance;
        double dy = Math.sin(rad) * distance * (height / width);
        return new int[]{(int)Math.round(x + dx), (int)Math.round(y + dy)};
    }

    protected void drawAngleLine(double x, double y, double angle, double width, double height, double length) {
        int[] p = this.getPoint(x, y, angle, width, height, length);
        this.renderer.drawLine((int)Math.round(x), (int)Math.round(y), p[0], p[1]);
    }

    protected Rectangle getEllipseRec() {
        return this.pieSize.viewRec;
    }

    public abstract Rectangle getBounds();

    public Arc getArc(int piece) {
        PieGraphDataSet.PiePiece p = this.data.getPieces().get(piece);
        int start = p.getPiePositionAngle();
        int end = start + p.getAngle();
        Rectangle rect = this.getEllipseRec();
        if (p.isSelected()) {
            int distance = this.getDistance(p);
            int cAngle = p.getPieCenterAngle();
            int[] pos = this.getPoint(rect.center.x, rect.center.y, cAngle, rect.width, rect.height, distance);
            return new Arc(pos[0], pos[1], rect.width, rect.height, start, end);
        }
        return new Arc(rect.center.x, rect.center.y, rect.width, rect.height, start, end);
    }

    public PieGraphDataSet getDataSet() {
        return this.data;
    }

    public int getPiePieceAt(int x, int y) {
        if (this.paintCell.isIn(x, y)) {
            for (int i = 0; i < this.data.getPieces().size(); ++i) {
                if (!this.getArc(i).contains(x, y)) continue;
                return i;
            }
        }
        return -1;
    }

    public double getFillRatio() {
        return this.fillRatio;
    }

    public void setFillRatio(double fillRatio) {
        this.fillRatio = fillRatio;
    }

    protected class PieSize {
        Rectangle viewRec;
        Point2D center;
        int x;
        int y;
        int width;
        int h_width;
        int height;
        int h_height;

        PieSize() {
            this.center = new Point2D(PieGraph.this.paintCell.width / 2, PieGraph.this.paintCell.height / 2);
            this.width = PieGraph.this.calculateDrawingAreaWidth(PieGraph.this.paintCell.width, PieGraph.this.paintCell.height);
            this.h_width = this.width / 2;
            this.height = PieGraph.this.calculateDrawingAreaHeight(PieGraph.this.paintCell.width, PieGraph.this.paintCell.height);
            this.h_height = this.height / 2;
            this.x = this.center.x - this.h_width;
            this.y = this.center.y + this.h_height;
            this.viewRec = new Rectangle(PieGraph.this.paintCell.x + this.x, PieGraph.this.paintCell.y_end + this.y, this.width, this.height);
        }
    }

    public static enum GraphType {
        Graph2D,
        Graph3D;

    }
}

