/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.GraphContainerChart;
import com.sap.jvm.profiling.ui.graph.Pie2DGraph;
import com.sap.jvm.profiling.ui.graph.Pie3DGraph;
import com.sap.jvm.profiling.ui.graph.PieGraph;
import com.sap.jvm.profiling.ui.graph.PieGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.PieGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.legend.LegendPositionAnchor;
import com.sap.jvm.profiling.ui.graph.mouse.PieGraphMouseActionController;
import com.sap.jvm.profiling.ui.graph.renderer.ChartsContainerActionListener;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import com.sap.jvm.tracing.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PieGraphChart
extends GraphContainerChart<PieGraphDataSet> {
    private final PieGraphToolTipProvider DEFAULT_TOOLTIPS = new PieGraphToolTipProvider(){

        @Override
        public String provideToolTip(PieGraphDataSet pie, PieGraphDataSet.PiePiece piece) {
            StringBuilder tip = new StringBuilder(piece.getName());
            tip.append(" ");
            int digits = pie.getPercentDigits();
            if (digits != -1) {
                tip.append(DataFormatter.getPercentage((double)(piece.getPercent() / 100.0), (int)digits));
            } else {
                tip.append(DataFormatter.getPercentage((double)(piece.getPercent() / 100.0)));
            }
            return tip.toString();
        }
    };
    private GraphChartContainer chartsContainer;
    private PieGraph pieGraph;
    private PieGraphMouseActionController mouseController;
    private Map<PieGraphDataSet, PieGraphToolTipProvider> toolTipsProviders = new HashMap<PieGraphDataSet, PieGraphToolTipProvider>();
    private Map<PieGraphDataSet, List<PieGraphSelectionListener>> listeners = new HashMap<PieGraphDataSet, List<PieGraphSelectionListener>>();
    private final LegendPositionAnchor[] ANCHORS = new LegendPositionAnchor[]{new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.RIGHT_TOP, this.graphArea, 0), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.RIGHT_CENTER, this.graphArea, 1), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.RIGHT_BOTTOM, this.graphArea, 2), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_BOTTOM, this.graphArea, 3), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_CENTER, this.graphArea, 4), new LegendPositionAnchor.GraphAreaAnchor(LegendPositionAnchor.PinCorner.LEFT_TOP, this.graphArea, 5)};
    private ChartsContainerActionListener actionListener = new ChartsContainerActionListener(){

        @Override
        public void dispose() {
        }

        @Override
        public void initializedDrawingArea(Renderer source, GraphChartContainer.DisplayCell cell) {
            Rectangle newGraphArea = cell.getGraphArea();
            PieGraphChart.this.graphArea.update(newGraphArea.x, newGraphArea.y, newGraphArea.width, newGraphArea.height);
        }

        @Override
        public void resizedDrawingArea(Renderer renderer, GraphChartContainer.DisplayCell cell) {
            Rectangle newGraphArea = cell.getGraphArea();
            PieGraphChart.this.graphArea.update(newGraphArea.x, newGraphArea.y, newGraphArea.width, newGraphArea.height);
            if (PieGraphChart.this.pieGraph != null) {
                ((PieGraphChart)PieGraphChart.this).pieGraph.paintCell = cell.getGraphArea();
                PieGraphChart.this.pieGraph.graphAreaResized();
                PieGraphChart.this.notifyLayoutListener(((PieGraphChart)PieGraphChart.this).pieGraph.paintCell, null);
            }
        }

        @Override
        public boolean hasModelDataChanged() {
            return true;
        }

        @Override
        public void repaintDrawingArea(Renderer renderer) {
            if (renderer.getScreenHeight() > 10 && renderer.getScreenWidth() > 10) {
                renderer.setPaintArea(PieGraphChart.this.graphArea);
                renderer.clearDrawingArea();
                if (PieGraphChart.this.pieGraph != null) {
                    PieGraphChart.this.pieGraph.paintGraph(PieGraphChart.this.graphArea, PieGraphChart.this.getToolTipsProvider(((PieGraphChart)PieGraphChart.this).pieGraph.data));
                }
                renderer.saveScreen(PieGraphChart.this.graphArea, PieGraphChart.this);
            } else {
                renderer.restoreScreen(PieGraphChart.this);
            }
        }

        @Override
        public void postRestoredScreen(Renderer renderer) {
            if (PieGraphChart.this.pieGraph != null) {
                renderer.setPaintArea(PieGraphChart.this.graphArea);
                PieGraphChart.this.pieGraph.paintGraphTools(PieGraphChart.this.graphArea, PieGraphChart.this.getToolTipsProvider(((PieGraphChart)PieGraphChart.this).pieGraph.data));
            }
        }

        @Override
        public void mouseDownLeft(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            PieGraphChart.this.mouseController.mouseDownLeft(x, y);
            if (this.getPiePieceAt(x, y)) {
                PieGraphChart.this.mouseController.setLeftAction(14);
            } else {
                PieGraphChart.this.mouseController.setLeftAction(0);
            }
        }

        private boolean getPiePieceAt(int x, int y) {
            int idx;
            if (PieGraphChart.this.pieGraph != null && (idx = PieGraphChart.this.pieGraph.getPiePieceAt(x, y)) != -1) {
                PieGraphChart.this.mouseController.setSelectedGraph(PieGraphChart.this.pieGraph);
                PieGraphChart.this.mouseController.setSelectedPieIdx(idx);
                return true;
            }
            PieGraphChart.this.mouseController.setSelectedGraph(null);
            PieGraphChart.this.mouseController.setSelectedPieIdx(-1);
            return false;
        }

        @Override
        public void mouseDownRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            PieGraphChart.this.mouseController.mouseDownRight(x, y);
            PieGraphChart.this.mouseController.setRightAction(0);
        }

        @Override
        public void mouseHovered(Renderer renderer, int x, int y, GraphChartContainer.DisplayCell cell) {
            int idx;
            if (PieGraphChart.this.pieGraph != null && !((PieGraphChart)PieGraphChart.this).pieGraph.data.hasFixedTooltips() && (idx = PieGraphChart.this.pieGraph.getPiePieceAt(x, y)) > -1) {
                PieGraphToolTipProvider toolTipsProvider = PieGraphChart.this.getToolTipsProvider(((PieGraphChart)PieGraphChart.this).pieGraph.data);
                String toolTip = toolTipsProvider.provideToolTip(((PieGraphChart)PieGraphChart.this).pieGraph.data, ((PieGraphChart)PieGraphChart.this).pieGraph.data.getPieces().get(idx));
                if (toolTip != null && toolTip.length() > 0) {
                    renderer.provideToolTip(x, y, toolTip);
                }
                return;
            }
        }

        @Override
        public void mouseMoved(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMovedByLeftPressed(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMovedByRightPressed(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseUpLeft(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (PieGraphChart.this.mouseController.getLeftAction() == 14) {
                PieGraph graph = PieGraphChart.this.mouseController.getSelectedGraph();
                int idx = PieGraphChart.this.mouseController.getSelectedPieIdx();
                this.getPiePieceAt(x, y);
                if (PieGraphChart.this.mouseController.getSelectedPieIdx() == idx && PieGraphChart.this.mouseController.getSelectedGraph() == graph) {
                    PieGraphDataSet.PiePiece selection;
                    selection.setSelection(!(selection = graph.data.getPieces().get(idx)).isSelected());
                    PieGraphChart.this.notifyListenersSelection(graph.data, selection);
                    PieGraphChart.this.refresh();
                    PieGraphChart.this.notifyACC();
                }
                return;
            }
            if (PieGraphChart.this.graphArea.isIn(x, y) && PieGraphChart.this.pieGraph != null && ((PieGraphChart)PieGraphChart.this).pieGraph.paintCell.isIn(x, y)) {
                for (PieGraphDataSet.PiePiece p : ((PieGraphChart)PieGraphChart.this).pieGraph.data.getPieces()) {
                    if (!p.isSelected()) continue;
                    p.setSelection(false);
                    PieGraphChart.this.notifyListenersSelection(((PieGraphChart)PieGraphChart.this).pieGraph.data, p);
                }
                PieGraphChart.this.refresh();
                PieGraphChart.this.notifyACC();
            }
        }

        @Override
        public void mouseUpRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseDoubleClicked(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }
    };

    public PieGraphChart(GraphChartContainer chartsContainer) {
        this.chartsContainer = chartsContainer;
        this.mouseController = new PieGraphMouseActionController();
    }

    @Override
    public Renderer getRenderer() {
        return this.chartsContainer.getRenderer();
    }

    @Override
    public LegendPositionAnchor getDefaultLegedPosition() {
        return this.ANCHORS[0];
    }

    @Override
    public LegendPositionAnchor[] getLegendAnchors() {
        return this.ANCHORS;
    }

    @Override
    public void addGraph(PieGraphDataSet data) {
        switch (data.getGraphType()) {
            case Graph2D: {
                this.pieGraph = new Pie2DGraph(this.getRenderer(), data);
                break;
            }
            case Graph3D: {
                this.pieGraph = new Pie3DGraph(this.getRenderer(), data);
            }
        }
        this.notifyACC();
    }

    @Override
    public void addGraph(PieGraphDataSet graph, boolean secondary) {
        if (secondary) {
            throw new UnsupportedOperationException("Secondary y-axis is not supported by PieGraphChart");
        }
        this.addGraph(graph);
    }

    @Override
    public List<PieGraphDataSet> getAllGraphs() {
        if (this.pieGraph == null) {
            return new ArrayList<PieGraphDataSet>(0);
        }
        ArrayList<PieGraphDataSet> result = new ArrayList<PieGraphDataSet>(1);
        result.add(this.pieGraph.data);
        return result;
    }

    public PieGraph getPieGraph() {
        return this.pieGraph;
    }

    @Override
    public void removeAllGraphs() {
        this.pieGraph = null;
        this.refresh();
        this.notifyACC();
    }

    @Override
    public void refresh() {
        this.actionListener.repaintDrawingArea(this.chartsContainer.getRenderer());
        this.actionListener.postRestoredScreen(this.chartsContainer.getRenderer());
        this.chartsContainer.updateFullScreen();
    }

    public void enableTransparentFixedToolTips(boolean enable) {
        this.pieGraph.enableTransparentFixedToolTips(enable);
    }

    public void setToolTipsProvider(PieGraphDataSet pie, PieGraphToolTipProvider provider) {
        if (provider == null && this.toolTipsProviders.containsKey(pie)) {
            this.toolTipsProviders.remove(pie);
        } else {
            this.toolTipsProviders.put(pie, provider);
        }
    }

    public PieGraphToolTipProvider getToolTipsProvider(PieGraphDataSet pie) {
        return this.toolTipsProviders.containsKey(pie) ? this.toolTipsProviders.get(pie) : this.DEFAULT_TOOLTIPS;
    }

    public void addSelectionListener(PieGraphDataSet pie, PieGraphSelectionListener listener) {
        if (!this.listeners.containsKey(pie)) {
            this.listeners.put(pie, new ArrayList());
        }
        if (!this.listeners.get(pie).contains(listener)) {
            this.listeners.get(pie).add(listener);
        }
    }

    public void removeSelectionListener(PieGraphSelectionListener listener) {
        for (List<PieGraphSelectionListener> l : this.listeners.values()) {
            if (!l.contains(listener)) continue;
            l.remove(listener);
        }
    }

    private void notifyListenersSelection(PieGraphDataSet set, PieGraphDataSet.PiePiece piece) {
        try {
            if (this.listeners.containsKey(set)) {
                for (PieGraphSelectionListener l : this.listeners.get(set)) {
                    l.selectionChanged(set, piece);
                }
            }
        }
        catch (Throwable th) {
            Trace.error((Throwable)th);
        }
    }

    public void changeSelectionState(String name) {
        if (this.pieGraph == null) {
            return;
        }
        HashMap<PieGraphDataSet.PiePiece, PieGraphDataSet> toBeSelected = new HashMap<PieGraphDataSet.PiePiece, PieGraphDataSet>();
        boolean toSelect = false;
        if (this.pieGraph.data.getPieces().size() > 1) {
            for (PieGraphDataSet.PiePiece piePiece : this.pieGraph.data.getPieces()) {
                if (!piePiece.getName().equals(name)) continue;
                toBeSelected.put(piePiece, this.pieGraph.data);
                if (piePiece.isSelected()) continue;
                toSelect = true;
            }
        }
        for (Map.Entry entry : toBeSelected.entrySet()) {
            boolean changedSel = ((PieGraphDataSet.PiePiece)entry.getKey()).isSelected() != toSelect;
            ((PieGraphDataSet.PiePiece)entry.getKey()).setSelection(toSelect);
            if (!changedSel) continue;
            this.notifyListenersSelection((PieGraphDataSet)entry.getValue(), (PieGraphDataSet.PiePiece)entry.getKey());
        }
        this.refresh();
        this.notifyACC();
    }

    public void resetSelection(boolean focusReset, boolean silent) {
        if (this.pieGraph == null) {
            return;
        }
        for (PieGraphDataSet.PiePiece p : this.pieGraph.data.getPieces()) {
            if (!p.isSelected()) continue;
            p.setSelection(false);
            if (silent) continue;
            this.notifyListenersSelection(this.pieGraph.getDataSet(), p);
        }
        this.notifyACC();
    }

    public void resetSelection(PieGraphDataSet pie, boolean silent) {
        if (this.pieGraph == null) {
            return;
        }
        if (this.pieGraph.data == pie) {
            for (PieGraphDataSet.PiePiece p : this.pieGraph.data.getPieces()) {
                if (!p.isSelected()) continue;
                p.setSelection(false);
                if (silent) continue;
                this.notifyListenersSelection(this.pieGraph.getDataSet(), p);
            }
            this.notifyACC();
            return;
        }
    }

    public void setSelection(PieGraphDataSet data, PieGraphDataSet.PiePiece piece, boolean selectionState, boolean withListeners) {
        if (piece != null) {
            piece.setSelection(selectionState);
            if (withListeners) {
                this.notifyListenersSelection(data, piece);
            }
        }
    }

    public PieSelectedPieces[] getSelection() {
        if (this.pieGraph == null) {
            return new PieSelectedPieces[0];
        }
        ArrayList<PieSelectedPiecesImpl> pieces = new ArrayList<PieSelectedPiecesImpl>();
        PieSelectedPiecesImpl p = new PieSelectedPiecesImpl(this.pieGraph.getDataSet());
        if (p.getSelectedPieces() != null) {
            pieces.add(p);
        }
        return pieces.isEmpty() ? new PieSelectedPieces[]{} : pieces.toArray(new PieSelectedPieces[pieces.size()]);
    }

    @Override
    public void keyNext() {
        if (this.pieGraph != null) {
            for (PieGraphDataSet.PiePiece piece : this.pieGraph.getDataSet().getPieces()) {
                if (piece.isSelected()) continue;
                this.setSelection(this.pieGraph.getDataSet(), piece, true, true);
                this.refresh();
                this.notifyACC();
                return;
            }
        }
    }

    @Override
    public void keyPrevious() {
        if (this.pieGraph != null) {
            ArrayList<PieGraphDataSet.PiePiece> list = this.pieGraph.getDataSet().getPieces();
            for (int i = list.size() - 1; i >= 0; --i) {
                PieGraphDataSet.PiePiece piece = (PieGraphDataSet.PiePiece)list.get(i);
                if (!piece.isSelected()) continue;
                this.setSelection(this.pieGraph.getDataSet(), piece, false, true);
                this.refresh();
                this.notifyACC();
                return;
            }
        }
    }

    @Override
    public ChartsContainerActionListener provideContainerListener() {
        return this.actionListener;
    }

    @Override
    public String getAccessibleControlName() {
        return I18n._s((String)"Pie Chart");
    }

    @Override
    public String getAccessibleStateText() {
        StringBuilder text = new StringBuilder();
        List<PieGraphDataSet> graphs = this.getAllGraphs();
        for (int i = 0; i < graphs.size(); ++i) {
            PieGraphDataSet pie;
            if (i > 0) {
                text.append(", ");
            }
            if ((pie = graphs.get(i)).getName() != null) {
                text.append(I18n._s((String)"Graph {0}", (Object[])new Object[]{pie.getName()}));
                text.append(", ");
            }
            boolean empty = true;
            StringBuilder selectionTxt = new StringBuilder();
            for (PieGraphDataSet.PiePiece p : pie.getPieces()) {
                String toolTip;
                if (!p.isSelected()) continue;
                if (!empty) {
                    selectionTxt.append(", ");
                }
                empty = false;
                selectionTxt.append(I18n._s((String)"{0} % piece selected with the name {1}", (Object[])new Object[]{p.getPercent(), p.getName()}));
                selectionTxt.append(", ");
                if (!this.toolTipsProviders.containsKey(pie) || (toolTip = this.toolTipsProviders.get(pie).provideToolTip(pie, p)) == null || (toolTip = toolTip.trim()).length() <= 0) continue;
                selectionTxt.append(" tooltip, ");
                selectionTxt.append(toolTip);
            }
            if (empty) {
                text.append(I18n._s((String)"Nothing selected."));
                continue;
            }
            text.append((CharSequence)selectionTxt);
        }
        return text.toString();
    }

    private static class PieSelectedPiecesImpl
    implements PieSelectedPieces {
        private PieGraphDataSet data;
        private PieGraphDataSet.PiePiece[] selection;

        public PieSelectedPiecesImpl(PieGraphDataSet data) {
            this.data = data;
            ArrayList<PieGraphDataSet.PiePiece> pieces = new ArrayList<PieGraphDataSet.PiePiece>();
            for (PieGraphDataSet.PiePiece p : data.getPieces()) {
                if (!p.isSelected()) continue;
                pieces.add(p);
            }
            if (!pieces.isEmpty()) {
                this.selection = pieces.toArray(new PieGraphDataSet.PiePiece[pieces.size()]);
            }
        }

        @Override
        public PieGraphDataSet getDataSet() {
            return this.data;
        }

        @Override
        public PieGraphDataSet.PiePiece[] getSelectedPieces() {
            return this.selection;
        }
    }

    public static interface PieSelectedPieces {
        public PieGraphDataSet getDataSet();

        public PieGraphDataSet.PiePiece[] getSelectedPieces();
    }
}

