/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.RangeLineTableContainer;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisRasterAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.RangeLineDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.RangeLineTableDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.ui.graph.renderer.Image;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RangeLineTableCellRenderer {
    protected static final int MIN_IMG_SIZE = 16;
    protected static final int TABLE_MAIN_SASH_SPACE = 5;
    protected static final int TABLE_SASH_SPACE = 2;
    protected static final int TABLE_LINE_SPACE = 2;
    protected static final int MIN_COLUMN_WIDTH = 15;
    protected static final int CELL_MARGIN_WIDTH = 5;
    protected static final int CELL_MARGIN_HEIGHT = 2;
    protected static final int CELL_MARGIN_HEADER_HEIGHT = 2;
    protected static final int CELL_V_SPACE = 5;
    protected static final int SCALE_TEXT_SPACE = 7;
    private final RangeLineAxisModel axis_model = new RangeLineAxisModel();
    private long raster = 0L;
    private Color clAxis = Color.BLACK;
    private Color clAxisGrid = Color.LIGHT_GRAY;
    private Color clAxisText = Color.BLACK;
    private Map<RangeLineDataSet.TimeStamp, Rectangle> visibleTimeStamps = new HashMap<RangeLineDataSet.TimeStamp, Rectangle>();
    private Map<RangeLineDataSet.Range, Rectangle> visibleRanges = new HashMap<RangeLineDataSet.Range, Rectangle>();
    private RangeLineAxisCaptionProvider axis_provider = new RangeLineAxisCaptionProvider(){

        @Override
        public String getAxisCaption() {
            return "";
        }

        @Override
        public String getValueCaption(long value, long step) {
            return String.valueOf(value);
        }

        @Override
        public String getFirstValueCaption(long value, long step) {
            return this.getValueCaption(value, step);
        }

        @Override
        public String getLastValueCaption(long value, long step) {
            return this.getValueCaption(value, step);
        }
    };
    private Renderer renderer;
    private RangeLineTableContainer container;
    private Font headerFont;
    private Font cellFont;

    public RangeLineTableCellRenderer(Renderer renderer, RangeLineTableContainer container) {
        this.renderer = renderer;
        this.container = container;
        this.cellFont = renderer.getFont();
        this.headerFont = new Font(this.cellFont.getName(), this.cellFont.getSize(), Font.Style.BOLD);
    }

    public void renderTableHeaderCell(int column, Rectangle cell, RangeLineTableDataSet.TableGroup group) {
        if (group.getColumnName(column) != null) {
            this.renderer.setPaintArea(cell);
            this.renderer.setFont(this.headerFont);
            RangeLineTableDataSet.TableGroup.Align alignment = group.getColumnHeaderAlignment(column);
            Image img = group.getColumnImage(column);
            String text = group.getColumnName(column);
            int pos = 5;
            int width = this.renderer.getStringWidth(text);
            if (img != null) {
                width += img.getBounds().width + 5;
                if (alignment == RangeLineTableDataSet.TableGroup.Align.CENTER) {
                    pos = cell.width / 2 - width / 2;
                } else if (alignment == RangeLineTableDataSet.TableGroup.Align.RIGHT) {
                    pos = cell.width - width - 5;
                }
                this.renderer.drawImage(img, pos, this.renderer.getHeight() / 2 + img.getBounds().height / 2);
                pos += img.getBounds().width + 5;
            } else if (alignment == RangeLineTableDataSet.TableGroup.Align.CENTER) {
                pos = cell.width / 2 - width / 2;
            } else if (alignment == RangeLineTableDataSet.TableGroup.Align.RIGHT) {
                pos = cell.width - width - 5;
            }
            this.renderer.drawString(text, pos, this.renderer.getHeight() / 2 + this.renderer.getFontHeight() / 2);
        }
        this.renderer.setPaintArea(null);
    }

    public void renderTableCell(int column, Rectangle cell, RangeLineTableDataSet data, Color textColor, boolean focused) {
        RangeLineTableDataSet.TableGroup.Align alignment = data.getGroup().getColumnAlignment(column);
        String text = data.getValue(column);
        Image img = column == 0 ? data.getIcon() : data.getIcon(column);
        this.renderer.setPaintArea(cell);
        if (focused) {
            this.renderer.setAlpha(140);
            this.renderer.fillRectangle(0, cell.height - 1, cell.width, cell.height);
            this.renderer.drawFocus(0, cell.height - 1, cell.width, cell.height);
            this.renderer.setAlpha(255);
        }
        if (text != null) {
            this.renderer.setFont(this.cellFont);
            int posX = 5;
            int posY = cell.height / 2;
            int width = this.renderer.getStringWidth(text);
            if (img != null) {
                width += img.getBounds().width + 5;
                if (alignment == RangeLineTableDataSet.TableGroup.Align.CENTER) {
                    posX = cell.width / 2 - width / 2;
                } else if (alignment == RangeLineTableDataSet.TableGroup.Align.RIGHT) {
                    posX = cell.width - width - 5;
                }
                this.renderer.drawImage(img, posX, posY + img.getBounds().height / 2);
                posX += 5 + img.getBounds().width;
            } else if (alignment == RangeLineTableDataSet.TableGroup.Align.CENTER) {
                posX = cell.width / 2 - width / 2;
            } else if (alignment == RangeLineTableDataSet.TableGroup.Align.RIGHT) {
                posX = cell.width - width - 5;
            }
            this.renderer.setForeground(textColor);
            this.renderer.drawString(text, posX, posY + this.renderer.getFontHeight() / 2);
        }
        this.renderer.setPaintArea(null);
    }

    public void paintAxis(Rectangle top, Rectangle bottom, Rectangle graph) {
        int x = this.axis_model.getPixelPosition(this.axis_model.getMin());
        this.raster = this.axis_model.calculateRaster();
        this.renderer.setFont(this.cellFont);
        int lineHeightOffset = graph.height - top.height;
        int scale_count = (int)(this.axis_model.getRange() / this.raster);
        int last_text_pos = 0;
        for (int i = 0; i <= scale_count; ++i) {
            long value = (long)i * this.raster;
            x = this.axis_model.toPixels(value);
            String text = null;
            if (i == 0) {
                text = this.axis_provider.getFirstValueCaption(this.axis_model.getMin() + value, this.raster);
            } else if (x > last_text_pos) {
                String string = text = scale_count == i ? this.axis_provider.getLastValueCaption(this.axis_model.getMin() + value, this.raster) : this.axis_provider.getValueCaption(this.axis_model.getMin() + value, this.raster);
            }
            if (text != null) {
                this.renderer.setPaintArea(graph, top);
                last_text_pos = this.paintScale(x, graph.height, text);
                this.renderer.setPaintArea(graph, bottom);
                this.paintScale(x, 0, text);
            }
            this.renderer.setPaintArea(graph);
            this.paintRasterLine(x, lineHeightOffset);
        }
        this.renderer.setPaintArea(graph);
        this.paintRasterLine(graph.width - 1, lineHeightOffset);
        this.renderer.drawLine(0, lineHeightOffset, graph.width - 1, lineHeightOffset);
        this.renderer.drawLine(0, 0, graph.width - 1, 0);
        this.renderer.setPaintArea(null);
    }

    private int paintScale(int x, int y, String caption) {
        if (caption != null) {
            this.renderer.setForeground(this.clAxis);
            int txt_width = this.renderer.getStringWidth(caption) / 2;
            this.renderer.setForeground(this.clAxisText);
            this.renderer.drawString(caption, x - txt_width, y);
            return x + txt_width * 2 + 7;
        }
        return x;
    }

    private void paintRasterLine(int x, int y) {
        this.renderer.setForeground(this.clAxisGrid);
        this.renderer.setLineStyle(Renderer.LineType.LINE_DOT);
        this.renderer.drawLine(x, y, x, 0);
        this.renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
        this.renderer.setForeground(this.clAxis);
        this.renderer.drawLine(x, y, x, y - 2);
        this.renderer.drawLine(x, 0, x, 2);
    }

    public void paintLine(Rectangle line, RangeLineDataSet data, boolean header, boolean focused) {
        ArrayList<RangeLineDataSet.Range> shownList = new ArrayList<RangeLineDataSet.Range>();
        List<RangeLineDataSet.Range> ranges = data.getAllRanges();
        for (int i = 0; i < ranges.size(); ++i) {
            RangeLineDataSet.Range next = ranges.get(i);
            if (!this.axis_model.isInAxisRange(next)) continue;
            if (next.getType().isSpace() || this.axis_model.toPixels(next.getSize()) > 0) {
                shownList.add(next);
                continue;
            }
            MixedRange mixedRange = new MixedRange();
            shownList.add(mixedRange);
            do {
                mixedRange.update(next);
                if (++i == ranges.size()) break;
                next = ranges.get(i);
                if (this.axis_model.toPixels(next.getSize()) == 0) continue;
                --i;
                break;
            } while (this.axis_model.isInAxisRange(next));
            mixedRange.mixColor();
        }
        int lineHeight = header ? (int)((double)line.height * 0.75) : line.height;
        int lineYOffset = header ? line.y - 1 : line.y;
        for (int i = 0; i < shownList.size(); ++i) {
            RangeLineDataSet.Range next = (RangeLineDataSet.Range)shownList.get(i);
            if (i + 1 < shownList.size() && ((RangeLineDataSet.Range)shownList.get(i + 1)).getType() == next.getType()) {
                MeltedRange mRange = new MeltedRange(next);
                do {
                    next = (RangeLineDataSet.Range)shownList.get(++i);
                    mRange.update(next);
                } while (i + 1 < shownList.size() && ((RangeLineDataSet.Range)shownList.get(i + 1)).getType() == next.getType());
                next = mRange;
            }
            if (next.getType().isSpace()) continue;
            int x_start = line.x + this.axis_model.getPixelPosition(next.getMinValue());
            int width = this.axis_model.getPixelPosition(next.getMaxValue(), line.x) - x_start - 1;
            this.paintRange(next, x_start, lineYOffset, width, lineHeight);
        }
        for (RangeLineDataSet.TimeStamp ts : data.getAllTimeStamps()) {
            if (!this.axis_model.isInAxisRange(ts.getValue())) continue;
            this.paintTimeStamp(line, ts);
        }
        if (focused) {
            this.renderer.drawFocus(line.x, line.y, line.width, line.height + 2);
        }
    }

    private void paintTimeStamp(Rectangle line, RangeLineDataSet.TimeStamp data) {
        this.renderer.setForeground(Color.DARK_GRAY);
        this.renderer.setFillColor(Color.LIGHT_GRAY);
        int start_pos = line.x + this.axis_model.getPixelPosition(data.getValue());
        int[] arrow = new int[]{start_pos - 3, line.y - 3, start_pos, line.y - 3, start_pos, line.y};
        int[] shadow = new int[]{start_pos - 4, line.y - 5, start_pos + 2, line.y - 5, start_pos + 2, line.y};
        this.renderer.fillPolygon(shadow);
        this.renderer.drawPolygon(arrow);
        this.renderer.setFillColor(Color.LIGHT_GRAY);
        this.renderer.fillRectangle(start_pos + 2, line.y - 7, 2, line.height - 4);
        this.renderer.setForeground(data.getBorderColor());
        this.renderer.setFillColor(data.getColor());
        this.renderer.fillRectangle(start_pos - 1, line.y - 5, 2, line.height - 4);
        this.renderer.drawRectangle(start_pos - 1, line.y - 5, 2, line.height - 4);
        this.visibleTimeStamps.put(data, new Rectangle(start_pos - 3, line.y, 5, line.height));
    }

    private void paintRange(RangeLineDataSet.Range range, int x, int y, int width, int height) {
        if (width <= 0) {
            this.renderer.setFillColor(Color.LIGHT_GRAY);
            Rectangle rec = new Rectangle(x + 2, y - 3, 2, height + 1);
            rec.fillRectangle(this.renderer);
            this.renderer.setForeground(range.getType().getBorderColor());
            this.renderer.drawLine(x, y, x, y - height);
            this.visibleRanges.put(range, rec);
        } else {
            this.renderer.setFillColor(Color.LIGHT_GRAY);
            Rectangle rec = new Rectangle(x, y, width, height);
            rec.fillShadowRectangle(this.renderer);
            this.renderer.setFillColor(range.getType().getColor());
            rec.fillRectangle(this.renderer);
            this.renderer.setForeground(range.getType().getBorderColor());
            rec.drawRectangle(this.renderer);
            this.visibleRanges.put(range, rec);
        }
    }

    public void provideToolTip(Renderer source, int x, int y) {
        for (Map.Entry<RangeLineDataSet.TimeStamp, Rectangle> entry : this.visibleTimeStamps.entrySet()) {
            if (!entry.getValue().isIn(x, y)) continue;
            source.provideToolTip(entry.getValue().x + entry.getValue().width, entry.getValue().y, entry.getKey().getTooltip());
            return;
        }
        for (Map.Entry<Object, Rectangle> entry : this.visibleRanges.entrySet()) {
            if (!entry.getValue().isIn(x, y)) continue;
            if (((RangeLineDataSet.Range)entry.getKey()).getToolTip() != null) {
                source.provideToolTip(x, y, ((RangeLineDataSet.Range)entry.getKey()).getToolTip());
            }
            return;
        }
    }

    public RangeLineDataSet.TimeStamp getTimeStamp(RangeLineDataSet data, int x, int y) {
        for (RangeLineDataSet.TimeStamp ts : data.getAllTimeStamps()) {
            if (!this.visibleTimeStamps.containsKey(ts) || !this.visibleTimeStamps.get(ts).isIn(x, y)) continue;
            return ts;
        }
        return null;
    }

    public void clearVisibleTSCache() {
        this.visibleTimeStamps.clear();
        this.visibleRanges.clear();
    }

    void setAxisCaptionProvider(RangeLineAxisCaptionProvider provider) {
        this.axis_provider = provider;
    }

    void setRasterAdapter(RangeLineAxisRasterAdapter adapter) {
        this.axis_model.setRasterAdapter(adapter);
    }

    long getRasterSize() {
        return this.raster;
    }

    RangeLineAxisModel getAxesModel() {
        return this.axis_model;
    }

    long getAxisRange() {
        return this.axis_model.getRange();
    }

    RangeLineAxisModel getAxisModel() {
        return this.axis_model;
    }

    long getAxisValue(int pixels) {
        return this.axis_model.getMin() + Math.round(this.axis_model.toValue(pixels));
    }

    void updateAxisModel(RangeLineDataSet data) {
        this.axis_model.updateRange(data.getMinValue(), data.getMaxValue());
    }

    void updateAxisModelScreenWidth(int width) {
        this.axis_model.setScreenWidth(width);
    }

    int getAvgAxisCaptionWidth() {
        return this.renderer.getStringWidth(this.axis_provider.getLastValueCaption(this.axis_model.getMax(), this.axis_model.calculateRaster()));
    }

    void setAxisColor(Color color) {
        this.clAxis = color;
    }

    void setAxisGridColor(Color color) {
        this.clAxisGrid = color;
    }

    void setAxisTextColor(Color color) {
        this.clAxisText = color;
    }

    public void packAxis() {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (RangeLineTableDataSet.TableGroup group : this.container.getGroups()) {
            for (RangeLineTableDataSet line : this.container.getItems(group)) {
                min = line.getMinValue() < min ? line.getMinValue() : min;
                max = line.getMaxValue() > max ? line.getMaxValue() : max;
            }
            if (group.getRangeLine() == null) continue;
            min = group.getRangeLine().getMinValue() < min ? group.getRangeLine().getMinValue() : min;
            max = group.getRangeLine().getMaxValue() > max ? group.getRangeLine().getMaxValue() : max;
        }
        this.axis_model.setRange(min, max);
    }

    private static class MeltedRange
    extends RangeLineDataSet.Range {
        public MeltedRange(RangeLineDataSet.Range range) {
            super(range.getMinValue(), range.getMaxValue(), range.getType());
        }

        void update(RangeLineDataSet.Range next) {
            this.max = next.getMaxValue();
            this.size = this.max - this.min;
        }
    }

    private static class MixedRange
    extends RangeLineDataSet.Range {
        Set<RangeLineDataSet.RangeType> types = new HashSet<RangeLineDataSet.RangeType>();

        public MixedRange() {
            super(0L, 0L, null);
        }

        void update(RangeLineDataSet.Range next) {
            if (this.type == null) {
                this.type = RangeLineDataSet.createType("MIXED", "...", Color.BLUE);
                this.min = next.getMinValue();
            }
            this.types.add(next.getType());
            this.max = next.getMaxValue();
            this.size = this.max - this.min;
        }

        void mixColor() {
            int r = 0;
            int g = 0;
            int b = 0;
            for (RangeLineDataSet.RangeType t : this.types) {
                r += t.getColor().red;
                g += t.getColor().green;
                b += t.getColor().blue;
            }
            this.type.setColor(new Color(r /= this.types.size(), g /= this.types.size(), b /= this.types.size()));
        }
    }
}

