/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.RangeLineSelectionListener;
import com.sap.jvm.profiling.ui.graph.RangeLineTableCellRenderer;
import com.sap.jvm.profiling.ui.graph.RangeLineTableContainer;
import com.sap.jvm.profiling.ui.graph.RangeLineTableRangeSelector;
import com.sap.jvm.profiling.ui.graph.RangeLineTableValueBar;
import com.sap.jvm.profiling.ui.graph.RangeTableGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisRasterAdapter;
import com.sap.jvm.profiling.ui.graph.axes.RasterAnchorsList;
import com.sap.jvm.profiling.ui.graph.dataset.RangeLineDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.RangeLineTableDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.layouting.RangeLineTableLayoutListener;
import com.sap.jvm.profiling.ui.graph.mouse.RangeTableGraphMouseController;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import com.sap.jvm.profiling.ui.graph.renderer.RendererActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RangeLineTableChart
implements RendererActionListener {
    private Renderer renderer;
    private RangeLineTableContainer container;
    private RangeLineTableCellRenderer cellRenderer;
    private Rectangle mainScreen = new Rectangle();
    private Rectangle minScreen = new Rectangle();
    private Rectangle axisScreenTop = new Rectangle();
    private Rectangle axisScreenBottom = new Rectangle();
    private Rectangle tableScreen = new Rectangle();
    private Rectangle graphScreen = new Rectangle();
    private Map<Object, Line> contents = new LinkedHashMap<Object, Line>();
    private List<Rectangle> tableSashes = new ArrayList<Rectangle>();
    private Rectangle mainSash = new Rectangle();
    private int sashIndex = 0;
    private RangeLineTableDataSet selection = null;
    private int focusedCol = 0;
    private RangeTableGraphMouseController mouseController;
    private Color selectionColor;
    private Color selectionTextColor;
    private List<RangeLineSelectionListener<RangeLineTableDataSet>> selectionListeners = new ArrayList<RangeLineSelectionListener<RangeLineTableDataSet>>();
    private boolean linesSelectable = true;
    private RangeLineTableRangeSelector rangeSelector;
    private RangeLineTableValueBar valueBar;
    private boolean show_table = true;
    private boolean show_graph_axis = true;
    private RangeLineAxisCaptionProvider axisCaptionProvider;
    private RangeLineTableLayoutListener layoutListener;
    boolean selDirectionRight = true;
    private String accName;

    public RangeLineTableChart(Renderer renderer) {
        this.renderer = renderer;
        renderer.addRendererActionListener(this);
        this.container = new RangeLineTableContainer(renderer);
        this.cellRenderer = new RangeLineTableCellRenderer(renderer, this.container);
        this.rangeSelector = new RangeLineTableRangeSelector(renderer, this.cellRenderer.getAxisModel());
        this.valueBar = new RangeLineTableValueBar(renderer, this.cellRenderer.getAxisModel());
        this.mouseController = new RangeTableGraphMouseController();
        this.selectionColor = renderer.getDefaultSelectionColor();
        this.selectionTextColor = renderer.getDefaultSelectionTextColor();
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void adjustAxes(long min, long max) {
        this.cellRenderer.getAxesModel().setRange(min, max);
    }

    public void setLineSelectable(boolean selectable) {
        this.linesSelectable = selectable;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void initializedDrawingArea(Renderer source) {
        this.container.packTable();
        this.resizedDrawingArea(source);
    }

    @Override
    public void resizedDrawingArea(Renderer source) {
        this.mainScreen.update(0, source.getHeight(), source.getWidth() - 1, source.getHeight() - 1);
        this.axisScreenTop.update(this.mainScreen.x, this.mainScreen.y, this.mainScreen.width, this.show_graph_axis ? source.getFontHeight() : 4);
        if (this.container.getTableWidth() > this.mainScreen.width - this.container.getMinTableWidth()) {
            this.container.setTableWidth(this.mainScreen.width - this.container.getMinTableWidth());
        }
        if (this.show_table) {
            this.tableScreen.update(this.mainScreen.x, this.axisScreenTop.y_end, this.container.getTableWidth(), this.mainScreen.height - this.axisScreenTop.height);
            this.mainSash.update(this.tableScreen.x_end, this.tableScreen.y, 5, this.tableScreen.height);
            this.graphScreen.update(this.mainSash.x_end, this.axisScreenTop.y, this.mainScreen.x_end - this.mainSash.x_end, this.mainScreen.height);
        } else {
            this.tableScreen.update(this.mainScreen.x, this.axisScreenTop.y_end, 0, this.mainScreen.height - this.axisScreenTop.height);
            this.mainSash.update(this.tableScreen.x_end, this.tableScreen.y, 0, this.tableScreen.height);
            this.graphScreen.update(this.mainSash.x_end, this.axisScreenTop.y, this.mainScreen.x_end - this.mainSash.x_end, this.mainScreen.height);
        }
        this.cellRenderer.updateAxisModelScreenWidth(this.graphScreen.width);
        this.contents.clear();
        int offset = this.tableScreen.y;
        int fontHeight = this.renderer.getFontHeight() < 16 ? 16 : this.renderer.getFontHeight();
        for (RangeLineTableDataSet.TableGroup group : this.container.getGroups()) {
            if ((group.getRangeLine() == null || group.getRangeLine().isEmpty()) && this.container.getItems(group).isEmpty()) continue;
            Line header = new Line(this.container.getColumnCount(), new Rectangle(this.tableScreen.x, offset, this.mainScreen.width, fontHeight + 4), true);
            offset = header.getLineArea().y_end - 2;
            header.updateGraphArea(this.graphScreen);
            this.contents.put(group, header);
            for (RangeLineTableDataSet item : this.container.getItems(group)) {
                Line line = new Line(this.container.getColumnCount(), new Rectangle(this.tableScreen.x, offset, this.mainScreen.width, fontHeight + 4), false);
                offset = line.getLineArea().y_end - 2;
                line.updateGraphArea(this.graphScreen);
                this.contents.put(item, line);
            }
        }
        this.tableScreen.update(this.tableScreen.width, this.tableScreen.height - offset);
        this.graphScreen.update(this.graphScreen.width, this.graphScreen.height - offset);
        this.mainSash.update(this.mainSash.width, this.mainSash.height - offset);
        this.axisScreenBottom.update(this.mainScreen.x, this.tableScreen.y_end, this.mainScreen.width, this.show_graph_axis ? fontHeight : 0);
        this.minScreen.update(this.axisScreenTop.x, this.axisScreenTop.y, this.axisScreenTop.width, this.axisScreenTop.y - this.axisScreenBottom.y_end);
        this.layoutTable();
        this.repaintDrawingArea(source);
        this.notifyLayoutlisteners(this.contents);
    }

    private void notifyLayoutlisteners(Map<Object, Line> data) {
        if (this.layoutListener != null) {
            HashMap<Object, Rectangle> lines = new HashMap<Object, Rectangle>(data.size());
            for (Map.Entry<Object, Line> item : data.entrySet()) {
                lines.put(item.getKey(), item.getValue().lineArea);
            }
            this.layoutListener.layoutChanged(lines);
        }
    }

    @Override
    public void repaintDrawingArea(Renderer source) {
        this.renderer.setPaintArea(null);
        this.renderer.clearDrawingArea();
        if (this.container.isEmpty()) {
            this.renderer.showScreenBuffer();
            return;
        }
        Line selectedLine = null;
        if (this.selection != null) {
            selectedLine = this.contents.get(this.selection);
            if (selectedLine == null) {
                this.selection = null;
            } else {
                this.renderer.setFillColor(this.selectionColor);
                if (this.renderer.isFocused()) {
                    this.renderer.fillRectangle(selectedLine.getLineArea().x, selectedLine.getLineArea().y, this.tableScreen.width, selectedLine.getLineArea().height);
                } else {
                    this.renderer.setAlpha(30);
                    this.renderer.fillRectangle(selectedLine.getLineArea().x, selectedLine.getLineArea().y, this.tableScreen.width, selectedLine.getLineArea().height);
                    this.renderer.setAlpha(255);
                }
                this.renderer.setDefaultColors();
            }
        }
        if (this.show_table) {
            this.repaintTableArea(false);
        }
        this.repaintGraphArea(false);
        this.renderer.showScreenBuffer();
    }

    private void repaintGraphArea(boolean standalon) {
        if (standalon) {
            Object line;
            this.renderer.setDefaultColors();
            this.renderer.fillRectangle(this.graphScreen.x, this.graphScreen.y, this.graphScreen.width, this.graphScreen.height);
            this.renderer.fillRectangle(this.axisScreenTop.x, this.axisScreenTop.y, this.axisScreenTop.width, this.axisScreenTop.height);
            this.renderer.fillRectangle(this.axisScreenBottom.x, this.axisScreenBottom.y, this.axisScreenBottom.width, this.axisScreenBottom.height);
            if (this.selection != null && (line = this.contents.get(this.selection)) == null) {
                this.selection = null;
            }
        }
        if (this.cellRenderer.getAxisModel().getRange() > 0L) {
            for (Map.Entry<Object, Line> entry : this.contents.entrySet()) {
                if (!entry.getValue().isHeader) continue;
                this.renderer.setForeground(Color.LIGHT_GRAY);
                this.renderer.setFillColor(Color.LIGHT_GRAY);
                this.renderer.fillRectangle(entry.getValue().getGraphArea().x, entry.getValue().getLineArea().y, this.graphScreen.width, entry.getValue().getLineArea().height);
                this.renderer.setDefaultColors();
            }
            if (this.show_graph_axis) {
                this.cellRenderer.paintAxis(this.axisScreenTop, this.axisScreenBottom, this.graphScreen);
            }
            this.cellRenderer.clearVisibleTSCache();
            Line lastLine = null;
            for (Map.Entry<Object, Line> entry : this.contents.entrySet()) {
                if (entry.getValue().isHeader()) {
                    RangeLineDataSet data = ((RangeLineTableDataSet.TableGroup)entry.getKey()).getRangeLine();
                    if (data != null) {
                        this.cellRenderer.paintLine(entry.getValue().graphArea, data, true, false);
                    }
                } else {
                    boolean focused = this.renderer.isFocused() && entry.getKey() == this.selection && this.focusedCol == entry.getValue().cols.length;
                    this.cellRenderer.paintLine(entry.getValue().graphArea, (RangeLineDataSet)entry.getKey(), false, focused);
                }
                this.renderer.setForeground(entry.getValue().isHeader() ? Color.GRAY : Color.LIGHT_GRAY);
                if (lastLine != null && !lastLine.isHeader()) {
                    this.renderer.drawLine(lastLine.getGraphArea().x, lastLine.getLineArea().y_end, lastLine.getGraphArea().x_end, lastLine.getLineArea().y_end);
                }
                if (entry.getValue().isHeader()) {
                    this.renderer.drawLine(entry.getValue().getGraphArea().x, entry.getValue().getLineArea().y_end, entry.getValue().getGraphArea().x_end, entry.getValue().getLineArea().y_end);
                }
                lastLine = entry.getValue();
            }
        } else {
            Rectangle rec = new Rectangle(this.graphScreen.x, this.graphScreen.y - this.axisScreenTop.height, this.graphScreen.width - 1, this.graphScreen.height - this.axisScreenTop.height - 1);
            rec.drawAndFill(this.renderer, Color.DARK_GRAY, new Color(255, 244, 244));
        }
        this.renderer.saveScreen();
        if (!this.rangeSelector.drawSelection(this.graphScreen, this.axisScreenTop.height + 1) && this.valueBar.isEnabled()) {
            this.valueBar.drawValueBar(this.graphScreen, this.show_graph_axis);
        }
        if (standalon) {
            this.renderer.showScreenBuffer();
        }
    }

    private void layoutTable() {
        this.tableSashes.clear();
        int offset = this.tableScreen.x;
        boolean allIn = true;
        for (int i = 0; i < this.container.getColumnCount() - 1; ++i) {
            int width = this.container.getColumnWidth(i);
            Rectangle sash = new Rectangle(offset + width, this.tableScreen.y, 2, this.tableScreen.height);
            if (!this.tableScreen.isInXRange(sash)) {
                for (Line line : this.contents.values()) {
                    ((Line)line).cols[i] = new Rectangle(sash.x - width, line.getLineArea().y, width - (sash.x - this.mainSash.x), line.getLineArea().height);
                }
                allIn = false;
                break;
            }
            offset = sash.x_end;
            this.tableSashes.add(sash);
            for (Line line : this.contents.values()) {
                ((Line)line).cols[i] = new Rectangle(sash.x - width, line.getLineArea().y, width, line.getLineArea().height);
            }
        }
        if (allIn) {
            for (Line line : this.contents.values()) {
                ((Line)line).cols[this.container.getColumnCount() - 1] = new Rectangle(offset, line.getLineArea().y, this.mainSash.x - offset, line.getLineArea().height);
            }
        }
    }

    private void repaintTableArea(boolean standalone) {
        if (standalone) {
            this.renderer.setDefaultColors();
            this.renderer.fillRectangle(this.tableScreen.x, this.tableScreen.y, this.tableScreen.width, this.tableScreen.height);
            if (this.selection != null) {
                Line line = this.contents.get(this.selection);
                if (line == null) {
                    this.selection = null;
                } else {
                    this.renderer.setFillColor(this.renderer.getDefaultSelectionColor());
                    if (this.renderer.isFocused()) {
                        this.renderer.fillRectangle(line.getLineArea().x, line.getLineArea().y, this.tableScreen.width, line.getLineArea().height);
                    } else {
                        this.renderer.setAlpha(30);
                        this.renderer.fillRectangle(line.getLineArea().x, line.getLineArea().y, this.tableScreen.width, line.getLineArea().height);
                        this.renderer.setAlpha(255);
                    }
                    this.renderer.setDefaultColors();
                }
            }
        }
        for (Map.Entry<Object, Line> entry : this.contents.entrySet()) {
            Line line = entry.getValue();
            if (line.isHeader()) {
                this.renderer.setAlpha(150);
                this.renderer.setForeground(this.renderer.getDefaultHeaderBackground());
                this.renderer.setFillColor(this.renderer.getDefaultInactiveHeaderBackground());
                this.renderer.fillGradientRectangle(line.getLineArea().x, line.getLineArea().y, this.tableScreen.width, line.getLineArea().height, true);
                this.renderer.setAlpha(255);
                this.renderer.setDefaultColors();
                this.renderer.drawRectangle(line.getLineArea().x, line.getLineArea().y_end + 2, this.tableScreen.width, 2);
                for (int i = 0; i < line.cols.length; ++i) {
                    if (line.cols[i] == null) continue;
                    this.cellRenderer.renderTableHeaderCell(i, line.cols[i], (RangeLineTableDataSet.TableGroup)entry.getKey());
                }
                continue;
            }
            this.renderer.setDefaultColors();
            this.renderer.drawLine(line.getLineArea().x, line.getLineArea().y_end, line.getLineArea().x + this.tableScreen.width, line.getLineArea().y_end);
            Color defaultTextColor = this.renderer.getForeground();
            RangeLineTableDataSet data = (RangeLineTableDataSet)entry.getKey();
            for (int i = 0; i < line.cols.length; ++i) {
                if (line.cols[i] == null) continue;
                this.cellRenderer.renderTableCell(i, line.cols[i], data, data == this.selection && this.renderer.isFocused() ? this.selectionTextColor : defaultTextColor, this.renderer.isFocused() && this.focusedCol == i && data == this.selection);
            }
            this.renderer.setDefaultColors();
        }
        for (Rectangle sash : this.tableSashes) {
            this.renderer.drawLine(sash.x, sash.y, sash.x, sash.y_end + 2);
        }
        this.renderer.setDefaultColors();
        this.renderer.fillRectangle(this.mainSash.x, this.mainSash.y, 2, this.mainSash.height - 1);
        this.renderer.setForeground(this.renderer.getDefaultForeground());
        this.renderer.drawRectangle(this.mainSash.x, this.mainSash.y, 2, this.mainSash.height - 1);
        this.renderer.drawRectangle(this.tableScreen.x, this.tableScreen.y, this.tableScreen.width, this.tableScreen.height - 1);
        if (standalone) {
            this.renderer.showScreenBuffer();
        }
    }

    @Override
    public void mouseDoubleClicked(Renderer source, int x, int y) {
        if (this.tableScreen.isIn(x, y)) {
            for (RangeLineTableDataSet.TableGroup group : this.container.getGroups()) {
                Line headerLine = this.contents.get(group);
                if (headerLine != null && headerLine.getLineArea().isIn(x, y)) {
                    for (int i = 0; i < headerLine.cols.length; ++i) {
                        if (!headerLine.cols[i].isIn(x, y)) continue;
                        if (i == headerLine.cols.length - 1) {
                            this.container.packColumn(i, true);
                            this.refresh();
                        } else {
                            this.container.packColumn(i, false);
                            this.refreshTable();
                        }
                        return;
                    }
                }
                for (RangeLineTableDataSet data : this.container.getItems(group)) {
                    Line line = this.contents.get(data);
                    if (!this.linesSelectable || line == null || !line.lineArea.isIn(x, y) && !line.graphArea.isIn(x, y)) continue;
                    this.notifyLineDoubleClickSelection(data);
                    return;
                }
            }
        }
        if (this.graphScreen.isIn(x, y)) {
            for (RangeLineTableDataSet.TableGroup group : this.container.getGroups()) {
                if (this.rangeSelector.isEnabled() && this.rangeSelector.isSelected()) continue;
                for (RangeLineTableDataSet data : this.container.getItems(group)) {
                    Line line = this.contents.get(data);
                    if (!this.linesSelectable || line == null || !line.graphArea.isIn(x, y)) continue;
                    this.notifyLineDoubleClickSelection(data);
                    return;
                }
            }
        }
    }

    private void notifyLineDoubleClickSelection(RangeLineTableDataSet data) {
        for (RangeLineSelectionListener<RangeLineTableDataSet> l : this.selectionListeners) {
            l.lineDoubleClickSelection(data);
        }
    }

    @Override
    public void mouseDownLeft(Renderer source, int x, int y) {
        this.mouseController.mouseDownLeft(x, y);
        if (this.mainSash.isIn(x, y)) {
            this.mouseController.setLeftAction(100);
        } else if (this.tableScreen.isIn(x, y)) {
            for (int i = 0; i < this.tableSashes.size(); ++i) {
                if (!this.tableSashes.get(i).isIn(x, y)) continue;
                this.mouseController.setLeftAction(101);
                this.sashIndex = i;
                return;
            }
            for (Map.Entry<Object, Line> entry : this.contents.entrySet()) {
                if (entry.getValue().isHeader() || !entry.getValue().getLineArea().isInYRange(y)) continue;
                RangeLineTableDataSet newSelection = (RangeLineTableDataSet)entry.getKey();
                int newFocusedCell = entry.getValue().getColIndex(x);
                if (newSelection == this.selection && newFocusedCell != this.focusedCol) {
                    this.focusedCol = newFocusedCell;
                    this.repaintDrawingArea(this.renderer);
                    if (this.linesSelectable) {
                        for (RangeLineSelectionListener<RangeLineTableDataSet> l : this.selectionListeners) {
                            l.cellSelected(this.selection, this.focusedCol);
                        }
                    }
                } else {
                    this.focusedCol = newFocusedCell;
                }
                this.setSelection(newSelection);
                this.mouseController.setLeftAction(102);
                return;
            }
        } else if (this.graphScreen.isIn(x, y)) {
            int x_trans = this.graphScreen.getXinRec(x);
            if (this.rangeSelector.isMinBorderHovered(x_trans)) {
                this.rangeSelector.setMaxAsStart();
                this.mouseController.setLeftAction(5);
                return;
            }
            if (this.rangeSelector.isMaxBorderHovered(x_trans)) {
                this.rangeSelector.setMinAsStart();
                this.mouseController.setLeftAction(6);
                return;
            }
            if (this.rangeSelector.isHovered(x_trans)) {
                this.mouseController.setLeftAction(7);
                return;
            }
            if (this.rangeSelector.isEnabled()) {
                this.rangeSelector.startSelection(x_trans);
                this.mouseController.setLeftAction(3);
                return;
            }
        }
    }

    @Override
    public void mouseDownRight(Renderer source, int x, int y) {
        this.mouseController.mouseDownRight(x, y);
    }

    @Override
    public void mouseUpLeft(Renderer source, int x, int y) {
        switch (this.mouseController.getLeftAction()) {
            case 7: {
                this.container.notifySelectionClickedOn();
                this.rangeSelector.resetSelection();
                this.container.notifySelectionReset();
                this.repaintGraphArea(true);
                break;
            }
            case 5: 
            case 6: {
                this.renderer.setCursor(Renderer.CursorType.CURSOR_RESIZE);
            }
            case 4: {
                if (this.rangeSelector.adaptSelectionToRaster()) {
                    this.renderer.restoreScreen();
                    this.renderer.setPaintArea(this.graphScreen);
                    if (this.rangeSelector.isSelected()) {
                        this.rangeSelector.drawSelection(this.graphScreen, this.axisScreenTop.height + 1);
                    } else {
                        this.container.notifySelectionReset();
                        this.valueBar.drawValueBar(this.graphScreen, this.show_graph_axis);
                    }
                    this.renderer.showScreenBuffer();
                }
                if (!this.rangeSelector.isSelected()) break;
                this.container.notifySelected(this.rangeSelector.getMin(), this.rangeSelector.getMax());
                break;
            }
            case 3: {
                if (this.rangeSelector.isSelected()) {
                    this.rangeSelector.resetSelection();
                    this.container.notifySelectionReset();
                    this.renderer.restoreScreen();
                    this.valueBar.drawValueBar(this.graphScreen, this.show_graph_axis);
                    this.renderer.showScreenBuffer();
                    break;
                }
                if (this.rangeSelector.isSelected()) break;
            }
            case 0: {
                if (!this.graphScreen.isIn(x, y)) break;
                this.rangeSelector.resetSelection();
                this.container.notifySelectionReset();
                this.repaintGraphArea(true);
                if (!this.linesSelectable) break;
                for (Map.Entry<Object, Line> entry : this.contents.entrySet()) {
                    if (entry.getValue().isHeader() || !entry.getValue().getGraphArea().isInYRange(y)) continue;
                    RangeLineTableDataSet newSelection = (RangeLineTableDataSet)entry.getKey();
                    int newFocusedCell = entry.getValue().cols.length;
                    if (newSelection == this.selection && newFocusedCell != this.focusedCol) {
                        this.focusedCol = newFocusedCell;
                        this.repaintDrawingArea(this.renderer);
                        if (this.linesSelectable) {
                            for (RangeLineSelectionListener<RangeLineTableDataSet> l : this.selectionListeners) {
                                l.rangeLineSelected(newSelection);
                            }
                        }
                    } else {
                        this.focusedCol = newFocusedCell;
                    }
                    this.setSelection((RangeLineTableDataSet)entry.getKey());
                }
                break;
            }
        }
    }

    @Override
    public void mouseUpRight(Renderer source, int x, int y) {
    }

    @Override
    public void mouseHovered(Renderer source, int x, int y) {
        this.cellRenderer.provideToolTip(source, x, y);
    }

    @Override
    public void mouseMoved(Renderer source, int x, int y) {
        int x_trans;
        this.renderer.setCursor(null);
        if (this.show_table && this.mainSash.isIn(x, y)) {
            this.renderer.setCursor(Renderer.CursorType.CURSOR_RESIZE);
        } else if (this.tableScreen.isIn(x, y)) {
            for (Rectangle sash : this.tableSashes) {
                if (!sash.isIn(x, y)) continue;
                this.renderer.setCursor(Renderer.CursorType.CURSOR_RESIZE);
                return;
            }
        } else if (this.graphScreen.isIn(x, y) && (this.rangeSelector.isMinBorderHovered(x_trans = this.graphScreen.getXinRec(x)) || this.rangeSelector.isMaxBorderHovered(x_trans))) {
            this.renderer.setCursor(Renderer.CursorType.CURSOR_RESIZE);
        }
    }

    @Override
    public void mouseMovedByLeftPressed(Renderer source, int x, int y) {
        switch (this.mouseController.getLeftAction()) {
            case 100: {
                this.container.setTableWidth(x - this.tableScreen.x);
                this.refresh();
                break;
            }
            case 101: {
                int offset = this.sashIndex == 0 ? this.tableScreen.x : this.tableSashes.get((int)(this.sashIndex - 1)).x_end;
                this.container.setColumnWidth(this.sashIndex, x - offset);
                this.refreshTable();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (this.container.isEmpty() || !this.rangeSelector.select(this.graphScreen.getXinRec(x))) break;
                this.mouseController.setLeftAction(4);
                this.renderer.restoreScreen();
                this.renderer.setPaintArea(this.graphScreen);
                this.rangeSelector.drawSelection(this.graphScreen, this.axisScreenTop.height + 1);
                this.container.notifyselectionChanged(this.rangeSelector.getMin(), this.rangeSelector.getMax());
                this.renderer.showScreenBuffer();
                break;
            }
        }
    }

    @Override
    public void mouseMovedByRightPressed(Renderer source, int x, int y) {
    }

    public void refresh() {
        if (this.renderer.isVisibleInitialized()) {
            this.resizedDrawingArea(this.renderer);
            this.cellRenderer.packAxis();
            this.repaintDrawingArea(this.renderer);
        }
    }

    public void refreshTable() {
        if (this.renderer.isVisibleInitialized()) {
            this.layoutTable();
            if (this.show_table) {
                this.repaintTableArea(true);
            }
        }
    }

    public void repaintControl() {
        if (this.renderer.isVisibleInitialized()) {
            this.repaintDrawingArea(this.renderer);
        }
    }

    public Set<RangeLineTableDataSet.TableGroup> getGroups() {
        return this.container.getGroups();
    }

    public List<RangeLineTableDataSet> getItems(RangeLineTableDataSet.TableGroup group) {
        return this.container.getItems(group);
    }

    public RangeLineTableDataSet getSelection() {
        return this.selection;
    }

    public boolean setSelection(RangeLineTableDataSet selection) {
        if (!this.linesSelectable) {
            return false;
        }
        if (this.contents.containsKey(selection) && this.selection != selection) {
            this.selection = selection;
            this.repaintDrawingArea(this.renderer);
            for (RangeLineSelectionListener<RangeLineTableDataSet> l : this.selectionListeners) {
                l.lineSelected(selection);
                int colSize = this.contents.get(selection).cols.length;
                if (this.focusedCol == colSize) {
                    l.rangeLineSelected(selection);
                    continue;
                }
                l.cellSelected(selection, this.focusedCol);
            }
            return true;
        }
        return false;
    }

    public void selectPrevious() {
        if (this.selection != null) {
            List<RangeLineTableDataSet> list = this.container.getItems(this.selection.getGroup());
            int idx = list.indexOf(this.selection);
            if (idx != 0) {
                this.setSelection(list.get(idx - 1));
            } else {
                Set<RangeLineTableDataSet.TableGroup> groups = this.container.getGroups();
                RangeLineTableDataSet.TableGroup[] reversedGroups = new RangeLineTableDataSet.TableGroup[groups.size()];
                int revIdx = groups.size() - 1;
                for (RangeLineTableDataSet.TableGroup group : groups) {
                    reversedGroups[revIdx--] = group;
                }
                boolean look = false;
                for (RangeLineTableDataSet.TableGroup group : reversedGroups) {
                    if (look) {
                        List<RangeLineTableDataSet> sets = this.container.getItems(group);
                        if (sets.isEmpty()) continue;
                        this.setSelection(sets.get(sets.size() - 1));
                        return;
                    }
                    if (group != this.selection.getGroup()) continue;
                    look = true;
                }
            }
        } else {
            this.selectFirst();
        }
    }

    public void selectNext() {
        if (this.selection != null) {
            List<RangeLineTableDataSet> list = this.container.getItems(this.selection.getGroup());
            int idx = list.indexOf(this.selection);
            if (idx != list.size() - 1) {
                this.setSelection(list.get(idx + 1));
            } else {
                Iterator<RangeLineTableDataSet.TableGroup> i = this.container.getGroups().iterator();
                while (i.hasNext()) {
                    if (i.next() != this.selection.getGroup()) continue;
                    while (i.hasNext()) {
                        List<RangeLineTableDataSet> sets = this.container.getItems(i.next());
                        if (sets.isEmpty()) continue;
                        this.setSelection(sets.get(0));
                        return;
                    }
                }
            }
        } else {
            this.selectFirst();
        }
    }

    public void setNextCellFocused() {
        block3: {
            Line line;
            block4: {
                if (!this.linesSelectable) {
                    return;
                }
                if (!this.contents.containsKey(this.selection)) break block3;
                line = this.contents.get(this.selection);
                if (this.focusedCol + 1 >= line.cols.length) break block4;
                ++this.focusedCol;
                this.repaintDrawingArea(this.renderer);
                for (RangeLineSelectionListener<RangeLineTableDataSet> l : this.selectionListeners) {
                    l.cellSelected(this.selection, this.focusedCol);
                }
                break block3;
            }
            if (this.focusedCol >= line.cols.length) break block3;
            ++this.focusedCol;
            this.repaintDrawingArea(this.renderer);
            for (RangeLineSelectionListener<RangeLineTableDataSet> l : this.selectionListeners) {
                l.rangeLineSelected(this.selection);
            }
        }
    }

    public void setPreviousCellFocused() {
        if (!this.linesSelectable) {
            return;
        }
        if (this.contents.containsKey(this.selection) && this.focusedCol - 1 >= 0) {
            --this.focusedCol;
            this.repaintDrawingArea(this.renderer);
            for (RangeLineSelectionListener<RangeLineTableDataSet> l : this.selectionListeners) {
                l.cellSelected(this.selection, this.focusedCol);
            }
        }
    }

    private void selectFirst() {
        for (RangeLineTableDataSet.TableGroup group : this.container.getGroups()) {
            Iterator<RangeLineTableDataSet> iterator = this.container.getItems(group).iterator();
            if (!iterator.hasNext()) continue;
            RangeLineTableDataSet line = iterator.next();
            this.setSelection(line);
            return;
        }
    }

    public void addRangeLineSelectionListener(RangeLineSelectionListener<RangeLineTableDataSet> listener) {
        this.selectionListeners.add(listener);
    }

    public void removeRangeLineSelectionListener(RangeLineSelectionListener<RangeLineTableDataSet> listener) {
        this.selectionListeners.remove(listener);
    }

    public void performDefaultActionSelection() {
        if (!this.linesSelectable) {
            return;
        }
        if (this.getSelection() != null) {
            this.notifyLineDoubleClickSelection(this.getSelection());
        }
    }

    public void setLayoutListener(RangeLineTableLayoutListener listener) {
        this.layoutListener = listener;
    }

    public Rectangle getMinScreen() {
        return this.minScreen;
    }

    public void packTable(boolean animated) {
        if (animated) {
            int tabWidth = this.container.getTableWidth();
            this.container.packTable();
            int toBeExpandedSpace = this.container.getTableWidth() - tabWidth;
            if (toBeExpandedSpace > 0) {
                this.container.setTableWidth(tabWidth);
                int STEP_COUNT = 10;
                long DELAY = 20L;
                final int STEP = toBeExpandedSpace / 10;
                Thread animation = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < 10; ++i) {
                            RangeLineTableChart.this.renderer.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    RangeLineTableChart.this.container.setTableWidth(RangeLineTableChart.this.container.getTableWidth() + STEP);
                                    RangeLineTableChart.this.refresh();
                                }
                            });
                            try {
                                Thread.sleep(20L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                });
                animation.start();
            }
        } else {
            this.container.packTable();
            this.refresh();
        }
    }

    public void maximizeGraph(boolean animated) {
        if (animated) {
            int STEP_COUNT = 10;
            long DELAY = 20L;
            final int STEP = (this.container.getTableWidth() - this.container.getMinTableWidth()) / 10;
            Thread animation = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        RangeLineTableChart.this.renderer.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                RangeLineTableChart.this.container.setTableWidth(RangeLineTableChart.this.container.getTableWidth() - STEP);
                                RangeLineTableChart.this.refresh();
                            }
                        });
                        try {
                            Thread.sleep(20L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            });
            animation.start();
        } else {
            this.container.setTableWidth(0);
            this.refresh();
        }
    }

    public void appendRangeGroup(RangeLineTableDataSet.TableGroup group) {
        this.container.appendRangeGroup(group);
    }

    public void appendRangeLine(RangeLineTableDataSet data) {
        this.container.appendRangeLine(data);
        this.cellRenderer.updateAxisModel(data);
        this.cellRenderer.packAxis();
    }

    public void setAxisCaptionProvider(RangeLineAxisCaptionProvider provider) {
        this.cellRenderer.setAxisCaptionProvider(provider);
        this.axisCaptionProvider = provider;
    }

    public long getRasterSize() {
        return this.cellRenderer.getRasterSize();
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    public void removeAll() {
        this.container.removeAll();
    }

    public void enableTableView(boolean enable) {
        this.show_table = enable;
    }

    public void enableGraphAxis(boolean enable) {
        this.show_graph_axis = enable;
    }

    public void enableRangeSelection(boolean enable) {
        this.rangeSelector.enable(enable);
    }

    public void resetRangeSelection(boolean silent) {
        if (this.rangeSelector.resetSelection()) {
            this.renderer.restoreScreen();
            this.valueBar.drawValueBar(this.graphScreen, this.show_graph_axis);
            this.renderer.showScreenBuffer();
            if (!silent) {
                this.container.notifySelectionReset();
            }
        }
    }

    public void selectRange(long min, long max) {
        if (!this.container.isEmpty() && this.rangeSelector.select(min, max)) {
            this.renderer.restoreScreen();
            this.renderer.setPaintArea(this.graphScreen);
            this.rangeSelector.drawSelection(this.graphScreen, this.axisScreenTop.height + 1);
            this.renderer.showScreenBuffer();
        }
    }

    public boolean isSelected() {
        return this.rangeSelector.isSelected();
    }

    public void selectFromValueBar(int pixels, boolean silent) {
        if (!this.container.isEmpty() && this.rangeSelector.isEnabled()) {
            RangeLineAxisModel axes_model = this.cellRenderer.getAxisModel();
            boolean selected = false;
            if (this.rangeSelector.isSelected()) {
                long delta = axes_model.getRange() / (long)this.graphScreen.width * (long)pixels;
                if (this.selDirectionRight) {
                    long newMax = this.rangeSelector.getMax() + delta;
                    if (newMax > this.rangeSelector.getMin()) {
                        selected = this.rangeSelector.select(this.rangeSelector.getMin(), newMax);
                    } else {
                        this.selDirectionRight = false;
                        selected = this.rangeSelector.select(newMax, this.rangeSelector.getMin());
                    }
                } else {
                    long newMin = this.rangeSelector.getMin() + delta;
                    if (newMin < this.rangeSelector.getMax()) {
                        selected = this.rangeSelector.select(newMin, this.rangeSelector.getMax());
                    } else {
                        this.selDirectionRight = true;
                        selected = this.rangeSelector.select(this.rangeSelector.getMax(), newMin);
                    }
                }
            } else if (pixels != 0) {
                this.selDirectionRight = pixels > 0;
                this.rangeSelector.startSelection(this.valueBar.getPixelPosition());
                selected = this.rangeSelector.select(this.valueBar.getPixelPosition() + pixels);
            }
            if (selected) {
                if (!silent) {
                    this.container.notifyselectionChanged(this.rangeSelector.getMin(), this.rangeSelector.getMax());
                }
                this.renderer.restoreScreen();
                this.renderer.setPaintArea(this.graphScreen);
                this.rangeSelector.drawSelection(this.graphScreen, this.axisScreenTop.height + 1);
                this.renderer.showScreenBuffer();
            }
        }
    }

    public void enableValueBar(boolean enable) {
        this.valueBar.setEnabled(enable);
    }

    public void setValueBarPosition(long value) {
        if (this.valueBar.isEnabled() && !this.isEmpty()) {
            this.valueBar.setPosition(value);
            this.repaintGraphArea(true);
        }
    }

    public void moveValueBar(int pixels, boolean left, boolean silent) {
        if (this.valueBar.isEnabled() && !this.isEmpty()) {
            int px = this.valueBar.getPixelPosition();
            px = left ? (px -= pixels) : (px += pixels);
            this.valueBar.setPosition(px);
            this.valueBar.checkPositionAndAdjust(this.graphScreen.width);
            this.repaintGraphArea(true);
            if (!silent) {
                long val = this.cellRenderer.getAxisModel().getMin() + (long)this.cellRenderer.getAxisModel().toValue(this.valueBar.getPixelPosition());
                this.container.notifyValueBarPositionChanged(val);
            }
        }
    }

    public void setRasterAdapter(RangeLineAxisRasterAdapter adapter) {
        this.cellRenderer.setRasterAdapter(adapter);
    }

    public void addGraphSelectionListener(RangeTableGraphSelectionListener listener) {
        this.container.addSelectionListener(listener);
    }

    public void removeGraphSelectionListener(RangeTableGraphSelectionListener listener) {
        this.container.removeSelectionListener(listener);
    }

    public void enableRasterSelection(long rasterPeriod) {
        this.rangeSelector.enableRasterSelection(rasterPeriod);
    }

    public void enableRasterSelection(RasterAnchorsList anchors) {
        this.rangeSelector.enableRasterSelection(anchors);
    }

    public void enableRasterSelection(final long[] anchors) {
        RasterAnchorsList list = new RasterAnchorsList(){

            @Override
            public long getLength() {
                return anchors.length;
            }

            @Override
            public double getValueAt(long idx) {
                return anchors[(int)idx];
            }
        };
        this.rangeSelector.enableRasterSelection(list);
    }

    public void setAccessibleControlName(String name) {
        this.accName = name;
    }

    public String getAccessibleName() {
        StringBuilder text = new StringBuilder(this.accName == null ? "Range Line Table" : this.accName);
        text.append(',');
        ArrayList<RangeLineTableDataSet.TableGroup> groups = new ArrayList<RangeLineTableDataSet.TableGroup>();
        for (RangeLineTableDataSet.TableGroup g : this.container.getGroups()) {
            if ((g.getRangeLine() == null || g.getRangeLine().isEmpty()) && this.container.getItems(g).isEmpty()) continue;
            groups.add(g);
        }
        if (groups.isEmpty()) {
            text.append("is empty");
        } else {
            text.append("the table shows, ");
            text.append(groups.size());
            text.append(", groups");
            int groupIdx = 1;
            for (RangeLineTableDataSet.TableGroup g : groups) {
                text.append(", group number, ");
                text.append(groupIdx++);
                text.append(", shows, ");
                text.append(g.getColumnCount());
                text.append(", columns and contains, ");
                text.append(this.container.getItems(g).size());
                text.append(", lines, the column names are");
                for (int i = 0; i < g.getColumnCount(); ++i) {
                    text.append(',');
                    if (i > 0 && i + 1 == g.getColumnCount()) {
                        text.append("and,");
                    }
                    text.append(g.getColumnName(i));
                }
            }
        }
        return text.toString();
    }

    public String getAccessibleText() {
        StringBuilder result = new StringBuilder();
        RangeLineTableDataSet data = this.getSelection();
        if (data != null) {
            Line line = this.contents.get(data);
            if (this.focusedCol == line.cols.length) {
                this.getRanges(data, result);
                RangeLineDataSet group = data.getGroup().getRangeLine();
                if (group != null) {
                    result.append("group, ");
                    result.append(this.getValue(group.getName(), "undefined"));
                    result.append(",");
                    this.getRanges(group, result);
                }
            } else {
                result.append(this.getValue(data.getGroup().getColumnName(this.focusedCol)));
                result.append(", ");
                result.append(this.getValue(data.getValue(this.focusedCol)));
            }
            result.append(", to move in the table use the arrow keys");
        }
        return result.toString();
    }

    private void getRanges(RangeLineDataSet data, StringBuilder result) {
        if (!data.getAllRanges().isEmpty()) {
            result.append("range line with, ");
            result.append(data.getRangeCount());
            result.append(", ");
            result.append(data.getRangeCount() > 1 ? "ranges" : "range");
            for (RangeLineDataSet.Range r : data.getAllRanges()) {
                if (r.getType().isSpace()) continue;
                result.append(", ");
                result.append(r.getType().getName());
                result.append(" from ");
                result.append(this.getAxisValue(r.getMinValue()));
                result.append(" to ");
                result.append(this.getAxisValue(r.getMaxValue()));
            }
        } else {
            result.append("range line with no ranges defined");
        }
        if (!data.getAllTimeStamps().isEmpty()) {
            int stampsCount = data.getAllTimeStamps().size();
            result.append(',');
            result.append(stampsCount);
            result.append(", ");
            result.append(stampsCount > 1 ? "stamps" : "stamp");
            result.append(" available");
            for (RangeLineDataSet.TimeStamp s : data.getAllTimeStamps()) {
                result.append(", stamp at, ");
                result.append(this.getAxisValue(s.getValue()));
                String tip = s.getTooltip();
                if (tip.trim().length() <= 0) continue;
                result.append(',');
                result.append(tip);
                result.append(' ');
            }
        } else {
            result.append("no stamps defined, ");
        }
    }

    private String getValue(String value) {
        return value == null || value.trim().length() == 0 ? "empty" : value;
    }

    private String getValue(String value, String defText) {
        return value == null || value.trim().length() == 0 ? defText : value;
    }

    private String getAxisValue(long value) {
        if (this.axisCaptionProvider != null) {
            return this.axisCaptionProvider.getValueCaption(value, this.cellRenderer.getRasterSize());
        }
        return String.valueOf(value);
    }

    static class Line {
        private Rectangle lineArea;
        private Rectangle[] cols;
        private Rectangle graphArea;
        private boolean isHeader;

        private Line(int columns, Rectangle lineArea, boolean isHeader) {
            this.lineArea = lineArea;
            this.isHeader = isHeader;
            this.cols = new Rectangle[columns];
            this.graphArea = new Rectangle();
        }

        public Rectangle getLineArea() {
            return this.lineArea;
        }

        public Rectangle getGraphArea() {
            return this.graphArea;
        }

        public boolean isHeader() {
            return this.isHeader;
        }

        public int getColIndex(int x) {
            for (int i = 0; i < this.cols.length; ++i) {
                if (!this.cols[i].isInXRange(x)) continue;
                return i;
            }
            return -1;
        }

        private void updateGraphArea(Rectangle rec) {
            this.graphArea.update(rec.x, this.lineArea.y - 2, rec.width, this.lineArea.height - 6);
        }
    }
}

