/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.RangeLineTableValueBarListener;
import com.sap.jvm.profiling.ui.graph.RangeTableGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.dataset.RangeLineTableDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RangeLineTableContainer {
    private Renderer renderer;
    private int columnCount = 0;
    private int tableWidth = this.getMinTableWidth();
    private int[] columnWidth = new int[]{15};
    private Map<RangeLineTableDataSet.TableGroup, List<RangeLineTableDataSet>> groupItems = new LinkedHashMap<RangeLineTableDataSet.TableGroup, List<RangeLineTableDataSet>>();
    private HashSet<RangeTableGraphSelectionListener> selection_listeners = new HashSet();
    private HashSet<RangeLineTableValueBarListener> valuebar_listeners = new HashSet();

    public RangeLineTableContainer(Renderer renderer) {
        this.renderer = renderer;
    }

    public int getMinTableWidth() {
        return this.getColumnCount() * 15;
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public void setTableWidth(int width) {
        this.tableWidth = width < this.getMinTableWidth() ? this.getMinTableWidth() : width;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getColumnWidth(int idx) {
        return this.columnWidth[idx];
    }

    public void setColumnWidth(int idx, int width) {
        this.columnWidth[idx] = width < 15 ? 15 : width;
    }

    public Set<RangeLineTableDataSet.TableGroup> getGroups() {
        return this.groupItems.keySet();
    }

    public List<RangeLineTableDataSet> getItems(RangeLineTableDataSet.TableGroup group) {
        return this.groupItems.get(group);
    }

    public void appendRangeGroup(RangeLineTableDataSet.TableGroup group) {
        if (!this.groupItems.containsKey(group)) {
            this.groupItems.put(group, new ArrayList());
            this.updateColumnSettings(group);
        }
    }

    public void appendRangeLine(RangeLineTableDataSet line) {
        if (this.groupItems.containsKey(line.getGroup())) {
            List<RangeLineTableDataSet> lines = this.groupItems.get(line.getGroup());
            for (RangeLineTableDataSet test : lines) {
                if (test != line) continue;
                return;
            }
            lines.add(line);
        } else {
            ArrayList<RangeLineTableDataSet> lines = new ArrayList<RangeLineTableDataSet>();
            lines.add(line);
            this.groupItems.put(line.getGroup(), lines);
            this.updateColumnSettings(line.getGroup());
        }
    }

    private void updateColumnSettings(RangeLineTableDataSet.TableGroup group) {
        int addColumns = group.getColumnCount() - this.columnCount;
        if (addColumns > 0) {
            this.columnCount += addColumns;
            int[] newColumns = new int[this.columnWidth.length + addColumns];
            System.arraycopy(this.columnWidth, 0, newColumns, 0, this.columnWidth.length);
            for (int i = this.columnWidth.length; i < newColumns.length; ++i) {
                newColumns[i] = 15;
            }
            this.columnWidth = newColumns;
        }
        this.columnCount = group.getColumnCount() > this.columnCount ? group.getColumnCount() : this.columnCount;
    }

    public void packTable() {
        this.tableWidth = 0;
        for (int i = 0; i < this.columnWidth.length; ++i) {
            this.packColumn(i, false);
            this.tableWidth += this.columnWidth[i] + 2;
        }
    }

    protected void packColumn(int idx, boolean tableResize) {
        int width = 0;
        Font headerFont = this.renderer.getFont().getBold();
        for (Map.Entry<RangeLineTableDataSet.TableGroup, List<RangeLineTableDataSet>> entry : this.groupItems.entrySet()) {
            RangeLineTableDataSet.TableGroup group = entry.getKey();
            if ((group.getRangeLine() == null || group.getRangeLine().isEmpty()) && entry.getValue().isEmpty()) continue;
            Font oldUsedFont = this.renderer.getFont();
            this.renderer.setFont(headerFont);
            int textWidth = this.renderer.getStringWidth(entry.getKey().getColumnName(idx)) + 5;
            this.renderer.setFont(oldUsedFont);
            int n = width = width < textWidth ? textWidth : width;
            if (entry.getKey().getColumnImage(idx) != null) {
                width += entry.getKey().getColumnImage((int)idx).getBounds().width + 5;
            }
            for (RangeLineTableDataSet data : entry.getValue()) {
                textWidth = this.renderer.getStringWidth(data.getValue(idx)) + 10;
                if (data.getIcon(idx) != null) {
                    textWidth += data.getIcon((int)idx).getBounds().width + 5;
                }
                width = width < textWidth ? textWidth : width;
            }
        }
        this.columnWidth[idx] = width;
        if (tableResize) {
            this.tableWidth = 0;
            for (Object col : (Object)this.columnWidth) {
                this.tableWidth += col + 2;
            }
        }
    }

    public boolean isEmpty() {
        if (this.groupItems.isEmpty()) {
            return true;
        }
        for (Map.Entry<RangeLineTableDataSet.TableGroup, List<RangeLineTableDataSet>> entry : this.groupItems.entrySet()) {
            if (!entry.getValue().isEmpty()) {
                return false;
            }
            if (entry.getKey().getRangeLine() == null || entry.getKey().getRangeLine().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void removeAll() {
        this.groupItems.clear();
    }

    public void addSelectionListener(RangeTableGraphSelectionListener listener) {
        this.selection_listeners.add(listener);
    }

    public void removeSelectionListener(RangeTableGraphSelectionListener listener) {
        this.selection_listeners.remove(listener);
    }

    protected void notifySelected(long min, long max) {
        for (RangeTableGraphSelectionListener l : this.selection_listeners) {
            l.selected(min, max);
        }
    }

    protected void notifyselectionChanged(long min, long max) {
        for (RangeTableGraphSelectionListener l : this.selection_listeners) {
            l.selectionChanged(min, max);
        }
    }

    protected void notifySelectionReset() {
        for (RangeTableGraphSelectionListener l : this.selection_listeners) {
            l.selectionReset();
        }
    }

    protected void notifySelectionClickedOn() {
        for (RangeTableGraphSelectionListener l : this.selection_listeners) {
            l.selectionClickedOn();
        }
    }

    public void addValueBarListener(RangeLineTableValueBarListener listener) {
        this.valuebar_listeners.add(listener);
    }

    public void removeValueBarListener(RangeLineTableValueBarListener listener) {
        this.valuebar_listeners.remove(listener);
    }

    protected void notifyValueBarPositionChanged(long value) {
        for (RangeLineTableValueBarListener l : this.valuebar_listeners) {
            l.positionChanged(value);
        }
    }
}

