/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisModel;
import com.sap.jvm.profiling.ui.graph.axes.RasterAnchorsList;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;

public class RangeLineTableRangeSelector {
    private Renderer renderer;
    private RangeLineAxisModel axisModel;
    private boolean enabled;
    private double min;
    private double max;
    private int startPos;
    private double raster = -1.0;
    private RasterAnchorsList selectionAnchors = null;

    public RangeLineTableRangeSelector(Renderer renderer, RangeLineAxisModel axisModel) {
        this.renderer = renderer;
        this.axisModel = axisModel;
    }

    public void enableRasterSelection(double rasterPeriod) {
        if (rasterPeriod <= 0.0) {
            throw new IllegalArgumentException("The selection raster could not be a negative value.");
        }
        this.selectionAnchors = null;
        this.raster = rasterPeriod;
    }

    public void enableRasterSelection(RasterAnchorsList anchors) {
        this.disableRasterSelection();
        if (anchors != null) {
            this.selectionAnchors = anchors;
        }
    }

    public void disableRasterSelection() {
        this.raster = -1.0;
        this.selectionAnchors = null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSelected() {
        return this.enabled && this.min < this.max;
    }

    public void enable(boolean enable) {
        this.enabled = enable;
    }

    public boolean resetSelection() {
        if (this.isSelected()) {
            this.min = this.max;
            return true;
        }
        return false;
    }

    public boolean select(long minValue, long maxVale) {
        if (this.enabled) {
            if (minValue > maxVale) {
                throw new IllegalArgumentException("The min selection border cannot be greater then the max border.");
            }
            this.min = minValue;
            this.max = maxVale;
            return true;
        }
        return false;
    }

    public void startSelection(int pos) {
        this.startPos = pos;
        if (this.isSelected()) {
            this.min = (double)this.axisModel.getMin() + this.axisModel.toValue(this.startPos);
        } else {
            this.max = this.min = (double)this.axisModel.getMin() + this.axisModel.toValue(this.startPos);
        }
    }

    public void setMinAsStart() {
        this.startPos = this.axisModel.getPixelPosition(this.min);
    }

    public void setMaxAsStart() {
        this.startPos = this.axisModel.getPixelPosition(this.max);
    }

    public boolean select(int selectedPos) {
        if (this.enabled && Math.abs(selectedPos - this.startPos) > 5) {
            int posMax = selectedPos;
            if (posMax < 2) {
                posMax = 2;
            } else if (posMax > this.renderer.getWidth()) {
                posMax = this.renderer.getWidth() - 1;
            }
            if (posMax < this.startPos) {
                int posMin = posMax;
                posMax = this.startPos;
                this.min = (double)this.axisModel.getMin() + this.axisModel.toValue(posMin);
                this.max = (double)this.axisModel.getMin() + this.axisModel.toValue(posMax);
            } else {
                int posMin = this.startPos;
                this.max = (double)this.axisModel.getMin() + this.axisModel.toValue(posMax);
            }
            return true;
        }
        return false;
    }

    public boolean isHovered(int pos) {
        if (this.isSelected()) {
            int posMin = this.axisModel.getPixelPosition(this.min);
            int posMax = this.axisModel.getPixelPosition(this.max);
            return pos > posMin && pos < posMax;
        }
        return false;
    }

    public boolean isMinBorderHovered(int pos) {
        if (this.isSelected()) {
            int posMin = this.axisModel.getPixelPosition(this.min);
            return Math.abs(pos - posMin) < 3;
        }
        return false;
    }

    public boolean isMaxBorderHovered(int pos) {
        if (this.isSelected()) {
            int posMax = this.axisModel.getPixelPosition(this.max);
            return Math.abs(pos - posMax) < 3;
        }
        return false;
    }

    boolean drawSelection(Rectangle graph, int topOffset) {
        if (this.enabled && this.isSelected()) {
            int minPixel = this.axisModel.getPixelPosition(this.min);
            int maxPixel = this.axisModel.getPixelPosition(this.max);
            this.renderer.setPaintArea(graph);
            this.renderer.setFillColor(Color.GRAY);
            this.renderer.setAlpha(15);
            this.renderer.fillRectangle(minPixel, graph.height - topOffset, maxPixel - minPixel, graph.height - topOffset);
            this.renderer.setAlpha(255);
            this.renderer.setLineStyle(Renderer.LineType.LINE_DOT);
            this.renderer.setForeground(Color.GRAY);
            this.renderer.drawLine(minPixel, graph.height - topOffset, minPixel, 0);
            this.renderer.drawLine(maxPixel, graph.height - topOffset, maxPixel, 0);
            this.renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
            this.renderer.setDefaultColors();
            this.renderer.setPaintArea(null);
            return true;
        }
        return false;
    }

    public boolean adaptSelectionToRaster() {
        if (this.raster > 0.0) {
            this.min = this.min % this.raster == 0.0 ? this.min : this.min - this.min % this.raster;
            this.max = this.max % this.raster == 0.0 ? this.max : this.max + this.raster - this.max % this.raster;
            return true;
        }
        if (this.selectionAnchors != null) {
            this.min = this.selectionAnchors.getValueAt(this.find(this.selectionAnchors, this.min, true));
            this.max = this.selectionAnchors.getValueAt(this.find(this.selectionAnchors, this.max, false));
            return true;
        }
        return false;
    }

    private long find(RasterAnchorsList list, double val, boolean nextLow) {
        long result;
        long low = 0L;
        long high = list.getLength() - 1L;
        while (low <= high) {
            long mid = low + high >> 1;
            double midVal = list.getValueAt(mid);
            double cmp = midVal - val;
            if (cmp < 0.0) {
                low = mid + 1L;
                continue;
            }
            if (cmp > 0.0) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        long l = result = nextLow ? high : low;
        if (result < 0L) {
            return 0L;
        }
        if (result > list.getLength() - 1L) {
            return list.getLength() - 1L;
        }
        return result;
    }

    public long getMin() {
        return (long)this.min;
    }

    public long getMax() {
        return (long)this.max;
    }
}

