/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisModel;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;

public final class RangeLineTableValueBar {
    private boolean enabled;
    private Renderer renderer;
    private RangeLineAxisModel axesModel;
    private long valuePos;

    public RangeLineTableValueBar(Renderer renderer, RangeLineAxisModel axesModel) {
        this.renderer = renderer;
        this.axesModel = axesModel;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isIn(int min, int max) {
        int pixelPos = this.getPixelPosition();
        return this.enabled && pixelPos > min && pixelPos < max;
    }

    public boolean isHovered(int pos) {
        return this.enabled && Math.abs(pos - this.getPixelPosition()) < 3;
    }

    public void setPosition(int pos) {
        this.valuePos = this.axesModel.getMin() + (long)this.axesModel.toValue(pos);
    }

    public void setPosition(long value) {
        this.valuePos = value;
    }

    public int getPixelPosition() {
        long v = this.valuePos - this.axesModel.getMin();
        return this.axesModel.toPixels(v);
    }

    public void checkPositionAndAdjust(int width) {
        if (this.enabled) {
            int pixelPos;
            int newPos = pixelPos = this.getPixelPosition();
            if (pixelPos > width) {
                newPos = width - 1;
            } else if (pixelPos < 0) {
                newPos = 0;
            }
            if (newPos != pixelPos) {
                pixelPos = newPos;
                this.valuePos = this.axesModel.getMin() + (long)this.axesModel.toValue(pixelPos);
            }
        }
    }

    public void drawValueBar(Rectangle graphArea, boolean withAxis) {
        if (this.enabled) {
            this.renderer.setPaintArea(graphArea);
            int pixelPos = this.getPixelPosition();
            int height = withAxis ? this.renderer.getHeight() - this.renderer.getFontHeight() - 3 : this.renderer.getHeight() - 2;
            this.renderer.setForeground(new Color(200, 120, 120));
            this.renderer.setLineStyle(Renderer.LineType.LINE_DOT);
            this.renderer.drawLine(pixelPos, 3, pixelPos, height);
            this.renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
            this.renderer.setForeground(Color.DARK_GRAY);
            this.renderer.drawLine(pixelPos - 2, height, pixelPos + 2, height);
            this.renderer.drawLine(pixelPos - 1, height - 1, pixelPos + 1, height - 1);
            this.renderer.drawPoint(pixelPos, height - 2);
            this.renderer.drawLine(pixelPos - 2, 3, pixelPos + 2, 3);
            this.renderer.drawLine(pixelPos - 1, 4, pixelPos + 1, 4);
            this.renderer.drawPoint(pixelPos, 5);
            this.renderer.setPaintArea(null);
            this.renderer.setDefaultColors();
        }
    }
}

