/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.GraphContainerChart;
import com.sap.jvm.profiling.ui.graph.dataset.AccSingleBarDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.SingeBarDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.geometry.RectangleLayoutAdaptor;
import com.sap.jvm.profiling.ui.graph.legend.LegendPositionAnchor;
import com.sap.jvm.profiling.ui.graph.renderer.ChartsContainerActionListener;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SingleBarValueChart
extends GraphContainerChart<SingeBarDataSet> {
    private GraphChartContainer chartsContainer;
    private SingeBarDataSet graphData;
    private Rectangle mainArea = new Rectangle();
    private Rectangle graphBarArea = new Rectangle();
    private Rectangle graphBarDescriptionArea = new Rectangle();
    private Rectangle graphRangeMarkerArea = new Rectangle();
    private Rectangle graphValueMarkerArea = new Rectangle();
    private Rectangle[] allChartAreas = new Rectangle[]{this.mainArea, this.graphArea, this.graphBarArea, this.graphBarDescriptionArea, this.graphValueMarkerArea, this.graphRangeMarkerArea};
    private RectangleLayoutAdaptor layoutAdaptor;
    private Type type = Type.VERTICAL;
    private DescAlighnment alignment = DescAlighnment.RIGHT;
    private boolean withShadows = false;
    private boolean flipLabels = false;
    private int leftMargin = 0;
    private int rightMargin = 0;
    private boolean enableToolTips = true;
    private GraphChartContainer.DisplayCell lastDisplayCell;
    private ChartsContainerActionListener actionListener = new ChartsContainerActionListener(){
        private boolean hasRangeMarkers;
        private boolean hasValueMarkers;
        private boolean hasDescription;

        @Override
        public void dispose() {
        }

        @Override
        public void initializedDrawingArea(Renderer source, GraphChartContainer.DisplayCell cell) {
            this.resizedDrawingArea(source, cell);
        }

        @Override
        public void resizedDrawingArea(Renderer renderer, GraphChartContainer.DisplayCell cell) {
            SingleBarValueChart.this.lastDisplayCell = cell;
            SingleBarValueChart.this.mainArea.copy(cell.getEntireArea());
            SingleBarValueChart.this.graphArea.copy(cell.getGraphArea());
            if (SingleBarValueChart.this.layoutAdaptor != null) {
                SingleBarValueChart.this.graphArea.updateLayout(SingleBarValueChart.this.layoutAdaptor);
            }
            if (SingleBarValueChart.this.graphData != null) {
                int fontHeight = renderer.getFontHeight();
                int hText = fontHeight + 2;
                this.hasDescription = SingleBarValueChart.this.graphData.getValueDescription() != null;
                this.hasValueMarkers = !SingleBarValueChart.this.graphData.getValueMarkers().isEmpty();
                this.hasRangeMarkers = false;
                if (SingleBarValueChart.this.graphData instanceof AccSingleBarDataSet) {
                    AccSingleBarDataSet accData = (AccSingleBarDataSet)SingleBarValueChart.this.graphData;
                    boolean bl = this.hasRangeMarkers = !accData.getRangeMarkers().isEmpty();
                }
                if (SingleBarValueChart.this.type == Type.HORIZONTAL) {
                    int w = SingleBarValueChart.this.graphArea.width - 5;
                    int hDscr = this.hasDescription ? hText : 0;
                    int hRMark = this.hasRangeMarkers ? fontHeight + 10 : 0;
                    int hVMark = this.hasValueMarkers ? fontHeight + 5 : 0;
                    int hSpace = hDscr + hRMark + hVMark;
                    int availableHeight = SingleBarValueChart.this.graphArea.height - hSpace;
                    int hBar = Math.max((int)((double)hText * 0.8), (int)Math.round((double)availableHeight * 0.7));
                    int graphAreaHeight = hSpace + hBar + 4;
                    if (SingleBarValueChart.this.withShadows) {
                        hBar -= 5;
                        w -= 5;
                    }
                    w -= SingleBarValueChart.this.leftMargin;
                    SingleBarValueChart.this.graphArea.update(SingleBarValueChart.this.graphArea.x, ((SingleBarValueChart)SingleBarValueChart.this).mainArea.center.y + graphAreaHeight / 2 - 1, SingleBarValueChart.this.graphArea.width, graphAreaHeight);
                    SingleBarValueChart.this.graphBarDescriptionArea.update(SingleBarValueChart.this.graphArea.x, SingleBarValueChart.this.graphArea.y - 1, w -= SingleBarValueChart.this.rightMargin, hDscr);
                    if (SingleBarValueChart.this.flipLabels) {
                        SingleBarValueChart.this.graphValueMarkerArea.update(SingleBarValueChart.this.graphArea.x + SingleBarValueChart.this.leftMargin, ((SingleBarValueChart)SingleBarValueChart.this).graphBarDescriptionArea.y_end, w, hVMark);
                        SingleBarValueChart.this.graphBarArea.update(SingleBarValueChart.this.graphArea.x + SingleBarValueChart.this.leftMargin, ((SingleBarValueChart)SingleBarValueChart.this).graphValueMarkerArea.y_end, w, hBar);
                        SingleBarValueChart.this.graphRangeMarkerArea.update(SingleBarValueChart.this.graphArea.x + SingleBarValueChart.this.leftMargin, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.y_end, w, hRMark);
                    } else {
                        SingleBarValueChart.this.graphRangeMarkerArea.update(SingleBarValueChart.this.graphArea.x + SingleBarValueChart.this.leftMargin, ((SingleBarValueChart)SingleBarValueChart.this).graphBarDescriptionArea.y_end, w, hRMark);
                        SingleBarValueChart.this.graphBarArea.update(SingleBarValueChart.this.graphArea.x + SingleBarValueChart.this.leftMargin, ((SingleBarValueChart)SingleBarValueChart.this).graphRangeMarkerArea.y_end, w, hBar);
                        SingleBarValueChart.this.graphValueMarkerArea.update(SingleBarValueChart.this.graphArea.x + SingleBarValueChart.this.leftMargin, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.y_end, w, hVMark);
                    }
                } else {
                    int hDscr = this.hasDescription ? hText : 0;
                    int h = SingleBarValueChart.this.graphArea.height - hDscr - 1;
                    int w = h / 5;
                    if (h < hText) {
                        h = hText;
                    }
                    if (w > SingleBarValueChart.this.graphArea.width - 15) {
                        w = SingleBarValueChart.this.graphArea.width - 15;
                    }
                    int h2p = SingleBarValueChart.this.graphArea.y;
                    SingleBarValueChart.this.graphBarDescriptionArea.update(SingleBarValueChart.this.graphArea.x, h2p, SingleBarValueChart.this.graphArea.width, hDscr);
                    int barTop = h2p - hDscr - 1;
                    if (this.hasRangeMarkers && this.hasValueMarkers) {
                        SingleBarValueChart.this.graphBarArea.update(SingleBarValueChart.this.graphArea.center.x - w / 2, barTop, w, h);
                    } else if (this.hasRangeMarkers) {
                        SingleBarValueChart.this.graphBarArea.update(SingleBarValueChart.this.graphArea.x_end - w - 1, barTop, w, h);
                    } else if (this.hasValueMarkers) {
                        SingleBarValueChart.this.graphBarArea.update(SingleBarValueChart.this.graphArea.x + 7, barTop, w, h);
                    } else {
                        SingleBarValueChart.this.graphBarArea.update(SingleBarValueChart.this.graphArea.center.x - w / 2, barTop, w, h);
                    }
                    SingleBarValueChart.this.graphRangeMarkerArea.update(SingleBarValueChart.this.graphArea.x, barTop, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.x - SingleBarValueChart.this.graphArea.x, h);
                    if (SingleBarValueChart.this.withShadows) {
                        SingleBarValueChart.this.graphBarArea.update(((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width - 3, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height - 3);
                    }
                }
            }
            SingleBarValueChart.this.notifyLayoutListener(SingleBarValueChart.this.graphArea, SingleBarValueChart.this.allChartAreas);
        }

        @Override
        public boolean hasModelDataChanged() {
            return true;
        }

        @Override
        public void repaintDrawingArea(Renderer renderer) {
            if (renderer.getScreenHeight() > 10 && renderer.getScreenWidth() > 10) {
                if (this.layoutChanged()) {
                    this.resizedDrawingArea(renderer, SingleBarValueChart.this.lastDisplayCell);
                }
                renderer.setPaintArea(SingleBarValueChart.this.mainArea);
                renderer.clearDrawingArea();
                this.paintGraph(renderer);
                renderer.setPaintArea(null);
                renderer.saveScreen(SingleBarValueChart.this.mainArea, SingleBarValueChart.this);
            } else {
                renderer.restoreScreen(SingleBarValueChart.this);
            }
        }

        private boolean layoutChanged() {
            if (SingleBarValueChart.this.graphData == null) {
                return false;
            }
            if (this.hasDescription != (SingleBarValueChart.this.graphData.getValueDescription() != null)) {
                return true;
            }
            if (this.hasValueMarkers != !SingleBarValueChart.this.graphData.getValueMarkers().isEmpty()) {
                return true;
            }
            boolean rangeMarkers = false;
            if (SingleBarValueChart.this.graphData instanceof AccSingleBarDataSet) {
                AccSingleBarDataSet accData = (AccSingleBarDataSet)SingleBarValueChart.this.graphData;
                rangeMarkers = !accData.getRangeMarkers().isEmpty();
            }
            return this.hasRangeMarkers != rangeMarkers;
        }

        private void paintGraph(Renderer renderer) {
            if (SingleBarValueChart.this.graphData != null) {
                ArrayList<Marker> markerData;
                Iterator<Marker> markerData2;
                if (SingleBarValueChart.this.withShadows) {
                    renderer.setPaintArea(SingleBarValueChart.this.graphBarArea, SingleBarValueChart.this.graphArea);
                    renderer.setFillColor(Color.GRAY);
                    renderer.fillRectangle(3, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height - 3, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height);
                    renderer.setPaintArea(SingleBarValueChart.this.mainArea);
                    renderer.blur(6);
                }
                Font f = renderer.getFont();
                Font f2 = new Font(f.getName(), f.getSize() - 1, f.getStyle());
                renderer.setFont(f2);
                renderer.setDefaultColors();
                if (SingleBarValueChart.this.graphData.getValueDescription() != null) {
                    renderer.setPaintArea(SingleBarValueChart.this.graphBarDescriptionArea);
                    switch (SingleBarValueChart.this.alignment) {
                        case LEFT: {
                            renderer.drawString(SingleBarValueChart.this.graphData.getValueDescription(), 5, renderer.getFontHeight() + 2);
                            break;
                        }
                        case CENTER: {
                            renderer.drawString(SingleBarValueChart.this.graphData.getValueDescription(), ((SingleBarValueChart)SingleBarValueChart.this).graphBarDescriptionArea.width / 2 - renderer.getStringWidth(SingleBarValueChart.this.graphData.getValueDescription()) / 2, renderer.getFontHeight() + 2);
                            break;
                        }
                        case RIGHT: {
                            renderer.drawString(SingleBarValueChart.this.graphData.getValueDescription(), ((SingleBarValueChart)SingleBarValueChart.this).graphBarDescriptionArea.width - renderer.getStringWidth(SingleBarValueChart.this.graphData.getValueDescription()) - 5, renderer.getFontHeight() + 2);
                            break;
                        }
                        case CENTERED_ON_BAR: {
                            renderer.drawString(SingleBarValueChart.this.graphData.getValueDescription(), ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.x + ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width / 2 - ((SingleBarValueChart)SingleBarValueChart.this).graphBarDescriptionArea.x - renderer.getStringWidth(SingleBarValueChart.this.graphData.getValueDescription()) / 2, renderer.getFontHeight() + 2);
                        }
                    }
                }
                if (SingleBarValueChart.this.type == Type.HORIZONTAL) {
                    if (SingleBarValueChart.this.graphData instanceof AccSingleBarDataSet) {
                        AccSingleBarDataSet data = (AccSingleBarDataSet)SingleBarValueChart.this.graphData;
                        markerData2 = new ArrayList<Marker>();
                        for (AccSingleBarDataSet.RangeMarker m : data.getRangeMarkers()) {
                            int pos1 = (int)((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width / (double)SingleBarValueChart.this.graphData.getMaxValue() * (double)m.getFromValue());
                            int pos2 = (int)((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width / (double)SingleBarValueChart.this.graphData.getMaxValue() * (double)m.getToValue());
                            ((ArrayList)((Object)markerData2)).add(new Marker(pos1, pos2, m.getDescription(), renderer.getStringWidth(m.getDescription()), m.getColor()));
                        }
                        this.positionMarkers((List<Marker>)((Object)markerData2), ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width, 5);
                        Iterator<Object> iterator = ((ArrayList)((Object)markerData2)).iterator();
                        while (iterator.hasNext()) {
                            Marker marker = (Marker)iterator.next();
                            this.drawHorizontalRange(marker, renderer);
                        }
                        renderer.setPaintArea(SingleBarValueChart.this.graphBarArea, SingleBarValueChart.this.graphArea);
                        int offsetStart = 0;
                        long accValue = 0L;
                        for (int i = 0; i < data.getValuesCount(); ++i) {
                            long currentVal = data.getValue(i);
                            int offsetEnd = (int)((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width / (double)data.getMaxValue() * (double)(accValue + currentVal));
                            renderer.setFillColor(data.getColor(i));
                            renderer.fillRectangle(offsetStart, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height, offsetEnd - offsetStart, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height);
                            offsetStart = offsetEnd;
                            accValue += currentVal;
                        }
                        if (SingleBarValueChart.this.withShadows && offsetStart < ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width) {
                            renderer.setFillColor(renderer.getDefaultBackground());
                            renderer.fillRectangle(offsetStart, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width - offsetStart, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height);
                        }
                    } else {
                        renderer.setPaintArea(SingleBarValueChart.this.graphBarArea, SingleBarValueChart.this.graphArea);
                        renderer.setFillColor(SingleBarValueChart.this.graphData.getColor());
                        int w = (int)((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width / 100.0 * SingleBarValueChart.this.graphData.getPercent());
                        renderer.fillRectangle(0, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height, w, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height);
                        if (SingleBarValueChart.this.withShadows && w < ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width) {
                            renderer.setFillColor(renderer.getDefaultBackground());
                            renderer.fillRectangle(w, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width - w, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height);
                        }
                    }
                    markerData = new ArrayList();
                    ArrayList<Marker> selectedMarkerData = new ArrayList<Marker>();
                    for (SingeBarDataSet.ValueMarker m : SingleBarValueChart.this.graphData.getValueMarkers()) {
                        int pos = (int)((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width / (double)SingleBarValueChart.this.graphData.getMaxValue() * (double)m.getValue());
                        Marker marker = new Marker(pos, m.getDescription(), renderer.getStringWidth(m.getDescription()), m.getColor());
                        if (m.isSelected()) {
                            selectedMarkerData.add(marker);
                        }
                        markerData.add(marker);
                    }
                    this.positionMarkers(markerData, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width, 5);
                    for (Marker marker : markerData) {
                        this.drawHorizontalMarker(marker, renderer);
                    }
                    renderer.setAlpha(40);
                    renderer.setForeground(SingleBarValueChart.this.graphData.getValueBackgroundHighlightColor());
                    for (Long selection : SingleBarValueChart.this.graphData.getValueHighlights()) {
                        this.drawHorizontalLine(selection, true, renderer);
                    }
                    renderer.setAlpha(255);
                    renderer.setForeground(SingleBarValueChart.this.graphData.getSelectionColor());
                    for (Marker marker : selectedMarkerData) {
                        this.drawHorizontalSelectedMarker(marker, renderer);
                    }
                    renderer.setAlpha(90);
                    for (Long selection : SingleBarValueChart.this.graphData.getValueSelection()) {
                        this.drawHorizontalLine(selection, false, renderer);
                    }
                    renderer.setAlpha(255);
                } else {
                    if (SingleBarValueChart.this.graphData instanceof AccSingleBarDataSet) {
                        AccSingleBarDataSet data = (AccSingleBarDataSet)SingleBarValueChart.this.graphData;
                        markerData2 = new ArrayList();
                        for (AccSingleBarDataSet.RangeMarker m : data.getRangeMarkers()) {
                            int pos1 = (int)((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height / (double)SingleBarValueChart.this.graphData.getMaxValue() * (double)m.getFromValue());
                            int pos2 = (int)((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height / (double)SingleBarValueChart.this.graphData.getMaxValue() * (double)m.getToValue());
                            ((ArrayList)((Object)markerData2)).add(new Marker(pos1, pos2, m.getDescription(), renderer.getFontHeight(), m.getColor()));
                        }
                        this.positionMarkers((List<Marker>)((Object)markerData2), ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height, 1);
                        Iterator<Object> offsetStart = ((ArrayList)((Object)markerData2)).iterator();
                        while (offsetStart.hasNext()) {
                            Marker marker = (Marker)offsetStart.next();
                            this.drawVerticalRange(marker, renderer);
                        }
                        renderer.setPaintArea(SingleBarValueChart.this.graphBarArea, SingleBarValueChart.this.graphArea);
                        int offsetStart2 = 0;
                        long accValue = 0L;
                        for (int i = 0; i < data.getValuesCount(); ++i) {
                            long currentVal = data.getValue(i);
                            int offsetEnd = (int)((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height / (double)data.getMaxValue() * (double)(accValue + currentVal));
                            renderer.setFillColor(data.getColor(i));
                            renderer.fillRectangle(0, offsetEnd, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width, offsetEnd - offsetStart2);
                            offsetStart2 = offsetEnd;
                            accValue += currentVal;
                        }
                        if (SingleBarValueChart.this.withShadows && offsetStart2 < ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height) {
                            renderer.setFillColor(renderer.getDefaultBackground());
                            renderer.fillRectangle(0, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height - offsetStart2);
                        }
                    } else {
                        renderer.setPaintArea(SingleBarValueChart.this.graphBarArea, SingleBarValueChart.this.graphArea);
                        int h = (int)((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height / 100.0 * SingleBarValueChart.this.graphData.getPercent());
                        renderer.setFillColor(SingleBarValueChart.this.graphData.getColor());
                        renderer.fillRectangle(0, h, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width, h);
                        if (SingleBarValueChart.this.withShadows && h < ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height) {
                            renderer.setFillColor(renderer.getDefaultBackground());
                            renderer.fillRectangle(0, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height - h);
                        }
                    }
                    markerData = new ArrayList<Marker>();
                    for (SingeBarDataSet.ValueMarker m : SingleBarValueChart.this.graphData.getValueMarkers()) {
                        int pos = (int)((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height / (double)SingleBarValueChart.this.graphData.getMaxValue() * (double)m.getValue());
                        markerData.add(new Marker(pos, m.getDescription(), renderer.getFontHeight(), m.getColor()));
                    }
                    this.positionMarkers(markerData, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height, 1);
                    for (Marker marker : markerData) {
                        this.drawVerticalMarker(marker, renderer);
                    }
                }
                if (SingleBarValueChart.this.graphData.getBorderColor() != null) {
                    renderer.setForeground(SingleBarValueChart.this.graphData.getBorderColor());
                } else {
                    renderer.setForeground(Color.darker(SingleBarValueChart.this.graphData.getColor()));
                }
                renderer.drawRectangle(0, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height);
                String pattern = SingleBarValueChart.this.graphData.getInlinedText();
                if (pattern != null) {
                    renderer.setDefaultColors();
                    String cap = MessageFormat.format(pattern, (double)Math.round(SingleBarValueChart.this.graphData.getPercent() * 100.0) / 100.0);
                    int capH = (int)Math.round((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height / 2.0 + (double)renderer.getFontHeight() / 2.0);
                    renderer.drawString(cap, ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width / 2 - renderer.getStringWidth(cap) / 2, capH);
                }
                renderer.setFont(f);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void positionMarkers(List<Marker> markerData, int maxPos, int minDistance) {
            void var8_11;
            if (markerData.size() == 0) {
                return;
            }
            int maxOverBounds = 8;
            Collections.sort(markerData);
            Marker last = null;
            int lastPos = -maxOverBounds;
            for (Marker marker : markerData) {
                marker.distancePrevious = marker.getTextStart() - lastPos;
                if (last != null) {
                    last.distanceNext = marker.distancePrevious;
                    last.next = marker;
                }
                marker.previous = last;
                lastPos = marker.getTextEnd();
                last = marker;
            }
            last.distanceNext = maxPos + maxOverBounds - lastPos;
            ArrayList<Marker> visibleMarkers = new ArrayList<Marker>(markerData.size());
            for (Marker current : markerData) {
                if (current.previous != null && current.next != null && current.next.getTextStart() - current.previous.getTextEnd() < current.textSize) {
                    current.hide = true;
                    current.previous.distanceNext += current.textSize + current.distanceNext;
                    current.next.distancePrevious += current.textSize + current.distancePrevious;
                    current.previous.next = current.next;
                    current.next.previous = current.previous;
                    continue;
                }
                visibleMarkers.add(current);
            }
            boolean bl = false;
            while (var8_11 < visibleMarkers.size() / 2) {
                Marker left = (Marker)visibleMarkers.get((int)var8_11);
                left.moveRight(minDistance);
                Marker right = (Marker)visibleMarkers.get(visibleMarkers.size() - (var8_11 + true));
                right.moveLeft(minDistance);
                ++var8_11;
            }
            Marker marker = (Marker)visibleMarkers.get(visibleMarkers.size() / 2);
            if (marker.distanceNext > marker.distancePrevious) {
                marker.moveRight(minDistance);
            } else {
                marker.moveLeft(minDistance);
            }
        }

        private void drawHorizontalMarker(Marker m, Renderer renderer) {
            renderer.setPaintArea(SingleBarValueChart.this.graphBarArea, SingleBarValueChart.this.mainArea);
            renderer.setForeground(Color.BLACK);
            int p = ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height;
            int pos = m.pos1;
            renderer.drawPoint(pos, p + 1);
            renderer.drawLine(pos - 1, p + 2, pos + 1, p + 2);
            renderer.drawLine(pos - 2, p + 3, pos + 2, p + 3);
            renderer.drawLine(pos - 3, p + 4, pos + 3, p + 4);
            renderer.drawLine(pos, p + 5, pos, p + 6);
            renderer.drawPoint(pos, -1);
            renderer.drawLine(pos - 1, -2, pos + 1, -2);
            renderer.drawLine(pos - 2, -3, pos + 2, -3);
            renderer.drawLine(pos - 3, -4, pos + 3, -4);
            renderer.drawLine(pos, -5, pos, -6);
            renderer.setForeground(m.col);
            renderer.setLineStyle(Renderer.LineType.LINE_DOT);
            renderer.drawLine(pos, 1, pos, p - 1);
            renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
            renderer.setDefaultColors();
            if (!m.hide) {
                int yPos = -6;
                if (SingleBarValueChart.this.flipLabels) {
                    yPos = ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height + 6 + renderer.getFontHeight();
                }
                renderer.drawString(m.text, m.getTextStart(), yPos);
            }
        }

        private void drawHorizontalSelectedMarker(Marker m, Renderer renderer) {
            renderer.setPaintArea(SingleBarValueChart.this.graphBarArea, SingleBarValueChart.this.mainArea);
            renderer.setForeground(Color.BLUE);
            int p = ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height;
            int pos = m.pos1;
            renderer.drawPoint(pos, p + 1);
            renderer.drawLine(pos - 1, p + 2, pos + 1, p + 2);
            renderer.drawLine(pos - 2, p + 3, pos + 2, p + 3);
            renderer.drawLine(pos - 3, p + 4, pos + 3, p + 4);
            renderer.drawLine(pos - 4, p + 5, pos + 4, p + 5);
            renderer.drawLine(pos - 1, p + 6, pos + 1, p + 6);
            renderer.drawLine(pos - 1, p + 7, pos + 1, p + 7);
            renderer.drawPoint(pos, -1);
            renderer.drawLine(pos - 1, -2, pos + 1, -2);
            renderer.drawLine(pos - 2, -3, pos + 2, -3);
            renderer.drawLine(pos - 3, -4, pos + 3, -4);
            renderer.drawLine(pos - 4, -5, pos + 4, -5);
            renderer.drawLine(pos - 1, -6, pos + 1, -6);
            renderer.drawLine(pos - 1, -7, pos + 1, -7);
            renderer.setLineStyle(Renderer.LineType.LINE_DOT);
            renderer.setLineWidth(3);
            renderer.drawLine(pos, 4, pos, p - 3);
            renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
            renderer.setLineWidth(1);
        }

        private void drawHorizontalLine(long value, boolean highlight, Renderer renderer) {
            renderer.setPaintArea(SingleBarValueChart.this.graphBarArea, SingleBarValueChart.this.mainArea);
            int p = ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height;
            int pos = (int)Math.round((double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width / (double)SingleBarValueChart.this.graphData.getMaxValue() * (double)value);
            if (highlight) {
                renderer.setLineWidth(1);
                renderer.drawLine(pos, 1, pos, p - 2);
            } else {
                renderer.setLineWidth(2);
                renderer.drawLine(pos, 1, pos, p - 2);
                renderer.setLineWidth(1);
            }
        }

        private void drawHorizontalRange(Marker rm, Renderer renderer) {
            renderer.setPaintArea(SingleBarValueChart.this.graphRangeMarkerArea, SingleBarValueChart.this.graphArea);
            renderer.setForeground(rm.col);
            int lineY = 10;
            int tickY = 0;
            int textY = lineY + 2 + renderer.getFontHeight();
            if (SingleBarValueChart.this.flipLabels) {
                lineY = ((SingleBarValueChart)SingleBarValueChart.this).graphRangeMarkerArea.height - lineY;
                tickY = ((SingleBarValueChart)SingleBarValueChart.this).graphRangeMarkerArea.height;
                textY = lineY - 2;
            }
            renderer.setLineStyle(Renderer.LineType.LINE_DOT);
            renderer.drawLine(rm.pos1, lineY, rm.pos2, lineY);
            renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
            if (rm.pos2 - rm.pos1 > 16) {
                this.arrowHeadHorizontal(renderer, rm.pos1, lineY, 1);
                this.arrowHeadHorizontal(renderer, rm.pos2, lineY, -1);
            } else {
                if (rm.pos1 > 7) {
                    this.arrowHeadHorizontal(renderer, rm.pos1, lineY, -1);
                }
                if (((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width - rm.pos2 > 7) {
                    this.arrowHeadHorizontal(renderer, rm.pos2, lineY, 1);
                }
            }
            renderer.setForeground(Color.BLACK);
            renderer.drawLine(rm.pos1, tickY, rm.pos1, lineY);
            renderer.drawLine(rm.pos2, tickY, rm.pos2, lineY);
            renderer.setDefaultColors();
            renderer.drawString(rm.text, rm.getTextStart(), textY);
        }

        private void arrowHeadHorizontal(Renderer renderer, int x, int y, int direction) {
            renderer.setAlpha(64);
            renderer.drawPoint(x + direction * 2, y + 1);
            renderer.drawPoint(x + direction * 2, y - 1);
            renderer.drawPoint(x + direction * 5, y + 2);
            renderer.drawPoint(x + direction * 5, y - 2);
            renderer.setAlpha(128);
            renderer.drawPoint(x + direction * 3, y + 1);
            renderer.drawPoint(x + direction * 3, y - 1);
            renderer.drawPoint(x + direction * 6, y + 2);
            renderer.drawPoint(x + direction * 6, y - 2);
            renderer.setAlpha(255);
            renderer.drawLine(x, y, x + direction * 9, y);
            renderer.drawLine(x + direction * 4, y + 1, x + direction * 7, y + 1);
            renderer.drawLine(x + direction * 4, y - 1, x + direction * 7, y - 1);
            renderer.drawLine(x + direction * 7, y + 2, x + direction * 8, y + 2);
            renderer.drawLine(x + direction * 7, y - 2, x + direction * 8, y - 2);
        }

        private void drawVerticalMarker(Marker m, Renderer renderer) {
            renderer.setPaintArea(SingleBarValueChart.this.graphBarArea, SingleBarValueChart.this.graphArea);
            renderer.setForeground(Color.BLACK);
            int p = ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width;
            int pos = m.pos1;
            renderer.drawPoint(p + 1, pos);
            renderer.drawLine(p + 2, pos + 1, p + 2, pos - 1);
            renderer.drawLine(p + 3, pos + 2, p + 3, pos - 2);
            renderer.drawLine(p + 4, pos + 3, p + 4, pos - 3);
            renderer.drawLine(p + 5, pos, p + 6, pos);
            renderer.drawPoint(-1, pos);
            renderer.drawLine(-2, pos + 1, -2, pos - 1);
            renderer.drawLine(-3, pos + 2, -3, pos - 2);
            renderer.drawLine(-4, pos + 3, -4, pos - 3);
            renderer.drawLine(-5, pos, -6, pos);
            renderer.setForeground(m.col);
            renderer.setLineStyle(Renderer.LineType.LINE_DOT);
            renderer.drawLine(1, pos, p - 1, pos);
            renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
            renderer.setDefaultColors();
            renderer.drawString(m.text, p + 7, m.textPos + renderer.getFontHeight() / 2);
        }

        private void drawVerticalRange(Marker rm, Renderer renderer) {
            renderer.setPaintArea(SingleBarValueChart.this.graphRangeMarkerArea, SingleBarValueChart.this.graphArea);
            renderer.setForeground(rm.col);
            int x2 = ((SingleBarValueChart)SingleBarValueChart.this).graphRangeMarkerArea.width;
            int x1 = ((SingleBarValueChart)SingleBarValueChart.this).graphRangeMarkerArea.width - 10;
            renderer.setLineStyle(Renderer.LineType.LINE_DOT);
            renderer.drawLine(x1, rm.pos1, x1, rm.pos2);
            renderer.setLineStyle(Renderer.LineType.LINE_SOLID);
            if (rm.pos2 - rm.pos1 > 16) {
                this.arrowHeadVertical(renderer, x1, rm.pos1, 1);
                this.arrowHeadVertical(renderer, x1, rm.pos2, -1);
            } else {
                if (((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height - rm.pos2 > 7) {
                    this.arrowHeadVertical(renderer, x1, rm.pos2, 1);
                }
                if (rm.pos1 > 7) {
                    this.arrowHeadVertical(renderer, x1, rm.pos1, -1);
                }
            }
            renderer.setForeground(Color.BLACK);
            renderer.drawLine(x1, rm.pos1, x2, rm.pos1);
            renderer.drawLine(x1, rm.pos2, x2, rm.pos2);
            renderer.setDefaultColors();
            if (rm.pos1 > 7) {
                renderer.drawString(rm.text, x1 - 2 - renderer.getStringWidth(rm.text), rm.textPos + rm.textSize / 2);
            } else {
                renderer.drawString(rm.text, x1 - 2 - renderer.getStringWidth(rm.text), rm.textPos + rm.textSize);
            }
        }

        private void arrowHeadVertical(Renderer renderer, int x, int y, int direction) {
            renderer.setAlpha(64);
            renderer.drawPoint(x + 1, y + direction * 2);
            renderer.drawPoint(x - 1, y + direction * 2);
            renderer.drawPoint(x + 2, y + direction * 5);
            renderer.drawPoint(x - 2, y + direction * 5);
            renderer.setAlpha(128);
            renderer.drawPoint(x + 1, y + direction * 3);
            renderer.drawPoint(x - 1, y + direction * 3);
            renderer.drawPoint(x + 2, y + direction * 6);
            renderer.drawPoint(x - 2, y + direction * 6);
            renderer.setAlpha(255);
            renderer.drawLine(x, y, x, y + direction * 9);
            renderer.drawLine(x + 1, y + direction * 4, x + 1, y + direction * 7);
            renderer.drawLine(x - 1, y + direction * 4, x - 1, y + direction * 7);
            renderer.drawLine(x + 2, y + direction * 7, x + 2, y + direction * 8);
            renderer.drawLine(x - 2, y + direction * 7, x - 2, y + direction * 8);
        }

        @Override
        public void postRestoredScreen(Renderer source) {
        }

        @Override
        public void mouseUpRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseUpLeft(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMovedByRightPressed(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMovedByLeftPressed(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseMoved(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseHovered(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
            if (!SingleBarValueChart.this.enableToolTips) {
                return;
            }
            if (SingleBarValueChart.this.graphBarArea.isIn(x, y)) {
                if (SingleBarValueChart.this.type == Type.HORIZONTAL) {
                    int pos = x - ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.x;
                    if (SingleBarValueChart.this.graphData instanceof AccSingleBarDataSet) {
                        AccSingleBarDataSet data = (AccSingleBarDataSet)SingleBarValueChart.this.graphData;
                        int offset = 0;
                        double f = (double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.width / (double)data.getMaxValue();
                        for (int i = 0; i < data.getValuesCount(); ++i) {
                            int w = (int)(f * (double)data.getValue(i));
                            if (pos <= offset || pos >= (offset += w)) continue;
                            String toolTip = data.getToolTip(i);
                            if (toolTip == null) {
                                double p = (double)Math.round(100.0 / (double)data.getMaxValue() * (double)data.getValue(i) * 100.0) / 100.0;
                                source.provideToolTip(x, y, String.valueOf(p) + " %");
                            } else {
                                source.provideToolTip(x, y, toolTip);
                            }
                            break;
                        }
                    } else {
                        String toolTip = SingleBarValueChart.this.graphData.getToolTip();
                        if (toolTip == null) {
                            source.provideToolTip(x, y, SingleBarValueChart.this.graphData.getPercent() + "%");
                        } else {
                            source.provideToolTip(x, y, toolTip);
                        }
                    }
                } else {
                    int pos = y - ((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.y_end;
                    if (SingleBarValueChart.this.graphData instanceof AccSingleBarDataSet) {
                        AccSingleBarDataSet data = (AccSingleBarDataSet)SingleBarValueChart.this.graphData;
                        int offset = 0;
                        double f = (double)((SingleBarValueChart)SingleBarValueChart.this).graphBarArea.height / (double)data.getMaxValue();
                        for (int i = 0; i < data.getValuesCount(); ++i) {
                            int h = (int)(f * (double)data.getValue(i));
                            if (pos <= offset || pos >= (offset += h)) continue;
                            String toolTip = data.getToolTip(i);
                            if (toolTip == null) {
                                double p = (double)Math.round(100.0 / (double)data.getMaxValue() * (double)data.getValue(i) * 100.0) / 100.0;
                                source.provideToolTip(x, y, String.valueOf(p) + " %");
                            } else {
                                source.provideToolTip(x, y, toolTip);
                            }
                            break;
                        }
                    } else {
                        String toolTip = SingleBarValueChart.this.graphData.getToolTip();
                        if (toolTip == null) {
                            source.provideToolTip(x, y, SingleBarValueChart.this.graphData.getPercent() + "%");
                        } else {
                            source.provideToolTip(x, y, toolTip);
                        }
                    }
                }
            }
        }

        @Override
        public void mouseDownRight(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseDownLeft(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        @Override
        public void mouseDoubleClicked(Renderer source, int x, int y, GraphChartContainer.DisplayCell cell) {
        }

        final class Marker
        implements Comparable<Marker> {
            int pos1;
            int pos2;
            int textPos;
            int textSize;
            String text;
            boolean hide;
            Color col;
            Marker previous;
            Marker next;
            int distancePrevious;
            int distanceNext;

            public Marker(int pos1, int pos2, String text, int textSize, Color col) {
                this.pos1 = pos1;
                this.pos2 = pos2;
                this.textPos = pos1 + (pos2 - pos1) / 2;
                this.text = text;
                this.col = col;
                this.textSize = textSize;
            }

            public Marker(int pos, String text, int textSize, Color col) {
                this.pos1 = pos;
                this.pos2 = pos;
                this.textPos = pos;
                this.text = text;
                this.col = col;
                this.textSize = textSize;
            }

            public int getTextStart() {
                return this.textPos - this.textSize / 2;
            }

            public int getTextEnd() {
                return this.textPos + this.textSize / 2;
            }

            @Override
            public int compareTo(Marker o) {
                return this.textPos - o.textPos;
            }

            public String toString() {
                return this.text + (this.pos1 != this.pos2 ? " (Range): " : ": ") + "pos1=" + this.pos1 + ", textPos=" + this.textPos;
            }

            public void moveRight(int minDistance) {
                if (this.distancePrevious >= minDistance) {
                    return;
                }
                int delta = minDistance - this.distancePrevious;
                int push = 0;
                if (this.previous != null) {
                    push = Math.min(Math.min(delta / 2, this.previous.textSize / 2), Math.max(this.previous.distancePrevious - minDistance, 0));
                    this.previous.textPos -= push;
                    this.previous.distancePrevious -= push;
                    this.previous.distanceNext += delta;
                }
                int move = delta - push;
                this.textPos += move;
                this.distancePrevious += delta;
                this.distanceNext -= move;
                if (this.next != null) {
                    this.next.distancePrevious -= move;
                }
            }

            public void moveLeft(int minDistance) {
                if (this.distanceNext >= minDistance) {
                    return;
                }
                int delta = minDistance - this.distanceNext;
                int push = 0;
                if (this.next != null) {
                    push = Math.min(Math.min(delta / 2, this.next.textSize / 2), Math.max(this.next.distanceNext - minDistance, 0));
                    this.next.textPos += push;
                    this.next.distanceNext -= push;
                    this.next.distancePrevious += delta;
                }
                int move = delta - push;
                this.textPos -= move;
                this.distanceNext += delta;
                this.distancePrevious -= move;
                if (this.previous != null) {
                    this.previous.distanceNext -= move;
                }
            }
        }
    };

    public SingleBarValueChart(GraphChartContainer container) {
        this.chartsContainer = container;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void enableShadows(boolean enable) {
        this.withShadows = enable;
    }

    public void enableToolTips(boolean enable) {
        this.enableToolTips = enable;
    }

    public void flipBarLables(boolean flip) {
        this.flipLabels = flip;
    }

    public void setDescriptionAlignment(DescAlighnment alignment) {
        this.alignment = alignment;
    }

    @Override
    public Renderer getRenderer() {
        return this.chartsContainer.getRenderer();
    }

    @Override
    public LegendPositionAnchor getDefaultLegedPosition() {
        return null;
    }

    @Override
    public LegendPositionAnchor[] getLegendAnchors() {
        return null;
    }

    @Override
    public void addGraph(SingeBarDataSet graph) {
        this.graphData = graph;
    }

    @Override
    public void addGraph(SingeBarDataSet graph, boolean secondary) {
        if (secondary) {
            throw new UnsupportedOperationException("Secondary y-axis is not supported by SingleBarValueChart");
        }
        this.addGraph(graph);
    }

    @Override
    public List<SingeBarDataSet> getAllGraphs() {
        ArrayList<SingeBarDataSet> result = new ArrayList<SingeBarDataSet>(1);
        result.add(this.graphData);
        return result;
    }

    @Override
    public void removeAllGraphs() {
        this.graphData = null;
    }

    @Override
    public void refresh() {
        if (this.lastDisplayCell == null || this.lastDisplayCell.isDisposed()) {
            return;
        }
        this.actionListener.repaintDrawingArea(this.chartsContainer.getRenderer());
        this.actionListener.postRestoredScreen(this.chartsContainer.getRenderer());
        this.chartsContainer.updateScreen(this.lastDisplayCell);
    }

    @Override
    public ChartsContainerActionListener provideContainerListener() {
        return this.actionListener;
    }

    public void setGraphAreaLayoutAdatptor(RectangleLayoutAdaptor adaptor) {
        this.layoutAdaptor = adaptor;
    }

    @Override
    public String getAccessibleControlName() {
        return I18n._s((String)"Bar Chart");
    }

    @Override
    public String getAccessibleStateText() {
        String toolTip;
        StringBuilder result = new StringBuilder();
        if (this.graphData.getName() != null) {
            result.append(this.graphData.getName()).append(", ");
        }
        if (this.graphData.getValueDescription() != null) {
            result.append(this.graphData.getValueDescription()).append(", ");
        }
        if ((toolTip = this.graphData.getToolTip()) != null && toolTip.length() != 0) {
            result.append(toolTip);
        } else {
            double percent = (double)Math.round(this.graphData.getPercent() * 100.0) / 100.0;
            String pattern = this.graphData.getInlinedText();
            if (pattern != null) {
                result.append(MessageFormat.format(pattern, percent));
            } else {
                result.append(percent).append("%");
            }
        }
        return result.toString();
    }

    @Override
    public void keyNext() {
    }

    @Override
    public void keyPrevious() {
    }

    public static enum DescAlighnment {
        LEFT,
        CENTER,
        RIGHT,
        CENTERED_ON_BAR;

    }

    public static enum Type {
        VERTICAL,
        HORIZONTAL;

    }
}

