/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph;

import com.sap.jvm.profiling.ui.graph.XYGraphContainerListener;
import com.sap.jvm.profiling.ui.graph.XYGraphRenderer;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.dataset.XYGraphDataSet;
import com.sap.jvm.profiling.ui.graph.progress.RenderingAsyncProgress;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class XYGraphContainer<T extends XYGraphDataSet> {
    protected Renderer renderer;
    private ArrayList<T> graphs = new ArrayList();
    private ArrayList<Boolean> secondaryAxis = new ArrayList();
    private HashSet<XYGraphContainerListener<T>> listeners = new HashSet();

    protected XYGraphContainer(Renderer renderer) {
        this.renderer = renderer;
    }

    protected abstract XYGraphRenderer<T> getGraphRenderer();

    protected void appendGraph(T data, boolean secondary) {
        this.graphs.add(data);
        this.secondaryAxis.add(secondary);
        this.notifyAppendedGraph(data);
    }

    protected List<T> getAllGraphs() {
        return new ArrayList<T>(this.graphs);
    }

    protected List<T> getAllPrimaryAxisGraphs() {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < this.graphs.size(); ++i) {
            if (this.secondaryAxis.get(i).booleanValue()) continue;
            result.add(this.graphs.get(i));
        }
        return result;
    }

    protected List<T> getAllSecondaryAxisGraphs() {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < this.graphs.size(); ++i) {
            if (!this.secondaryAxis.get(i).booleanValue()) continue;
            result.add(this.graphs.get(i));
        }
        return result;
    }

    protected List<Boolean> getSecondaryAxisFlags() {
        return new ArrayList<Boolean>(this.secondaryAxis);
    }

    public boolean isEmpty() {
        return this.graphs.isEmpty();
    }

    public T getFirstGraph() {
        return (T)(this.isEmpty() ? null : (XYGraphDataSet)this.graphs.get(0));
    }

    protected void removeAllGraphs(XYGraphAxesModel axes_model) {
        if (this.graphs.size() == 0) {
            return;
        }
        ArrayList<T> save_graphs = this.graphs;
        this.graphs = new ArrayList();
        this.secondaryAxis = new ArrayList();
        if (axes_model != null) {
            axes_model.setAxesToDefault(this.renderer.getWidth(), this.renderer.getHeight());
        }
        this.notifyRemovedAllGraphs(save_graphs);
    }

    protected boolean removeGraph(T graph) {
        if (!this.graphs.isEmpty() && this.graphs.contains(graph)) {
            int idx = this.graphs.indexOf(graph);
            this.graphs.remove(graph);
            this.secondaryAxis.remove(idx);
            this.notifyRemovedGraph(graph);
            return true;
        }
        return false;
    }

    protected void initAxes(XYGraphAxesModel axes_model, RenderingAsyncProgress.Progress progress) {
        if (axes_model != null) {
            axes_model.updateAxesSize(this.graphs, this.secondaryAxis, this.renderer.getWidth(), this.renderer.getHeight(), progress);
        }
    }

    protected void repaintGraphs(XYGraphAxesModel model) {
        for (XYGraphDataSet graph : this.graphs) {
            this.getGraphRenderer().drawGraph(graph, this.renderer, model);
        }
    }

    public void addGraphContainerListener(XYGraphContainerListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeGraphContainerListener(XYGraphContainerListener<T> listener) {
        this.listeners.remove(listener);
    }

    private void notifyAppendedGraph(T graph) {
        for (XYGraphContainerListener<T> l : this.listeners) {
            l.appendedGraph(graph);
        }
    }

    private void notifyRemovedAllGraphs(ArrayList<T> removedGraphs) {
        for (XYGraphContainerListener<T> l : this.listeners) {
            l.removedAllGraphs(removedGraphs);
        }
    }

    private void notifyRemovedGraph(T removedGraph) {
        for (XYGraphContainerListener<T> l : this.listeners) {
            l.removedGraph(removedGraph);
        }
    }
}

