/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.example;

import com.sap.jvm.profiling.ui.graph.BarGraphChart;
import com.sap.jvm.profiling.ui.graph.BarGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.BarGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.awt.controls.GraphContainerControl;
import com.sap.jvm.profiling.ui.graph.axes.BarGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.dataset.AccBarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.BarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.ColoredBarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.XYGraphDataSet;
import com.sap.jvm.profiling.ui.graph.legend.BarGraphLegendContributor;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;

public class BarGraphAWTExample {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        GraphContainerControl container = new GraphContainerControl(2);
        container.getChartContainer().enableLegend(true);
        BarGraphAWTExample.configureGraph(container.getChartContainer());
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)container, "Center");
        frame.setTitle("AWT Bar Graph Control");
        frame.setSize(500, 500);
        frame.setVisible(true);
    }

    public static void configureGraph(GraphChartContainer container) {
        final BarGraphAxisCaptionProvider captionProvider = new BarGraphAxisCaptionProvider(){

            @Override
            public String provideScaleUnitCaption(double value, double scaleStep, double min, double max) {
                return String.valueOf(value);
            }

            @Override
            public String provideBarIndexCaption(int idx) {
                switch (idx) {
                    case 0: {
                        return "Long text with \n wrapping!!";
                    }
                    case 1: {
                        return "Single but very long";
                    }
                    case 2: {
                        return "Short";
                    }
                }
                return "idx " + idx;
            }

            @Override
            public String provideAxisTitle(double min, double max) {
                return "";
            }
        };
        final BarGraphChart chart1 = new BarGraphChart(container, true, true);
        final BarGraphChart chart2 = new BarGraphChart(container, true, false);
        final BarGraphChart chart3 = new BarGraphChart(container, true, true);
        BarGraphLegendContributor legendCreator = new BarGraphLegendContributor(container);
        legendCreator.registerChartLegendContributor(chart1);
        legendCreator.registerChartLegendContributor(chart2);
        legendCreator.registerChartLegendContributor(chart3);
        chart1.setAxesCaptionProvider(captionProvider);
        chart2.setAxesCaptionProvider(captionProvider);
        chart3.setAxesCaptionProvider(captionProvider);
        BarGraphToolTipProvider toolTipProvider = new BarGraphToolTipProvider(){

            @Override
            public String provideToolTip(BarGraphDataSet set, int idx) {
                String name = set.getName();
                if (set.getType() == XYGraphDataSet.GraphType.COLORED) {
                    ColoredBarGraphDataSet cSet = (ColoredBarGraphDataSet)set;
                    name = cSet.getText(cSet.getValueAt(idx));
                }
                return name + "\n---------------\n" + captionProvider.provideBarIndexCaption(idx) + "\n---------------\n" + set.getYValueAt(idx);
            }
        };
        chart1.setToolTipProvider(toolTipProvider);
        chart2.setToolTipProvider(toolTipProvider);
        chart3.setToolTipProvider(toolTipProvider);
        chart1.enableContentScrolling(true);
        chart2.enableContentScrolling(true);
        chart3.enableContentScrolling(true);
        container.setInitializer(new Runnable(){

            @Override
            public void run() {
                chart1.adjustYAxis(0.0, 150.0);
                chart1.adjustYAxis(0.0, 300.0);
                chart2.adjustYAxis(0.0, 150.0);
                chart2.adjustYAxis(0.0, 300.0);
                chart3.adjustYAxis(0.0, 150.0);
                chart3.adjustYAxis(0.0, 300.0);
            }
        });
        BarGraphDataSet data = new BarGraphDataSet("set1");
        data.setGraphColor(new Color(251, 246, 195));
        data.addValue(60.0);
        data.addValue(80.0);
        data.addValue(100.0);
        data.addValue(120.0);
        BarGraphDataSet data2 = new BarGraphDataSet("set2");
        data2.setGraphColor(new Color(172, 249, 106));
        data2.addValue(20.0);
        data2.addValue(70.0);
        data2.addValue(90.0);
        data2.addValue(110.0);
        chart1.addGraph(data2);
        BarGraphDataSet data3 = new BarGraphDataSet("set3");
        data3.setGraphColor(new Color(223, 183, 112));
        data3.addValue(10.0);
        data3.addValue(20.0);
        data3.addValue(30.0);
        data3.addValue(40.0);
        chart1.addGraph(data3);
        AccBarGraphDataSet accSet = new AccBarGraphDataSet("", new BarGraphDataSet[]{data, data2, data3});
        chart1.addGraph(accSet, false);
        BarGraphDataSet data4 = new BarGraphDataSet("set4");
        for (int i = 0; i < 30; ++i) {
            data4.addValue(Math.round(Math.random() * 100.0));
        }
        data4.setGraphColor(new Color(223, 183, 172));
        chart2.addGraph(data4);
        BarGraphDataSet data5 = new BarGraphDataSet("set5");
        data5.setGraphColor(new Color(136, 164, 212));
        data5.addValue(10.0);
        data5.addValue(20.0);
        data5.addValue(30.0);
        data5.addValue(40.0);
        chart3.addGraph(data5);
        chart3.addGraph(data);
        ColoredBarGraphDataSet data6 = new ColoredBarGraphDataSet();
        for (int i = 0; i < 4; ++i) {
            data6.addValue(0.0);
        }
        data6.addValue(40.0, "C_P1", Color.RED);
        data6.addValue(24.0, "C_P2", Color.GREEN);
        data6.addValue(24.0, "C_P3", Color.YELLOW);
        chart3.addGraph(data6);
        chart1.addSelectionListener(new BarGraphSelectionListener(){

            @Override
            public void selectionChanged(BarGraphChart.BarSelectedValues val, boolean selected) {
                StringBuilder values = new StringBuilder(selected ? "SEL\n" : "DSEL\n");
                if (val.getDataSet() instanceof ColoredBarGraphDataSet) {
                    values.append("colored...");
                } else {
                    values.append(val.getDataSet().getName());
                }
                for (int i : val.getSelectedValues()) {
                    values.append(" [");
                    values.append(String.valueOf(i));
                    values.append(']');
                }
                values.append('\n');
                System.out.println(values);
            }
        });
        container.addChart(chart1);
        container.addChart(chart2);
        container.addChart(chart3);
    }
}

