/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.example;

import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.PieGraphChart;
import com.sap.jvm.profiling.ui.graph.PieGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.PieGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.awt.controls.GraphContainerControl;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.ColorPool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedHashSet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ColorPoolExample {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JTabbedPane tabPane = new JTabbedPane();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)tabPane, "Center");
        JPanel panel = new JPanel();
        tabPane.add("Entire Color Poool", panel);
        GraphContainerControl container = new GraphContainerControl(1);
        panel.setLayout(new BorderLayout());
        panel.add((Component)container, "Center");
        PieGraphChart chart = new PieGraphChart(container.getChartContainer());
        container.getChartContainer().addChart(chart);
        container.getChartContainer().enableLegend(true);
        ColorPoolExample.configureGraph2(chart);
        panel = new JPanel();
        tabPane.add("Color Categories", panel);
        container = new GraphContainerControl(3);
        container.getChartContainer().enableLegend(true);
        panel.setLayout(new BorderLayout());
        panel.add((Component)container, "Center");
        ColorPoolExample.configureGraph(container.getChartContainer());
        frame.setTitle("Color Pool");
        frame.setExtendedState(6);
        frame.setSize(700, 600);
        frame.setVisible(true);
    }

    public static void configureGraph(GraphChartContainer container) {
        ColorPool pool = ColorPool.getPool();
        int i = 0;
        for (Color[] c : pool.getColors()) {
            PieGraphDataSet data = new PieGraphDataSet("[" + i++ + "]");
            int j = 0;
            for (Color c2 : c) {
                data.addValue(10.0, "[" + j++ + "]", c2);
            }
            data.setFixedToolTips(true);
            PieGraphChart chart = new PieGraphChart(container);
            chart.addGraph(data);
            chart.setToolTipsProvider(data, new PieGraphToolTipProvider(){

                @Override
                public String provideToolTip(PieGraphDataSet pie, PieGraphDataSet.PiePiece piece) {
                    return "[" + pie.getPieces().indexOf(piece) + ']';
                }
            });
            container.addChart(chart);
        }
    }

    public static void configureGraph2(final PieGraphChart chart) {
        final ColorPool pool = ColorPool.getPool();
        int i = 0;
        PieGraphDataSet data = new PieGraphDataSet("All Colors...");
        for (Color[] c : pool.getColors()) {
            int j = 0;
            for (Color c2 : c) {
                data.addValue(10.0, "[" + i + "][" + j++ + "]", c2);
            }
            ++i;
        }
        chart.setToolTipsProvider(data, new PieGraphToolTipProvider(){

            @Override
            public String provideToolTip(PieGraphDataSet pie, PieGraphDataSet.PiePiece piece) {
                return null;
            }
        });
        chart.addGraph(data);
        chart.addSelectionListener(data, new PieGraphSelectionListener(){

            @Override
            public void selectionChanged(PieGraphDataSet set, PieGraphDataSet.PiePiece piece) {
                LinkedHashSet<Color> checkSet = new LinkedHashSet<Color>();
                PieGraphChart.PieSelectedPieces[] selection = chart.getSelection();
                if (selection.length > 0) {
                    for (PieGraphDataSet.PiePiece p : chart.getSelection()[0].getSelectedPieces()) {
                        checkSet.add(p.getColor());
                    }
                    StringBuilder codeTxt = new StringBuilder();
                    for (Color[] c : pool.getColors()) {
                        codeTxt.append("new ColorRange(new Color[] {\n");
                        for (Color c2 : c) {
                            codeTxt.append("    ");
                            if (checkSet.contains(c2)) {
                                codeTxt.append("//");
                            }
                            codeTxt.append("new Color(" + c2.red + ',' + c2.green + ',' + c2.blue + "),\n");
                        }
                        codeTxt.append("}),\n");
                    }
                    System.out.print("\n\n\n\n\n");
                    System.out.print("----------------------------------");
                    System.out.print("\n\n\n\n\n" + codeTxt);
                }
            }
        });
    }
}

