/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.example;

import com.sap.jvm.profiling.ui.graph.AxisChart;
import com.sap.jvm.profiling.ui.graph.BarGraphChart;
import com.sap.jvm.profiling.ui.graph.BarGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.LineGraphChart;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.LineGraphValueBarToolTipProvider;
import com.sap.jvm.profiling.ui.graph.PieGraphChart;
import com.sap.jvm.profiling.ui.graph.SingleBarValueChart;
import com.sap.jvm.profiling.ui.graph.TitleAlignment;
import com.sap.jvm.profiling.ui.graph.awt.controls.GraphContainerControl;
import com.sap.jvm.profiling.ui.graph.axes.AxisCaptionProviderBase;
import com.sap.jvm.profiling.ui.graph.axes.BarGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.InvalidSelectionRange;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.AccSingleBarDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.BarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.ColoredBarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphVirtualDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.XYGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.layouting.GraphContainerChartLayoutListener;
import com.sap.jvm.profiling.ui.graph.legend.LegendItem;
import com.sap.jvm.profiling.ui.graph.legend.LegendSelectionListener;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.ColorPool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;

public class GraphContainerAWTExample {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        GraphContainerControl container = new GraphContainerControl();
        GraphContainerAWTExample.configureGraph(container.getChartContainer());
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)container, "Center");
        frame.setTitle("AWT Graphs Container Control");
        frame.setSize(1300, 900);
        frame.setVisible(true);
    }

    public static void configureGraph(GraphChartContainer container) {
        int x;
        container.setColumnsCount(20);
        container.enableLegend(true);
        container.enableLegendItemSelection(true);
        container.addLegendItem("T1", Color.RED, new LegendSelectionListener(){

            @Override
            public void selectionChanged(LegendItem item) {
                System.out.println("T1 selected");
            }
        });
        container.addLegendItem("T2", Color.GRAY, new LegendSelectionListener(){

            @Override
            public void selectionChanged(LegendItem item) {
                System.out.println("T2 selected");
            }
        });
        container.addLegendSeparator("Separator");
        container.addLegendItem("T3", Color.BLUE, new LegendSelectionListener(){

            @Override
            public void selectionChanged(LegendItem item) {
                System.out.println("T3 selected");
            }
        });
        final BarGraphAxisCaptionProvider captionProvider = new BarGraphAxisCaptionProvider(){

            @Override
            public String provideScaleUnitCaption(double value, double scaleStep, double min, double max) {
                return String.valueOf(value);
            }

            @Override
            public String provideBarIndexCaption(int idx) {
                switch (idx) {
                    case 0: {
                        return "Long text with \n wrapping!!";
                    }
                    case 1: {
                        return "Single but very long";
                    }
                    case 2: {
                        return "Short";
                    }
                }
                return "idx " + idx;
            }

            @Override
            public String provideAxisTitle(double min, double max) {
                return "";
            }
        };
        final BarGraphChart chart = new BarGraphChart(container, true, true);
        chart.setAxesCaptionProvider(captionProvider);
        chart.setToolTipProvider(new BarGraphToolTipProvider(){

            @Override
            public String provideToolTip(BarGraphDataSet set, int idx) {
                String name = set.getName();
                if (set.getType() == XYGraphDataSet.GraphType.COLORED) {
                    ColoredBarGraphDataSet cSet = (ColoredBarGraphDataSet)set;
                    name = cSet.getText(cSet.getValueAt(idx));
                }
                return name + "\n---------------\n" + captionProvider.provideBarIndexCaption(idx) + "\n---------------\n" + set.getYValueAt(idx);
            }
        });
        chart.enableVerticalBarTitels(true);
        chart.enableContentScrolling(true);
        BarGraphDataSet data = new BarGraphDataSet("set1");
        data.setGraphColor(new Color(251, 246, 195));
        data.addValue(60.0);
        data.addValue(80.0);
        data.addValue(100.0);
        data.addValue(120.0);
        chart.addGraph(data);
        BarGraphDataSet data2 = new BarGraphDataSet("set2");
        data2.setGraphColor(new Color(172, 249, 106));
        data2.addValue(20.0);
        data2.addValue(70.0);
        data2.addValue(90.0);
        data2.addValue(110.0);
        chart.addGraph(data2);
        BarGraphDataSet data3 = new BarGraphDataSet("set3");
        data3.setGraphColor(new Color(223, 183, 112));
        data3.addValue(10.0);
        data3.addValue(20.0);
        data3.addValue(30.0);
        data3.addValue(40.0);
        chart.addGraph(data3);
        final BarGraphChart chart2 = new BarGraphChart(container, true, true);
        chart2.enableContentScrolling(true);
        chart2.setToolTipProvider(new BarGraphToolTipProvider(){

            @Override
            public String provideToolTip(BarGraphDataSet set, int idx) {
                String name = set.getName();
                if (set.getType() == XYGraphDataSet.GraphType.COLORED) {
                    ColoredBarGraphDataSet cSet = (ColoredBarGraphDataSet)set;
                    name = cSet.getText(cSet.getValueAt(idx));
                }
                return name + "\n---------------\n" + captionProvider.provideBarIndexCaption(idx) + "\n---------------\n" + set.getYValueAt(idx);
            }
        });
        BarGraphDataSet data4 = new BarGraphDataSet("set4");
        for (int i = 0; i < 30; ++i) {
            data4.addValue(Math.round(Math.random() * 100.0));
        }
        data4.setGraphColor(new Color(223, 183, 172));
        chart2.addGraph(data4);
        final LineGraphChart chart3 = new LineGraphChart(container, true, true);
        chart3.enableHorizontalMouseMove(true);
        chart3.enableHorizontalSelection(true);
        chart3.setAdjustOnDoubleClick(true);
        chart3.enableQuickView(true);
        chart3.setHorizontalQuickViewSelection(true);
        chart3.setYAxisCaptionProvider(new AxisCaptionProviderBase(){

            @Override
            public String provideAxisTitle(double min, double max) {
                return "Y-Axis Title";
            }
        });
        chart3.setXAxisCaptionProvider(new AxisCaptionProviderBase(){

            @Override
            public String provideAxisTitle(double min, double max) {
                return "X-Axis Title";
            }
        });
        chart3.setValueBarToolTipProvider(new LineGraphValueBarToolTipProvider(){

            @Override
            public boolean isGraphValueToltipAvailable(LineGraphDataSet graph) {
                return true;
            }

            @Override
            public boolean isBarValueTooltipAvailable() {
                return true;
            }

            @Override
            public Color getTipColor(LineGraphDataSet graph) {
                return graph.getGraphColor();
            }

            @Override
            public String getYAxisValueText(LineGraphDataSet graph, double value) {
                return String.valueOf(value);
            }

            @Override
            public String getXAxisValueText(double value) {
                return String.valueOf(value);
            }
        });
        chart3.addLineGraphSelectionListener(new LineGraphSelectionListener(){

            @Override
            public void valueSelected(LineGraphDataSet graph, List<Value2D> values) {
            }

            @Override
            public void selectionReset() {
            }

            @Override
            public void selectionClickedOn() {
                chart3.zoomSelection();
            }

            @Override
            public void rectangleRangeSelectionChanged(double minX, double maxX, double minY, double maxY) {
            }

            @Override
            public void rectangleRangeSelected(double minX, double maxX, double minY, double maxY) {
            }

            @Override
            public void horizontalRangeSelectionChanged(double min, double max, List<InvalidSelectionRange> ranges) {
            }

            @Override
            public void horizontalRangeSelected(double min, double max, List<InvalidSelectionRange> ranges) {
            }

            @Override
            public void graphSelected(LineGraphDataSet graph) {
            }
        });
        try {
            LineGraphVirtualDataSet set = LineGraphChart.createVirtualDataSet("VG_1", "VG1");
            LineGraphVirtualDataSet set2 = LineGraphChart.createVirtualDataSet("VG_2", "VG2");
            LineGraphVirtualDataSet set3 = LineGraphChart.createVirtualDataSet("VG_3", "VG3");
            for (x = 0; x < 1999999; ++x) {
                set.addValue(x, Math.random() * 10.0);
                set2.addValue(x, Math.random() * 10.0);
                set3.addValue(x, Math.random() * 10.0);
            }
            chart3.addGraph(set);
            chart3.addGraph(set2);
            chart3.addGraph(set3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        final LineGraphChart chart8 = new LineGraphChart(container, true, true);
        try {
            LineGraphVirtualDataSet set8 = LineGraphChart.createVirtualDataSet("VG_8", "VG8");
            LineGraphVirtualDataSet set9 = LineGraphChart.createVirtualDataSet("VG_9", "VG9");
            for (x = 0; x < 1999999; ++x) {
                set8.addValue(x, Math.random() * 10.0);
                set9.addValue((double)x, Math.random() * 10.0, x % 5 == 0);
            }
            chart8.addGraph(set8);
            chart8.addGraph(set9);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        chart8.enableHorizontalMouseMove(true);
        chart8.enableHorizontalSelection(true);
        chart8.setAdjustOnDoubleClick(true);
        chart8.enableQuickView(true);
        chart8.enableValueSelection(true);
        chart8.setValueBarToolTipProvider(new LineGraphValueBarToolTipProvider(){

            @Override
            public boolean isGraphValueToltipAvailable(LineGraphDataSet graph) {
                return true;
            }

            @Override
            public boolean isBarValueTooltipAvailable() {
                return true;
            }

            @Override
            public Color getTipColor(LineGraphDataSet graph) {
                return null;
            }

            @Override
            public String getYAxisValueText(LineGraphDataSet graph, double value) {
                return String.valueOf(value);
            }

            @Override
            public String getXAxisValueText(double value) {
                return String.valueOf(value);
            }
        });
        chart8.addLineGraphSelectionListener(new LineGraphSelectionListener(){

            @Override
            public void valueSelected(LineGraphDataSet graph, List<Value2D> values) {
            }

            @Override
            public void selectionReset() {
            }

            @Override
            public void selectionClickedOn() {
                chart8.zoomSelection();
            }

            @Override
            public void rectangleRangeSelectionChanged(double minX, double maxX, double minY, double maxY) {
            }

            @Override
            public void rectangleRangeSelected(double minX, double maxX, double minY, double maxY) {
            }

            @Override
            public void horizontalRangeSelectionChanged(double min, double max, List<InvalidSelectionRange> ranges) {
            }

            @Override
            public void horizontalRangeSelected(double min, double max, List<InvalidSelectionRange> ranges) {
            }

            @Override
            public void graphSelected(LineGraphDataSet graph) {
            }
        });
        PieGraphChart chart4 = new PieGraphChart(container);
        PieGraphDataSet dataPie = new PieGraphDataSet();
        dataPie.addValue(35.0, "P1");
        dataPie.addValue(135.0, "P2");
        dataPie.addValue(65.0, "P3");
        dataPie.addValue(45.0, "P4");
        dataPie.set3DRepresentation(true);
        dataPie.setFixedToolTips(true);
        chart4.addGraph(dataPie);
        PieGraphChart chart5 = new PieGraphChart(container);
        PieGraphDataSet dataPie2 = new PieGraphDataSet();
        dataPie2.addValue(345.0, "P1");
        dataPie2.addValue(1335.0, "P2");
        dataPie2.addValue(645.0, "P3");
        dataPie2.addValue(455.0, "P4");
        dataPie2.addValue(645.0, "P5");
        chart5.addGraph(dataPie2);
        dataPie2.setStartAngle(90);
        dataPie2.setRotateCW(true);
        dataPie2.setFixedToolTips(true);
        SingleBarValueChart chart10 = new SingleBarValueChart(container);
        chart10.enableShadows(true);
        AccSingleBarDataSet data10 = new AccSingleBarDataSet();
        chart10.addGraph(data10);
        chart10.setType(SingleBarValueChart.Type.HORIZONTAL);
        data10.setMaxValue(100L);
        data10.setValueDescription("Value Description");
        data10.setRangeMarker(20L, 40L, "raster", Color.RED);
        SingleBarValueChart chart11 = new SingleBarValueChart(container);
        AccSingleBarDataSet data11 = new AccSingleBarDataSet();
        chart11.addGraph(data11);
        data11.setMaxValue(1000L);
        data11.addValue(385L);
        data11.addValue(205L);
        data11.addValue(123L, ColorPool.getPool().getNext(), "Last Value!!!!");
        data10.addValue(68L);
        data10.setValueMarker(20L, "min");
        data10.setValueMarker(80L, "max");
        data11.setValueMarker(200L, "min");
        data11.setValueMarker(800L, "max");
        data11.setRangeMarker(300L, 700L, "range", ColorPool.getPool().getNext());
        data11.setValueDescription("Value Description");
        RasterCalculationAdapter rasterA = new RasterCalculationAdapter(){

            @Override
            public double adaptRasterSize(double calculatedValue, double min, double max) {
                return 50.0;
            }

            @Override
            public int getInitialScaleStepSize() {
                return 30;
            }

            @Override
            public double getRasterOrigin(double rasterSize, double min) {
                return min;
            }
        };
        final AxisChart axesChartBottom = new AxisChart(container);
        axesChartBottom.setRasterAdapter(rasterA);
        axesChartBottom.adjustAxis(0.0, 1000.0);
        AxisChart axesChartLeft = new AxisChart(container, 0, 0);
        axesChartLeft.setRasterAdapter(rasterA);
        axesChartLeft.adjustAxis(0.0, 1000.0);
        axesChartLeft.addLayoutListener(new GraphContainerChartLayoutListener(){

            @Override
            public void layoutChanged(Rectangle baseGraphArea, Rectangle[] allChartAreas) {
                axesChartBottom.setPaddingStart(baseGraphArea.width);
            }
        });
        container.addChart(axesChartLeft, 1, 22);
        container.addChart(chart, 19, 8);
        container.addChart(chart4, 9, 3);
        container.addChart(chart3, 10, 7);
        container.addChart(chart2, 9, 4);
        container.addChart(chart8, 7, 7);
        container.addChart(chart5, 5, 7);
        container.addChart(chart11, 3, 7);
        container.addChart(chart10, 4, 7);
        container.addChart(axesChartBottom, 20, 1);
        container.setChartTitle("BarGraphChart", TitleAlignment.CENTER, 1);
        container.setChartTitle("PieChart 3d", TitleAlignment.CENTER, 2);
        container.setChartTitle("LinegraphChart", TitleAlignment.CENTER, 3);
        container.setChartTitle("BarGraphChart", TitleAlignment.CENTER, 4);
        container.setChartTitle("LinegraphChart", TitleAlignment.CENTER, 5);
        container.setChartTitle("PieChart 2d", TitleAlignment.CENTER, 6);
        container.setChartTitle("SingleBarGraphChart", TitleAlignment.CENTER, 8);
        container.setInitializer(new Runnable(){

            @Override
            public void run() {
                chart.adjustYAxis(0.0, 150.0);
                chart2.adjustYAxis(0.0, 150.0);
                chart3.adjustXAxis(0.0, 1999999.0, false);
                chart8.adjustXAxis(0.0, 1999999.0, false);
            }
        });
    }
}

