/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.example;

import com.sap.jvm.profiling.ui.graph.LineGraphChart;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionToolTipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphValueBarToolTipProvider;
import com.sap.jvm.profiling.ui.graph.awt.controls.GraphContainerControl;
import com.sap.jvm.profiling.ui.graph.axes.AxisCaptionProviderBase;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JFrame;

public class LineGraphAWTExample {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        GraphContainerControl container = new GraphContainerControl(1);
        LineGraphChart chart = new LineGraphChart(container.getChartContainer(), true, true);
        container.getChartContainer().addChart(chart);
        container.getChartContainer().enableLegend(true);
        LineGraphAWTExample.configureGraph(chart);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)container, "Center");
        frame.setTitle("AWT Line Graph Control");
        frame.setSize(500, 500);
        frame.setVisible(true);
    }

    public static void configureGraph(LineGraphChart chart) {
        chart.enableValueSelection(true);
        chart.enableRectangleSelection(true);
        chart.enableHorizontalSelection(true);
        chart.enableMouseMove(true);
        chart.setAdjustOnDoubleClick(true);
        chart.enableQuickView(true);
        chart.adjustXAxis(0.0, 11.0, false);
        chart.adjustYAxis(-2.0, 17.0, false);
        chart.setValueBarToolTipProvider(new LineGraphValueBarToolTipProvider(){

            @Override
            public String getXAxisValueText(double value) {
                return "X-" + value;
            }

            @Override
            public String getYAxisValueText(LineGraphDataSet graph1, double value) {
                return graph1.getName();
            }

            @Override
            public boolean isBarValueTooltipAvailable() {
                return true;
            }

            @Override
            public boolean isGraphValueToltipAvailable(LineGraphDataSet graph1) {
                return true;
            }
        });
        chart.addLineGraphSelectionToolTipProvider(new LineGraphSelectionToolTipProvider(){

            @Override
            public String provideHorizontalSelectionText(double min, double max) {
                return "" + Math.round(min) + '/' + Math.round(max);
            }

            @Override
            public String provideSelectedValueToolTip(LineGraphDataSet graph, List<Value2D> values) {
                return "A    \nB    \nC    y";
            }
        });
        LineGraphDataSet dataset = LineGraphChart.createDataSet("First");
        dataset.addValue(2.0, 1.0, true);
        dataset.addValue(3.0, 1.8, true);
        dataset.addValue(4.5, 7.9, true);
        dataset.addValue(5.6, 15.0, true);
        dataset.addValue(6.0, 4.0, true);
        dataset.addValue(7.0, 8.0, true);
        dataset.addValue(8.0, 9.0, true);
        dataset.setGraphColor(Color.GREEN);
        dataset.setValueColor(Color.ORANGE);
        chart.addGraph(dataset);
        LineGraphDataSet dataset2 = LineGraphChart.createDataSet("Second");
        dataset2.addValue(2.0, 1.5, true);
        dataset2.addValue(3.5, 7.0, true);
        dataset2.addValue(4.0, 5.0, true);
        dataset2.addValue(6.0, 1.0, true);
        dataset2.addValue(7.0, 10.0, true);
        chart.addGraph(dataset2);
        LineGraphDataSet data3 = LineGraphChart.createDataSet("Third");
        data3.addValue(5.4, 10.0, true);
        data3.addValue(3.4, 6.0, true);
        data3.addValue(1.4, 7.9, true);
        data3.addValue(6.8, 4.3, true);
        data3.addValue(7.1, 10.0, true);
        data3.setGraphColor(Color.MAGENTA);
        data3.setValueColor(Color.BLACK);
        chart.addGraph(data3);
        LineGraphDataSet data4 = LineGraphChart.createDataSet("Fourth");
        data4.addValue(3.0, 0.0, true);
        data4.addValue(4.0, 0.0, true);
        data4.addValue(5.0, 1.0, true);
        data4.addValue(6.0, 1.0, true);
        data4.addValue(7.0, 0.0, true);
        data4.addValue(10.0, 0.0, true);
        data4.setGraphColor(Color.ORANGE);
        data4.setValueColor(Color.BLACK);
        chart.addGraph(data4);
        chart.setXAxisCaptionProvider(new AxisCaptionProviderBase());
        chart.setYAxisCaptionProvider(new AxisCaptionProviderBase());
    }
}

