/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.example;

import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.PieGraphChart;
import com.sap.jvm.profiling.ui.graph.PieGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.PieGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.awt.controls.GraphContainerControl;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.legend.PieGraphLegendContributor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;

public class PieGraphAWTExample {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        GraphContainerControl container = new GraphContainerControl(2);
        container.getChartContainer().enableLegend(true);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)container, "Center");
        PieGraphAWTExample.configureGraph(container.getChartContainer());
        frame.setTitle("AWT Pie Graph Control");
        frame.setSize(700, 600);
        frame.setVisible(true);
    }

    public static void configureGraph(GraphChartContainer container) {
        PieGraphChart chart = new PieGraphChart(container);
        container.addChart(chart);
        final PieGraphChart chart2 = new PieGraphChart(container);
        container.addChart(chart2);
        PieGraphLegendContributor legendCreator = new PieGraphLegendContributor(container);
        legendCreator.registerChartLegendContributor(chart);
        legendCreator.registerChartLegendContributor(chart2);
        PieGraphDataSet data1 = new PieGraphDataSet("2-D Pie 1.");
        data1.setFixedToolTips(true);
        data1.set3DRepresentation(true);
        data1.addValue(20.0, "A1");
        data1.addValue(40.0, "A2");
        data1.addValue(50.0, "A3");
        data1.addValue(10.0, "A4");
        chart.addGraph(data1);
        PieGraphDataSet data2 = new PieGraphDataSet("2-D Pie 2.");
        data2.addValue(4500000.0, "A1");
        data2.addValue(4500000.0, "A2");
        data2.addValue(3000000.0, "A3");
        data2.addValue(6000000.0, "A4");
        data2.addValue(9000000.0, "A5");
        data2.addValue(5000000.0, "A6");
        data2.addValue(4000000.0, "A7");
        data2.addValue(0.0, "A8");
        chart2.addGraph(data2);
        chart2.setToolTipsProvider(data2, new PieGraphToolTipProvider(){

            @Override
            public String provideToolTip(PieGraphDataSet pie, PieGraphDataSet.PiePiece piece) {
                return "ZZZZ + " + piece.getPercent() + "%";
            }
        });
        legendCreator.updateLegend();
        chart2.addSelectionListener(data2, new PieGraphSelectionListener(){

            @Override
            public void selectionChanged(PieGraphDataSet set, PieGraphDataSet.PiePiece piece) {
                for (PieGraphChart.PieSelectedPieces s : chart2.getSelection()) {
                    StringBuilder values = new StringBuilder(s.getDataSet().getName());
                    for (PieGraphDataSet.PiePiece p : s.getSelectedPieces()) {
                        values.append(" [");
                        values.append(p.getName());
                        values.append(' ');
                        values.append(p.getPercent());
                        values.append(']');
                    }
                    System.out.println(values);
                }
                System.out.println("--------------------------");
            }
        });
    }
}

