/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.example;

import com.sap.jvm.profiling.ui.graph.awt.renderer.AwtRenderer;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import com.sap.jvm.profiling.ui.graph.renderer.RendererActionListener;
import java.util.ArrayList;
import javax.swing.JFrame;

public class RendererAWTTest {
    private static final byte[] IMG = new byte[]{71, 73, 70, 56, 57, 97, 16, 0, 16, 0, -43, 0, 0, -79, -82, -79, 29, 98, 121, 29, 99, 121, 29, 99, 120, 31, 101, 121, 31, 100, 120, 32, 101, 121, 34, 102, 122, 33, 103, 121, 36, 104, 122, 39, 106, 123, 39, 107, 122, 42, 109, 124, 42, 109, 123, 43, 110, 124, 44, 111, 123, 45, 112, 124, 56, 86, 83, 49, 78, 74, 32, 57, 50, 45, 78, 69, 56, 86, 78, 49, 86, 74, 40, 65, 57, 49, 78, 69, 40, 72, 61, 40, 69, 57, 45, 72, 61, 35, 62, 50, 35, 65, 50, 45, 78, 61, 46, 106, 34, 58, 124, 43, 83, -115, 60, -110, -63, 127, 115, -89, 88, -106, -61, 121, -107, -62, 121, -97, -57, -127, -90, -55, -121, -82, -50, -111, -81, -50, -111, -75, -46, -103, -37, -21, -52, -74, -46, -103, -72, -46, -100, -72, -46, -99, -58, -36, -82, -43, -25, -62, -37, -22, -52, -25, -13, -37, -57, -36, -81, -58, -37, -82, -57, -37, -81, -53, -33, -76, -43, -26, -62, -57, -37, -82, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 57, 0, 44, 0, 0, 0, 0, 16, 0, 16, 0, 0, 6, 121, -64, -100, 112, 72, 44, 26, 43, -58, -92, 80, 50, -116, 40, -123, -128, 13, 64, -120, 73, 90, 36, -108, 12, 4, 2, -48, 76, -107, 0, -120, -84, -74, -123, -28, 38, -105, -92, 99, -10, 89, -35, 94, 15, 0, -64, 99, 17, 70, -100, -128, 70, 76, -74, -78, -71, 24, 95, 68, 24, 26, 10, 48, 43, 34, 52, 44, 39, 11, 73, 28, 9, 47, 54, 56, 35, 41, 38, 9, 19, 30, 69, 94, 8, 45, 42, 40, 33, 36, 7, 83, 76, 67, 20, 0, 4, 6, 39, 38, 37, 32, 5, 70, 117, 66, 19, 1, 3, 2, 1, 79, 66, 29, 114, -74, 67, 25, -70, 67, -81, 73, 65, 0, 59};

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        AwtRenderer renderer = new AwtRenderer();
        frame.getContentPane().add(renderer.getComponent());
        renderer.addRendererActionListener(new ActionAdapter());
        frame.setTitle("AWT Renderer Test");
        frame.setSize(500, 600);
        frame.setVisible(true);
    }

    public static void paintElements(Renderer r) {
        r.setPaintArea(null);
        r.setDefaultColors();
        r.clearDrawingArea();
        int y = 10;
        for (int i = 1; i <= 5; ++i) {
            r.setLineWidth(i);
            r.setLineStyle(Renderer.LineType.LINE_DOT);
            r.drawLine(10, y += 20, 150, y);
            r.setLineStyle(Renderer.LineType.LINE_SOLID);
            r.drawLine(10, y + 10, 150, y + 10);
        }
        r.setLineWidth(1);
        r.setFillColor(Color.BLUE);
        r.fillOval(190, 110, 90, 90);
        r.setFillColor(Color.RED);
        r.fillOval(290, 110, 50, 90);
        r.setForeground(Color.BLACK);
        r.drawOval(350, 120, 90, 50);
        r.drawOval(350, 60, 90, 50);
        r.setAntialiased(true);
        r.setFillColor(Color.BLUE);
        r.fillOval(190, 230, 90, 90);
        r.setFillColor(Color.RED);
        r.fillOval(290, 230, 50, 90);
        r.setForeground(Color.BLACK);
        r.drawOval(350, 240, 90, 50);
        r.drawOval(350, 180, 90, 50);
        r.setAntialiased(false);
        r.setFillColor(Color.YELLOW);
        r.fillRectangle(270, 460, 100, 200);
        r.drawRectangle(270, 460, 100, 200);
        r.setFillColor(Color.GREEN);
        r.setForeground(Color.BLUE);
        r.setAlpha(30);
        r.fillRectangle(300, 450, 150, 40);
        r.drawRectangle(300, 450, 150, 40);
        r.setAlpha(80);
        r.fillRectangle(300, 400, 150, 40);
        r.drawRectangle(300, 400, 150, 40);
        r.setAlpha(160);
        r.fillRectangle(300, 350, 150, 40);
        r.drawRectangle(300, 350, 150, 40);
        r.setAlpha(200);
        r.fillRectangle(300, 290, 150, 40);
        r.drawRectangle(300, 290, 150, 40);
        r.setAlpha(255);
        r.setDefaultColors();
        ArrayList<Point2D> line = new ArrayList<Point2D>();
        line.add(new Point2D(10, 460));
        line.add(new Point2D(100, 400));
        line.add(new Point2D(150, 450));
        line.add(new Point2D(190, 410));
        r.drawPolyline(line);
        ArrayList<Point2D> poly = new ArrayList<Point2D>();
        poly.add(new Point2D(10, 260));
        poly.add(new Point2D(100, 340));
        poly.add(new Point2D(150, 290));
        poly.add(new Point2D(140, 180));
        r.drawPolyline(poly);
        int[] poly2 = new int[]{10, 260, 100, 340, 150, 290, 140, 180};
        r.setFillColor(Color.YELLOW);
        r.fillPolygon(poly2);
        r.drawPolygon(poly2);
        String text = "Das ist ein Text";
        r.drawString(text, 10, 150);
        r.drawRectangle(10, 150, r.getStringWidth(text), r.getFontHeight());
        text = "Das ist noch ein Text";
        r.drawRectangle(10, 160 + r.getFontHeight(), r.getStringWidth(text), r.getFontHeight());
        r.setPaintArea(new Rectangle(10, 160 + r.getFontHeight(), r.getStringWidth(text), r.getFontHeight()));
        r.drawString(text, 0, r.getFontHeight());
        r.setPaintArea(null);
        r.drawRectangle(160, 380, 90, 140);
        r.setFillColor(Color.ORANGE);
        r.fillArc(160, 380, 90, 140, 0, 112);
        r.drawArc(160, 380, 90, 140, 0, 112);
        r.drawRectangle(10, 530, 100, 50);
        r.setPaintArea(new Rectangle(10, 530, 100, 50));
        r.setForeground(Color.RED);
        r.setFillColor(Color.LIGHT_RED);
        r.drawPoint(10, 40);
        r.drawLine(50, 10, 60, 40);
        r.fillRectangle(10, 15, 10, 10);
        r.drawRectangle(10, 15, 10, 10);
        r.fillOval(20, 40, 20, 15);
        r.drawOval(20, 40, 20, 15);
        r.fillPolygon(new int[]{60, 5, 70, 15, 80, 2});
        r.drawPolygon(new int[]{60, 5, 70, 15, 80, 2});
        ArrayList<Point2D> pLine = new ArrayList<Point2D>();
        pLine.add(new Point2D(5, 30));
        pLine.add(new Point2D(15, 22));
        pLine.add(new Point2D(25, 20));
        pLine.add(new Point2D(45, 5));
        r.drawPolyline(pLine);
        r.setPaintArea(r.getPainArea(), new Rectangle(80, 520, 20, 20));
        r.setFillColor(Color.ORANGE);
        r.fillRectangle(70, 50, 30, 30);
        r.setPaintArea(null);
        r.setForeground(Color.RED);
        r.setFillColor(Color.YELLOW);
        r.fillGradientRectangle(10, 390, 30, 80, true);
        r.fillGradientRectangle(50, 390, 80, 30, false);
        r.saveScreen();
        r.clearDrawingArea();
        r.restoreScreen();
        r.fillOval(290, 110, 50, 90);
        r.drawRectangle(285, 115, 60, 100);
        r.drawLine(285, 115, 345, 15);
        Object key_1 = new Object();
        Object key_2 = new Object();
        Rectangle area_1 = new Rectangle(260, 470, 200, 225);
        Rectangle area_2 = new Rectangle(5, 395, 150, 217);
        Rectangle area_3 = new Rectangle(310, 545, 50, 70);
        Rectangle area_4 = new Rectangle(385, 550, 80, 90);
        r.saveScreen(area_1, key_1);
        r.saveScreen(area_2, key_2);
        r.setPaintArea(area_1);
        r.clearDrawingArea();
        r.restoreScreen(key_1);
        r.restoreScreen(key_2, area_3);
        r.restoreScreen(key_1, area_4);
        int h = r.getScreenHeight() / 2;
        Rectangle r_1 = new Rectangle(0, r.getScreenHeight(), r.getScreenWidth(), h);
        Rectangle r_2 = new Rectangle(0, h, r.getScreenWidth(), h);
        r.saveScreen(r_1, key_1);
        r.saveScreen(r_2, key_2);
        r.setPaintArea(null);
        r.clearDrawingArea();
        r.restoreScreen(key_1);
        r.restoreScreen(key_2);
        r.setPaintArea(null);
        r.clearDrawingArea();
        r.restoreAllSavedScreens();
        r.drawImage(r.getImage(IMG), 130, 500);
        r.showScreenBuffer();
    }

    public static class ActionAdapter
    implements RendererActionListener {
        @Override
        public void repaintDrawingArea(Renderer source) {
            RendererAWTTest.paintElements(source);
        }

        @Override
        public void initializedDrawingArea(Renderer source) {
        }

        @Override
        public void mouseDoubleClicked(Renderer source, int x, int y) {
        }

        @Override
        public void mouseDownLeft(Renderer source, int x, int y) {
        }

        @Override
        public void mouseDownRight(Renderer source, int x, int y) {
        }

        @Override
        public void mouseHovered(Renderer source, int x, int y) {
        }

        @Override
        public void mouseMoved(Renderer source, int x, int y) {
        }

        @Override
        public void mouseMovedByLeftPressed(Renderer source, int x, int y) {
        }

        @Override
        public void mouseMovedByRightPressed(Renderer source, int x, int y) {
        }

        @Override
        public void mouseUpLeft(Renderer source, int x, int y) {
        }

        @Override
        public void mouseUpRight(Renderer source, int x, int y) {
        }

        @Override
        public void resizedDrawingArea(Renderer source) {
            this.repaintDrawingArea(source);
        }

        @Override
        public void dispose() {
        }
    }
}

