/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.example;

import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.SingleBarValueChart;
import com.sap.jvm.profiling.ui.graph.awt.controls.GraphContainerControl;
import com.sap.jvm.profiling.ui.graph.dataset.AccSingleBarDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;

public class SingleBarGraphAWTExample {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        GraphContainerControl container = new GraphContainerControl(1);
        container.getChartContainer().enableLegend(false);
        SingleBarGraphAWTExample.configureGraph(container.getChartContainer());
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)container, "Center");
        frame.setTitle("AWT Bar Graph Control");
        frame.setSize(500, 500);
        frame.setVisible(true);
    }

    public static void configureGraph(GraphChartContainer container) {
        SingleBarValueChart chart = new SingleBarValueChart(container);
        chart.setType(SingleBarValueChart.Type.HORIZONTAL);
        chart.enableShadows(true);
        chart.flipBarLables(true);
        container.enableCellMarginBottom(true);
        container.enableCellHorizontalMargin(true);
        AccSingleBarDataSet data = new AccSingleBarDataSet();
        data.setInlinedText("");
        data.setMaxValue(5000L);
        data.addValue(5000L, Color.GRAY_90);
        data.setValueMarker(0L, "1", Color.GRAY);
        data.setValueMarker(5000L, "5000", Color.GRAY);
        int delay = 50;
        long v = 0L;
        for (int i = 0; i < 1000 && (v += (long)(delay = i > 300 ? 50 : (i > 250 ? 15 : (i > 180 ? 1 : (i > 100 ? 4 : (i > 70 ? 6 : (i > 50 ? 10 : 50))))))) <= 5000L; ++i) {
            data.highlightValue(v);
        }
        chart.addGraph(data);
        container.addChart(chart);
    }
}

