/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.offscreen.renderer;

import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.LineGraphChart;
import com.sap.jvm.profiling.ui.graph.awt.example.BarGraphAWTExample;
import com.sap.jvm.profiling.ui.graph.awt.example.PieGraphAWTExample;
import com.sap.jvm.profiling.ui.graph.awt.renderer.AwtRenderer;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.tracing.Trace;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class GraphImageRenderer {
    private AwtRenderer renderer;
    private GraphChartContainer chartsContainer;

    public GraphImageRenderer(int width, int height, int columns) {
        this.renderer = new AwtRenderer(width, height);
        this.chartsContainer = new GraphChartContainer(this.renderer, columns);
        this.chartsContainer.setBackground(Color.WHITE);
    }

    public void setFont(Font font) {
        this.renderer.setFont(font);
    }

    public GraphChartContainer getChartsContainer() {
        return this.chartsContainer;
    }

    public BufferedImage getImage() {
        BufferedImage img = this.renderer.getImage();
        return img.getSubimage(0, 0, img.getWidth(), img.getHeight());
    }

    public boolean exportToPNG(String file) {
        try {
            return ImageIO.write((RenderedImage)this.renderer.getImage(), "png", new File(file));
        }
        catch (IOException e) {
            Trace.error((Throwable)e, () -> "Could not write PNG file " + file);
            return false;
        }
    }

    public void dispose() {
        this.renderer.dispose();
        this.renderer = null;
        this.chartsContainer = null;
    }

    public boolean exportToJPG(String file) {
        try {
            return ImageIO.write((RenderedImage)this.renderer.getImage(), "jpg", new File(file));
        }
        catch (IOException e) {
            Trace.error((Throwable)e, () -> "Could not write JPG file " + file);
            return false;
        }
    }

    public static void main(String[] args) {
        GraphImageRenderer offscreenRenderer = new GraphImageRenderer(1000, 1000, 2);
        GraphChartContainer container = offscreenRenderer.getChartsContainer();
        final LineGraphChart lineChart = new LineGraphChart(container, true, true);
        LineGraphDataSet set1 = LineGraphChart.createDataSet("Set1");
        LineGraphDataSet set2 = LineGraphChart.createDataSet("Set2");
        for (int i = 0; i < 99; ++i) {
            if (i % 3 == 0) {
                set1.addValue(i, Math.random() * 1000.0);
                continue;
            }
            set2.addValue(i, Math.random() * 1000.0);
        }
        lineChart.addGraph(set1);
        lineChart.addGraph(set2);
        container.addChart(lineChart);
        container.setChartTitle("LineGraph", 0);
        lineChart.setInitializer(new Runnable(){

            @Override
            public void run() {
                lineChart.adjustXAxis(0.0, 99.0, false);
                lineChart.adjustYAxis(0.0, 1000.0, false);
            }
        });
        PieGraphAWTExample.configureGraph(container);
        BarGraphAWTExample.configureGraph(container);
        offscreenRenderer.exportToPNG("export.png");
        offscreenRenderer.dispose();
    }
}

