/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.renderer;

import com.sap.jvm.profiling.ui.graph.awt.renderer.AwtRendererImage;
import com.sap.jvm.profiling.ui.graph.awt.renderer.ToolTip;
import com.sap.jvm.profiling.ui.graph.awt.renderer.Util;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.ui.graph.renderer.Image;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import com.sap.jvm.profiling.ui.graph.renderer.RendererActionListener;
import com.sap.jvm.tracing.Trace;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AwtRenderer
implements Renderer,
MouseListener,
MouseMotionListener {
    private static final com.sap.jvm.profiling.ui.graph.renderer.Color DEF_HEADER_BACKGROUND = Util.getColor(SystemColor.activeCaptionBorder);
    private static final com.sap.jvm.profiling.ui.graph.renderer.Color DEF_HEADER_FOREGROUND = Util.getColor(SystemColor.activeCaptionText);
    private static final com.sap.jvm.profiling.ui.graph.renderer.Color DEF_HEADER_INACTIVE_BACKGROUND = Util.getColor(SystemColor.inactiveCaption);
    private static final com.sap.jvm.profiling.ui.graph.renderer.Color DEF_HEADER_INACTIVE_FOREGROUND = Util.getColor(SystemColor.inactiveCaptionText);
    private static final com.sap.jvm.profiling.ui.graph.renderer.Color DEF_SELECTION = Util.getColor(SystemColor.textHighlight);
    private static final com.sap.jvm.profiling.ui.graph.renderer.Color DEF_SELECTION_TEXT = Util.getColor(SystemColor.textHighlightText);
    private Color defForeground = SystemColor.textText;
    private Color defBackground;
    private Color clBack = this.defBackground = SystemColor.text;
    private Color clForeground = this.defForeground;
    private float lineWidth = 1.0f;
    private BasicStroke lineStroke = new BasicStroke(0.0f);
    private int screen_width;
    private int screen_height;
    private Rectangle clipping_area;
    private Rectangle paint_area;
    private Graphics2D graphics;
    private BufferedImage workingImage;
    private boolean initialized;
    private boolean disposed = false;
    private boolean antialias;
    private Canvas canvas;
    private final boolean tooltipAbove = "true".equals(System.getProperty("com.sap.jvm.profiling.ui.graph.AwtRenderer.tooltipAbove", "true"));
    private final boolean noBlur = "true".equals(System.getProperty("com.sap.jvm.profiling.ui.graph.AwtRenderer.noBlur", "false"));
    private Map<com.sap.jvm.profiling.ui.graph.renderer.Color, Color> colorMapping = new HashMap<com.sap.jvm.profiling.ui.graph.renderer.Color, Color>();
    private RendererActionListener listener;
    Timer resizingTimer = new Timer("Resizing Timer", true);
    TimerTask resizingTask;
    private int draggeButtonKey;
    private Timer hoverTimer = new Timer("MouseHoverTimer", true);
    private TimerTask hoverTask;
    private ToolTip toolTip;
    private BufferedImage last_user_saved_screen;
    private Map<Object, BufferedScreen> screenBuffer = new HashMap<Object, BufferedScreen>();

    public AwtRenderer(int width, int height) {
        this.workingImage = new BufferedImage(width, height, 1);
        this.screen_width = this.workingImage.getWidth();
        this.screen_height = this.workingImage.getHeight();
        this.graphics = this.workingImage.createGraphics();
        this.antialias = this.isAntialiased();
        this.setDefaultColors();
        this.initialized = true;
        this.graphics.setBackground(this.defBackground);
        this.graphics.fillRect(0, 0, this.screen_width, this.screen_height);
    }

    public AwtRenderer() {
        this.workingImage = new BufferedImage(10, 10, 1);
        this.graphics = this.workingImage.createGraphics();
        this.antialias = this.isAntialiased();
        this.setDefaultColors();
        final ComponentAdapter control = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                if (AwtRenderer.this.resizingTask != null) {
                    AwtRenderer.this.resizingTask.cancel();
                }
                AwtRenderer.this.resizingTask = new TimerTask(){

                    @Override
                    public void run() {
                        if (AwtRenderer.this.screen_width != AwtRenderer.this.canvas.getWidth() || AwtRenderer.this.screen_height != AwtRenderer.this.canvas.getHeight()) {
                            AwtRenderer.this.screen_width = AwtRenderer.this.canvas.getWidth();
                            AwtRenderer.this.screen_height = AwtRenderer.this.canvas.getHeight();
                            if (AwtRenderer.this.screen_height > 0 && AwtRenderer.this.screen_width > 0) {
                                AwtRenderer.this.workingImage = new BufferedImage(AwtRenderer.this.screen_width, AwtRenderer.this.screen_height, 1);
                                AwtRenderer.this.graphics = AwtRenderer.this.workingImage.createGraphics();
                                AwtRenderer.this.graphics.setBackground(AwtRenderer.this.defBackground);
                                AwtRenderer.this.setAntialiased(AwtRenderer.this.antialias);
                                if (AwtRenderer.this.initialized) {
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                AwtRenderer.this.listener.resizedDrawingArea(AwtRenderer.this);
                                                AwtRenderer.this.listener.repaintDrawingArea(AwtRenderer.this);
                                            }
                                        });
                                    }
                                    catch (Exception e) {
                                        Trace.error((Throwable)e);
                                    }
                                }
                            }
                        }
                        AwtRenderer.this.resizingTask = null;
                    }
                };
                AwtRenderer.this.resizingTimer.schedule(AwtRenderer.this.resizingTask, 200L);
            }
        };
        this.canvas = new Canvas(){
            private static final long serialVersionUID = -1687783948481948922L;

            @Override
            public void paint(Graphics g) {
                if (AwtRenderer.this.initialized) {
                    if (AwtRenderer.this.resizingTask == null) {
                        AwtRenderer.this.listener.repaintDrawingArea(AwtRenderer.this);
                    }
                } else {
                    AwtRenderer.this.initialized = true;
                    if (AwtRenderer.this.listener != null) {
                        AwtRenderer.this.listener.initializedDrawingArea(AwtRenderer.this);
                        control.componentResized(null);
                        AwtRenderer.this.listener.repaintDrawingArea(AwtRenderer.this);
                    }
                }
            }
        };
        this.canvas.setBackground(Color.WHITE);
        this.canvas.addComponentListener(control);
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
    }

    public void dispose() {
        this.disposed = true;
        this.listener.dispose();
        this.invalidateAllSavedScreens();
        this.canvas = null;
        this.workingImage = null;
        this.listener = null;
        this.initialized = false;
    }

    public Component getComponent() {
        return this.canvas;
    }

    public BufferedImage getImage() {
        if (this.listener != null) {
            this.listener.initializedDrawingArea(this);
            this.listener.resizedDrawingArea(this);
            this.listener.repaintDrawingArea(this);
        }
        return this.workingImage;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.closeToolTip();
        if (this.initialized) {
            if (this.draggeButtonKey == 3) {
                this.listener.mouseMovedByRightPressed(this, e.getX(), this.screen_height - e.getY());
            } else if (this.draggeButtonKey == 1) {
                this.listener.mouseMovedByLeftPressed(this, e.getX(), this.screen_height - e.getY());
            }
        }
    }

    @Override
    public void mouseMoved(final MouseEvent e) {
        this.closeToolTip();
        if (this.initialized) {
            this.listener.mouseMoved(this, e.getX(), this.screen_height - e.getY());
            if (this.hoverTask != null) {
                this.hoverTask.cancel();
            }
            this.hoverTask = new TimerTask(){

                @Override
                public void run() {
                    AwtRenderer.this.listener.mouseHovered(AwtRenderer.this, e.getX(), AwtRenderer.this.screen_height - e.getY());
                }
            };
            this.hoverTimer.schedule(this.hoverTask, 500L);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.initialized) {
            this.draggeButtonKey = e.getButton();
            if (this.draggeButtonKey == 1) {
                this.listener.mouseDownLeft(this, e.getX(), this.screen_height - e.getY());
            } else if (this.draggeButtonKey == 3) {
                this.listener.mouseDownRight(this, e.getX(), this.screen_height - e.getY());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(null);
        if (this.initialized) {
            if (e.getButton() == 1) {
                this.listener.mouseUpLeft(this, e.getX(), this.screen_height - e.getY());
            } else if (e.getButton() == 3) {
                this.listener.mouseUpRight(this, e.getX(), this.screen_height - e.getY());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && this.initialized) {
            this.listener.mouseDoubleClicked(this, e.getX(), this.screen_height - e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.closeToolTip();
    }

    @Override
    public void setLineStyle(Renderer.LineType style) {
        switch (style) {
            case LINE_DOT: {
                this.lineStroke = new BasicStroke(this.lineWidth, this.lineStroke.getEndCap(), this.lineStroke.getLineJoin(), this.lineStroke.getMiterLimit(), new float[]{4.0f, 4.0f}, 0.0f);
                this.graphics.setStroke(this.lineStroke);
                return;
            }
            case LINE_SOLID: {
                this.lineStroke = new BasicStroke(this.lineWidth);
                this.graphics.setStroke(this.lineStroke);
                return;
            }
        }
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width > 1 ? (float)width : 1.0f;
        this.lineStroke = new BasicStroke(this.lineWidth, this.lineStroke.getEndCap(), this.lineStroke.getLineJoin(), this.lineStroke.getMiterLimit(), this.lineStroke.getDashArray(), this.lineStroke.getDashPhase());
        this.graphics.setStroke(this.lineStroke);
    }

    @Override
    public void setAlpha(int value) {
        float val = value >= 255 ? 1.0f : 0.003921569f * (float)value;
        AlphaComposite myAlpha = AlphaComposite.getInstance(3, val);
        this.graphics.setComposite(myAlpha);
    }

    @Override
    public void setAntialiased(boolean enable) {
        if (enable) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.antialias = enable;
    }

    @Override
    public boolean isAntialiased() {
        return this.graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    @Override
    public void setCursor(Renderer.CursorType cursor) {
        if (this.canvas != null) {
            if (cursor == null) {
                this.canvas.setCursor(new Cursor(0));
                return;
            }
            switch (cursor) {
                case CURSOR_MOVE: {
                    this.canvas.setCursor(new Cursor(13));
                    return;
                }
                case CURSOR_RESIZE: {
                    this.canvas.setCursor(new Cursor(11));
                    return;
                }
                case CURSOR_RESIZE_AXIS: {
                    this.canvas.setCursor(new Cursor(11));
                    return;
                }
                case CURSOR_SELECT: {
                    this.canvas.setCursor(new Cursor(12));
                    return;
                }
            }
        }
    }

    @Override
    public void setDefaultColors() {
        this.clBack = this.defBackground;
        this.clForeground = this.defForeground;
    }

    @Override
    public void setDefaultBackground(com.sap.jvm.profiling.ui.graph.renderer.Color color) {
        if (!this.colorMapping.containsKey(color)) {
            this.colorMapping.put(color, Util.getAWTColor(color));
        }
        this.defBackground = this.colorMapping.get(color);
    }

    @Override
    public void setDefaultForeground(com.sap.jvm.profiling.ui.graph.renderer.Color color) {
        if (!this.colorMapping.containsKey(color)) {
            this.colorMapping.put(color, Util.getAWTColor(color));
        }
        this.defForeground = this.colorMapping.get(color);
    }

    @Override
    public void setFont(Font font) {
        this.graphics.setFont(Util.getAWTFont(font));
    }

    @Override
    public Font getFont() {
        return Util.getFont(this.graphics != null ? this.graphics.getFont() : new JPanel().getFont());
    }

    @Override
    public int getFontHeight() {
        return this.graphics == null ? 1 : this.graphics.getFontMetrics().getHeight();
    }

    @Override
    public void setForeground(com.sap.jvm.profiling.ui.graph.renderer.Color color) {
        if (!this.colorMapping.containsKey(color)) {
            this.colorMapping.put(color, Util.getAWTColor(color));
        }
        this.clForeground = this.colorMapping.get(color);
    }

    @Override
    public com.sap.jvm.profiling.ui.graph.renderer.Color getForeground() {
        return Util.getColor(this.clForeground);
    }

    @Override
    public com.sap.jvm.profiling.ui.graph.renderer.Color getDefaultForeground() {
        return Util.getColor(this.defForeground);
    }

    @Override
    public com.sap.jvm.profiling.ui.graph.renderer.Color getDefaultBackground() {
        return Util.getColor(this.defBackground);
    }

    @Override
    public com.sap.jvm.profiling.ui.graph.renderer.Color getDefaultHeaderBackground() {
        return DEF_HEADER_BACKGROUND;
    }

    @Override
    public com.sap.jvm.profiling.ui.graph.renderer.Color getDefaultInactiveHeaderBackground() {
        return DEF_HEADER_INACTIVE_BACKGROUND;
    }

    @Override
    public com.sap.jvm.profiling.ui.graph.renderer.Color getDefaultHeaderForeground() {
        return DEF_HEADER_FOREGROUND;
    }

    @Override
    public com.sap.jvm.profiling.ui.graph.renderer.Color getDefaultInactiveHeaderForeground() {
        return DEF_HEADER_INACTIVE_FOREGROUND;
    }

    @Override
    public com.sap.jvm.profiling.ui.graph.renderer.Color getDefaultSelectionColor() {
        return DEF_SELECTION;
    }

    @Override
    public com.sap.jvm.profiling.ui.graph.renderer.Color getDefaultSelectionTextColor() {
        return DEF_SELECTION_TEXT;
    }

    @Override
    public void setFillColor(com.sap.jvm.profiling.ui.graph.renderer.Color color) {
        if (!this.colorMapping.containsKey(color)) {
            this.colorMapping.put(color, Util.getAWTColor(color));
        }
        this.clBack = this.colorMapping.get(color);
    }

    @Override
    public com.sap.jvm.profiling.ui.graph.renderer.Color getFillColor() {
        return Util.getColor(this.clBack);
    }

    @Override
    public int getStringWidth(String str) {
        try {
            return this.graphics.getFontMetrics().stringWidth(str);
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public boolean isFocused() {
        return this.canvas == null ? false : this.canvas.isFocusOwner();
    }

    @Override
    public boolean isVisibleInitialized() {
        return this.initialized;
    }

    @Override
    public void provideToolTip(int x, int y, String tooltip) {
        if (this.canvas != null && this.canvas.isShowing()) {
            Point p = this.canvas.getLocationOnScreen();
            this.toolTip = new ToolTip(this.canvas, tooltip, p.x + x, p.y + (this.screen_height - y), this.tooltipAbove);
            this.toolTip.setVisible(true);
        }
    }

    private void closeToolTip() {
        if (this.toolTip != null) {
            this.toolTip.dispose();
            this.toolTip = null;
        }
    }

    @Override
    public void addRendererActionListener(RendererActionListener action_listener) {
        this.listener = action_listener;
    }

    @Override
    public void asyncExec(Runnable action) {
        if (!this.disposed) {
            SwingUtilities.invokeLater(action);
        }
    }

    @Override
    public void syncExec(Runnable action) {
        if (!this.disposed) {
            try {
                SwingUtilities.invokeAndWait(action);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean restoreScreen() {
        if (this.last_user_saved_screen == null) {
            return false;
        }
        this.setPaintArea(null);
        this.graphics.drawImage((java.awt.Image)this.last_user_saved_screen, 0, 0, null);
        return true;
    }

    @Override
    public void saveScreen() {
        if (this.screen_width == 0 || this.screen_height == 0) {
            return;
        }
        this.last_user_saved_screen = new BufferedImage(this.screen_width, this.screen_height, 1);
        this.workingImage.copyData(this.last_user_saved_screen.getRaster());
    }

    @Override
    public void saveScreen(Rectangle area, Object key) {
        this.screenBuffer.put(key, new BufferedScreen(area));
    }

    @Override
    public boolean restoreScreen(Object key) {
        BufferedScreen screen = this.screenBuffer.get(key);
        if (screen == null) {
            return false;
        }
        this.setPaintArea(null);
        this.graphics.drawImage(screen.image, screen.area.x, this.screen_height - screen.area.y, screen.area.width, screen.area.height, null);
        return true;
    }

    @Override
    public boolean restoreScreen(Object key, Rectangle area) {
        BufferedScreen screen = this.screenBuffer.get(key);
        if (screen == null) {
            return false;
        }
        this.setPaintArea(null);
        this.graphics.drawImage(screen.image, area.x, this.screen_height - area.y, area.width, area.height, null);
        return true;
    }

    @Override
    public boolean isRestorable(Object key) {
        BufferedScreen screen = this.screenBuffer.get(key);
        return screen != null;
    }

    @Override
    public void restoreAllSavedScreens() {
        this.setPaintArea(null);
        this.clearDrawingArea();
        for (Map.Entry<Object, BufferedScreen> entry : this.screenBuffer.entrySet()) {
            BufferedScreen screen = entry.getValue();
            this.graphics.drawImage((java.awt.Image)screen.image, screen.area.x, this.screen_height - screen.area.y, null);
        }
    }

    @Override
    public void invalidateSavedScreen(Object key) {
        this.screenBuffer.remove(key);
    }

    @Override
    public void invalidateAllSavedScreens() {
        this.screenBuffer.clear();
        this.last_user_saved_screen = null;
    }

    @Override
    public void showScreenBuffer() {
        if (this.canvas != null && this.canvas.getGraphics() != null) {
            this.canvas.getGraphics().drawImage(this.workingImage, 0, 0, null);
        }
    }

    @Override
    public void setPaintArea(Rectangle rec) {
        this.setPaintArea(rec, rec);
    }

    @Override
    public void setPaintArea(Rectangle rec, Rectangle clip) {
        this.paint_area = rec;
        this.clipping_area = clip;
        if (clip == null) {
            this.graphics.setClip(null);
        } else {
            this.graphics.setClip(Util.getRectangle(clip, this.screen_height));
        }
    }

    @Override
    public Rectangle getPainArea() {
        return this.paint_area;
    }

    @Override
    public Rectangle getClippingArea() {
        return this.clipping_area;
    }

    @Override
    public int getHeight() {
        return this.paint_area == null ? this.screen_height : this.paint_area.height;
    }

    @Override
    public int getWidth() {
        return this.paint_area == null ? this.screen_width : this.paint_area.width;
    }

    @Override
    public int getScreenHeight() {
        return this.screen_height;
    }

    @Override
    public int getScreenWidth() {
        return this.screen_width;
    }

    private int getPaintY(int y) {
        return this.screen_height - this.paint_area.y + this.paint_area.height - y - 1;
    }

    @Override
    public void clearDrawingArea() {
        this.graphics.setColor(this.defBackground);
        if (this.paint_area == null) {
            this.graphics.fillRect(0, 0, this.screen_width, this.screen_height);
        } else {
            this.graphics.fillRect(this.paint_area.x, this.screen_height - this.paint_area.y, this.paint_area.width, this.paint_area.height);
        }
    }

    @Override
    public void drawPoint(int x, int y) {
        this.graphics.setColor(this.clForeground);
        if (this.paint_area == null) {
            this.graphics.drawLine(x, this.screen_height - y, x, this.screen_height - y);
        } else {
            this.graphics.drawLine(this.paint_area.x + x, this.getPaintY(y), this.paint_area.x + x, this.getPaintY(y));
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.setColor(this.clForeground);
        if (y1 == y2 && Math.abs(x1 - x2) > 3 * this.screen_width) {
            if (x1 > x2) {
                x1 = Math.min(3 * this.screen_width, x1);
                x2 = Math.max(-3 * this.screen_width, x2);
            } else {
                x1 = Math.max(-3 * this.screen_width, x1);
                x2 = Math.min(3 * this.screen_width, x2);
            }
        }
        if (this.paint_area == null) {
            this.graphics.drawLine(x1, this.screen_height - y1, x2, this.screen_height - y2);
        } else {
            this.graphics.drawLine(this.paint_area.x + x1, this.getPaintY(y1), this.paint_area.x + x2, this.getPaintY(y2));
        }
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.graphics.setColor(this.clForeground);
        if (this.paint_area == null) {
            this.graphics.drawOval(x, this.screen_height - y, width, height);
        } else {
            this.graphics.drawOval(this.paint_area.x + x, this.getPaintY(y), width, height);
        }
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.graphics.setColor(this.clBack);
        if (this.paint_area == null) {
            this.graphics.fillOval(x, this.screen_height - y, width, height);
        } else {
            this.graphics.fillOval(this.paint_area.x + x, this.getPaintY(y), width, height);
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int start_angle, int arc_angle) {
        this.graphics.setColor(this.clForeground);
        if (this.paint_area == null) {
            this.graphics.drawArc(x, this.screen_height - y, width, height, start_angle, arc_angle);
        } else {
            this.graphics.drawArc(this.paint_area.x + x, this.getPaintY(y), width, height, start_angle, arc_angle);
        }
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int start_angle, int arc_angle) {
        this.graphics.setColor(this.clBack);
        if (this.paint_area == null) {
            this.graphics.fillArc(x, this.screen_height - y, width, height, start_angle, arc_angle);
        } else {
            this.graphics.fillArc(this.paint_area.x + x, this.getPaintY(y), width, height, start_angle, arc_angle);
        }
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        this.graphics.setColor(this.clForeground);
        if (this.paint_area == null) {
            this.graphics.drawRect(x, this.screen_height - y, width, height);
        } else {
            this.graphics.drawRect(this.paint_area.x + x, this.getPaintY(y), width, height);
        }
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        this.graphics.setColor(this.clBack);
        if (this.paint_area == null) {
            this.graphics.fillRect(x, this.screen_height - y, width, height);
        } else {
            this.graphics.fillRect(this.paint_area.x + x, this.getPaintY(y), width, height);
        }
    }

    @Override
    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        this.graphics.setColor(this.clBack);
        Paint oldPaint = this.graphics.getPaint();
        if (this.paint_area == null) {
            GradientPaint gPaint = vertical ? new GradientPaint(x, this.screen_height - y, this.clForeground, x, this.screen_height - y + height, this.clBack, false) : new GradientPaint(x, this.screen_height - y, this.clForeground, x + width, this.screen_height - y, this.clBack, false);
            this.graphics.setPaint(gPaint);
            this.graphics.fillRect(x, this.screen_height - y, width, height);
        } else {
            int newX = this.paint_area.x + x;
            int newY = this.getPaintY(y);
            GradientPaint gPaint = vertical ? new GradientPaint(newX, newY, this.clForeground, newX, newY + height, this.clBack, false) : new GradientPaint(newX, newY, this.clForeground, newX + width, newY, this.clBack, false);
            this.graphics.setPaint(gPaint);
            this.graphics.fillRect(newX, newY, width, height);
        }
        this.graphics.setPaint(oldPaint);
    }

    @Override
    public void drawPolygon(int[] polygon) {
        this.graphics.setColor(this.clForeground);
        int[] polX = new int[polygon.length / 2];
        int[] polY = new int[polX.length];
        int idx = 0;
        if (this.paint_area == null) {
            for (int i = 1; i < polygon.length; i += 2) {
                polX[idx] = polygon[i - 1];
                polY[idx++] = this.screen_height - polygon[i];
            }
        } else {
            for (int i = 1; i < polygon.length; i += 2) {
                polX[idx] = this.paint_area.x + polygon[i - 1];
                polY[idx++] = this.getPaintY(polygon[i]);
            }
        }
        this.graphics.setColor(this.clForeground);
        this.graphics.drawPolygon(polX, polY, polX.length);
    }

    @Override
    public void fillPolygon(int[] polygon) {
        this.graphics.setColor(this.clBack);
        int[] polX = new int[polygon.length / 2];
        int[] polY = new int[polX.length];
        int idx = 0;
        if (this.paint_area == null) {
            for (int i = 1; i < polygon.length; i += 2) {
                polX[idx] = polygon[i - 1];
                polY[idx++] = this.screen_height - polygon[i];
            }
        } else {
            for (int i = 1; i < polygon.length; i += 2) {
                polX[idx] = this.paint_area.x + polygon[i - 1];
                polY[idx++] = this.getPaintY(polygon[i]);
            }
        }
        this.graphics.setColor(this.clBack);
        this.graphics.fillPolygon(polX, polY, polX.length);
    }

    @Override
    public void drawPolyline(List<Point2D> polyline) {
        this.graphics.setColor(this.clForeground);
        int[] polX = new int[polyline.size()];
        int[] polY = new int[polX.length];
        int idx = 0;
        if (this.paint_area == null) {
            for (Point2D val : polyline) {
                polX[idx] = val.x;
                polY[idx++] = this.screen_height - val.y;
            }
        } else {
            for (Point2D val : polyline) {
                polX[idx] = this.paint_area.x + val.x;
                polY[idx++] = this.getPaintY(val.y);
            }
        }
        this.graphics.setColor(this.clForeground);
        this.graphics.drawPolyline(polX, polY, polX.length);
    }

    @Override
    public void drawString(String str, int x, int y) {
        boolean saveAState = this.antialias;
        this.setAntialiased(true);
        this.graphics.setColor(this.clForeground);
        if (this.paint_area == null) {
            this.graphics.drawString(str, x, this.screen_height - y + this.getFontHeight() - 2);
        } else {
            this.graphics.drawString(str, this.paint_area.x + x, this.getPaintY(y) + this.getFontHeight() - 2);
        }
        if (!saveAState) {
            this.setAntialiased(false);
        }
    }

    @Override
    public void drawString(String str, int x, int y, float angle) {
        boolean saveAState = this.antialias;
        this.setAntialiased(true);
        AffineTransform oldTransform = this.graphics.getTransform();
        if (this.paint_area == null) {
            this.graphics.translate(x, this.screen_height - y);
        } else {
            this.graphics.translate(this.paint_area.x + x, this.getPaintY(y));
        }
        this.graphics.rotate(Math.PI * (double)angle / 180.0);
        this.graphics.drawString(str, 0, this.getFontHeight() - 2);
        this.graphics.setTransform(oldTransform);
        if (!saveAState) {
            this.setAntialiased(false);
        }
    }

    @Override
    public void blur(int radius) {
        if (this.noBlur) {
            return;
        }
        ConvolveOp f = this.getGaussianBlur(radius);
        int padding = radius * 2;
        if (this.paint_area == null) {
            BufferedImage img = this.copyImage(this.workingImage, padding);
            f.filter(img, this.workingImage);
        } else {
            BufferedImage clip = this.copyImage(this.workingImage, padding);
            BufferedImage img = new BufferedImage(clip.getWidth(), clip.getHeight(), clip.getType());
            f.filter(clip, img);
            this.graphics.drawImage(img, this.paint_area.x, this.getPaintY(0) - this.paint_area.height + 1, this.paint_area.x + this.paint_area.width, this.getPaintY(0), padding, padding, img.getWidth() - padding, img.getHeight() - padding, null);
        }
    }

    public BufferedImage copyImage(BufferedImage source, int padding) {
        if (this.paint_area == null) {
            BufferedImage b = new BufferedImage(source.getWidth() + 2 * padding, source.getHeight() + 2 * padding, source.getType());
            Graphics g = b.getGraphics();
            g.drawImage(source, padding, padding, null);
            g.dispose();
            return b;
        }
        BufferedImage b = new BufferedImage(this.paint_area.width + 2 * padding, this.paint_area.height + 2 * padding, source.getType());
        Graphics g = b.getGraphics();
        g.setColor(this.defBackground);
        g.fillRect(0, 0, b.getWidth(), b.getHeight());
        g.drawImage(source, padding, padding, b.getWidth() - padding, b.getHeight() - padding, this.paint_area.x, this.getPaintY(0) - this.paint_area.height, this.paint_area.x + this.paint_area.width, this.getPaintY(0), null);
        g.dispose();
        return b;
    }

    private ConvolveOp getGaussianBlur(int radius) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        GaussianKernel kernel = new GaussianKernel(radius);
        return new ConvolveOp(kernel, 1, null);
    }

    @Override
    public void drawImage(Image img, int x, int y) {
        java.awt.Image awtImage = null;
        if (img instanceof AwtRendererImage) {
            awtImage = (java.awt.Image)img.getImage();
        } else {
            AwtRendererImage tmpImage = new AwtRendererImage(img.getImageFileData());
            awtImage = tmpImage.getImage();
        }
        if (awtImage == null) {
            return;
        }
        if (this.paint_area == null) {
            this.graphics.drawImage(awtImage, x, this.screen_height - y, null);
        } else {
            this.graphics.drawImage(awtImage, this.paint_area.x + x, this.getPaintY(y), null);
        }
    }

    @Override
    public Image getImage(byte[] image_raw_data) {
        return new AwtRendererImage(image_raw_data);
    }

    @Override
    public void drawFocus(int x, int y, int width, int height) {
        if (this.paint_area == null) {
            this.graphics.drawRect(x, this.screen_height - y, width, height);
        } else {
            this.graphics.drawRect(this.paint_area.x + x, this.getPaintY(y), width, height);
        }
    }

    @Override
    public void setDebug(String name) {
    }

    private static class GaussianKernel
    extends Kernel {
        GaussianKernel(int blurRadius) {
            super(2 * blurRadius + 1, 2 * blurRadius + 1, GaussianKernel.createKernel(blurRadius));
        }

        private static float[] createKernel(int r) {
            int w = 2 * r + 1;
            float[] kernel = new float[w * w];
            double m = 2.0 * Math.pow((double)r / 3.0, 2.0);
            double n = Math.PI * m;
            double sum = 0.0;
            for (int x = 0; x < w; ++x) {
                int xr2 = (x - r) * (x - r);
                for (int y = 0; y < w; ++y) {
                    int yr2 = (y - r) * (y - r);
                    kernel[x * w + y] = (float)(Math.pow(Math.E, (double)(-(yr2 + xr2)) / m) / n);
                    sum += (double)kernel[x * w + y];
                }
            }
            int i = kernel.length - 1;
            while (i >= 0) {
                int n2 = i--;
                kernel[n2] = (float)((double)kernel[n2] / sum);
            }
            return kernel;
        }
    }

    private class BufferedScreen {
        Rectangle area;
        BufferedImage image;

        public BufferedScreen(Rectangle area) {
            this.area = area;
            this.image = new BufferedImage(area.width, area.height, 1);
            AwtRenderer.this.workingImage.getSubimage(area.x, Math.max(0, AwtRenderer.this.screen_height - 1 - area.y), area.width, area.height).copyData(this.image.getRaster());
        }
    }
}

