/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.renderer;

import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Image;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class AwtRendererImage
implements Image {
    private final java.awt.Image image;
    private final Rectangle bounds;

    public AwtRendererImage(byte[] imageFileData) {
        this(new ImageIcon(imageFileData));
    }

    public AwtRendererImage(ImageIcon img) {
        this.bounds = new Rectangle(0, 0, img.getIconWidth(), img.getIconHeight());
        this.image = img.getImage();
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public java.awt.Image getImage() {
        return this.image;
    }

    @Override
    public byte[] getImageFileData() {
        BufferedImage bufferedImage = new BufferedImage(this.bounds.width, this.bounds.height, 1);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(this.image, 0, 0, null);
        g2.dispose();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", bos);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return bos.toByteArray();
    }
}

