/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.awt.renderer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class ToolTip
extends JWindow {
    private static final long serialVersionUID = 3088075061485011267L;
    private static final int MARGIN_WIDTH = 5;
    private static final int MARGIN_HEIGHT = 4;
    private TipContent content;

    public ToolTip(Component owner, String text, int x, int y, boolean displayAbove) {
        this.content = new TipContent(text.split("\n"), this.getFontMetrics(owner.getFont()));
        this.getContentPane().add(this.content);
        this.setSize(this.content.getContentWidth(), this.content.getContentHeight());
        int rx = x;
        int ry = y - this.getHeight();
        if (!displayAbove) {
            int cursorSize = 32;
            ry = y + cursorSize;
            Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            Point sc = new Point(rx, ry);
            SwingUtilities.convertPointToScreen(sc, this);
            if (sc.getX() + (double)this.getWidth() + (double)cursorSize >= bounds.getWidth() && (rx = x - this.getWidth()) < cursorSize) {
                rx = cursorSize;
            }
            if (sc.getY() + (double)this.getHeight() + (double)cursorSize >= bounds.getHeight() && (ry = y - this.getHeight()) < cursorSize) {
                ry = cursorSize;
            }
        }
        this.setLocation(rx, ry);
    }

    private class TipContent
    extends Canvas {
        private static final long serialVersionUID = -4663434757677861957L;
        String[] lines;
        private int width;
        private int height;
        private int lineHeight;

        public TipContent(String[] lines, FontMetrics fm) {
            this.lines = lines;
            this.setBackground(new Color(255, 255, 220));
            this.lineHeight = fm.getHeight();
            this.height = 4;
            for (String line : lines) {
                int tmpWidth = fm.stringWidth(line);
                if (this.width < tmpWidth) {
                    this.width = tmpWidth;
                }
                this.height += this.lineHeight;
            }
            this.width += 10;
            this.height += 4;
        }

        int getContentWidth() {
            return this.width;
        }

        int getContentHeight() {
            return this.height;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int linePos = this.lineHeight;
            for (String line : this.lines) {
                g.drawString(line, 5, linePos);
                linePos += this.lineHeight;
            }
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

