/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.ui.graph.axes;

import com.sap.jvm.profiling.ui.graph.BarGraphChart;
import com.sap.jvm.profiling.ui.graph.axes.BarGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.dataset.BarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Rectangle;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import java.util.ArrayList;
import java.util.List;

public class BarGraphAxis {
    private static final int LABEL_ANGLE = 45;
    private XYGraphAxesModel axesModel;
    private Color color = Color.GRAY;
    private List<Rectangle> barsAreas = new ArrayList<Rectangle>();
    private BarGraphAxisCaptionProvider captionProvider;
    private BarGraphChart chart;

    public BarGraphAxis(XYGraphAxesModel axesModel, BarGraphChart chart) {
        this.axesModel = axesModel;
        this.chart = chart;
        this.color = chart.getRenderer().getDefaultForeground();
    }

    public List<Rectangle> calculateRaster(int width, int height) {
        double offset = this.axesModel.getMinX() % this.axesModel.getXAxisRasterSize();
        offset = this.axesModel.getMinX() - offset;
        if (this.axesModel.getMinX() < 0.0) {
            offset -= this.axesModel.getXAxisRasterSize();
        }
        this.barsAreas.clear();
        while (offset < this.axesModel.getMaxX()) {
            int xOffset = this.axesModel.getXPosition(width, offset);
            int xWidth = this.axesModel.getXPosition(width, offset + this.axesModel.getXAxisRasterSize()) - xOffset;
            this.barsAreas.add(new Rectangle(xOffset, height, xWidth, height));
            offset += this.axesModel.getXAxisRasterSize();
        }
        return this.barsAreas;
    }

    public void repaint(Rectangle graphArea, Rectangle axisXArea, Rectangle axisXClippArea, Renderer renderer) {
        renderer.setForeground(this.color);
        renderer.setPaintArea(axisXArea, axisXClippArea);
        renderer.drawLine(0, axisXArea.height - 1, axisXArea.width, axisXArea.height - 1);
        for (Rectangle rec : this.barsAreas) {
            renderer.drawLine(rec.x_end, axisXArea.height - 1, rec.x_end, axisXArea.height - renderer.getFontHeight() / 2);
        }
        renderer.setDefaultColors();
        this.chart.removeAllToolTips();
        for (Rectangle rec : this.barsAreas) {
            int barIdx = (int)Math.round(this.axesModel.getXValue(axisXArea.width, rec.x));
            String caption = this.captionProvider != null ? this.captionProvider.provideBarIndexCaption(barIdx) : String.valueOf(barIdx);
            this.paintCaption(rec, caption, renderer);
        }
    }

    public int getMinDimension(Renderer renderer) {
        return renderer.getFontHeight();
    }

    public int getVerticalTitleDimension(Renderer renderer) {
        int maxTextLength = renderer.getFontHeight() * 2;
        for (BarGraphDataSet set : this.chart.getAllGraphs()) {
            int i = 0;
            while ((long)i < set.getSize()) {
                int textLength;
                String caption;
                String string = caption = this.captionProvider != null ? this.captionProvider.provideBarIndexCaption(i) : String.valueOf(i);
                if (caption != null && (textLength = renderer.getStringWidth(caption) + 10) > maxTextLength) {
                    maxTextLength = textLength;
                }
                ++i;
            }
        }
        double rad = 0.7853981633974483;
        int labelHeight = (int)Math.round(Math.sin(rad) * (double)maxTextLength + Math.cos(rad) * (double)renderer.getFontHeight() / 2.0);
        return labelHeight + renderer.getFontHeight() / 2;
    }

    private void paintCaption(Rectangle rec, String caption, Renderer renderer) {
        if (caption != null) {
            int newLineIdx;
            int availableHeight = renderer.getHeight() - 2;
            int fontHeight = renderer.getFontHeight();
            int halfHeight = fontHeight / 2;
            int maxLines = Math.max(1, availableHeight / fontHeight);
            String[] lines = caption.split("[\n]");
            if (lines.length > maxLines) {
                lines[maxLines - 1] = "";
            }
            String text = (newLineIdx = caption.indexOf(10)) != -1 ? caption.substring(0, newLineIdx) + "..." : caption;
            int textWidth = renderer.getStringWidth(text);
            int posX = rec.x + rec.width / 2;
            int posY = renderer.getHeight() - 2 - halfHeight;
            if (this.chart.isVerticalBarTitelsEnabled()) {
                double rad = 0.7853981633974483;
                int offX = (int)Math.round(-Math.cos(rad) * (double)textWidth - Math.sin(rad) * (double)halfHeight);
                int offY = (int)Math.round(-Math.sin(rad) * (double)textWidth + Math.cos(rad) * (double)halfHeight);
                renderer.drawString(text, posX + offX, posY + offY, -45.0f);
            } else {
                int availableWidth = rec.width - 4;
                if (textWidth > availableWidth) {
                    this.chart.addAxisCaptionToolTip(rec, caption);
                    text = this.getShortText(renderer, text, availableWidth);
                } else if (newLineIdx > -1) {
                    this.chart.addAxisCaptionToolTip(rec, caption);
                }
                renderer.drawString(text, posX - textWidth / 2, renderer.getHeight() / 2 - 1 + halfHeight);
            }
        }
    }

    public String getShortText(Renderer renderer, String text, int size) {
        String txt = "...";
        int length = text.length() - 1;
        for (int n = 1; renderer.getStringWidth(txt) < size && n < length; ++n) {
            txt = text.substring(0, n) + "...";
        }
        return txt;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setAxisCaptionProvider(BarGraphAxisCaptionProvider provider) {
        this.captionProvider = provider;
    }

    public String getAccessibeValueText(int idx) {
        if (this.captionProvider != null) {
            try {
                return this.captionProvider.provideBarIndexCaption(idx);
            }
            catch (Throwable th) {
                return "undefined value";
            }
        }
        return String.valueOf(idx);
    }

    public String getAccessibleText() {
        StringBuilder result = new StringBuilder();
        result.append("horizontal axis, ");
        int min = (int)this.axesModel.getMinX();
        int max = (int)this.axesModel.getMaxX();
        result.append(" from ");
        result.append(this.getAccessibeValueText(min));
        result.append(", to ");
        result.append(this.getAccessibeValueText(max));
        return result.toString();
    }
}

